/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.taxCal.analysis;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.shr.compensation.app.tax.TaxItemPlanInfo;
import com.kingdee.shr.compensation.app.tax.base.TaxItemCollection;
import com.kingdee.shr.compensation.app.tax.base.TaxItemFactory;
import com.kingdee.shr.compensation.app.tax.base.TaxItemInfo;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class VerifyData4SubmitInitCal {
    private static final Logger LOG = Logger.getLogger(VerifyData4SubmitInitCal.class);
    private Map<String, String> taxItemNameMap;
    private Set<String> allowItemLessThanZero;
    private String mandatoryItem;
    private boolean isOneTimeSre = false;
    private DecimalFormat df = new DecimalFormat("0.00");

    public Map<String, String> verify(Context ctx, List<Map<String, Object>> submitDataMapList, List<String> itemList, TaxItemPlanInfo taxItemPlanInfo, List<String> zeroIncomeList) {
        String incomeCode = null == taxItemPlanInfo.getIncomeItem() ? null : taxItemPlanInfo.getIncomeItem().getIncomeCode();
        String incomeName = null == taxItemPlanInfo.getIncomeItem() ? null : taxItemPlanInfo.getIncomeItem().getName();
        HashMap<String, String> verifyResult = new HashMap<String, String>();
        this.initTaxItemName(ctx, itemList, incomeCode);
        Iterator<Map<String, Object>> iterator = submitDataMapList.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> temp = iterator.next();
            String cmpCalID = (String)temp.get("FCMPCALTABLEID");
            String personId = (String)temp.get("FPERSONID");
            String taxUnitId = (String)temp.get("FTAXUNITID");
            String key = cmpCalID + "_" + incomeName;
            if ("0101".equals(incomeCode) && zeroIncomeList.contains(CmpStrUtil.getZeroIncomeInfo(personId, taxUnitId))) {
                verifyResult.put(key, "\u63d0\u4ea4\u5931\u8d25\uff0c\u8be5\u5458\u5de5\u5df2\u63d0\u4ea4\u96f6\u5de5\u8d44");
                iterator.remove();
                continue;
            }
            String msg = this.verifyValueLessThanZero(temp);
            if (!StringUtils.isEmpty((CharSequence)msg)) {
                verifyResult.put(key, msg);
                iterator.remove();
                continue;
            }
            msg = this.verifyOtherValues(temp);
            if (!StringUtils.isEmpty((CharSequence)msg)) {
                verifyResult.put(key, msg);
                iterator.remove();
                continue;
            }
            verifyResult.put(key, null);
        }
        return verifyResult;
    }

    private void initTaxItemName(Context ctx, List<String> itemList, String incomeCode) {
        this.allowItemLessThanZero = new HashSet<String>();
        if ("0108".equals(incomeCode)) {
            this.allowItemLessThanZero.add("T1");
            this.mandatoryItem = "T39";
            this.isOneTimeSre = true;
        } else {
            this.allowItemLessThanZero.add("T39");
            this.mandatoryItem = "T1";
        }
        if (itemList.size() < 1) {
            return;
        }
        if (itemList.contains("T37") || itemList.contains("T38")) {
            this.allowItemLessThanZero.add("T37");
            this.allowItemLessThanZero.add("T38");
        }
        StringBuilder getTaxItemNameSql = new StringBuilder();
        this.taxItemNameMap = new HashMap<String, String>();
        for (String str : itemList) {
            getTaxItemNameSql.append(",").append(Integer.parseInt(str.replace("T", "")));
        }
        try {
            TaxItemCollection taxItemCollection = TaxItemFactory.getLocalInstance(ctx).getTaxItemCollection(" select fieldSn, name where fieldSn in (" + getTaxItemNameSql.toString().replaceFirst(",", "") + ") order by fieldSn");
            if (null != taxItemCollection && taxItemCollection.size() > 0) {
                int size = taxItemCollection.size();
                for (int i = 0; i < size; ++i) {
                    TaxItemInfo taxItemInfo = taxItemCollection.get(i);
                    this.taxItemNameMap.put("T" + taxItemInfo.getFieldSn(), taxItemInfo.getName());
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"init taxItem Failed", (Throwable)e);
        }
    }

    private String verifyValueLessThanZero(Map<String, Object> temp) {
        String result = "";
        if (null != this.taxItemNameMap && this.taxItemNameMap.size() > 0) {
            boolean isNeedCheckLessThanZero = null != this.allowItemLessThanZero && this.allowItemLessThanZero.size() > 0;
            BigDecimal res = BigDecimal.ZERO;
            if (!temp.containsKey(this.mandatoryItem) && !temp.containsKey(this.mandatoryItem.toLowerCase(Locale.ENGLISH))) {
                String itemName = this.isOneTimeSre ? "\u4e00\u6b21\u6027\u8865\u507f\u6536\u5165" : "\u672c\u671f\u6536\u5165";
                return "\u4e0d\u5b58\u5728[" + itemName + "]\uff0c\u8bf7\u68c0\u67e5";
            }
            Object sre = temp.get(this.mandatoryItem);
            if (null == sre) {
                sre = temp.get(this.mandatoryItem.toLowerCase(Locale.ENGLISH));
            }
            if (null == sre || new BigDecimal(String.valueOf(sre)).compareTo(BigDecimal.ZERO) <= 0) {
                return this.taxItemNameMap.get(this.mandatoryItem) + "\u4e3a\uff1a" + this.df.format(res) + ",\u5fc5\u987b\u5927\u4e8e0,\u8bf7\u786e\u8ba4\uff01";
            }
            for (Map.Entry<String, String> entry : this.taxItemNameMap.entrySet()) {
                double value;
                String taxItemField = entry.getKey();
                if (isNeedCheckLessThanZero && this.allowItemLessThanZero.contains(taxItemField) || !temp.containsKey(taxItemField)) continue;
                Object tempValue = temp.get(taxItemField);
                String str = String.valueOf(tempValue);
                if (!StringUtils.isEmpty((CharSequence)str)) {
                    try {
                        res = new BigDecimal(str);
                    }
                    catch (Exception e) {
                        res = new BigDecimal(0);
                    }
                }
                if (!((value = res.doubleValue()) < 0.0)) continue;
                result = entry.getKey() + MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label110"), this.df.format(res));
                break;
            }
        }
        return result;
    }

    private String verifyOtherValues(Map<String, Object> temp) {
        String result = "";
        if (temp.containsKey("T10") && temp.containsKey("T9") && (Double)temp.get("T10") > 0.0 && (Double)temp.get("T9") > 0.0) {
            result = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label111", (Locale)new Context().getLocale());
        }
        return result;
    }
}

