/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util.db;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractTempTable {
    private static Logger logger = Logger.getLogger(AbstractTempTable.class);
    private String tmpTableName;

    public String getTmpTableName() {
        return this.tmpTableName;
    }

    public String createTempTableName(Context ctx) throws BOSException {
        String tempTableName;
        try {
            if (this.tmpTableName != null) {
                throw new BOSException("Repeat create tmp table in CmpInSql object.");
            }
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
        }
        catch (Exception e) {
            logger.error((Object)"Create Temp table failed!");
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        this.tmpTableName = tempTableName;
        return tempTableName;
    }

    public void release(Context ctx) {
        if (!StringUtils.isEmpty((CharSequence)this.tmpTableName)) {
            TempTablePool.getInstance((Context)ctx).releaseTable(this.tmpTableName);
        }
    }
}

