/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.data.domain.db.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.common.util.StringUtils;
import com.kingdee.shr.data.domain.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.shr.data.model.designtime.AbstractSource;
import com.kingdee.shr.data.model.designtime.source.DBSource;
import com.kingdee.shr.data.model.vo.AbstractNode;
import com.kingdee.shr.data.model.vo.FolderNode;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractPGSourceJDBCAdapter
extends AbstractDBSourceJDBCAdapter {
    private static Set<String> ignoreSchemas = new HashSet<String>();

    @Override
    public AbstractNode getUsableEntities(Context ctx, AbstractSource source) throws BOSException, EASBizException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        String tableSql = "select tablename from pg_tables where schemaname = 'postgres' or schemaname = ?";
        String viewSql = "select viewname from pg_views where schemaname = 'postgres' or schemaname = ?";
        String schemaName = StringUtils.isBlank(dataBase.getSchema()) ? "public" : dataBase.getSchema();
        this.queryTableLeafNodes(ctx, root, dataBase, tableSql, new Object[]{schemaName});
        this.queryTableLeafNodes(ctx, root, dataBase, viewSql, new Object[]{schemaName});
        return root;
    }

    static {
        ignoreSchemas.add("gp_toolkit");
        ignoreSchemas.add("pg_toast");
        ignoreSchemas.add("pg_bitmapindex");
        ignoreSchemas.add("pg_aoseg");
        ignoreSchemas.add("pg_catalog");
        ignoreSchemas.add("information_schema");
        ignoreSchemas.add("pg_temp_1");
        ignoreSchemas.add("pg_toast_temp_1");
    }
}

