/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.data.domain.service.imp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.shr.common.util.CloseUtil;
import com.kingdee.shr.data.domain.service.IBizSourceConversionStrategy;
import com.kingdee.shr.data.domain.service.IConnectionFactory;
import com.kingdee.shr.data.model.designtime.AbstractSource;
import com.kingdee.shr.data.model.designtime.source.DBSource;
import com.kingdee.shr.data.model.designtime.source.ShrDBCenterSource;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class BizSourceConversionStrategyImpl
implements IBizSourceConversionStrategy {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.data.domain.db.AbstractDBSourceJDBCAdapter");

    @Override
    public DBSource createDBSourceByBizSource(AbstractSource source, Context ctx) {
        try {
            return this.createDbSource(source, ctx);
        }
        catch (BOSException e) {
            logger.error((Object)"Shr get DBSource failed,", (Throwable)e);
            return null;
        }
    }

    private DBSource createDbSource(AbstractSource source, Context ctx) throws BOSException {
        ShrDBCenterSource tableSource = (ShrDBCenterSource)source;
        DBSource.DBType dbType = this.getDbType(ctx);
        DBSource dbSource = new DBSource();
        dbSource.setDbName(tableSource.getDbName());
        dbSource.setName(tableSource.getName());
        dbSource.setDbType(dbType);
        return dbSource;
    }

    public DBSource.DBType getDbType(Context ctx) throws BOSException {
        try {
            String dbStrType = String.valueOf(ctx.get((Object)"dbType")).toUpperCase();
            logger.info((Object)("SHR DB CENTER DB TYPE:" + dbStrType));
            if (dbStrType.contains("MS SQL SERVER")) {
                return DBSource.DBType.SQLSERVER;
            }
            return DBSource.DBType.valueOf(dbStrType);
        }
        catch (Exception e) {
            return this.getDbTypeFromDriverName(ctx);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DBSource.DBType getDbTypeFromDriverName(Context ctx) throws BOSException {
        Connection conn = null;
        try {
            DBSource.DBType[] dbTypes;
            conn = EJBFactory.getConnection((Context)ctx);
            String dataBaseProductName = conn.getMetaData().getDatabaseProductName().toUpperCase();
            if (dataBaseProductName.contains("ORACLE")) {
                DBSource.DBType dBType = DBSource.DBType.ORACLE;
                return dBType;
            }
            if (dataBaseProductName.contains("MICROSOFT SQL SERVER")) {
                DBSource.DBType dBType = DBSource.DBType.SQLSERVER;
                return dBType;
            }
            DBSource.DBType[] dBTypeArray = dbTypes = DBSource.DBType.values();
            int n = dBTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBSource.DBType dbType = dBTypeArray[n2];
                if (dataBaseProductName.indexOf(dbType.name()) != -1) {
                    DBSource.DBType dBType = dbType;
                    return dBType;
                }
                ++n2;
            }
            throw new BOSException("load db driver failed");
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            CloseUtil.close(conn);
        }
    }

    @Override
    public IConnectionFactory createConnFactoryByBizSource(AbstractSource abstractSource, Context ctx) {
        return BizSourceConversionStrategyImpl.createConnFactory(ctx);
    }

    public static IConnectionFactory createConnFactory(final Context ctx) {
        return new IConnectionFactory(){

            @Override
            public Connection createConnect() throws BOSException {
                try {
                    return EJBFactory.getConnection((Context)ctx);
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }

            @Override
            public boolean supportKSql() {
                return true;
            }
        };
    }
}

