/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.econtractservice.service;

import com.alibaba.fastjson.JSONArray;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.contract.ContractBillMiddleCollection;
import com.kingdee.eas.hr.contract.ContractBillMiddleFactory;
import com.kingdee.eas.hr.contract.ContractBillMiddleInfo;
import com.kingdee.eas.hr.contract.ContractChangeBizBillEntryInfo;
import com.kingdee.eas.hr.contract.ContractChangeBizBillInfo;
import com.kingdee.eas.hr.contract.ContractEndBizBillEntryInfo;
import com.kingdee.eas.hr.contract.ContractEndBizBillInfo;
import com.kingdee.eas.hr.contract.ContractFreeBizBillEntryInfo;
import com.kingdee.eas.hr.contract.ContractFreeBizBillInfo;
import com.kingdee.eas.hr.contract.ContractPreSignBizBillInfo;
import com.kingdee.eas.hr.contract.ContractRenewBizBillEntryInfo;
import com.kingdee.eas.hr.contract.ContractRenewBizBillInfo;
import com.kingdee.eas.hr.contract.ContractSignBizBillInfo;
import com.kingdee.eas.hr.contract.EContractSignState;
import com.kingdee.eas.hr.contract.OtherContractSignBizBillInfo;
import com.kingdee.eas.hr.emp.ContractTempletFactory;
import com.kingdee.eas.hr.emp.ContractTempletInfo;
import com.kingdee.eas.hr.emp.IContractTemplet;
import com.kingdee.eas.hr.emp.LabContractFirstPartyInfo;
import com.kingdee.shr.econtractservice.EContractServiceFacadeFactory;
import com.kingdee.shr.econtractservice.ISSCEContractRecord;
import com.kingdee.shr.econtractservice.SSCEContractRecordCollection;
import com.kingdee.shr.econtractservice.SSCEContractRecordFactory;
import com.kingdee.shr.econtractservice.SSCEContractRecordInfo;
import com.kingdee.shr.econtractservice.app.EContractServiceException;
import com.kingdee.shr.econtractservice.service.EContractService;
import com.kingdee.shr.elecontract.util.EContractServiceUtils;
import com.kingdee.shr.elecontract.util.ElectronicContractUtils;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.preentry.PreEntryPersonInfo;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class ContractBizBillService {
    private static final Logger logger = LoggerFactory.getLogger(ContractBizBillService.class);

    public static String invokeHandlerMethod(Context ctx, String className, String methodName, Class<?> ... paramTypes) throws Exception {
        try {
            Class<?> clazz = Class.forName(className);
            Method method = ReflectionUtils.findMethod(clazz, (String)methodName, (Class[])paramTypes);
            if (method == null) {
                String label = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label", (Context)ctx);
                throw new Exception(label);
            }
            Object object = ReflectionUtils.invokeMethod((Method)method, clazz.newInstance(), (Object[])paramTypes);
            return object != null ? object.toString() : null;
        }
        catch (ClassNotFoundException e) {
            throw new Exception(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new Exception(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new Exception(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    public void processEContractData(Context ctx, IObjectValue model, Boolean isAddNew) throws EASBizException, BOSException {
        IObjectCollection otherEntryColl;
        HRBillBaseInfo billInfo = (HRBillBaseInfo)model;
        IObjectCollection entryColl = (IObjectCollection)billInfo.get("entrys");
        HRBillBaseEntryInfo entryInfo = null;
        IContractTemplet iContractTemplet = ContractTempletFactory.getLocalInstance((Context)ctx);
        if (entryColl.size() > 0 && isAddNew.booleanValue()) {
            for (int index = 0; index < entryColl.size(); ++index) {
                entryInfo = (HRBillBaseEntryInfo)entryColl.getObject(index);
                ContractTempletInfo templetInfo = EContractService.getContractTempletInfo(ctx, billInfo, entryInfo);
                if (!(templetInfo = iContractTemplet.getContractTempletInfo((IObjectPK)new ObjectUuidPK(templetInfo.getId().toString()))).isIsElectronicSign()) continue;
                this.createEContractAndSaveRecord(ctx, entryInfo, null, billInfo, templetInfo);
            }
        }
        if (EContractService.isSupportOtherFollowContractEntryInfo(billInfo.getId()) && null != (otherEntryColl = (IObjectCollection)billInfo.get("otherEntrys")) && otherEntryColl.size() > 0 && isAddNew.booleanValue()) {
            logger.info("otherEntryColl_ otherEntrys.size()\uff1a" + otherEntryColl.size());
            for (int indexOther = 0; indexOther < otherEntryColl.size(); ++indexOther) {
                HRBillBaseEntryInfo otherInfo = (HRBillBaseEntryInfo)otherEntryColl.getObject(indexOther);
                ContractTempletInfo otherContractTempleInfo = EContractService.getContractTempletInfo(ctx, billInfo, otherInfo);
                otherContractTempleInfo = iContractTemplet.getContractTempletInfo((IObjectPK)new ObjectUuidPK(otherContractTempleInfo.getId().toString()));
                logger.info("isIsElectronicSign\uff1a{}\uff0c contractNo\uff1a{}", (Object)otherContractTempleInfo.isIsElectronicSign(), (Object)otherInfo.getString("contractNo"));
                if (!otherContractTempleInfo.isIsElectronicSign()) continue;
                this.createEContractAndSaveRecord(ctx, otherInfo, entryInfo, billInfo, otherContractTempleInfo);
            }
        }
    }

    public void createEContractAndSaveRecord(Context ctx, HRBillBaseEntryInfo entryInfo, HRBillBaseEntryInfo entryForPerson, HRBillBaseInfo billInfo, ContractTempletInfo templetInfo) throws EASBizException, BOSException {
        Object preEntryPerson;
        Object person;
        logger.info("enter_ createEContractAndSaveRecord");
        String oldNumber = entryInfo.getString("contractNo");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("entryId", (Object)entryInfo.getId().toString()));
        SSCEContractRecordInfo eContractReocrdInfo = (SSCEContractRecordInfo)EContractServiceUtils.getModelWithFilter((Context)ctx, (String)"com.kingdee.shr.econtractservice.app.SSCEContractRecord", (FilterInfo)filter, null);
        if (eContractReocrdInfo == null) {
            eContractReocrdInfo = new SSCEContractRecordInfo();
        }
        String eContractNo = "";
        eContractNo = !oldNumber.startsWith("E") ? ElectronicContractUtils.generateContractNumber((Context)ctx, (String)oldNumber) : oldNumber;
        logger.info("eContractNo\uff1a{}", (Object)eContractNo);
        LabContractFirstPartyInfo firstParty = EContractService.getLabContractFirstParty(ctx, billInfo, entryInfo);
        String kdappIdEContractNo = ElectronicContractUtils.addContractNumber((Context)ctx, (LabContractFirstPartyInfo)firstParty, (String)eContractNo);
        logger.info("kdappIdEContractNo\uff1a{}", (Object)kdappIdEContractNo);
        eContractReocrdInfo.setBillId(billInfo.getId());
        eContractReocrdInfo.setEntryId(entryInfo.getId());
        eContractReocrdInfo.setBillNumber(billInfo.getNumber());
        eContractReocrdInfo.setContractNO(eContractNo);
        eContractReocrdInfo.setEContractNO(kdappIdEContractNo);
        if (null != entryForPerson) {
            logger.info("entryForPerson_ ");
            person = entryForPerson.get("person");
            if (person != null && person instanceof PersonInfo) {
                eContractReocrdInfo.put("person", person);
            }
            if (person != null && person instanceof PreEntryPersonInfo) {
                eContractReocrdInfo.put("preEntryPerson", person);
            }
            if ((preEntryPerson = entryForPerson.get("preEntryPerson")) != null && preEntryPerson instanceof PreEntryPersonInfo) {
                eContractReocrdInfo.put("preEntryPerson", preEntryPerson);
            }
        } else {
            logger.info("person_ ");
            person = entryInfo.get("person");
            if (person != null && person instanceof PersonInfo) {
                eContractReocrdInfo.setPerson((PersonInfo)person);
            }
            if (person != null && person instanceof PreEntryPersonInfo) {
                eContractReocrdInfo.setPreEntryPerson((PreEntryPersonInfo)person);
            }
            if ((preEntryPerson = entryInfo.get("preEntryPerson")) != null && preEntryPerson instanceof PreEntryPersonInfo) {
                eContractReocrdInfo.setPreEntryPerson((PreEntryPersonInfo)preEntryPerson);
            }
        }
        eContractReocrdInfo.setKdContractConfig(ElectronicContractUtils.getKDContractConfigByLabContractFirstParty((Context)ctx, (String)firstParty.getId().toString()));
        eContractReocrdInfo.setSignType(templetInfo.getSignType());
        SSCEContractRecordFactory.getLocalInstance(ctx).save((CoreBaseInfo)eContractReocrdInfo);
        ContractBillMiddleInfo middle = new ContractBillMiddleInfo();
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        ContractBillMiddleCollection collection = ContractBillMiddleFactory.getLocalInstance((Context)ctx).getContractBillMiddleCollection(view);
        if (collection.size() > 0) {
            middle = collection.get(0);
        }
        logger.info(" middle.size() \uff1a{}", middle == null ? "null" : Integer.valueOf(middle.size()));
        middle = (ContractBillMiddleInfo)ElectronicContractUtils.copyAndSaveBizBillDataToMiddle((Context)ctx, (HRBillBaseInfo)billInfo, (HRBillBaseEntryInfo)entryInfo, (CoreBaseInfo)middle);
        String newNumber = eContractNo;
        EContractServiceFacadeFactory.getLocalInstance(ctx).createEContractForDup(billInfo, entryInfo);
        if (!oldNumber.equals(newNumber)) {
            this.updateBillEntryNumber(ctx, billInfo, entryInfo, newNumber, oldNumber);
        }
    }

    public void boforeAbortBill(Context ctx, IObjectValue bill, IObjectValue entry) throws EASBizException, BOSException {
        HRBillBaseInfo billInfo = (HRBillBaseInfo)bill;
        HRBillBaseEntryInfo entryInfo = (HRBillBaseEntryInfo)entry;
        BOSUuid billBOSUuid = billInfo.getId();
        BOSUuid entryBOSUuid = entryInfo.getId();
        boolean isContractBill = EContractService.isContractBusinessBill(billBOSUuid);
        boolean isOtherContractBill = EContractService.isOtherContractBusinessBill(billBOSUuid);
        if (!isContractBill && !isOtherContractBill) {
            return;
        }
        SSCEContractRecordInfo recordInfo = EContractService.getSSCEContractRecord(ctx, billBOSUuid.toString(), entryBOSUuid.toString());
        if (recordInfo != null && (recordInfo.isIsPersonSign() || recordInfo.isIsCompanySign())) {
            throw new EContractServiceException(EContractServiceException.HAS_SIGNED_ABORT);
        }
        JSONArray taskInfoArray = EContractService.getTaskInfoByBillId(ctx, billBOSUuid.toString(), null, null);
        if (taskInfoArray != null && taskInfoArray.size() > 0) {
            throw new EContractServiceException(EContractServiceException.HAS_JOB_ABORT);
        }
    }

    private void updateBillEntryNumber(Context ctx, HRBillBaseInfo billInfo, HRBillBaseEntryInfo entryInfo, String newNumber, String oldNumber) throws EASBizException, BOSException {
        boolean isContractBill = EContractService.isContractBusinessBill(billInfo.getId());
        boolean isOtherContractBill = EContractService.isOtherContractBusinessBill(billInfo.getId());
        if (!isContractBill && !isOtherContractBill) {
            return;
        }
        if (!StringUtils.isEmpty((String)newNumber)) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("contractNo"));
            selector.add(new SelectorItemInfo("signState"));
            entryInfo.put("contractNo", (Object)newNumber);
            entryInfo.put("signState", (Object)EContractSignState.nosign);
            IHRBillBaseEntry iEntry = (IHRBillBaseEntry)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)entryInfo.getId().getType());
            iEntry.updatePartial((CoreBaseInfo)entryInfo, selector);
            if (isContractBill) {
                String sql1 = "UPDATE T_HR_EmployeeContract SET FCONTRACTNO = '" + newNumber + "' WHERE FCONTRACTNO = '" + oldNumber + "'";
                String sql2 = "UPDATE T_HR_HRContractInfo SET FCONTRACTNO  = '" + newNumber + "' WHERE FCONTRACTNO = '" + oldNumber + "'";
                ArrayList<String> sqls = new ArrayList<String>();
                sqls.add(sql1);
                sqls.add(sql2);
                DbUtil.executeBatch((Context)ctx, sqls);
            }
        }
    }

    public static void updateEcontractRecordSetHasCallback(Context ctx, String billId) throws BOSException, EASBizException {
        logger.info("===updateEcontractRecordSetHasCallback===");
        ContractBizBillService.updateEcontractRecordSetHasCallback(ctx, billId, null);
    }

    public static void updateEcontractRecordSetHasCallback(Context ctx, String billId, String entryId) throws BOSException, EASBizException {
        logger.info("===updateEcontractRecordSetHasCallbackForFollow===, billId is {}, entryId is {}", (Object)billId, (Object)entryId);
        String sql = "where billId = '" + billId + "'";
        if (!StringUtils.isEmpty((String)entryId)) {
            sql = sql + " and entryId = '" + entryId + "'";
        }
        logger.info("_sql is {}", (Object)sql);
        SSCEContractRecordInfo recordInfo = null;
        ISSCEContractRecord issceContractRecord = SSCEContractRecordFactory.getLocalInstance(ctx);
        SSCEContractRecordCollection sscEContractRecordCollection = issceContractRecord.getSSCEContractRecordCollection(sql);
        if (sscEContractRecordCollection.size() > 0) {
            recordInfo = sscEContractRecordCollection.get(0);
            recordInfo.setHasFileCallback(true);
            recordInfo.setFileCallbackTime(new Timestamp(System.currentTimeMillis()));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("hasFileCallback"));
            selector.add(new SelectorItemInfo("fileCallbackTime"));
            issceContractRecord.updatePartial(recordInfo, selector);
        }
    }

    public static void updateEcontractRecordSetCreated(Context ctx, String billId) throws BOSException, EASBizException {
        logger.info("===updateEcontractRecordSetCreated===");
        ContractBizBillService.updateEcontractRecordSetCreated(ctx, billId, null);
    }

    public static void updateEcontractRecordSetCreated(Context ctx, String billId, String entryId) throws BOSException, EASBizException {
        logger.info("===updateEcontractRecordSetCreatedForFollow===, billId is {}, entryId is {}", (Object)billId, (Object)entryId);
        String sql = "where billId = '" + billId + "'";
        if (!StringUtils.isEmpty((String)entryId)) {
            sql = sql + " and entryId = '" + entryId + "'";
        }
        logger.info("_sql2 is {}", (Object)sql);
        SSCEContractRecordInfo recordInfo = null;
        ISSCEContractRecord issceContractRecord = SSCEContractRecordFactory.getLocalInstance(ctx);
        SSCEContractRecordCollection sscEContractRecordCollection = issceContractRecord.getSSCEContractRecordCollection(sql);
        if (sscEContractRecordCollection.size() > 0) {
            recordInfo = sscEContractRecordCollection.get(0);
            recordInfo.setIsCreate(true);
            recordInfo.setEcreateTime(EContractService.getCurTimestamp());
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("isCreate"));
            selector.add(new SelectorItemInfo("ecreateTime"));
            issceContractRecord.updatePartial(recordInfo, selector);
        }
    }

    public static boolean isContractBusinessBill(BOSUuid billId) {
        String curBosType = billId.getType().toString();
        return "9F4ECBD6".equals(curBosType) || "2A2632A9".equals(curBosType) || "502B7D81".equals(curBosType) || "8015FF9B".equals(curBosType) || "056FBF2E".equals(curBosType) || "87AFF1F2".equals(curBosType);
    }

    public static boolean isOtherContractBusinessBill(BOSUuid billId) {
        String curBosType = billId.getType().toString();
        return "CB88E0A5".equals(curBosType);
    }

    public static boolean isCertificationBillBuss(BOSUuid billID) {
        String curBosType = billID.getType().toString();
        return "C84F6BC0".equalsIgnoreCase(curBosType);
    }

    public static LabContractFirstPartyInfo getLabContractFirstParty(HRBillBaseInfo billInfo, HRBillBaseEntryInfo entryInfo) {
        if (billInfo instanceof ContractRenewBizBillInfo) {
            ContractRenewBizBillEntryInfo contract = (ContractRenewBizBillEntryInfo)entryInfo;
            return contract.getLabContractFirstParty();
        }
        if (billInfo instanceof ContractPreSignBizBillInfo) {
            return ((ContractPreSignBizBillInfo)billInfo).getLabContractFirstParty();
        }
        if (billInfo instanceof ContractSignBizBillInfo) {
            return ((ContractSignBizBillInfo)billInfo).getLabContractFirstParty();
        }
        if (billInfo instanceof OtherContractSignBizBillInfo) {
            return ((OtherContractSignBizBillInfo)billInfo).getLabContractFirstParty();
        }
        if (billInfo instanceof ContractChangeBizBillInfo) {
            ContractChangeBizBillEntryInfo contract = (ContractChangeBizBillEntryInfo)entryInfo;
            return contract.getLabContractFirstParty();
        }
        if (billInfo instanceof ContractFreeBizBillInfo) {
            ContractFreeBizBillEntryInfo contract = ((ContractFreeBizBillInfo)billInfo).getEntrys().get(0);
            return contract.getLabContractFirstParty();
        }
        if (billInfo instanceof ContractEndBizBillInfo) {
            ContractEndBizBillEntryInfo contract = ((ContractEndBizBillInfo)billInfo).getEntrys().get(0);
            return contract.getLabContractFirstParty();
        }
        LabContractFirstPartyInfo party = null;
        LabContractFirstPartyInfo temp = new LabContractFirstPartyInfo();
        Enumeration keys = billInfo.keys();
        boolean flag = false;
        while (keys.hasMoreElements()) {
            String nextElement = (String)keys.nextElement();
            Object object = billInfo.get(nextElement);
            if (object == null) continue;
            logger.error("EContractService getLabContractFirstParty billBaseInfo : " + nextElement + " ; " + object.toString());
            if (object instanceof LabContractFirstPartyInfo) {
                party = (LabContractFirstPartyInfo)object;
                flag = true;
                break;
            }
            if (!(object instanceof BOSUuid)) continue;
            BOSUuid id = (BOSUuid)object;
            if (!temp.getBOSType().toString().equals(id.getType().toString())) continue;
            party = new LabContractFirstPartyInfo();
            party.setId(id);
            flag = true;
            break;
        }
        if (!flag && entryInfo != null) {
            Enumeration enumeration = entryInfo.keys();
            while (enumeration.hasMoreElements()) {
                String nextElement = (String)enumeration.nextElement();
                Object object = entryInfo.get(nextElement);
                if (object == null) continue;
                logger.error("EContractService getLabContractFirstParty billBaseEntryInfo : " + nextElement + " ; " + object.toString());
                if (object instanceof LabContractFirstPartyInfo) {
                    party = (LabContractFirstPartyInfo)object;
                    flag = true;
                    break;
                }
                if (!(object instanceof BOSUuid)) continue;
                BOSUuid id = (BOSUuid)object;
                if (!temp.getBOSType().toString().equals(id.getType().toString())) continue;
                party = new LabContractFirstPartyInfo();
                party.setId(id);
                flag = true;
                break;
            }
        }
        return party;
    }

    public static ContractTempletInfo getContractTempletInfo(HRBillBaseInfo billInfo, HRBillBaseEntryInfo entryInfo) {
        BOSUuid id;
        Object object;
        String nextElement;
        ContractTempletInfo contractTempletInfo = null;
        contractTempletInfo = (ContractTempletInfo)entryInfo.get("contractTemplet");
        if (contractTempletInfo != null) {
            return contractTempletInfo;
        }
        ContractTempletInfo temp = new ContractTempletInfo();
        boolean flag = false;
        if (entryInfo != null) {
            Enumeration enumeration = entryInfo.keys();
            while (enumeration.hasMoreElements()) {
                nextElement = (String)enumeration.nextElement();
                object = entryInfo.get(nextElement);
                if (object == null) continue;
                if (object instanceof ContractTempletInfo) {
                    contractTempletInfo = (ContractTempletInfo)object;
                    flag = true;
                    break;
                }
                if (!(object instanceof BOSUuid)) continue;
                id = (BOSUuid)object;
                if (!temp.getBOSType().toString().equals(id.getType().toString())) continue;
                contractTempletInfo = new ContractTempletInfo();
                contractTempletInfo.setId(id);
                flag = true;
                break;
            }
        }
        if (!flag) {
            Enumeration keys = billInfo.keys();
            while (keys.hasMoreElements()) {
                nextElement = (String)keys.nextElement();
                object = billInfo.get(nextElement);
                if (object == null) continue;
                if (object instanceof ContractTempletInfo) {
                    contractTempletInfo = (ContractTempletInfo)object;
                    flag = true;
                    break;
                }
                if (!(object instanceof BOSUuid)) continue;
                id = (BOSUuid)object;
                if (!temp.getBOSType().toString().equals(id.getType().toString())) continue;
                contractTempletInfo = new ContractTempletInfo();
                contractTempletInfo.setId(id);
                flag = true;
                break;
            }
        }
        return null;
    }
}

