/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.econtractservice.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.IHRBillBase;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.shr.base.syssetting.IMSFServiceFacade;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.econtractservice.EContractSendMessageFacadeFactory;
import com.kingdee.shr.econtractservice.EContractServiceFacadeFactory;
import com.kingdee.shr.econtractservice.SSCEContractRecordCollection;
import com.kingdee.shr.econtractservice.SSCEContractRecordFactory;
import com.kingdee.shr.econtractservice.SSCEContractRecordInfo;
import com.kingdee.shr.econtractservice.service.ITaskThread;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.shareservice.TaskMessageLogInfo;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EEmployeeSendMessageTaskThread
implements Runnable,
ITaskThread {
    private static final long serialVersionUID = 4706916063242558322L;
    private static final Logger logger = LoggerFactory.getLogger(EEmployeeSendMessageTaskThread.class);
    protected static final SecureRandom random = new SecureRandom();
    private Context ctx;
    private String threadName;
    private CountDownLatch latch;
    private String jobId;
    private String billId;
    private String entryId;
    private String personId;
    private boolean isBatch = false;
    private String creatorId;
    private BatchMessageTipsBody messageTips;

    public EEmployeeSendMessageTaskThread(Context ctx, CountDownLatch latch, String jobId, String billId, String entryId, String personId, BatchMessageTipsBody messageTips) {
        this.ctx = ctx;
        this.latch = latch;
        this.jobId = jobId;
        this.billId = billId;
        this.entryId = entryId;
        this.personId = personId;
        if (messageTips == null) {
            messageTips = new BatchMessageTipsBody();
        }
        messageTips.setMuitTipsState(Boolean.FALSE.booleanValue());
        this.messageTips = messageTips;
        this.threadName = "EEmployeeSendMessageTaskThread--> : " + billId + " : " + personId;
    }

    public EEmployeeSendMessageTaskThread(Context ctx, CountDownLatch latch, String jobId, String billId, String entryId, String personId, BatchMessageTipsBody messageTips, String creatorId) {
        this.ctx = ctx;
        this.latch = latch;
        this.jobId = jobId;
        this.billId = billId;
        this.entryId = entryId;
        this.personId = personId;
        if (messageTips == null) {
            messageTips = new BatchMessageTipsBody();
        }
        messageTips.setMuitTipsState(Boolean.FALSE.booleanValue());
        this.messageTips = messageTips;
        this.threadName = "EEmployeeSendMessageTaskThread--> : " + billId + " : " + personId;
        this.creatorId = creatorId;
    }

    public EEmployeeSendMessageTaskThread(Context ctx, CountDownLatch latch, String jobId, String billId, String entryId, String personId, BatchMessageTipsBody messageTips, boolean isBatch) {
        this.ctx = ctx;
        this.latch = latch;
        this.jobId = jobId;
        this.billId = billId;
        this.entryId = entryId;
        this.personId = personId;
        if (messageTips == null) {
            messageTips = new BatchMessageTipsBody();
        }
        this.isBatch = isBatch;
        messageTips.setMuitTipsState(Boolean.FALSE.booleanValue());
        this.messageTips = messageTips;
        this.threadName = "EEmployeeSendMessageTaskThread--> : " + billId + " : " + personId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            logger.error(this.threadName + " start running .......");
            this.checkEContractIsCreate();
            this.checkPersonState();
            TaskMessageLogInfo result = null;
            result = StringUtils.isEmpty((CharSequence)this.creatorId) ? (TaskMessageLogInfo)EContractSendMessageFacadeFactory.getLocalInstance(this.ctx).sendPersonSignMessage(this.billId, this.entryId, this.jobId, this.personId) : (TaskMessageLogInfo)EContractSendMessageFacadeFactory.getLocalInstance(this.ctx).autoSendPersonSignMessage(this.billId, this.entryId, this.jobId, this.personId, this.creatorId);
            if (result.isIsSend() && result.isSendResult()) {
                this.messageTips.setMuitTipsState(Boolean.TRUE.booleanValue());
                String label11 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label11", (Context)this.ctx);
                Locale locale = this.ctx.getLocale();
                String realObj = MessageFormat.format(label11, result.getType().getAlias(locale));
                this.messageTips.setMuitTipsMessage(realObj);
            } else {
                this.messageTips.setMuitTipsMessage(result.getReason());
            }
            Thread.sleep(EEmployeeSendMessageTaskThread.getRandomMils());
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.messageTips.setMuitTipsMessage(e.getMessage());
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(this.ctx.getLocale()), (Throwable)e);
            this.messageTips.setMuitTipsMessage(e.getMessage(this.ctx.getLocale()));
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.messageTips.setMuitTipsMessage(e.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.messageTips.setMuitTipsMessage(e.getMessage());
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            this.messageTips.setMuitTipsMessage(e.getMessage());
        }
        finally {
            this.latch.countDown();
        }
    }

    protected void checkEContractIsCreate() throws BOSException, EASBizException {
        if (this.isBatch) {
            logger.error(this.threadName + " start checkEContractIsCreate ......." + this.personId);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("billId", (Object)this.billId));
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            SSCEContractRecordCollection collection = SSCEContractRecordFactory.getLocalInstance(this.ctx).getSSCEContractRecordCollection(view);
            logger.info("collection_ size is " + collection.size());
            if (collection.size() > 0) {
                for (int i = 0; i < collection.size(); ++i) {
                    if (collection.get(i).isIsCreate()) continue;
                    SSCEContractRecordInfo contractRecordInfo = collection.get(i);
                    BOSUuid billId = contractRecordInfo.getBillId();
                    BOSUuid entryId = contractRecordInfo.getEntryId();
                    HRBillBaseInfo billInfo = ((IHRBillBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)billId.getType())).getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billId));
                    HRBillBaseEntryInfo entryInfo = null;
                    if (entryId != null) {
                        entryInfo = ((IHRBillBaseEntry)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)entryId.getType())).getHRBillBaseEntryInfo((IObjectPK)new ObjectUuidPK(entryId));
                    }
                    EContractServiceFacadeFactory.getLocalInstance(this.ctx).createEContractForDup(billInfo, entryInfo);
                }
            }
        }
    }

    public void checkPersonState() throws BOSException, EASBizException {
        logger.error(this.threadName + " start checkPersonState ......." + this.personId);
        if (!StringUtils.isEmpty((CharSequence)this.personId)) {
            HashMap<String, String> osfDataMap = new HashMap<String, String>();
            osfDataMap.put("personIds", this.personId);
            IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)this.ctx);
            Map osfResult = (Map)osfServiceFacade.processService("checkPersonIdCardCellStatusService", osfDataMap);
            if (osfResult == null || osfResult.size() <= 0 || osfResult.get(this.personId) == null) {
                String label12 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label12", (Context)this.ctx);
                String realObj = MessageFormat.format(label12, this.personId);
                throw new BOSException(realObj);
            }
            Map dataMap = (Map)osfResult.get(this.personId);
            String idCardNO = (String)dataMap.get("idCardNO");
            String cell = (String)dataMap.get("cell");
            String wxOpenId = (String)dataMap.get("wxOpenId");
            String openId = (String)dataMap.get("openId");
            BOSUuid bosUuid = BOSUuid.read((String)this.personId);
            String bosType = bosUuid.getType().toString();
            StringBuffer msg = new StringBuffer();
            if (StringUtils.isEmpty((CharSequence)idCardNO)) {
                msg.append("NO_IDCARD_NO");
            }
            if (StringUtils.isEmpty((CharSequence)cell)) {
                if (msg.length() > 0) {
                    msg.append(",").append("NO_CELL");
                } else {
                    msg.append("NO_CELL");
                }
            }
            if ("80EF7DED".equals(bosType)) {
                boolean isWx = (Boolean)dataMap.get("isWx");
                if (isWx) {
                    if (StringUtils.isEmpty((CharSequence)wxOpenId)) {
                        if (msg.length() > 0) {
                            msg.append(",").append("NO_WX");
                        } else {
                            msg.append("NO_WX");
                        }
                    }
                } else if (StringUtils.isEmpty((CharSequence)openId)) {
                    if (msg.length() > 0) {
                        msg.append(",").append("NO_OPEN_ID");
                    } else {
                        msg.append("NO_OPEN_ID");
                    }
                }
            }
            if (msg.length() > 0) {
                String realObj = this.getMsgInfo(msg.toString());
                throw new BOSException(realObj);
            }
        } else {
            String label13 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label13", (Context)this.ctx);
            throw new BOSException(label13);
        }
    }

    private String getMsgInfo(String selectItem) {
        if ("NO_IDCARD_NO".equals(selectItem)) {
            String label14 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label14", (Context)this.ctx);
            return label14;
        }
        if ("NO_IDCARD_NO,NO_CELL".equals(selectItem)) {
            String label15 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label15", (Context)this.ctx);
            return label15;
        }
        if ("NO_IDCARD_NO,NO_OPEN_ID".equals(selectItem)) {
            String label18 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label18", (Context)this.ctx);
            return label18;
        }
        if ("NO_IDCARD_NO,NO_WX".equals(selectItem)) {
            String label19 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label19", (Context)this.ctx);
            return label19;
        }
        if ("NO_IDCARD_NO,NO_CELL,NO_OPEN_ID".equals(selectItem)) {
            String label20 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label20", (Context)this.ctx);
            return label20;
        }
        if ("NO_IDCARD_NO,NO_CELL,NO_WX".equals(selectItem)) {
            String label21 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label21", (Context)this.ctx);
            return label21;
        }
        if ("NO_CELL".equals(selectItem)) {
            String label16 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label16", (Context)this.ctx);
            return label16;
        }
        if ("NO_CELL,NO_OPEN_ID".equals(selectItem)) {
            String label22 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label22", (Context)this.ctx);
            return label22;
        }
        if ("NO_CELL,NO_WX".equals(selectItem)) {
            String label23 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label23", (Context)this.ctx);
            return label23;
        }
        if ("NO_OPEN_ID".equals(selectItem)) {
            String label17 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label17", (Context)this.ctx);
            return label17;
        }
        String label24 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label24", (Context)this.ctx);
        return label24;
    }

    public static int getRandomMils() {
        return random.nextInt(2001) + 500;
    }

    public final Context getCtx() {
        return this.ctx;
    }

    public final String getThreadName() {
        return this.threadName;
    }

    public final CountDownLatch getLatch() {
        return this.latch;
    }

    public final String getJobId() {
        return this.jobId;
    }

    public final String getBillId() {
        return this.billId;
    }

    public final String getEntryId() {
        return this.entryId;
    }

    public final String getPersonId() {
        return this.personId;
    }

    public final boolean isBatch() {
        return this.isBatch;
    }

    public final String getCreatorId() {
        return this.creatorId;
    }

    public final BatchMessageTipsBody getMessageTips() {
        return this.messageTips;
    }
}

