/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.elecontract.service;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.IMSFServiceFacade;
import com.kingdee.shr.elecontract.IKDContractConfig;
import com.kingdee.shr.elecontract.IKDContractConfigAuthRecord;
import com.kingdee.shr.elecontract.KDContractConfigAuthRecordCollection;
import com.kingdee.shr.elecontract.KDContractConfigAuthRecordFactory;
import com.kingdee.shr.elecontract.KDContractConfigAuthRecordInfo;
import com.kingdee.shr.elecontract.KDContractConfigInfo;
import com.kingdee.shr.elecontract.KDManageType;
import com.kingdee.shr.elecontract.KDState;
import com.kingdee.shr.elecontract.app.KDContractConfigAuthRecordState;
import com.kingdee.shr.elecontract.app.KDContractServiceStatus;
import com.kingdee.shr.elecontract.util.KdContractConfigAuthRecordUtils;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KDContractConfigListGetDataThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(KDContractConfigListGetDataThread.class);
    private String threadName = "";
    private Context ctx;
    private CountDownLatch latch;
    private IMSFServiceFacade osfServiceFacade;
    private IKDContractConfig ikdContractConfig;
    private Map dataMap;

    public KDContractConfigListGetDataThread(Context ctx, CountDownLatch latch, IMSFServiceFacade osfServiceFacade, IKDContractConfig ikdContractConfig, Map dataMap) {
        this.ctx = ctx;
        this.latch = latch;
        this.osfServiceFacade = osfServiceFacade;
        this.ikdContractConfig = ikdContractConfig;
        this.dataMap = dataMap;
    }

    @Override
    public void run() {
        try {
            this.processManageInfo();
            this.processAuthRecordInfo();
            this.processAuthStateInfo();
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
        finally {
            this.latch.countDown();
        }
    }

    public void processManageInfo() {
        KDManageType manageType = null;
        try {
            Object manageTypeObj = this.dataMap.get("manageType");
            if (manageTypeObj != null && !"".equals(String.valueOf(manageTypeObj))) {
                int manageTypeValue = -1;
                if (manageTypeObj instanceof KDManageType) {
                    manageType = (KDManageType)((Object)manageTypeObj);
                    manageTypeValue = manageType.getValue();
                } else if (manageTypeObj instanceof BizEnumValueDTO) {
                    BizEnumValueDTO enumValueDTO = (BizEnumValueDTO)manageTypeObj;
                    manageTypeValue = enumValueDTO.getInt();
                } else {
                    String manageTypeStr = String.valueOf(manageTypeObj);
                    manageTypeValue = KDManageType.LEGALPERSON.getAlias(this.ctx.getLocale()).equalsIgnoreCase(manageTypeStr) ? KDManageType.LEGALPERSON.getValue() : KDManageType.AUTHORIZEDAGENT.getValue();
                }
                if (KDManageType.LEGALPERSON.getValue() == manageTypeValue) {
                    this.dataMap.put("manageName", this.dataMap.get("enterpriseLegal"));
                } else {
                    this.dataMap.put("manageName", this.dataMap.get("agentLinkMan"));
                }
            } else {
                this.dataMap.put("manageName", this.dataMap.get("enterpriseLegal"));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void processAuthStateInfo() throws EASBizException, BOSException {
        Object stateObj;
        String id = (String)this.dataMap.get("id");
        String userId = (String)this.dataMap.get("clientEnterpriseId");
        String clientKDAppId = (String)this.dataMap.get("clientKDAppId");
        String clientSecret = (String)this.dataMap.get("clientSecret");
        String cloudServerUrl = (String)this.dataMap.get("cloudServerUrl");
        BizEnumValueDTO cloudSysVersion = (BizEnumValueDTO)this.dataMap.get("cloudSysVersion");
        if (!(StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)clientKDAppId) || StringUtils.isEmpty((String)clientSecret) || StringUtils.isEmpty((String)cloudServerUrl) || cloudSysVersion == null || (stateObj = this.dataMap.get("state")) == null || StringUtils.isEmpty((String)String.valueOf(stateObj)) || !(stateObj instanceof BizEnumValueDTO))) {
            BizEnumValueDTO state = (BizEnumValueDTO)stateObj;
            logger.error("afterGetListData state : " + state);
            int stateValue = state.getInt();
            if (KDState.NOAUTH.getValue() != stateValue && KDState.NOPASS.getValue() != stateValue && KDState.PASS.getValue() != stateValue) {
                JSONObject objectJson;
                HashMap<String, Object> osfDataMap = new HashMap<String, Object>();
                osfDataMap.put("userId", userId);
                osfDataMap.put("kdAppId", clientKDAppId);
                osfDataMap.put("secret", clientSecret);
                osfDataMap.put("version", cloudSysVersion.getValue());
                osfDataMap.put("serverURL", cloudServerUrl);
                Object result = this.osfServiceFacade.processService("electronicLaborGetAuthResultService", osfDataMap);
                if (result != null && 0 == (objectJson = result instanceof JSONObject ? (JSONObject)result : JSONObject.parseObject((String)result.toString())).getIntValue("code")) {
                    KDContractConfigInfo info = null;
                    SelectorItemCollection selector = new SelectorItemCollection();
                    info = new KDContractConfigInfo();
                    info.setId(BOSUuid.read((String)id));
                    JSONObject data = objectJson.getJSONObject("data");
                    int resultCode = data.getIntValue("resultCode");
                    if (stateValue != resultCode) {
                        selector.clear();
                        selector.add(new SelectorItemInfo("state"));
                        if (1 == resultCode) {
                            this.dataMap.put("state", KDState.PASS);
                            info.setState(KDState.PASS);
                            info.setServiceStatus(KDContractServiceStatus.REGISTSUCC);
                            selector.add(new SelectorItemInfo("serviceStatus"));
                        } else if (0 == resultCode) {
                            this.dataMap.put("state", KDState.NOPASS);
                            info.setState(KDState.NOPASS);
                            info.setServiceStatus(KDContractServiceStatus.REGISTFAILED);
                            selector.add(new SelectorItemInfo("serviceStatus"));
                        } else if (2 == resultCode) {
                            this.dataMap.put("state", KDState.AUTHING);
                            info.setState(KDState.AUTHING);
                        } else if (3 == resultCode) {
                            this.dataMap.put("state", KDState.TOAUDIT);
                            info.setState(KDState.TOAUDIT);
                        }
                        this.ikdContractConfig.updatePartial(info, selector);
                    }
                }
            }
        }
    }

    public void processAuthRecordInfo() {
        String id = (String)this.dataMap.get("id");
        String userId = (String)this.dataMap.get("clientEnterpriseId");
        EntityViewInfo view = new EntityViewInfo();
        try {
            KDContractConfigAuthRecordState authState = KDContractConfigAuthRecordState.Unauthorized;
            this.dataMap.put("authState", authState);
            String authId = "";
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("config.id", (Object)id.toString()));
            filter.getFilterItems().add(new FilterItemInfo("enterpId", (Object)userId));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
            view.setSelector(selector);
            IKDContractConfigAuthRecord ikdContractConfigAuthRecord = KDContractConfigAuthRecordFactory.getLocalInstance(this.ctx);
            KDContractConfigAuthRecordCollection authRecordCollection = ikdContractConfigAuthRecord.getKDContractConfigAuthRecordCollection(view);
            if (authRecordCollection != null && authRecordCollection.size() > 0) {
                boolean isQueryCancelAuth;
                KDContractConfigAuthRecordInfo authRecordInfo = authRecordCollection.get(0);
                if (authRecordInfo.get("state") != null) {
                    authState = authRecordInfo.getState();
                    this.dataMap.put("authState", authState);
                }
                authId = authRecordInfo.getId().toString();
                String authUrl = authRecordInfo.getAuthUrl();
                String cancelAuthUrl = authRecordInfo.getCancelAuthUrl();
                boolean isQueryAuth = !StringUtils.isEmpty((String)authUrl) && KDContractConfigAuthRecordState.Unauthorized.equals((Object)authState);
                boolean bl = isQueryCancelAuth = !StringUtils.isEmpty((String)cancelAuthUrl) && KDContractConfigAuthRecordState.Authorized.equals((Object)authState);
                if (isQueryAuth || isQueryCancelAuth) {
                    KdContractConfigAuthRecordUtils.refreshAuthRecordState(this.ctx, authRecordInfo, this.dataMap);
                }
            }
            this.dataMap.put("authId", authId);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

