/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.elecontract.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.elecontract.util.CloudHubPropertyConstant;
import com.kingdee.shr.shareservice.ISSCPropertyConfig;
import com.kingdee.shr.shareservice.SSCPropertyConfigCollection;
import com.kingdee.shr.shareservice.SSCPropertyConfigFactory;
import com.kingdee.shr.shareservice.SSCPropertyConfigInfo;
import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudHubPropertiesUtilsV2 {
    private static final Logger logger = LoggerFactory.getLogger(CloudHubPropertiesUtilsV2.class);
    private Map<String, String> propertyMap = new ConcurrentHashMap<String, String>();
    private static Properties instance = new Properties();
    private static CloudHubPropertiesUtilsV2 v2 = null;

    private CloudHubPropertiesUtilsV2() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void init(Context ctx) {
        if (null != v2) return;
        Class<CloudHubPropertiesUtilsV2> clazz = CloudHubPropertiesUtilsV2.class;
        synchronized (CloudHubPropertiesUtilsV2.class) {
            if (null != v2) return;
            try {
                v2 = null;
                v2 = new CloudHubPropertiesUtilsV2();
                HashMap<String, SSCPropertyConfigInfo> notFinishMap = new HashMap<String, SSCPropertyConfigInfo>();
                ISSCPropertyConfig isscPropertyConfig = SSCPropertyConfigFactory.getLocalInstance((Context)ctx);
                SSCPropertyConfigCollection sscPropertyConfigCollection = isscPropertyConfig.getSSCPropertyConfigCollection(CloudHubPropertiesUtilsV2.getEntityViewInfo());
                if (sscPropertyConfigCollection.size() > 0) {
                    for (int i = 0; i < sscPropertyConfigCollection.size(); ++i) {
                        SSCPropertyConfigInfo sscPropertyConfigInfo = sscPropertyConfigCollection.get(i);
                        if (sscPropertyConfigInfo.isIsFinish()) {
                            String value = StringUtils.isEmpty((String)sscPropertyConfigInfo.getKValue()) ? sscPropertyConfigInfo.getDefaultValue() : sscPropertyConfigInfo.getKValue();
                            v2.getPropertyMap().put(sscPropertyConfigInfo.getKey(), value);
                            continue;
                        }
                        notFinishMap.put(sscPropertyConfigInfo.getKey(), sscPropertyConfigInfo);
                    }
                }
                sscPropertyConfigCollection = null;
                CloudHubPropertiesUtilsV2.load(CloudHubPropertiesUtilsV2.getPropertiesFile());
                for (int i = 0; i < CloudHubPropertyConstant.DEFAULT_CONTRACT_KEY.length; ++i) {
                    String key;
                    instance.put(key, instance.containsKey(key = CloudHubPropertyConstant.DEFAULT_CONTRACT_KEY[i]) ? instance.getProperty(key) : CloudHubPropertyConstant.DEFAULT_CONTRACT_VALUE[i]);
                }
                Set<String> properties = instance.stringPropertyNames();
                SSCPropertyConfigCollection updateColls = new SSCPropertyConfigCollection();
                CoreBaseCollection addColls = new CoreBaseCollection();
                if (properties.size() > 0) {
                    for (String property : properties) {
                        if (StringUtils.isEmpty((String)property) || v2.getPropertyMap().containsKey(property)) continue;
                        if (notFinishMap.containsKey(property)) {
                            SSCPropertyConfigInfo updateInfo = (SSCPropertyConfigInfo)notFinishMap.get(property);
                            updateInfo.setKValue(instance.getProperty(property));
                            updateInfo.setIsFinish(true);
                            updateColls.add(updateInfo);
                            v2.getPropertyMap().put(property, instance.getProperty(property));
                            notFinishMap.remove(property);
                            continue;
                        }
                        v2.getPropertyMap().put(property, instance.getProperty(property));
                        SSCPropertyConfigInfo addInfo = new SSCPropertyConfigInfo();
                        addInfo.setKey(property);
                        addInfo.setKValue(instance.getProperty(property));
                        addInfo.setDefaultValue(instance.getProperty(property));
                        addInfo.setIsFinish(true);
                        addColls.add((CoreBaseInfo)addInfo);
                    }
                }
                if (notFinishMap.size() > 0) {
                    Set entrySet = notFinishMap.entrySet();
                    for (Map.Entry entry : entrySet) {
                        SSCPropertyConfigInfo updateInfo = (SSCPropertyConfigInfo)entry.getValue();
                        updateInfo.setKValue(updateInfo.getDefaultValue());
                        updateInfo.setIsFinish(true);
                        updateColls.add(updateInfo);
                    }
                }
                if (updateColls.size() > 0) {
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("kValue"));
                    selector.add(new SelectorItemInfo("isFinish"));
                    isscPropertyConfig.updatePartialBatchData((IObjectCollection)updateColls, selector);
                }
                if (addColls.size() > 0) {
                    isscPropertyConfig.addnew(addColls);
                }
                updateColls = null;
                addColls = null;
                notFinishMap = null;
                logger.error("CloudHubPropertiesUtilsV2\u521d\u59cb\u5316\u6210\u529f + " + v2.getPropertyMap());
            }
            catch (BOSException e) {
                logger.error("CloudHubPropertiesUtilsV2\u521d\u59cb\u5316\u5f02\u5e38");
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                logger.error("CloudHubPropertiesUtilsV2\u521d\u59cb\u5316\u5f02\u5e38");
                logger.error(e.getMessage(), (Throwable)e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(File file) {
        if (file.exists()) {
            FileReader fileReader = null;
            BufferedReader bufferedReader = null;
            try {
                fileReader = new FileReader(file);
                bufferedReader = new BufferedReader(fileReader);
                instance.clear();
                instance.load(bufferedReader);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        } else {
            logger.error("can't not find the config file " + file.getName());
        }
    }

    private static File getPropertiesFile() {
        String path = CloudHubPropertyConstant.PROPERTIES_PATH + System.getProperties().getProperty("file.separator") + "CloudHubMessageConfig.properties";
        return new File(SHRCheck.checkFilePath((String)path));
    }

    public static String getProperty(Context ctx, String key) {
        CloudHubPropertiesUtilsV2.init(ctx);
        return v2.getPropertyMap().get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPropertyMap() {
        Class<CloudHubPropertiesUtilsV2> clazz = CloudHubPropertiesUtilsV2.class;
        synchronized (CloudHubPropertiesUtilsV2.class) {
            if (v2 == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            v2.setPropertyMap(null);
            v2 = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private Map<String, String> getPropertyMap() {
        return this.propertyMap;
    }

    private void setPropertyMap(Map<String, String> propertyMap) {
        this.propertyMap = propertyMap;
    }

    private static EntityViewInfo getEntityViewInfo() {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("key"));
        selector.add(new SelectorItemInfo("kValue"));
        selector.add(new SelectorItemInfo("defaultValue"));
        selector.add(new SelectorItemInfo("type"));
        selector.add(new SelectorItemInfo("bizType"));
        selector.add(new SelectorItemInfo("isFinish"));
        view.setSelector(selector);
        return view;
    }
}

