/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.elecontract.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.contract.MapFieldSettingCollection;
import com.kingdee.eas.hr.contract.MapFieldSettingInfo;
import com.kingdee.eas.hr.contract.MapSolutionCollection;
import com.kingdee.eas.hr.contract.MapSolutionFactory;
import com.kingdee.eas.hr.contract.MapSolutionInfo;
import com.kingdee.eas.hr.contract.MapSolutionRelaCollection;
import com.kingdee.eas.hr.contract.MapSolutionRelaInfo;
import com.kingdee.shr.base.syssetting.app.util.MetaDataUtil;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactBillMiddleUtils {
    public static final Logger logger = LoggerFactory.getLogger(ContactBillMiddleUtils.class);
    public static final String DEFAULT_QUERY_METANAME = "com.kingdee.shr.econtractservice.app.ElectronicContractBizBillQuery";
    public static final String DEFAULT_OTHER_QUERY_METANAME = "com.kingdee.shr.elecontract.app.OtherEContractSignBizBillQuery";
    public static final String CONTRACT_QUERY_ID = "001";
    public static final String OTHER_CONTRACT_QUERY_ID = "002";

    public static String getQueryMeta(String queryId) {
        if (OTHER_CONTRACT_QUERY_ID.equals(queryId)) {
            return DEFAULT_OTHER_QUERY_METANAME;
        }
        return DEFAULT_QUERY_METANAME;
    }

    public static void copyData(Context ctx, IObjectValue sourceModel, IObjectValue targetModel) throws BOSException {
        String sourceProName;
        if (sourceModel == null || targetModel == null) {
            return;
        }
        BOSObjectType sourceBosType = sourceModel.getBOSType();
        EntityObjectInfo sourceEntity = MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)sourceBosType);
        String sourceFullName = sourceEntity.getFullName();
        PropertyCollection sourcePropertyCollection = sourceEntity.getPropertiesRuntime();
        BOSObjectType targetBosType = targetModel.getBOSType();
        EntityObjectInfo targetEntity = MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)targetBosType);
        String targetFullName = targetEntity.getFullName();
        MapSolutionCollection mapSolution = ContactBillMiddleUtils.getMapSolution(ctx, sourceFullName, targetFullName);
        MapSolutionInfo mapSolutionInfo = mapSolution.get(0);
        MapFieldSettingCollection fields = mapSolutionInfo.getFields();
        MapFieldSettingInfo settingInfo = null;
        ArrayList tempSettingList = null;
        logger.error("ContactBillMiddleUtils.copyData sourceFullName mapSolutionInfo.getFields() : " + fields.size());
        HashMap<String, ArrayList<MapFieldSettingInfo>> settingInfoMap = new HashMap<String, ArrayList<MapFieldSettingInfo>>();
        for (int dex = 0; dex < fields.size(); ++dex) {
            settingInfo = fields.get(dex);
            sourceProName = settingInfo.getSourceProName().toLowerCase();
            ArrayList<MapFieldSettingInfo> sourceProNameList = (ArrayList<MapFieldSettingInfo>)settingInfoMap.get(sourceProName);
            if (sourceProNameList == null) {
                sourceProNameList = new ArrayList<MapFieldSettingInfo>();
                settingInfoMap.put(sourceProName, sourceProNameList);
            }
            sourceProNameList.add(settingInfo);
        }
        HashMap cloneMap = (HashMap)settingInfoMap.clone();
        sourceProName = null;
        String targetProName = null;
        PropertyInfo sourceProperty = null;
        PropertyInfo targetProperty = null;
        for (int dex = 0; dex < sourcePropertyCollection.size(); ++dex) {
            sourceProperty = sourcePropertyCollection.get(dex);
            sourceProName = sourceProperty.getName();
            if (ContactBillMiddleUtils.isCopyExcludeField(sourceProName)) continue;
            tempSettingList = (ArrayList)settingInfoMap.get(sourceProName);
            if (tempSettingList != null && tempSettingList.size() > 0) {
                for (int index = 0; index < tempSettingList.size(); ++index) {
                    settingInfo = (MapFieldSettingInfo)tempSettingList.get(index);
                    targetProName = settingInfo == null ? sourceProName : settingInfo.getTargetProName();
                    targetProperty = targetEntity.getPropertyByNameRuntime(targetProName);
                    if (targetProperty == null) {
                        logger.error("one ContactBillMiddleUtils.copyData targetProName: " + targetProName);
                        logger.error("one ContactBillMiddleUtils.copyData sourceProName: " + sourceProName);
                        continue;
                    }
                    tempSettingList.remove(settingInfo);
                    ContactBillMiddleUtils.processCopySetData(ctx, settingInfo, sourceModel, sourceProperty, sourceProName, targetModel, targetProperty, targetProName);
                }
                if (tempSettingList.size() > 0) {
                    cloneMap.put(sourceProName, (ArrayList)tempSettingList.clone());
                    continue;
                }
                cloneMap.remove(sourceProName);
                continue;
            }
            targetProName = sourceProName;
            targetProperty = targetEntity.getPropertyByNameRuntime(targetProName);
            if (targetProperty == null) {
                logger.error("two ContactBillMiddleUtils.copyData targetProName: " + targetProName);
                logger.error("two ContactBillMiddleUtils.copyData sourceProName: " + sourceProName);
                continue;
            }
            cloneMap.remove(sourceProName);
            ContactBillMiddleUtils.processCopySetData(ctx, settingInfo, sourceModel, sourceProperty, sourceProName, targetModel, targetProperty, targetProName);
        }
        if (cloneMap.size() > 0) {
            Set entrySet = cloneMap.entrySet();
            for (Map.Entry entry : entrySet) {
                sourceProName = (String)entry.getKey();
                tempSettingList = (ArrayList)entry.getValue();
                if (tempSettingList == null || tempSettingList.size() <= 0) continue;
                for (int index = 0; index < tempSettingList.size(); ++index) {
                    settingInfo = (MapFieldSettingInfo)tempSettingList.get(index);
                    targetProName = settingInfo.getTargetProName();
                    targetProperty = targetEntity.getPropertyByNameRuntime(targetProName);
                    sourceProperty = sourceEntity.getPropertyByNameRuntime(sourceProName);
                    if (targetProperty == null || sourceProperty == null) {
                        logger.error("three ContactBillMiddleUtils.copyData targetProName: " + targetProName);
                        logger.error("three ContactBillMiddleUtils.copyData sourceProName: " + sourceProName);
                        continue;
                    }
                    ContactBillMiddleUtils.processCopySetData(ctx, settingInfo, sourceModel, sourceProperty, sourceProName, targetModel, targetProperty, targetProName);
                }
            }
        }
    }

    public static void copy2(Context ctx, IObjectValue sourceModel, IObjectValue targetModel, MapSolutionInfo mapSolutionInfo, EntityObjectInfo sourceEntity) throws BOSException {
        MapSolutionRelaCollection relationColl = mapSolutionInfo.getRelations();
        for (int dex = 0; dex < relationColl.size(); ++dex) {
            PropertyInfo property;
            String relaProName;
            MapSolutionRelaInfo relaInfo = relationColl.get(dex);
            if (!relaInfo.getId().toString().equals(mapSolutionInfo.getId().toString()) || StringUtils.isEmpty((String)(relaProName = relaInfo.getRelaProName())) || sourceEntity.getPropertyByNameRuntime(relaProName) == null || !((property = sourceEntity.getPropertyByNameRuntime(relaProName)) instanceof LinkPropertyInfo) || sourceModel.get(relaProName) == null || !(sourceModel.get(relaProName) instanceof IObjectValue)) continue;
            IObjectValue object = (IObjectValue)sourceModel.get(relaProName);
            ContactBillMiddleUtils.copyData(ctx, object, targetModel);
        }
    }

    public static MapSolutionCollection getMapSolution(Context ctx, String sourceImplName, String middleImplName) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("fields.*"));
        selector.add(new SelectorItemInfo("relations.*"));
        filter.getFilterItems().add(new FilterItemInfo("sourceEntity", (Object)sourceImplName));
        view.setFilter(filter);
        view.setSelector(selector);
        MapSolutionCollection collection = MapSolutionFactory.getLocalInstance((Context)ctx).getMapSolutionCollection(view);
        return collection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void processCopySetData(Context ctx, MapFieldSettingInfo settingInfo, IObjectValue sourceModel, PropertyInfo sourceProperty, String sourceProName, IObjectValue targetModel, PropertyInfo targetProperty, String targetProName) {
        if (targetProperty instanceof OwnPropertyInfo && sourceProperty instanceof OwnPropertyInfo) {
            OwnPropertyInfo targetOwnProperty = (OwnPropertyInfo)targetProperty;
            OwnPropertyInfo sourceOwnProperty = (OwnPropertyInfo)sourceProperty;
            if (targetOwnProperty.getDataType().equals((Object)sourceOwnProperty.getDataType())) {
                if (targetOwnProperty.isMultilingual() && sourceOwnProperty.isMultilingual()) {
                    targetModel.put(targetProName, sourceModel.get(sourceProName, LocaleUtils.locale_l1), LocaleUtils.locale_l1);
                    targetModel.put(targetProName, sourceModel.get(sourceProName, LocaleUtils.locale_l2), LocaleUtils.locale_l2);
                    targetModel.put(targetProName, sourceModel.get(sourceProName, LocaleUtils.locale_l3), LocaleUtils.locale_l3);
                    return;
                }
                if (targetOwnProperty.isMultilingual()) {
                    targetModel.put(targetProName, sourceModel.get(sourceProName), LocaleUtils.locale_l1);
                    targetModel.put(targetProName, sourceModel.get(sourceProName), LocaleUtils.locale_l2);
                    targetModel.put(targetProName, sourceModel.get(sourceProName), LocaleUtils.locale_l3);
                    return;
                }
                if (sourceOwnProperty.isMultilingual()) {
                    targetModel.put(targetProName, sourceModel.get(sourceProName, ctx.getLocale()));
                    return;
                }
                targetModel.put(targetProName, sourceModel.get(sourceProName));
                return;
            }
            if (targetOwnProperty.getDataType().equals((Object)DataType.SHORT)) {
                targetModel.put(targetProName, (Object)TypeConversionUtils.objToShort((Object)sourceModel.get(sourceProName)));
                return;
            }
            if (targetOwnProperty.getDataType().equals((Object)DataType.INTEGER)) {
                if (sourceModel.get(sourceProName) != null) {
                    targetModel.put(targetProName, (Object)TypeConversionUtils.objToInteger((Object)sourceModel.get(sourceProName)));
                    return;
                }
                targetModel.put(targetProName, null);
                return;
            }
            if (targetOwnProperty.getDataType().equals((Object)DataType.LONG)) {
                if (sourceModel.get(sourceProName) != null) {
                    targetModel.put(targetProName, (Object)TypeConversionUtils.objToLong((Object)sourceModel.get(sourceProName)));
                    return;
                }
                targetModel.put(targetProName, null);
                return;
            }
            if (targetOwnProperty.getDataType().equals((Object)DataType.FLOAT)) {
                if (sourceModel.get(sourceProName) != null) {
                    targetModel.put(targetProName, (Object)Float.valueOf(TypeConversionUtils.objToFloat((Object)sourceModel.get(sourceProName))));
                    return;
                }
                targetModel.put(targetProName, null);
                return;
            }
            if (targetOwnProperty.getDataType().equals((Object)DataType.DOUBLE)) {
                if (sourceModel.get(sourceProName) != null) {
                    targetModel.put(targetProName, (Object)TypeConversionUtils.objToDouble((Object)sourceModel.get(sourceProName)));
                    return;
                }
                targetModel.put(targetProName, null);
                return;
            }
            if (targetOwnProperty.getDataType().equals((Object)DataType.DECIMAL)) {
                targetModel.put(targetProName, (Object)TypeConversionUtils.objToBigDecimal((Object)sourceModel.get(sourceProName)));
                return;
            }
            if (targetOwnProperty.getDataType().equals((Object)DataType.DATE)) {
                targetModel.put(targetProName, (Object)TypeConversionUtils.objToDate((Object)sourceModel.get(sourceProName)));
                return;
            }
            if (targetOwnProperty.getDataType().equals((Object)DataType.TIMESTAMP)) {
                targetModel.put(targetProName, (Object)TypeConversionUtils.objToTimestamp((Object)sourceModel.get(sourceProName)));
                return;
            }
            if (targetOwnProperty.getDataType().equals((Object)DataType.CHAR)) {
                targetModel.put(targetProName, (Object)Character.valueOf(((Character)sourceModel.get(sourceProName)).charValue()));
                return;
            }
            if (targetOwnProperty.getDataType().equals((Object)DataType.BOOLEAN)) {
                targetModel.put(targetProName, (Object)TypeConversionUtils.objToBoolean((Object)sourceModel.get(sourceProName)));
                return;
            }
            if (targetOwnProperty.getDataType().equals((Object)DataType.BYTE)) {
                targetModel.put(targetProName, (Object)TypeConversionUtils.objToByte((Object)sourceModel.get(sourceProName)));
                return;
            }
            if (targetOwnProperty.getDataType().equals((Object)DataType.STRING)) {
                targetModel.put(targetProName, (Object)TypeConversionUtils.objToString((Object)sourceModel.get(sourceProName)));
                return;
            }
            if (targetOwnProperty.getDataType().equals((Object)DataType.BYTEARRAY)) {
                targetModel.put(targetProName, (Object)((byte[])sourceModel.get(sourceProName)));
                return;
            }
            if (targetOwnProperty.getDataType().equals((Object)DataType.BOSUUID)) {
                targetModel.put(targetProName, (Object)TypeConversionUtils.objToBOSUuid((Object)sourceModel.get(sourceProName)));
                return;
            }
            if (targetOwnProperty.getDataType().equals((Object)DataType.UUID)) {
                targetModel.put(targetProName, (Object)TypeConversionUtils.objToUuid((Object)sourceModel.get(sourceProName)));
                return;
            }
            if (!targetOwnProperty.getDataType().equals((Object)DataType.ENUM)) return;
            return;
        } else {
            if (targetProperty instanceof LinkPropertyInfo && sourceProperty instanceof LinkPropertyInfo) {
                LinkPropertyInfo targetLinkProperty = (LinkPropertyInfo)targetProperty;
                LinkPropertyInfo sourceLinkProperty = (LinkPropertyInfo)sourceProperty;
                RelationshipInfo targetRelationship = targetLinkProperty.getRelationship();
                RelationshipInfo sourceRelationship = sourceLinkProperty.getRelationship();
                if (!sourceRelationship.getSupplierObject().getBusinessImplName().equals(targetRelationship.getSupplierObject().getBusinessImplName())) return;
                if (sourceModel.get(sourceProName) == null) return;
                targetModel.put(targetProName, sourceModel.get(sourceProName));
                return;
            }
            if (targetProperty instanceof OwnPropertyInfo && sourceProperty instanceof LinkPropertyInfo) {
                String sourceLinkProAttr = settingInfo == null || StringUtils.isEmpty((String)settingInfo.getSourceLinkProAttr()) ? "name" : settingInfo.getSourceLinkProAttr();
                if (sourceModel.get(sourceProName) == null) return;
                IObjectValue linkModel = (IObjectValue)sourceModel.get(sourceProName);
                if (linkModel.get(sourceLinkProAttr) != null) {
                    targetModel.put(targetProName, linkModel.get(sourceLinkProAttr));
                    return;
                }
                try {
                    String pkField = linkModel.getPKField();
                    if (StringUtils.isEmpty((String)pkField)) return;
                    if (linkModel.get(pkField) == null) return;
                    String pkString = linkModel.get(pkField).toString();
                    ObjectUuidPK pk = new ObjectUuidPK(pkString);
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo(pkField));
                    selector.add(new SelectorItemInfo(sourceLinkProAttr));
                    ICoreBase bizInterface = MetaDataUtil.getBizInterface((Context)ctx, (BOSObjectType)linkModel.getBOSType());
                    CoreBaseInfo linkModelValue = bizInterface.getValue((IObjectPK)pk, selector);
                    targetModel.put(targetProName, linkModelValue.get(sourceLinkProAttr));
                    return;
                }
                catch (Exception e) {
                    targetModel.put(targetProName, linkModel.get(sourceLinkProAttr));
                    return;
                }
            }
            if (!(sourceProperty instanceof LinkPropertyInfo)) return;
            if (!(targetProperty instanceof OwnPropertyInfo)) return;
        }
    }

    private static boolean isCopyExcludeField(String key) {
        return key.equalsIgnoreCase("id") || key.equalsIgnoreCase("creator") || key.equalsIgnoreCase("createTime") || key.equalsIgnoreCase("lastUpdateUser") || key.equalsIgnoreCase("lastUpdateTime") || key.equalsIgnoreCase("CU");
    }
}

