/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.elecontract.util;

import com.kingdee.shr.elecontract.util.Base64Utils;
import java.net.URLEncoder;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptUtil {
    private static final Logger logger = LoggerFactory.getLogger(EncryptUtil.class);
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";
    private static final String KEY_ALGORITHM = "AES";

    public static String encryptAES(String content, String key) {
        String encryptStr = "";
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(1, EncryptUtil.generateKey(key));
            byte[] result = cipher.doFinal(content.getBytes());
            encryptStr = URLEncoder.encode(Base64Utils.encode(result), "UTF-8");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return encryptStr;
    }

    public static String decryptData(String data, String key) {
        try {
            byte[] decode = Base64Utils.decodeAsByte(data);
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(2, EncryptUtil.generateKey(key));
            return new String(cipher.doFinal(decode), "UTF-8");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return data;
        }
    }

    private static SecretKey generateKey(String key) throws Exception {
        return new SecretKeySpec(key.getBytes(), KEY_ALGORITHM);
    }
}

