/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.elecontract.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.cloudservice.util.HttpClientUtil;
import com.kingdee.shr.cloudservice.util.TSPServerInstance;
import com.kingdee.shr.elecontract.IKDContractConfig;
import com.kingdee.shr.elecontract.KDContractConfigFactory;
import com.kingdee.shr.elecontract.KDContractConfigInfo;
import com.kingdee.shr.elecontract.util.CheckHRCloudLicenseUtils;
import com.kingdee.shr.elecontract.util.CloudHubPropertiesUtilsV2;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.UuidException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KDConfigUtils {
    private static final Logger logger = LoggerFactory.getLogger(KDConfigUtils.class);

    public void checkTspInfo(Context ctx) throws BOSException, EASBizException {
        Map serverMap = null;
        String serviceId = "";
        try {
            serverMap = TSPServerInstance.getServerInfo((Context)ctx);
            serviceId = (String)serverMap.get("service_id");
        }
        catch (NullPointerException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (StringUtil.isEmpty((String)serviceId)) {
            String label36 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label36", (Context)ctx);
            throw new BOSException(label36 + "TSPServerInstance.getServerInfo(ctx) \uff1a " + serverMap);
        }
    }

    public void sendInfoToTsp(Context ctx, KDContractConfigInfo info) throws BOSException, EASBizException {
        Map serverMap = null;
        String tspServerUrl = "";
        try {
            serverMap = TSPServerInstance.getServerInfo((Context)ctx);
            tspServerUrl = CheckHRCloudLicenseUtils.getHRCloudBaseAddress(ctx);
            IKDContractConfig iKDContractConfig = KDContractConfigFactory.getLocalInstance(ctx);
            info = iKDContractConfig.getKDContractConfigInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()));
            if (null != info && info.isSyncToCloudService()) {
                logger.info("kdContractConfig already sync");
                return;
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        String serviceId = (String)serverMap.get("service_id");
        if (StringUtil.isEmpty((String)serviceId)) {
            String label36 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label36", (Context)ctx);
            throw new BOSException(label36 + "TSPServerInstance.getServerInfo(ctx) \uff1a " + serverMap);
        }
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("enterpriseName", info.getEnterpriseName());
        dataMap.put("kdAppId", info.getClientKDAppId());
        dataMap.put("serviceId", serviceId);
        dataMap.put("enterpriseId", info.getClientEnterpriseId());
        dataMap.put("cloudSysVersion", info.getCloudSysVersion().getValue());
        dataMap.put("cloudServerUrl", info.getCloudServerUrl());
        dataMap.put("clientSecret", info.getClientSecret());
        String tspInterfaceUrl = "";
        tspInterfaceUrl = tspServerUrl.endsWith("/") ? tspServerUrl + "kdcontract/kdcontract/sysconfig/save" + "?randomuuid=" + HttpClientUtil.generateShortUuid() : tspServerUrl + "/" + "kdcontract/kdcontract/sysconfig/save" + "?randomuuid=" + HttpClientUtil.generateShortUuid();
        String label25 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label25", (Context)ctx);
        logger.error(label25 + "dataMap " + dataMap);
        logger.error(label25 + "tspInterfaceUrl " + tspInterfaceUrl);
        JSONObject jsonObejct = HttpClientUtil.postForm((Context)ctx, (String)tspInterfaceUrl, dataMap);
        String label29 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label29", (Context)ctx);
        logger.error(label29 + jsonObejct.toString());
        int status = jsonObejct.getInt("status");
        if (status == 200) {
            try {
                JSONObject jsData = jsonObejct.getJSONObject("result");
                if (!"0".equals(jsData.getString("errcode"))) {
                    String label30 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label30", (Context)ctx);
                    throw new BOSException(label30);
                }
                SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
                selectorItemCollection.add(new SelectorItemInfo("syncToCloudService"));
                KDContractConfigInfo kdContractConfigInfo = new KDContractConfigInfo();
                kdContractConfigInfo.setId(info.getId());
                kdContractConfigInfo.setSyncToCloudService(true);
                KDContractConfigFactory.getLocalInstance(ctx).updatePartial(kdContractConfigInfo, selectorItemCollection);
                String label31 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label31", (Context)ctx);
                logger.error(label31);
            }
            catch (Exception e) {
                String label32 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label32", (Context)ctx);
                throw new BOSException(label32);
            }
        } else {
            String label_32 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label32", (Context)ctx);
            throw new BOSException(label_32);
        }
    }

    public void processClientInfo(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        try {
            IKDContractConfig iKDContractConfig = KDContractConfigFactory.getLocalInstance(ctx);
            KDContractConfigInfo def = iKDContractConfig.getDefaultConfigInfo();
            logger.error("processClientInfo" + model.toString());
            String clientKDAppId = model.getString("clientKDAppId");
            String clientSecret = model.getString("clientSecret");
            if (def.getClientKDAppId().equals(clientKDAppId) && def.getClientSecret().equals(clientSecret)) {
                JSONObject result;
                JSONObject jsonObject = this.getKDAppInfoFromCloud(ctx, model);
                int returnCode = jsonObject.getInt("status");
                if (returnCode == 200) {
                    result = new JSONObject();
                    result = jsonObject.get("result") instanceof JSONObject ? jsonObject.getJSONObject("result") : JSONObject.fromObject((Object)jsonObject.get("result"));
                    if (result.get("code") != null && result.getInt("code") != 0) {
                        String label37 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label37", (Context)ctx);
                        throw new BOSException(label37 + "," + result.getString("msg"));
                    }
                } else {
                    String label17 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label17", (Context)ctx);
                    String realObj = MessageFormat.format(label17, returnCode, jsonObject.getString("msg"));
                    logger.error(realObj);
                    String label37 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label37", (Context)ctx);
                    throw new BOSException(label37);
                }
                JSONObject data = new JSONObject();
                data = result.get("data") instanceof JSONObject ? result.getJSONObject("data") : JSONObject.fromObject((Object)result.get("data"));
                clientKDAppId = data.getString("kdAppId");
                clientSecret = data.getString("uuid");
                model.setString("clientKDAppId", clientKDAppId);
                model.setString("clientSecret", clientSecret);
                this.saveClientKdAppIdAndSecret(ctx, model);
            }
        }
        catch (UuidException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public JSONObject getKDAppInfoFromCloud(Context ctx, CoreBaseInfo model) {
        String productName;
        String client_secret;
        String client_id;
        String serverBaseUrl;
        String serverUrl = CloudHubPropertiesUtilsV2.getProperty(ctx, "cloud.interface.server");
        if (StringUtils.isEmpty((CharSequence)serverUrl)) {
            serverUrl = "https://api.kingdee.com/";
        }
        if (StringUtils.isEmpty((CharSequence)(serverBaseUrl = CloudHubPropertiesUtilsV2.getProperty(ctx, "cloud.interface.base.url")))) {
            serverBaseUrl = "emerchant/merchant/add";
        }
        if (StringUtils.isEmpty((CharSequence)(client_id = CloudHubPropertiesUtilsV2.getProperty(ctx, "cloud.client.id")))) {
            client_id = "200234";
        }
        if (StringUtils.isEmpty((CharSequence)(client_secret = CloudHubPropertiesUtilsV2.getProperty(ctx, "cloud.client.secret")))) {
            client_secret = "fde99eee9d188df7636b34de3fe3d6ce";
        }
        if (StringUtils.isEmpty((CharSequence)(productName = CloudHubPropertiesUtilsV2.getProperty(ctx, "cloud.client.product")))) {
            productName = "sHR";
        }
        String kdAppDesc = model.getString("enterpriseName");
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("product", productName);
        dataMap.put("kdAppDesc", kdAppDesc);
        String reallyUrl = serverUrl + serverBaseUrl + "?client_id=" + client_id + "&client_secret=" + client_secret;
        logger.error(SHRCheck.vaildLog((String)("KDContractConfigControllerBean getKDAppInfoFromCloud : reallyUrl " + reallyUrl + " dataMap " + dataMap)));
        JSONObject jsonObject = HttpClientUtil.postForm((Context)ctx, (String)reallyUrl, dataMap);
        logger.error(SHRCheck.vaildLog((String)("KDContractConfigControllerBean getKDAppInfoFromCloud : jsonObject " + jsonObject)));
        return jsonObject;
    }

    public void saveClientKdAppIdAndSecret(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        String clientKDAppId = model.getString("clientKDAppId");
        String clientSecret = model.getString("clientSecret");
        StringBuffer sql = new StringBuffer();
        String id = model.getId().toString();
        sql.append("UPDATE ");
        sql.append("T_CDS_KDContractConfig ");
        sql.append("SET ");
        sql.append("FCLIENTKDAPPID = '");
        sql.append(clientKDAppId);
        sql.append("', ");
        sql.append("FCLIENTSECRET = '");
        sql.append(clientSecret);
        sql.append("' ");
        sql.append("WHERE ");
        sql.append("FID = '");
        sql.append(id);
        sql.append("'");
        logger.error("KDContractConfigEditHandler saveClientKdAppIdAndSecret sql : " + sql.toString());
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public boolean comparisonNewAndOldValue(KDContractConfigInfo newValue, KDContractConfigInfo oldValue) {
        if (oldValue == null || newValue == null) {
            return true;
        }
        String newFieldValue = "";
        String oldFieldValue = "";
        newFieldValue = newValue.getEnterpriseName();
        oldFieldValue = oldValue.getEnterpriseName();
        if (StringUtils.isEmpty((CharSequence)oldFieldValue)) {
            return true;
        }
        if (!oldFieldValue.equals(newFieldValue)) {
            return true;
        }
        newFieldValue = newValue.getIdCardNO();
        oldFieldValue = oldValue.getIdCardNO();
        if (StringUtils.isEmpty((CharSequence)oldFieldValue)) {
            return true;
        }
        if (!oldFieldValue.equals(newFieldValue)) {
            return true;
        }
        newFieldValue = newValue.getEnterpriseLegal();
        oldFieldValue = oldValue.getEnterpriseLegal();
        if (StringUtils.isEmpty((CharSequence)oldFieldValue)) {
            return true;
        }
        if (!oldFieldValue.equals(newFieldValue)) {
            return true;
        }
        newFieldValue = newValue.getMobile();
        oldFieldValue = oldValue.getMobile();
        if (StringUtils.isEmpty((CharSequence)oldFieldValue)) {
            return true;
        }
        if (!oldFieldValue.equals(newFieldValue)) {
            return true;
        }
        newFieldValue = newValue.getEmail();
        oldFieldValue = oldValue.getEmail();
        if (StringUtils.isEmpty((CharSequence)oldFieldValue)) {
            return true;
        }
        if (!oldFieldValue.equals(newFieldValue)) {
            return true;
        }
        newFieldValue = newValue.getIcCode();
        oldFieldValue = oldValue.getIcCode();
        if (StringUtils.isEmpty((CharSequence)oldFieldValue)) {
            return true;
        }
        if (!oldFieldValue.equals(newFieldValue)) {
            return true;
        }
        newFieldValue = newValue.getOrgCode();
        oldFieldValue = oldValue.getOrgCode();
        if (StringUtils.isEmpty((CharSequence)oldFieldValue)) {
            return !StringUtils.isEmpty((CharSequence)newFieldValue);
        }
        if (!StringUtils.isEmpty((CharSequence)oldFieldValue) && !oldFieldValue.equals(newFieldValue)) {
            return true;
        }
        newFieldValue = newValue.getTaxCode();
        oldFieldValue = oldValue.getTaxCode();
        if (StringUtils.isEmpty((CharSequence)oldFieldValue)) {
            return !StringUtils.isEmpty((CharSequence)newFieldValue);
        }
        return !StringUtils.isEmpty((CharSequence)oldFieldValue) && !oldFieldValue.equals(newFieldValue);
    }
}

