/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.elecontract.util;

import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public final class URLUtils {
    public static final String UTF8 = "UTF-8";
    public static final String QUESTION_MARK_PA = "[?]";
    public static final String WITH_SYMBOLS_PA = "[&]";
    public static final String EQUAL_SIGN_PA = "[=]";
    public static final String QUESTION_MARK = "?";
    public static final String WITH_SYMBOLS = "&";
    public static final String EQUALS = "=";
    public static final String SLASH = "/";
    public static final String BACK_SLASH = "\\";

    public static String getBasePath(String url) {
        if (StringUtils.isEmpty((String)url)) {
            return url;
        }
        String[] urlParts = (url = url.trim()).split(QUESTION_MARK_PA);
        if (urlParts.length <= 1) {
            return url;
        }
        return urlParts[0];
    }

    public static Map<String, String> getQueryParams(String url) {
        String[] params;
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)url)) {
            return paramsMap;
        }
        String[] urlParts = (url = url.trim()).split(QUESTION_MARK_PA);
        if (urlParts.length <= 1) {
            return paramsMap;
        }
        for (String param : params = urlParts[1].split(WITH_SYMBOLS_PA)) {
            String[] keyValue = param.split(EQUAL_SIGN_PA);
            String key = keyValue[0];
            String value = keyValue.length == 2 ? keyValue[1] : "";
            paramsMap.put(key, value);
        }
        return paramsMap;
    }

    public static String assembleUrl(String url, Map<String, String> params) {
        StringBuilder redirectUrl = new StringBuilder(url);
        if (params != null && params.size() > 0) {
            if (redirectUrl.indexOf(QUESTION_MARK) == -1) {
                redirectUrl.append(QUESTION_MARK);
            } else {
                redirectUrl.append(WITH_SYMBOLS);
            }
            String key2 = null;
            String value = null;
            int index = 0;
            for (String key2 : params.keySet()) {
                if (index != 0) {
                    redirectUrl.append(WITH_SYMBOLS);
                }
                redirectUrl.append(key2);
                redirectUrl.append(EQUALS);
                value = params.get(key2).toString();
                try {
                    redirectUrl.append(URLEncoder.encode(value, UTF8));
                }
                catch (UnsupportedEncodingException e) {
                    redirectUrl.append(URLEncoder.encode(value));
                }
                ++index;
            }
        }
        return redirectUrl.toString();
    }

    public static void main(String[] args) {
        String url = "http://mbos.kingdee.com/mbos/page/loadPage?appid=10036&path=HTQS850sp1&name=contactNew1.custom&storeEid=4000148&contractNo=EHT-2019-06-27-0029-kd82da44ec501638f6";
        System.out.println(URLUtils.getBasePath(url));
        System.out.println(URLUtils.getQueryParams(url));
        System.out.println(URLUtils.assembleUrl(URLUtils.getBasePath(url), URLUtils.getQueryParams(url)));
    }
}

