/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.base.serviceImpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.DomainFilterFacadeFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsMessageCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsMessageFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsMessageHandlerStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsMessageInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsMessageReceiverCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsMessageReceiverFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsMessageReceiverInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsTaskPoolCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsTaskPoolFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsTaskPoolInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsTransmitFacadeFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IGoalsMessage;
import com.kingdee.shr.perfweb.app.base.evalplan.IGoalsMessageReceiver;
import com.kingdee.shr.perfweb.app.base.evalplan.IGoalsTaskPool;
import com.kingdee.shr.perfweb.app.base.evalplan.IGoalsTransmitFacade;
import com.kingdee.shr.perfweb.app.base.evalplan.MsgTypeEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectAssignTypeEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectPersonalGoalStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfGoalsObjectCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfGoalsObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfGoalsObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PersonVariationCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PersonVariationFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PersonVariationInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PersonalGoalsStatusEnum;
import com.kingdee.shr.perfweb.app.common.YesOrNoEnum;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.base.service.IPerfEvaluObject;
import com.kingdee.shr.perfweb.exception.SHRPerfWebException;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.PerfDateUtils;
import com.kingdee.shr.perfweb.utils.PerfWorkFlowUtils;
import java.sql.SQLException;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfEvaluObjectImpl
implements IPerfEvaluObject {
    private static Logger logger = LoggerFactory.getLogger(PerfEvaluObjectImpl.class);

    @Override
    public boolean addEvaluObject(Context ctx, Set personIdSet, String planId, String periodId, Date joinDate) {
        return this.addEvaluObject(ctx, personIdSet, planId, periodId, joinDate, null, null);
    }

    public boolean addEvaluObject(Context ctx, Set personIdSet, String planId, String periodId, Date joinDate, Set empPosOrgRelaSet, String orgId) {
        boolean flag = false;
        try {
            PerfPlanInfo planInfo = PerfPlanFactory.getLocalInstance((Context)ctx).getPerfPlanInfo((IObjectPK)new ObjectUuidPK(planId));
            IQueryExecutor exec = null;
            IRowSet rowSet = null;
            if (empPosOrgRelaSet != null || personIdSet != null) {
                exec = this.getPersonExec("");
                EntityViewInfo evi = exec.getObjectView();
                FilterInfo fi = evi.getFilter();
                FilterInfo filterInfo = new FilterInfo();
                if (empPosOrgRelaSet != null) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)empPosOrgRelaSet, CompareType.INCLUDE));
                } else if (personIdSet != null) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personIdSet, CompareType.INCLUDE));
                }
                fi.mergeFilter(filterInfo, "AND");
                this.getSelection(exec);
                rowSet = exec.executeQuery();
            } else {
                AdminOrgUnitInfo orgInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId.trim()));
                String filter = " (adminOrgUnit.longNumber = '" + orgInfo.getLongNumber() + "' OR adminOrgUnit.longNumber LIKE '" + orgInfo.getLongNumber() + "!%') and employeeType.isInCount = '1'";
                exec = this.getPersonExec(filter);
                this.getSelection(exec);
                String querySql = exec.getSQL();
                int orderByIndex = querySql.indexOf("ORDER BY");
                String baseSql = querySql.substring(0, orderByIndex);
                String finalSql = baseSql + " and not exists (select 1 from T_EVA_PerfEvaObject \"EvaObject\" where (\"EMPPOSORGRELATION\".FPositionID = \"EvaObject\".FPosition and \"EMPPOSORGRELATION\".FPersonID = \"EvaObject\".FPerson) and \"EvaObject\".FPeriodid = '" + periodId + "') ";
                rowSet = DbUtil.executeQuery((Context)ctx, (String)finalSql);
            }
            CoreBaseCollection coll = new CoreBaseCollection();
            CoreBaseCollection coll1 = new CoreBaseCollection();
            if (rowSet != null) {
                while (rowSet.next()) {
                    PerfEvaObjectInfo evalObject = new PerfEvaObjectInfo();
                    evalObject.put("person", (Object)rowSet.getString("person.ID"));
                    evalObject.put("number", (Object)rowSet.getString("person.NUMBER"));
                    evalObject.put("name", (Object)rowSet.getString("person.NAME"));
                    evalObject.put("changeDealType", (Object)100);
                    evalObject.put("period", (Object)periodId);
                    if (joinDate != null) {
                        evalObject.put("joinPeriodDate", (Object)joinDate);
                    } else {
                        evalObject.put("joinPeriodDate", (Object)new Date());
                    }
                    evalObject.put("position", (Object)rowSet.getString("POSITION.ID"));
                    evalObject.put("positionName", (Object)rowSet.getString("POSITION.NAME"));
                    evalObject.put("joinCurPosDate", (Object)rowSet.getDate("EFFDT"));
                    evalObject.put("adminOrUnit", (Object)rowSet.getString("ADMINORGUNIT.ID"));
                    evalObject.put("adminOrUnitName", (Object)rowSet.getString("ADMINORGUNIT.NAME"));
                    evalObject.put("employeeType", (Object)rowSet.getString("employeeType.name"));
                    if (empPosOrgRelaSet != null || personIdSet != null) {
                        BizEnumValueDTO enumInfo = (BizEnumValueDTO)rowSet.getObject("ASSIGNTYPE");
                        evalObject.put("assignType", enumInfo.get("value"));
                    } else {
                        int assignType = rowSet.getInt("ASSIGNTYPE");
                        evalObject.put("assignType", (Object)PerfEvaObjectAssignTypeEnum.getEnum((int)assignType));
                    }
                    evalObject.put("orgLongNumber", (Object)rowSet.getString("ADMINORGUNIT.LONGNUMBER"));
                    evalObject.put("adminOrUnitNumber", (Object)rowSet.getString("ADMINORGUNIT.NUMBER"));
                    evalObject.put("workFlow", (Object)planInfo.getDefaultWorkFlow());
                    this.getSuperior(ctx, evalObject);
                    coll.add((CoreBaseInfo)evalObject);
                    coll1.addObjectCollection((IObjectCollection)evalObject.getPerfGoalsObject());
                    if (coll.size() <= 10) continue;
                    PerfEvaObjectFactory.getLocalInstance((Context)ctx).addnewBatchData(coll);
                    coll.clear();
                }
            }
            if (coll.size() > 0) {
                PerfEvaObjectFactory.getLocalInstance((Context)ctx).saveBatchData(coll);
            }
            flag = true;
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        return flag;
    }

    private void getSelection(IQueryExecutor exec) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("person.number"));
        sic.add(new SelectorItemInfo("EFFDT"));
        sic.add(new SelectorItemInfo("position.name"));
        sic.add(new SelectorItemInfo("assignType"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("employeeType.name"));
        sic.add(new SelectorItemInfo("ADMINORGUNIT.ID"));
        sic.add(new SelectorItemInfo("ADMINORGUNIT.LONGNUMBER"));
        sic.add(new SelectorItemInfo("ADMINORGUNIT.NUMBER"));
        sic.add(new SelectorItemInfo("position.id"));
        exec.getObjectView().setSelector(sic);
    }

    @Override
    public boolean deleteEvaluObject(String[] personId) throws SHRPerfWebException {
        boolean flag = false;
        try {
            StringBuffer sb = new StringBuffer(48);
            int length = personId.length;
            for (int i = 0; i < length; ++i) {
                sb.append("'").append(personId[i]).append("'").append(",");
            }
            PerfEvaObjectFactory.getRemoteInstance().delete("where id  in (" + sb.substring(0, sb.length() - 1) + ") and (unitGoalsStatus = 0 or  unitGoalsStatus is null)");
            PerfEvaObjectCollection coll = PerfEvaObjectFactory.getRemoteInstance().getPerfEvaObjectCollection("where id in (" + sb.substring(0, sb.length() - 1) + ")");
            if (coll.size() == 0) {
                flag = true;
                return flag;
            }
            if (coll.size() == personId.length) {
                throw new SHRPerfWebBizException(SHRPerfWebBizException.DELEVAOBJERRASGOALSTRANSMIT);
            }
            if (coll.size() < personId.length) {
                throw new SHRPerfWebBizException(SHRPerfWebBizException.DELEVAOBJERRASGOALSTRANSMIT);
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        return flag;
    }

    @Override
    public boolean deleteEvaluObjectByPeriodId(String periodId) throws SHRPerfWebException {
        boolean flag = false;
        try {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)periodId, CompareType.EQUALS));
            evi.setFilter(filterInfo);
            int beforeDeltes = PerfEvaObjectFactory.getRemoteInstance().getCount(evi);
            PerfEvaObjectFactory.getRemoteInstance().delete("where period  = '" + periodId + "' and (unitGoalsStatus = 0 or  unitGoalsStatus is null)");
            int afterDeltes = PerfEvaObjectFactory.getRemoteInstance().getCount(evi);
            if (afterDeltes == 0) {
                flag = true;
                return flag;
            }
            if (afterDeltes == beforeDeltes) {
                throw new SHRPerfWebBizException(SHRPerfWebBizException.DELPARTEVAOBJERRASGOALSTRANSMIT);
            }
            if (afterDeltes < beforeDeltes) {
                throw new SHRPerfWebBizException(SHRPerfWebBizException.DELPARTEVAOBJERRASGOALSTRANSMIT);
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        return flag;
    }

    @Override
    public int addGoalObject(Context ctx, HashSet<String> personSet, String isSupervisor, String isSelf, HashSet<String> goalObjectSet) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", personSet, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("perfGoalsObject.*"));
        viewInfo.setFilter(filter);
        viewInfo.setSelector(sic);
        int count = 0;
        HashSet<String> unitGoalsAssigned = new HashSet<String>();
        HashMap<String, String> evaObjMap = new HashMap<String, String>();
        ArrayList<PerfEvaObjectInfo> addAbleEvaObjects = new ArrayList<PerfEvaObjectInfo>();
        HashSet<String> addAbleEvaObjectIds = new HashSet<String>();
        ArrayList<PerfEvaObjectInfo> superEvaObjects = new ArrayList<PerfEvaObjectInfo>();
        try {
            CoreBaseCollection perfGoals = new CoreBaseCollection();
            PerfEvaObjectCollection coll = PerfEvaObjectFactory.getLocalInstance((Context)ctx).getPerfEvaObjectCollection(viewInfo);
            for (int i = 0; i < coll.size(); ++i) {
                PerfEvaObjectInfo info = coll.get(i);
                evaObjMap.put(info.getId().toString(), info.getPerson().getId().toString());
                if (3 == info.getPersonalGoalStatus().getValue()) {
                    ++count;
                    continue;
                }
                if (1 == info.getUnitGoalsStatus().getValue()) {
                    unitGoalsAssigned.add(info.getId().toString());
                }
                info.getPerfGoalsObject().clear();
                if ("1".equals(isSupervisor)) {
                    superEvaObjects.add(info);
                }
                if ("1".equals(isSelf)) {
                    PerfGoalsObjectInfo perfGoalsObject = new PerfGoalsObjectInfo();
                    perfGoalsObject.put("person", (Object)info.getPerson().toString());
                    perfGoalsObject.put("personName", (Object)SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SELFWITHPREFIX, ctx, new Object[]{info.getName()}));
                    info.getPerfGoalsObject().add(perfGoalsObject);
                    perfGoalsObject.setPerfEvaObject(info);
                    perfGoalsObject.setId(BOSUuid.create((String)"D846667B"));
                    perfGoals.add((CoreBaseInfo)perfGoalsObject);
                }
                addAbleEvaObjects.add(info);
                addAbleEvaObjectIds.add(info.getId().toString());
            }
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("perfEvaObject", addAbleEvaObjectIds, CompareType.INCLUDE));
            PerfGoalsObjectFactory.getLocalInstance((Context)ctx).delete(filter1);
            if ("1".equals(isSupervisor)) {
                this.setPerfObjSupervisor(ctx, superEvaObjects, perfGoals);
            }
            if (goalObjectSet != null && goalObjectSet.size() > 0) {
                this.setPerfEvaGoalsObjByPerson(ctx, goalObjectSet, sic, addAbleEvaObjects, perfGoals);
            }
            PerfGoalsObjectFactory.getLocalInstance((Context)ctx).saveBatchData(perfGoals);
            this.pushToDoList(ctx, unitGoalsAssigned, evaObjMap);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        return count;
    }

    private void pushToDoList(Context ctx, Set<String> unitGoalsAssigned, Map<String, String> evaObjMap) throws BOSException, SQLException {
        if (unitGoalsAssigned.size() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("evaObj", unitGoalsAssigned, CompareType.INCLUDE));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            IGoalsTaskPool iGoalsTaskPool = GoalsTaskPoolFactory.getLocalInstance((Context)ctx);
            GoalsTaskPoolCollection collection = iGoalsTaskPool.getGoalsTaskPoolCollection(evi);
            HashMap<String, String> taskIdMap = new HashMap<String, String>();
            if (collection != null && collection.size() > 0) {
                for (int i = 0; i < collection.size(); ++i) {
                    GoalsTaskPoolInfo info = collection.get(i);
                    taskIdMap.put(info.getEvaObj(), info.getId().toString());
                }
                HashMap<String, String> goalMessageIdMap = new HashMap<String, String>();
                IGoalsMessage iGoalsMessage = GoalsMessageFactory.getLocalInstance((Context)ctx);
                filter = new FilterInfo();
                HashSet taskIdSet = new HashSet();
                taskIdSet.addAll(taskIdMap.values());
                filter.getFilterItems().add(new FilterItemInfo("taskId", taskIdSet, CompareType.INCLUDE));
                evi.setFilter(filter);
                GoalsMessageCollection goalsMessageCollection = iGoalsMessage.getGoalsMessageCollection(evi);
                if (goalsMessageCollection != null && goalsMessageCollection.size() > 0) {
                    for (int j = 0; j < goalsMessageCollection.size(); ++j) {
                        GoalsMessageInfo info = goalsMessageCollection.get(j);
                        goalMessageIdMap.put(info.getTaskId(), info.getId().toString());
                    }
                    IGoalsTransmitFacade iGoalsTransmitFacade = GoalsTransmitFacadeFactory.getLocalInstance((Context)ctx);
                    IGoalsMessageReceiver iGoalsMessageReceiver = GoalsMessageReceiverFactory.getLocalInstance((Context)ctx);
                    try {
                        for (Map.Entry entry : taskIdMap.entrySet()) {
                            String evaObj = (String)entry.getKey();
                            GoalsTaskPoolInfo taskPoolInfo = iGoalsTaskPool.getGoalsTaskPoolInfo((IObjectPK)new ObjectUuidPK((String)entry.getValue()));
                            String goalsMessageId = (String)goalMessageIdMap.get(entry.getValue());
                            filter = new FilterInfo();
                            filter.getFilterItems().add(new FilterItemInfo("evaObj", (Object)evaObj, CompareType.EQUALS));
                            filter.getFilterItems().add(new FilterItemInfo("goalsMessage", (Object)goalsMessageId, CompareType.EQUALS));
                            iGoalsMessageReceiver.delete(filter);
                            iGoalsTransmitFacade.createrGoalsMsgReceiver(evaObj, goalsMessageId, evaObjMap.get(evaObj), "0", taskPoolInfo.isIsDirectlyTransmit());
                        }
                    }
                    catch (EASBizException e) {
                        logger.error("EASBizException: ", (Throwable)e);
                    }
                }
            }
        }
    }

    private PersonCollection setPerfEvaGoalsObjByPerson(Context ctx, HashSet<String> goalObjectSet, SelectorItemCollection sic, List<PerfEvaObjectInfo> infos, CoreBaseCollection perfGoals) throws BOSException {
        FilterInfo Personfilter = new FilterInfo();
        Personfilter.getFilterItems().add(new FilterItemInfo("id", goalObjectSet, CompareType.INCLUDE));
        EntityViewInfo prsonViewInfo = new EntityViewInfo();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        prsonViewInfo.setFilter(Personfilter);
        PersonCollection personColl = PersonFactory.getRemoteInstance().getPersonCollection(prsonViewInfo);
        if (personColl != null) {
            for (int k = 0; k < personColl.size(); ++k) {
                PersonInfo person = personColl.get(k);
                for (PerfEvaObjectInfo info : infos) {
                    PerfGoalsObjectInfo perfGoalsObject = new PerfGoalsObjectInfo();
                    perfGoalsObject.put("person", (Object)person.getId().toString());
                    perfGoalsObject.put("personName", (Object)SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ASSIGNERWITHPREFIX, ctx, new Object[]{person.getName()}));
                    info.getPerfGoalsObject().add(perfGoalsObject);
                    perfGoalsObject.setPerfEvaObject(info);
                    perfGoalsObject.setId(BOSUuid.create((String)"D846667B"));
                    perfGoals.add((CoreBaseInfo)perfGoalsObject);
                }
            }
        }
        return personColl;
    }

    private void setPerfObjSupervisor(Context ctx, List<PerfEvaObjectInfo> infos, CoreBaseCollection perfGoals) {
        Map<String, Set<String>> superPersonMap = null;
        try {
            superPersonMap = PerfWorkFlowUtils.getDirectSuperiorByEvaObjs(ctx, infos);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        HashSet<String> directSuperiors = new HashSet<String>();
        for (Map.Entry<String, Set<String>> item : superPersonMap.entrySet()) {
            Set<String> personSet = item.getValue();
            if (personSet == null || personSet.size() <= 0) continue;
            directSuperiors.addAll(personSet);
        }
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("id", directSuperiors, CompareType.INCLUDE));
        EntityViewInfo viewInfo1 = new EntityViewInfo();
        SelectorItemCollection sic1 = viewInfo1.getSelector();
        sic1.add(new SelectorItemInfo("*"));
        viewInfo1.setFilter(filter1);
        viewInfo1.setSelector(sic1);
        PersonCollection perColl = null;
        try {
            perColl = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(viewInfo1);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        if (perColl != null && perColl.size() != 0) {
            HashMap<String, PerfGoalsObjectInfo> goalsMap = new HashMap<String, PerfGoalsObjectInfo>();
            for (int j = 0; j < perColl.size(); ++j) {
                PersonInfo supervisorInfo = perColl.get(j);
                PerfGoalsObjectInfo perfGoalsObject = new PerfGoalsObjectInfo();
                perfGoalsObject.put("person", (Object)supervisorInfo.getId().toString());
                perfGoalsObject.put("personName", (Object)SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SUPERIORWITHPREFIX, ctx, new Object[]{supervisorInfo.getName()}));
                goalsMap.put(supervisorInfo.getId().toString(), perfGoalsObject);
            }
            for (PerfEvaObjectInfo info : infos) {
                String evaObjId = info.getId().toString();
                Set<String> superPersons = superPersonMap.get(evaObjId);
                if (superPersons == null || superPersons.size() <= 0) continue;
                for (String person : superPersons) {
                    PerfGoalsObjectInfo perfGoalsObject = new PerfGoalsObjectInfo();
                    perfGoalsObject.setPerson(((PerfGoalsObjectInfo)goalsMap.get(person)).getPerson());
                    perfGoalsObject.setPersonName(((PerfGoalsObjectInfo)goalsMap.get(person)).getPersonName());
                    perfGoalsObject.setPerfEvaObject(info);
                    info.getPerfGoalsObject().add(perfGoalsObject);
                    perfGoals.add((CoreBaseInfo)perfGoalsObject);
                }
            }
        }
    }

    @Override
    public boolean updateAdminOrUnit(Context ctx, String[] personId) throws Exception {
        boolean flag = false;
        HashSet set = new HashSet();
        HashSet<String> evaObjs = new HashSet<String>();
        PerfEvaObjectCollection coll = this.getEvaluObjectById(personId);
        HashMap<String, PerfEvaObjectInfo> evaMap = new HashMap<String, PerfEvaObjectInfo>();
        HashMap<String, String> evaObjMap = new HashMap<String, String>();
        for (int i = 0; i < coll.size(); ++i) {
            PerfEvaObjectInfo info = coll.get(i);
            if (info.getPersonalGoalStatus().getValue() == 3) continue;
            info.setPersonalGoalStatus(PerfEvaObjectPersonalGoalStatusEnum.UNESTABLISHED);
            evaMap.put(info.getPerson().getId().toString(), info);
            evaObjMap.put(info.getId().toString(), info.getPerson().getId().toString());
            evaObjs.add(info.getId().toString());
        }
        Iterator it = evaMap.keySet().iterator();
        while (it.hasNext()) {
            set.add(it.next());
        }
        if (set.size() == 0 && coll.size() > 0) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.UPDATEEVAOBJPOSERRASGOALSTRANSMIT);
        }
        IQueryExecutor exec = this.getPersonExec("");
        EntityViewInfo evi = exec.getObjectView();
        FilterInfo fi = evi.getFilter();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", set, CompareType.INCLUDE));
        try {
            fi.mergeFilter(filterInfo, "AND");
        }
        catch (BOSException e1) {
            logger.error("", (Throwable)e1);
        }
        IRowSet rowSet = null;
        try {
            rowSet = exec.executeQuery();
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        HashMap delGoalsObjMap = new HashMap();
        if (rowSet != null) {
            try {
                while (rowSet.next()) {
                    String person = rowSet.getString("person.id");
                    String admin = rowSet.getString("ADMINORGUNIT.ID");
                    String adminName = rowSet.getString("ADMINORGUNIT.NAME");
                    String position = rowSet.getString("POSITION.ID");
                    String positionName = rowSet.getString("POSITION.NAME");
                    PerfEvaObjectInfo info = (PerfEvaObjectInfo)evaMap.get(person);
                    info.put("joinCurPosDate", (Object)rowSet.getDate("EFFDT"));
                    BizEnumValueDTO enumInfo = (BizEnumValueDTO)rowSet.getObject("ASSIGNTYPE");
                    info.put("assignType", enumInfo.get("value"));
                    this.getSuperior(ctx, info);
                }
            }
            catch (SQLException e) {
                logger.error("SQLException: ", (Throwable)e);
            }
        }
        try {
            PerfEvaObjectFactory.getLocalInstance((Context)ctx).addEvaluObject(coll);
            this.pushToDoList(ctx, evaObjs, evaObjMap);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        flag = true;
        return flag;
    }

    public boolean updateAdminOrUnit(Context ctx, String[] personId, String[] personVaria) throws Exception {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < personId.length; ++i) {
            set.add(personId[i]);
        }
        StringBuilder evaId = new StringBuilder(48);
        for (int i = 0; i < personVaria.length; ++i) {
            evaId.append("'").append(personVaria[i]).append("'").append(",");
        }
        String oql = "where id in (" + evaId.toString().substring(0, evaId.length() - 1) + ")";
        try {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = viewInfo.getSelector();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("perfGoalsObject.*"));
            viewInfo.setFilter(filter);
            viewInfo.setSelector(sic);
            PerfEvaObjectCollection evaColl = PerfEvaObjectFactory.getLocalInstance((Context)ctx).getPerfEvaObjectCollection(viewInfo);
            PersonVariationCollection personColl = PersonVariationFactory.getLocalInstance((Context)ctx).getPersonVariationCollection(oql);
            HashMap<String, PersonVariationInfo> personMap = new HashMap<String, PersonVariationInfo>();
            for (int j = 0; j < personColl.size(); ++j) {
                PersonVariationInfo info = personColl.get(j);
                personMap.put(info.getPerson().getId().toString(), info);
            }
            CoreBaseCollection coreBaseColl = new CoreBaseCollection();
            HashSet<String> evaObjs = new HashSet<String>();
            HashMap<String, String> evaObjMap = new HashMap<String, String>();
            for (int i = 0; i < evaColl.size(); ++i) {
                PerfEvaObjectInfo info = evaColl.get(i);
                if (info.getPersonalGoalStatus().getValue() == 3) continue;
                PersonVariationInfo personVarInfo = (PersonVariationInfo)personMap.get(info.getPerson());
                this.getSuperior(ctx, info);
                coreBaseColl.add((CoreBaseInfo)info);
                evaObjMap.put(info.getId().toString(), info.getPerson().getId().toString());
                evaObjs.add(info.getId().toString());
                if (coreBaseColl.size() <= 50) continue;
                PerfEvaObjectFactory.getLocalInstance((Context)ctx).saveBatchData(coreBaseColl);
                coreBaseColl.clear();
            }
            PerfEvaObjectFactory.getLocalInstance((Context)ctx).saveBatchData(coreBaseColl);
            this.pushToDoList(ctx, evaObjs, evaObjMap);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return true;
    }

    private void getSuperior(Context ctx, PerfEvaObjectInfo info) throws BOSException {
        PerfGoalsObjectCollection coll = info.getPerfGoalsObject();
        if (coll != null) {
            for (int i = 0; i < coll.size(); ++i) {
                if (!info.getPerfGoalsObject().get(i).getPersonName().contains("(" + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SUPERIOR, ctx) + ")")) continue;
                info.getPerfGoalsObject().removeObject(i);
                --i;
            }
        }
        ArrayList<PersonInfo> perColl = new ArrayList<PersonInfo>();
        Map<String, String> directSuperior = PerfWorkFlowUtils.getDirectSuperior(ctx, info.getPerfFile().getPosition().getId().toString());
        for (Map.Entry<String, String> entry : directSuperior.entrySet()) {
            PersonInfo personInfo = new PersonInfo();
            personInfo.put("id", (Object)entry.getKey());
            personInfo.setName(entry.getValue().toString());
            perColl.add(personInfo);
        }
        for (int k = 0; k < perColl.size(); ++k) {
            PerfGoalsObjectInfo perfGoalInfo = new PerfGoalsObjectInfo();
            perfGoalInfo.put("person", (Object)((PersonInfo)perColl.get(k)).getId().toString());
            perfGoalInfo.put("personName", (Object)SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SUPERIORWITHPREFIX, ctx, new Object[]{((PersonInfo)perColl.get(k)).getName()}));
            if (info.getId() != null) {
                perfGoalInfo.put("perfEvaObject", (Object)info.getId().toString());
            }
            info.getPerfGoalsObject().add(perfGoalInfo);
        }
    }

    @Override
    public boolean updateChangeDealType(String[] personId, String changeTime, String changeDealType) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date();
        boolean flag = false;
        PerfEvaObjectCollection coll = this.getEvaluObjectById(personId);
        if (coll == null) {
            return flag;
        }
        try {
            date = formatter.parse(formatter.format(date));
        }
        catch (ParseException e1) {
            logger.error("", (Throwable)e1);
        }
        for (int i = 0; i < coll.size(); ++i) {
            PerfEvaObjectInfo info = coll.get(i);
            info.put("changeDealType", (Object)Integer.valueOf(changeDealType));
            info.put("changeTime", (Object)date);
        }
        try {
            PerfEvaObjectFactory.getRemoteInstance().addEvaluObject(coll);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        flag = true;
        return flag;
    }

    public boolean recoverGoalObject(Context ctx, String[] personId) {
        int i;
        boolean flag = false;
        PerfEvaObjectCollection coll = this.getEvaluObjectById(personId);
        HashSet<String> personSet = new HashSet<String>();
        for (i = 0; i < personId.length; ++i) {
            personSet.add(personId[i]);
        }
        for (i = 0; i < coll.size(); ++i) {
            if (3 != coll.get(i).getPersonalGoalStatus().getValue()) continue;
            personSet.remove(coll.get(i).getId().toString());
        }
        if (personSet.size() == 0) {
            return false;
        }
        HashMap<String, Set<String>> delGoalsObjMap = new HashMap<String, Set<String>>();
        try {
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("perfEvaObject", personSet, CompareType.INCLUDE));
            PerfGoalsObjectFactory.getLocalInstance((Context)ctx).delete(filter1);
            CoreBaseCollection coreBaseColl = new CoreBaseCollection();
            for (int i2 = 0; i2 < coll.size(); ++i2) {
                PerfEvaObjectInfo info = coll.get(i2);
                if (3 == info.getPersonalGoalStatus().getValue()) continue;
                HashSet<String> currentGoalsObject = new HashSet<String>();
                PerfEvaluObjectImpl.setGoalsObjectPersons(info.getPerfGoalsObject(), currentGoalsObject);
                info.getPerfGoalsObject().clear();
                this.getSuperior(ctx, info);
                coreBaseColl.add((CoreBaseInfo)info);
                HashSet<String> recoverGoalsObject = new HashSet<String>();
                PerfEvaluObjectImpl.setGoalsObjectPersons(info.getPerfGoalsObject(), recoverGoalsObject);
                currentGoalsObject.removeAll(recoverGoalsObject);
                if (currentGoalsObject == null || currentGoalsObject.size() <= 0) continue;
                delGoalsObjMap.put(info.getId().toString(), currentGoalsObject);
            }
            if (coreBaseColl.size() > 0) {
                PerfEvaObjectFactory.getLocalInstance((Context)ctx).saveBatchData(coreBaseColl);
            }
            if (delGoalsObjMap.size() > 0) {
                this.deleteGoalsMessageReceiver(ctx, delGoalsObjMap);
                this.buildGoalsMessageReceiver(ctx, coreBaseColl);
            }
            flag = true;
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        return flag;
    }

    private static void setGoalsObjectPersons(PerfGoalsObjectCollection coll, Set<String> goalsObjects) {
        for (int i = 0; i < coll.size(); ++i) {
            PerfGoalsObjectInfo info = coll.get(i);
            goalsObjects.add(info.getPerson());
        }
    }

    private static String getReceiverByEvaObjAndGoalsObjs(Map<String, Set<String>> delGoalsMap) {
        StringBuffer sqlSb = new StringBuffer("select FID from T_EVA_GoalsMessageReceiver ");
        sqlSb.append(" where FHandleStatus = 1").append(" and FMsgType = 0").append(" and (");
        int count = 0;
        for (Map.Entry<String, Set<String>> entry : delGoalsMap.entrySet()) {
            StringBuffer sb = new StringBuffer();
            for (String goalsObj : entry.getValue()) {
                sb.append("'").append(goalsObj).append("',");
            }
            sb.setLength(sb.length() - 1);
            if (count > 0 && count <= delGoalsMap.size() - 1) {
                sqlSb.append(" or (");
            }
            sqlSb.append(" FEvaObjID = '" + entry.getKey() + "'");
            sqlSb.append(" and FReceiver in (").append(sb.toString()).append(")");
            if (count > 0 && count <= delGoalsMap.size() - 1) {
                sqlSb.append(" )");
            }
            ++count;
        }
        return sqlSb.append(")").toString();
    }

    private void deleteGoalsMessageReceiver(Context ctx, Map<String, Set<String>> delGoalsMap) throws BOSException, SQLException, EASBizException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)PerfEvaluObjectImpl.getReceiverByEvaObjAndGoalsObjs(delGoalsMap));
        ObjectStringPK[] objectPK = new ObjectStringPK[rs.size()];
        if (rs != null && rs.size() > 0) {
            int i = 0;
            while (rs.next()) {
                objectPK[i] = new ObjectStringPK(rs.getString("FID"));
                ++i;
            }
            IGoalsMessageReceiver receiver = GoalsMessageReceiverFactory.getLocalInstance((Context)ctx);
            receiver.deleteBatchData((IObjectPK[])objectPK);
        }
    }

    private void buildGoalsMessageReceiver(Context ctx, CoreBaseCollection coreBaseColl) throws EASBizException, BOSException {
        IGoalsMessageReceiver igoalsMsgReceiver = GoalsMessageReceiverFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < coreBaseColl.size(); ++i) {
            PerfEvaObjectInfo info = (PerfEvaObjectInfo)coreBaseColl.get(i);
            if (info.getPersonalGoalStatus().getValue() == 3 || info.getUnitGoalsStatus().getValue() == 0) continue;
            PerfPeriodInfo periodInfo = new PerfPeriodInfo();
            if (info.getPeriod().getId() != null) {
                periodInfo = GetEntityInfoUtils.getPerfPeriodInfo(ctx, info.getPeriod().getId().toString());
            }
            String combName = "";
            String startDate = PerfDateUtils.formatDate(periodInfo.getPEndDate(), "yyyy.MM.dd");
            String endDate = PerfDateUtils.formatDate(periodInfo.getPEndDate(), "yyyy.MM.dd");
            combName = periodInfo.getName() + " " + startDate + "-" + endDate;
            String oql = "where evaObj = '" + info.getId().toString() + "'";
            GoalsTaskPoolInfo goalsTaskPool = GoalsTaskPoolFactory.getLocalInstance((Context)ctx).getGoalsTaskPoolInfo(oql);
            String taskId = goalsTaskPool.getId().toString();
            oql = "where taskId = '" + taskId + "' and person = '" + info.getPerson() + "'";
            GoalsMessageInfo goalsMessageInfo = GoalsMessageFactory.getLocalInstance((Context)ctx).getGoalsMessageInfo(oql);
            String messageId = goalsMessageInfo.getId().toString();
            oql = "where evaObj = '" + info.getId().toString() + "'";
            GoalsMessageReceiverCollection goalMesColl = igoalsMsgReceiver.getGoalsMessageReceiverCollection(oql);
            HashSet<String> exitSet = new HashSet<String>();
            for (int k = 0; k < goalMesColl.size(); ++k) {
                exitSet.add(goalMesColl.get(i).getReceiver());
            }
            PerfGoalsObjectCollection goalsObjColl = info.getPerfGoalsObject();
            HashSet<String> set = new HashSet<String>();
            if (goalsObjColl != null && goalsObjColl.size() > 0) {
                for (int j = 0; j < goalsObjColl.size(); ++j) {
                    PerfGoalsObjectInfo perfGoalsObjInfo = goalsObjColl.get(j);
                    set.add(perfGoalsObjInfo.getPerson());
                }
            }
            set.removeAll(exitSet);
            Iterator iterator = set.iterator();
            CoreBaseCollection goalsMsgReceiverColl = new CoreBaseCollection();
            int count = 0;
            while (iterator.hasNext()) {
                String receiver = (String)iterator.next();
                String personName = "";
                PerfGoalsObjectCollection perfGoalsObjColl = PerfGoalsObjectFactory.getLocalInstance((Context)ctx).getPerfGoalsObjectCollection(" where person='" + receiver + "'");
                if (perfGoalsObjColl != null && perfGoalsObjColl.size() > 0) {
                    personName = perfGoalsObjColl.get(0).getPersonName();
                }
                GoalsMessageReceiverInfo goalsMsgInfo = new GoalsMessageReceiverInfo();
                goalsMsgInfo.setReceiver(receiver);
                goalsMsgInfo.setReceiverName(personName);
                goalsMsgInfo.setReceiverTime(new Time(System.currentTimeMillis()));
                goalsMsgInfo.setHandleStatus(GoalsMessageHandlerStatusEnum.SENT);
                goalsMsgInfo.put("goalsMessage", (Object)messageId);
                goalsMsgInfo.put("evaObj", (Object)info.getId().toString());
                goalsMsgInfo.setPerson(info.getPerson().getId().toString());
                goalsMsgInfo.setMsgType(MsgTypeEnum.TARGETFILL);
                goalsMsgInfo.setTargetStatus(PersonalGoalsStatusEnum.SAVE);
                goalsMsgInfo.setIsSelf(YesOrNoEnum.NO);
                goalsMsgInfo.setPeriod(periodInfo.getId().toString());
                goalsMsgInfo.setPStartDate(periodInfo.getPStartDate());
                goalsMsgInfo.setPEndDate(periodInfo.getPEndDate());
                goalsMsgInfo.setCombName(combName);
                goalsMsgInfo.setEvaObjName(info.getName());
                goalsMsgReceiverColl.add((CoreBaseInfo)goalsMsgInfo);
                if (++count % 50 == 0) {
                    igoalsMsgReceiver.addnew(goalsMsgReceiverColl);
                    goalsMsgReceiverColl.clear();
                    continue;
                }
                if (count != set.size()) continue;
                igoalsMsgReceiver.addnew(goalsMsgReceiverColl);
                goalsMsgReceiverColl.clear();
            }
        }
    }

    public PerfEvaObjectCollection getEvaluObjectById(String[] personId) {
        if (personId.length == 0) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < personId.length; ++i) {
            set.add(personId[i]);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("perfGoalsObject.*"));
        viewInfo.setFilter(filter);
        viewInfo.setSelector(sic);
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        try {
            sorterItemCollection.getSorter().decode("order by perfGoalsObject.personName");
        }
        catch (ParserException e1) {
            logger.error("", (Throwable)e1);
        }
        viewInfo.setSorter(sorterItemCollection);
        PerfEvaObjectCollection coll = null;
        try {
            coll = PerfEvaObjectFactory.getRemoteInstance().getPerfEvaObjectCollection(viewInfo);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return coll;
    }

    public IQueryExecutor getPersonExec(String customerFilter) {
        return this.getPersonExec(customerFilter, null);
    }

    public IQueryExecutor getPersonExec(String customerFilter, String sorterItems) {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.shr.perfweb.app.base.evalplan", "GetPersonListQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        String condition = "[ ('&', ('EFFDT','>=','$EmpPosOrgRelaEFFDTFilter'), ('LEFFDT','<','$EmpPosOrgRelaLEFFDTFilter'), ('pp.EFFDT','>=','$EmpPosOrgRelaEFFDTFilter'), ('pp.LEFFDT','<','$EmpPosOrgRelaLEFFDTFilter'),  ('isInner','=',1) ) ]";
        String entityName = "com.kingdee.eas.basedata.person.app.Person";
        if (StringUtils.isEmpty((CharSequence)sorterItems)) {
            sorterItems = "adminOrgUnit.sortCode,adminOrgUnit.longNumber,position.index,position.number,person.indexOf,person.number,id";
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        FilterInfo filter = new FilterInfo();
        try {
            filter = DomainFilterFacadeFactory.getRemoteInstance().getDomainFilter(entityName, condition, null);
            entityViewInfo.setFilter(filter);
            if (!StringUtils.isEmpty((CharSequence)customerFilter)) {
                FilterInfo filterInfo = new FilterInfo(customerFilter);
                entityViewInfo.getFilter().mergeFilter(filterInfo, "AND");
            }
            sorterItemCollection.getSorter().decode("order by " + sorterItems);
        }
        catch (ParserException e1) {
            logger.error("ParserException: ", (Throwable)e1);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        entityViewInfo.setSorter(sorterItemCollection);
        exec.setObjectView(entityViewInfo);
        exec.option().isIgnoreOrder = true;
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().isIgnorePermissionCheck = false;
        return exec;
    }

    @Override
    public boolean recoverGoalObject(String[] personId) throws SHRPerfWebException {
        return false;
    }
}

