/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.bean;

import com.google.common.collect.Sets;
import com.kingdee.shr.perfweb.bean.FileCheckStatement;
import com.kingdee.shr.perfweb.util.FileSecUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.model.InternalWorkbook;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.EvaluationWorkbook;
import org.apache.poi.xssf.model.ExternalLinksTable;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelCheckCmdStatement
extends FileCheckStatement {
    private static Logger logger = LoggerFactory.getLogger(ExcelCheckCmdStatement.class);

    public ExcelCheckCmdStatement(Set<String> checks) {
        super(checks);
    }

    public ExcelCheckCmdStatement() {
        this.checks = Sets.newHashSet((Object[])new String[]{"xlsx", "xls"});
    }

    @Override
    public String ifFail(String part) throws IOException {
        throw new IllegalArgumentException("PERFWEB_F_0024");
    }

    @Override
    public boolean checkFile(String fileName, byte[] content) throws IOException {
        boolean hasDdeLink;
        String suffix = "";
        if (StringUtils.isNotBlank((CharSequence)fileName) && fileName.contains(".")) {
            suffix = FileSecUtil.getSuffixByName(fileName);
        }
        if (hasDdeLink = this.hasDdeLink(suffix, content)) {
            this.ifFail(null);
        }
        return hasDdeLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasDdeLink(String s, byte[] b) throws IOException {
        block17: {
            XSSFWorkbook workbook;
            ByteArrayInputStream is;
            block16: {
                is = new ByteArrayInputStream(b);
                workbook = null;
                try {
                    if ("xlsx".equals(s)) {
                        workbook = new XSSFWorkbook((InputStream)is);
                        break block16;
                    }
                    if ("xls".equals(s)) {
                        workbook = new HSSFWorkbook((InputStream)is);
                        break block16;
                    }
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            }
            try {
                if (workbook instanceof XSSFWorkbook) {
                    XSSFWorkbook xssfWorkbook = workbook;
                    int numberOfSheets = xssfWorkbook.getNumberOfSheets();
                    for (int i = 0; i < numberOfSheets; ++i) {
                        XSSFSheet sheetAt = xssfWorkbook.getSheetAt(i);
                        int numHyperlinks = sheetAt.getNumHyperlinks();
                        if (numHyperlinks <= 0) continue;
                        throw new IllegalArgumentException("PERFWEB_F_0026");
                    }
                    List externalLinks = xssfWorkbook.getExternalLinksTable();
                    for (ExternalLinksTable linksTable : externalLinks) {
                        if (!linksTable.getCTExternalLink().isSetDdeLink()) continue;
                        boolean bl = true;
                        return bl;
                    }
                    break block17;
                }
                if (workbook instanceof HSSFWorkbook) {
                    HSSFWorkbook hssfWorkbook = (HSSFWorkbook)workbook;
                    boolean bl = this.hasWorkbookReferencesWithCMD(hssfWorkbook);
                    return bl;
                }
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
                if (e instanceof IllegalArgumentException) {
                    throw new IllegalArgumentException(e.getMessage());
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
        }
        return false;
    }

    private boolean hasWorkbookReferencesWithCMD(HSSFWorkbook wb) {
        InternalWorkbook internalWorkbook = null;
        try {
            Field field = wb.getClass().getDeclaredField("workbook");
            field.setAccessible(true);
            internalWorkbook = (InternalWorkbook)field.get(wb);
            List hyperlinks = internalWorkbook.getHyperlinks();
            if (hyperlinks != null && hyperlinks.size() > 0) {
                throw new IllegalArgumentException("PERFWEB_F_0026");
            }
            int extSheetIdx = 0;
            while (internalWorkbook != null && internalWorkbook.getExternalSheet(extSheetIdx) != null) {
                EvaluationWorkbook.ExternalSheet extSheet;
                if ((extSheet = internalWorkbook.getExternalSheet(extSheetIdx++)) == null || !StringUtils.isNotBlank((CharSequence)extSheet.getWorkbookName()) || !extSheet.getWorkbookName().toLowerCase(Locale.ENGLISH).contains("cmd")) continue;
                return true;
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return false;
        }
        return false;
    }
}

