/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.comprehensive.baseformula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.perfweb.app.base.perfmancescore.IPerfScorLevelDefine;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScorLevelDefineCollection;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScorLevelDefineFactory;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScorLevelDefineInfo;
import com.kingdee.shr.perfweb.util.SumCalUtil;
import com.kingdee.shr.validaterule.exception.SalaryException;
import com.kingdee.shr.validaterule.formula.base.impl.SaveCalResultImplCommon;
import com.kingdee.shr.validaterule.formula.base.vo.Cell;
import com.kingdee.shr.validaterule.formula.base.vo.ErrRow;
import com.kingdee.shr.validaterule.formula.base.vo.InitCalData;
import com.kingdee.shr.validaterule.formula.base.vo.Row;
import com.kingdee.shr.validaterule.formula.base.vo.Sheet;
import com.kingdee.shr.validaterule.util.FunUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.util.CollectionUtils;

public class SumCalResultImpl
extends SaveCalResultImplCommon {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.validaterule.formula.base.impl.SumCalResultImpl");
    private static final Map<String, String> evaObjTabMap = new HashMap<String, String>(){
        {
            this.put("T_EVA_EVARESULTSUMMARY", "T_EVA_SUMMARYPERSONEVAOBJECT");
            this.put("T_EVA_ORGEVARESULTSUMMARY", "T_EVA_PERFSUMMARYORGEVAOBJECT");
        }
    };

    public void saveCalResult(InitCalData initCalData, Sheet result) throws SalaryException {
        List errDataList = result.getErrDataList();
        if (errDataList != null && errDataList.size() > 0) {
            throw new RuntimeException(((ErrRow)errDataList.get(0)).getErrMsg());
        }
        List changeDataList = result.getChangeDataList();
        if (null == changeDataList) {
            return;
        }
        LinkedList updateSqlList = new LinkedList();
        LinkedList<Object[]> objectList = new LinkedList<Object[]>();
        LinkedList<String> paramsListTemp = null;
        try {
            StringBuffer setStr = new StringBuffer();
            StringBuffer updateSql = new StringBuffer();
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(System.currentTimeMillis());
            Map allCnSnMap = initCalData.getAllCnSnMap();
            String mainTableName = initCalData.getMainTableName();
            Context ctx = initCalData.getCtx();
            Map outerData = (Map)initCalData.getOuterData();
            String perfRateId = (String)outerData.get("perfRate");
            String parimutualmin = (String)outerData.get("parimutualmin");
            String nowDate = FunUtils.toKSqlDate((Date)calendar.getTime());
            Map strItemLenMap = (Map)allCnSnMap.get("strLengthMap");
            int tempLength = 0;
            String fid = "";
            String column = "";
            String value = "";
            HashMap<String, String> sumCalItemResultMap = null;
            for (Row row : changeDataList) {
                paramsListTemp = new LinkedList<String>();
                fid = row.getFID();
                List cells = row.getCells();
                sumCalItemResultMap = new HashMap<String, String>();
                for (Cell cell : cells) {
                    String gradeLevel;
                    column = cell.getColumn();
                    value = cell.getValue();
                    if (column.contains("SUMCALITEM")) {
                        String calItemNumber = column.replaceAll("SUMCALITEM_", "");
                        String calItemId = SumCalUtil.getCalItemIdByNumber(ctx, calItemNumber);
                        sumCalItemResultMap.put(calItemId, value);
                        continue;
                    }
                    if (column.equals("FORWARNCONTENT")) {
                        column = "F" + column;
                    }
                    if (value != null && strItemLenMap.containsKey(column.toLowerCase(Locale.ENGLISH))) {
                        tempLength = (Integer)strItemLenMap.get(column.toLowerCase(Locale.ENGLISH));
                        value = value.length() > tempLength ? value.substring(0, tempLength - 1) : value;
                    }
                    value = StringEscapeUtils.escapeSql((String)value);
                    if ("FSUMSCORE".equals(column.toUpperCase()) && !StringUtils.isEmpty((CharSequence)perfRateId) && !StringUtils.isEmpty((CharSequence)(gradeLevel = this.getGradeLevelByScore(ctx, Float.valueOf(value).floatValue(), Float.valueOf(parimutualmin).floatValue(), perfRateId)))) {
                        paramsListTemp.add(gradeLevel);
                        if (updateSql.length() < 1) {
                            setStr.append(",FGradeLevel=?");
                        }
                    }
                    paramsListTemp.add(value);
                    if (updateSql.length() >= 1) continue;
                    setStr.append(", ").append(column).append(" = ? ");
                }
                if (!CollectionUtils.isEmpty(sumCalItemResultMap)) {
                    String sumCalItemResultJson = JSONUtils.convertObjectToJson((Context)ctx, sumCalItemResultMap);
                    if (sumCalItemResultJson.length() > 1024) {
                        sumCalItemResultJson = sumCalItemResultJson.substring(0, 1024);
                    }
                    paramsListTemp.add(sumCalItemResultJson);
                    if (updateSql.length() < 1) {
                        setStr.append(",FSumCalItemResult=?");
                    }
                }
                if (updateSql.length() < 1) {
                    updateSql.append("update ").append(mainTableName).append(" set ");
                    updateSql.append(setStr.toString().replaceFirst(",", ""));
                    updateSql.append(" ,FLastUpdateTime = ").append(nowDate);
                    updateSql.append(" where fid = ?");
                }
                paramsListTemp.add(fid);
                objectList.add(paramsListTemp.toArray());
            }
            this.executeBatchPrepare(ctx, updateSql.toString(), objectList);
        }
        catch (Exception e) {
            throw new SalaryException(SalaryException.SAVEERROR);
        }
    }

    protected void execute(Context ctx, Object[] sqlLists, List<String[]> paramList) {
        int len = sqlLists.length;
        for (int i = 0; i < len; ++i) {
            try {
                DbUtil.execute((Context)ctx, (String)sqlLists[i].toString(), (Object[])paramList.get(i));
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)"[perfweb]it is failed to execute sql.", (Throwable)e);
            }
        }
    }

    protected void executeBatch(Context ctx, Object[] sqlLists) {
        if (sqlLists == null || sqlLists.length < 1) {
            return;
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        int i = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            conn.setAutoCommit(false);
            for (i = 0; i < sqlLists.length; ++i) {
                stmt.executeUpdate(sqlLists[i].toString());
            }
            conn.commit();
        }
        catch (Exception e) {
            logger.error((Object)("errorSQL sqlLists[" + i + "]:" + e.getMessage()), (Throwable)e);
            if (null != conn) {
                try {
                    conn.rollback();
                }
                catch (Exception ex) {
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException(e);
        }
        finally {
            this.closeAllDBSource(conn, stmt, rs);
        }
    }

    protected void executeBatchPrepare(Context ctx, String updateSql, List<Object[]> paramsList) {
        if (StringUtils.isEmpty((CharSequence)updateSql) || paramsList == null || paramsList.size() < 1) {
            return;
        }
        Connection conn = null;
        PreparedStatement prep = null;
        int i = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            prep = conn.prepareStatement(updateSql);
            for (i = 0; i < paramsList.size(); ++i) {
                Object[] objects = paramsList.get(i);
                int len = objects.length;
                for (int j = 0; j < len; ++j) {
                    prep.setObject(j + 1, objects[j]);
                }
                prep.addBatch();
            }
            prep.executeBatch();
        }
        catch (Exception e) {
            logger.error((Object)("errorSQL sqlLists[" + i + "]:" + e.getMessage()), (Throwable)e);
            if (null != conn) {
                try {
                    conn.rollback();
                }
                catch (Exception ex) {
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException(e);
        }
        finally {
            if (prep != null) {
                try {
                    prep.close();
                }
                catch (SQLException e) {
                    logger.error((Object)"[perfweb]it is failed to close PreparedStatement", (Throwable)e);
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    logger.error((Object)"[perfweb]it is failed to close Connection", (Throwable)e);
                }
            }
        }
    }

    public void closeAllDBSource(Connection conn, Statement stmt, ResultSet rs) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private String getGradeLevelByScore(Context ctx, float score, float scoreMin, String perfRateId) throws BOSException {
        IPerfScorLevelDefine iPerfScorLevelDefine;
        PerfScorLevelDefineCollection scoreLvDefColl;
        String level = "";
        if (StringUtils.isNotEmpty((CharSequence)perfRateId) && (scoreLvDefColl = (iPerfScorLevelDefine = PerfScorLevelDefineFactory.getLocalInstance((Context)ctx)).getPerfScorLevelDefineCollection(" select scoreLowLimit,scoreUpLimit,perfLevelName where perfScoreLevel='" + perfRateId + "' order by scoreUpLimit desc")) != null && scoreLvDefColl.size() > 0) {
            PerfScorLevelDefineInfo maxDefineInfo = scoreLvDefColl.get(0);
            for (int i = 0; i < scoreLvDefColl.size(); ++i) {
                PerfScorLevelDefineInfo scoreLevelDefineInfo = scoreLvDefColl.get(i);
                float scoreLowLimit = scoreLevelDefineInfo.getScoreLowLimit().floatValue();
                float scoreUpLimit = scoreLevelDefineInfo.getScoreUpLimit().floatValue();
                if (!(score == scoreMin && scoreLowLimit == score || score > scoreLowLimit && score <= scoreUpLimit) && maxDefineInfo.getScoreUpLimit().compareTo(BigDecimal.valueOf(score)) > 0) continue;
                level = scoreLevelDefineInfo.getPerfLevelName();
                break;
            }
        }
        return level;
    }
}

