/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.jdbc.utils;

import com.kingdee.jdbc.rowset.IRowSet;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class ClassUtil {
    public static String getFieldValue(Object obj, String fieldName) throws Exception {
        String methodName;
        Class<?> clazz;
        Object value = null;
        if (obj == null || fieldName == null) {
            return null;
        }
        if (obj instanceof Map) {
            value = ((Map)obj).get(fieldName);
        }
        if (ClassUtil.hasMethod(clazz = obj.getClass(), methodName = "get" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1), null)) {
            Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
            value = method.invoke(obj, new Object[0]);
        }
        if (value != null) {
            if (value instanceof Date) {
                SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                value = sf.format(value);
            }
            return value.toString();
        }
        return null;
    }

    public static Object getFieldObjectValue(Object obj, String fieldName) throws Exception {
        String methodName;
        if (obj == null || fieldName == null) {
            return null;
        }
        if (obj instanceof Map) {
            return ((Map)obj).get(fieldName);
        }
        Class<?> clazz = obj.getClass();
        if (ClassUtil.hasMethod(clazz, methodName = "get" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1), null)) {
            Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
            return method.invoke(obj, new Object[0]);
        }
        return null;
    }

    public static int getFieldIntValue(Object obj, String fieldName) throws Exception {
        String methodName;
        if (obj == null || fieldName == null) {
            return 0;
        }
        if (obj instanceof Map) {
            return (Integer)((Map)obj).get(fieldName);
        }
        Class<?> clazz = obj.getClass();
        if (ClassUtil.hasMethod(clazz, methodName = "get" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1), null)) {
            Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
            Object localObj1 = method.invoke(obj, new Object[0]);
            if (localObj1 != null && Integer.class.isInstance(localObj1)) {
                return (Integer)method.invoke(obj, new Object[0]);
            }
            return 0;
        }
        return 0;
    }

    public static short getFieldShortValue(Object obj, String fieldName) throws Exception {
        String methodName;
        if (obj == null || fieldName == null) {
            return 0;
        }
        if (obj instanceof Map) {
            return (Short)((Map)obj).get(fieldName);
        }
        Class<?> clazz = obj.getClass();
        if (ClassUtil.hasMethod(clazz, methodName = "get" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1), null)) {
            Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
            Object localObj1 = method.invoke(obj, new Object[0]);
            if (localObj1 != null && Short.class.isInstance(localObj1)) {
                return (Short)method.invoke(obj, new Object[0]);
            }
            return 0;
        }
        return 0;
    }

    public static long getFieldLongValue(Object obj, String fieldName) throws Exception {
        String methodName;
        if (obj == null || fieldName == null) {
            return 0L;
        }
        if (obj instanceof Map) {
            return (Long)((Map)obj).get(fieldName);
        }
        Class<?> clazz = obj.getClass();
        if (ClassUtil.hasMethod(clazz, methodName = "get" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1), null)) {
            Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
            Object localObj1 = method.invoke(obj, new Object[0]);
            if (localObj1 != null && Long.class.isInstance(localObj1)) {
                return (Long)method.invoke(obj, new Object[0]);
            }
            return 0L;
        }
        return 0L;
    }

    public static double getFieldDoubleValue(Object obj, String fieldName) throws Exception {
        String methodName;
        if (obj == null || fieldName == null) {
            return 0.0;
        }
        if (obj instanceof Map) {
            return (Double)((Map)obj).get(fieldName);
        }
        Class<?> clazz = obj.getClass();
        if (ClassUtil.hasMethod(clazz, methodName = "get" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1), null)) {
            Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
            Object localObj1 = method.invoke(obj, new Object[0]);
            if (localObj1 != null && Double.class.isInstance(localObj1)) {
                return (Double)method.invoke(obj, new Object[0]);
            }
            return 0.0;
        }
        return 0.0;
    }

    public static float getFieldFloatValue(Object obj, String fieldName) throws Exception {
        String methodName;
        if (obj == null || fieldName == null) {
            return 0.0f;
        }
        if (obj instanceof Map) {
            return ((Float)((Map)obj).get(fieldName)).floatValue();
        }
        Class<?> clazz = obj.getClass();
        if (ClassUtil.hasMethod(clazz, methodName = "get" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1), null)) {
            Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
            Object localObj1 = method.invoke(obj, new Object[0]);
            if (localObj1 != null && Float.class.isInstance(localObj1)) {
                return ((Float)method.invoke(obj, new Object[0])).floatValue();
            }
            return 0.0f;
        }
        return 0.0f;
    }

    public static byte getFieldByteValue(Object obj, String fieldName) throws Exception {
        String methodName;
        if (obj == null || fieldName == null) {
            return 0;
        }
        if (obj instanceof Map) {
            return (Byte)((Map)obj).get(fieldName);
        }
        Class<?> clazz = obj.getClass();
        if (ClassUtil.hasMethod(clazz, methodName = "get" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1), null)) {
            Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
            Object localObj1 = method.invoke(obj, new Object[0]);
            if (localObj1 != null && Byte.class.isInstance(localObj1)) {
                return (Byte)method.invoke(obj, new Object[0]);
            }
            return 0;
        }
        return 0;
    }

    public static boolean getFieldBooleanValue(Object obj, String fieldName) throws Exception {
        String methodName;
        if (obj == null || fieldName == null) {
            return false;
        }
        if (obj instanceof Map) {
            return (Boolean)((Map)obj).get(fieldName);
        }
        Class<?> clazz = obj.getClass();
        if (ClassUtil.hasMethod(clazz, methodName = "is" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1), null)) {
            Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
            Object localObj1 = method.invoke(obj, new Object[0]);
            if (localObj1 != null && Boolean.class.isInstance(localObj1)) {
                return (Boolean)method.invoke(obj, new Object[0]);
            }
            return false;
        }
        return false;
    }

    public static boolean hasMethod(Class clazz, String methodName, Class[] args) {
        Method[] ms = clazz.getDeclaredMethods();
        if (ms.length == 0) {
            return false;
        }
        for (Method m : ms) {
            if (!m.getName().equals(methodName)) continue;
            Class<?>[] target = m.getParameterTypes();
            if (args == null || target.length == 0) {
                return true;
            }
            if (args.length != target.length) {
                return false;
            }
            for (int i = 0; i < args.length; ++i) {
                if (args[i].isAssignableFrom(target[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Object singleRowSet2Entity(IRowSet rowSet, Class clazz) throws Exception {
        Field[] fs;
        if (rowSet == null || clazz == null) {
            return null;
        }
        if (HashMap.class.equals((Object)clazz)) {
            return ClassUtil.singleRowSet2Map(rowSet);
        }
        Object obj = null;
        obj = clazz.newInstance();
        for (Field f : fs = clazz.getDeclaredFields()) {
            String methodName = "set" + f.getName().toUpperCase().charAt(0) + f.getName().substring(1);
            if (!ClassUtil.hasMethod(clazz, methodName, new Class[]{String.class})) continue;
            Method method = clazz.getMethod(methodName, String.class);
            if (!ClassUtil.containColumnName(rowSet, f.getName()) || rowSet.getString(f.getName()) == null) continue;
            method.invoke(obj, rowSet.getString(f.getName()));
        }
        return obj;
    }

    public static List<String> getColumnsName(IRowSet rowSet) throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        int count = rowSet.getRowSetMetaData().getColumnCount();
        for (int i = 1; i <= count; ++i) {
            list.add(rowSet.getRowSetMetaData().getColumnName(i));
        }
        return list;
    }

    public static boolean containColumnName(IRowSet rowSet, String columnName) throws SQLException {
        return ClassUtil.getColumnsName(rowSet).contains(columnName);
    }

    public static Object singleRowSet2Entity(IRowSet rowSet, String className) throws Exception {
        if (className == null) {
            return null;
        }
        Class<?> clazz = Class.forName(className);
        return ClassUtil.singleRowSet2Entity(rowSet, clazz);
    }

    public static Map singleRowSet2Map(IRowSet rowSet) throws SQLException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (rowSet.getRow() == 0) {
            return result;
        }
        ResultSetMetaData rsd = rowSet.getMetaData();
        int count = rsd.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            String name = rsd.getColumnName(i);
            String value = null;
            if (ClassUtil.containColumnName(rowSet, name) && rowSet.getString(name) != null) {
                value = rowSet.getString(name);
            }
            result.put(name, value);
        }
        return result;
    }

    public static Map singleRowSet2LowKeyMap(IRowSet rowSet) throws SQLException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (rowSet.getRow() == 0) {
            return result;
        }
        ResultSetMetaData rsd = rowSet.getMetaData();
        int count = rsd.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            String name = rsd.getColumnName(i);
            String value = null;
            if (ClassUtil.containColumnName(rowSet, name) && rowSet.getString(name) != null) {
                value = rowSet.getString(name);
            }
            if ("UPDATETIME".equals(name)) {
                name = "updateTime";
            } else if ("USEFLAG".equals(name)) {
                name = "useFlag";
            } else if ("ORGRANK".equals(name)) {
                name = "orgRank";
            } else if ("UPDATETIME".equals(name) || "UPDATETIME".equals(name) || "UPDATETIME".equals(name) || "UPDATETIME".equals(name)) {
                // empty if block
            }
            result.put(name.toLowerCase(), value);
        }
        return result;
    }

    public static Object getMapValueIgnoreKeyCase(Map map, String key) {
        if (map == null || key == null || !map.containsKey(key)) {
            return null;
        }
        Set keySet = map.keySet();
        for (Object temp : keySet) {
            if (!temp.toString().equalsIgnoreCase(key)) continue;
            return map.get(key);
        }
        return null;
    }

    public static Object entityTransform(Object src, Object dest) throws Exception {
        Field[] srcFields;
        if (src == null || dest == null) {
            return dest;
        }
        Class<?> srcClass = src.getClass();
        for (Field f : srcFields = srcClass.getDeclaredFields()) {
            String type = f.getGenericType().toString();
            if (type.endsWith("int")) {
                int localObj1 = ClassUtil.getFieldIntValue(src, f.getName());
                ClassUtil.setFieldValue(dest, f.getName(), localObj1);
                continue;
            }
            if (type.endsWith("short")) {
                short localObj1 = ClassUtil.getFieldShortValue(src, f.getName());
                ClassUtil.setFieldValue(dest, f.getName(), localObj1);
                continue;
            }
            if (type.endsWith("float")) {
                float localObj1 = ClassUtil.getFieldFloatValue(src, f.getName());
                ClassUtil.setFieldValue(dest, f.getName(), localObj1);
                continue;
            }
            if (type.endsWith("long")) {
                long localObj1 = ClassUtil.getFieldLongValue(src, f.getName());
                ClassUtil.setFieldValue(dest, f.getName(), localObj1);
                continue;
            }
            if (type.endsWith("boolean")) {
                boolean localObj1 = ClassUtil.getFieldBooleanValue(src, f.getName());
                ClassUtil.setFieldValue(dest, f.getName(), localObj1);
                continue;
            }
            if (type.endsWith("double")) {
                double localObj1 = ClassUtil.getFieldDoubleValue(src, f.getName());
                ClassUtil.setFieldValue(dest, f.getName(), localObj1);
                continue;
            }
            if (type.endsWith("byte")) {
                byte localObj1 = ClassUtil.getFieldByteValue(src, f.getName());
                ClassUtil.setFieldValue(dest, f.getName(), localObj1);
                continue;
            }
            Object localObj1 = ClassUtil.getFieldObjectValue(src, f.getName());
            ClassUtil.setFieldValue(dest, f.getName(), localObj1);
        }
        return dest;
    }

    public static void setFieldValue(Object obj, String fieldName, Object fieldValue) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (obj == null || fieldValue == null || fieldName == null) {
            return;
        }
        String methodName = "set" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1);
        if (ClassUtil.hasMethod(obj.getClass(), methodName, new Class[]{fieldValue.getClass()})) {
            Class<?> clazz = obj.getClass();
            Method method = clazz.getDeclaredMethod(methodName, fieldValue.getClass());
            method.invoke(obj, fieldValue);
        }
    }

    public static void setFieldValue(Object obj, String fieldName, int fieldValue) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (obj == null || fieldName == null) {
            return;
        }
        String methodName = "set" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1);
        if (ClassUtil.hasMethod(obj.getClass(), methodName, new Class[]{Integer.TYPE})) {
            Class<?> clazz = obj.getClass();
            Method method = clazz.getDeclaredMethod(methodName, Integer.TYPE);
            method.invoke(obj, fieldValue);
        }
    }

    public static void setFieldValue(Object obj, String fieldName, short fieldValue) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (obj == null || fieldName == null) {
            return;
        }
        String methodName = "set" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1);
        if (ClassUtil.hasMethod(obj.getClass(), methodName, new Class[]{Short.TYPE})) {
            Class<?> clazz = obj.getClass();
            Method method = clazz.getDeclaredMethod(methodName, Short.TYPE);
            method.invoke(obj, fieldValue);
        }
    }

    public static void setFieldValue(Object obj, String fieldName, long fieldValue) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (obj == null || fieldName == null) {
            return;
        }
        String methodName = "set" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1);
        if (ClassUtil.hasMethod(obj.getClass(), methodName, new Class[]{Long.TYPE})) {
            Class<?> clazz = obj.getClass();
            Method method = clazz.getDeclaredMethod(methodName, Long.TYPE);
            method.invoke(obj, fieldValue);
        }
    }

    public static void setFieldValue(Object obj, String fieldName, float fieldValue) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (obj == null || fieldName == null) {
            return;
        }
        if (ClassUtil.hasMethod(obj.getClass(), fieldName, new Class[]{Float.TYPE})) {
            Class<?> clazz = obj.getClass();
            String methodName = "set" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1);
            Method method = clazz.getDeclaredMethod(methodName, Float.TYPE);
            method.invoke(obj, Float.valueOf(fieldValue));
        }
    }

    public static void setFieldValue(Object obj, String fieldName, byte fieldValue) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (obj == null || fieldName == null) {
            return;
        }
        String methodName = "set" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1);
        if (ClassUtil.hasMethod(obj.getClass(), methodName, new Class[]{Byte.TYPE})) {
            Class<?> clazz = obj.getClass();
            Method method = clazz.getDeclaredMethod(methodName, Byte.TYPE);
            method.invoke(obj, fieldValue);
        }
    }

    public static void setFieldValue(Object obj, String fieldName, boolean fieldValue) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (obj == null || fieldName == null) {
            return;
        }
        String methodName = "set" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1);
        if (ClassUtil.hasMethod(obj.getClass(), methodName, new Class[]{Boolean.TYPE})) {
            Class<?> clazz = obj.getClass();
            Method method = clazz.getDeclaredMethod(methodName, Boolean.TYPE);
            method.invoke(obj, fieldValue);
        }
    }

    public static void setFieldValue(Object obj, String fieldName, char fieldValue) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (obj == null || fieldName == null) {
            return;
        }
        String methodName = "set" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1);
        if (ClassUtil.hasMethod(obj.getClass(), methodName, new Class[]{Character.TYPE})) {
            Class<?> clazz = obj.getClass();
            Method method = clazz.getDeclaredMethod(methodName, Character.TYPE);
            method.invoke(obj, Character.valueOf(fieldValue));
        }
    }

    public static String returnBaseType(Object obj) {
        String result = null;
        if (Integer.class.isInstance(obj)) {
            return "Integer";
        }
        if (Short.class.isInstance(obj)) {
            return "Short";
        }
        if (Long.class.isInstance(obj)) {
            return "Long";
        }
        if (Float.class.isInstance(obj)) {
            return "Float";
        }
        if (Boolean.class.isInstance(obj)) {
            return "Boolean";
        }
        if (Byte.class.isInstance(obj)) {
            return "Byte";
        }
        if (Double.class.isInstance(obj)) {
            return "Double";
        }
        return result;
    }

    public static Map<String, String> HttpRequest2Map(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            map.put(key, request.getParameter(key));
        }
        return map;
    }

    public static String returnNotNullMapValueAsString(Map map, Object key) {
        if (map == null || key == null) {
            return "";
        }
        if (map.containsKey(key) && map.get(key) != null) {
            return map.get(key).toString();
        }
        return "";
    }
}

