/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.multiEvalution.quescloud;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.cloud.http.MyHttpClient;
import com.kingdee.shr.base.syssetting.cloud.http.ResultVo;
import com.kingdee.shr.base.syssetting.util.URLUtil;
import com.kingdee.shr.cloudservice.util.HttpClientUtil;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.multiEvalution.commontask.utils.QuesServerInstance;
import com.kingdee.shr.perfweb.multiEvalution.quescloud.result.QuesCloudResult;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQuesCloudRequest {
    private static Logger logger = LoggerFactory.getLogger(AbstractQuesCloudRequest.class);
    public static final String EID = "eid";
    private Context ctx;
    private Integer page;
    private Integer rows;
    private Map<String, Object> customParams;
    protected String url;
    private Map<String, Object> params;

    public AbstractQuesCloudRequest(Context ctx) throws EASBizException {
        this.ctx = ctx;
    }

    public AbstractQuesCloudRequest(Context ctx, Map<String, Object> customParams) throws EASBizException {
        this.ctx = ctx;
        this.customParams = customParams;
    }

    public AbstractQuesCloudRequest(Context ctx, Integer page, Integer rows, Map<String, Object> customParams) throws EASBizException {
        this.ctx = ctx;
        this.page = page;
        this.rows = rows;
        this.customParams = customParams;
    }

    public AbstractQuesCloudRequest buildRequest() throws EASBizException {
        return this.buildRequest("0");
    }

    public AbstractQuesCloudRequest buildRequest(String serviceType) throws EASBizException {
        String serviceUrl;
        Map<String, String> map;
        String serviceName = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.QUESCLOUD, this.ctx);
        if ("2".equals(serviceType)) {
            serviceName = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.CLOUDSERVICE, this.ctx);
        }
        try {
            map = QuesServerInstance.getServerInfo(this.ctx, serviceType);
        }
        catch (Exception e) {
            logger.error("buildRequest err: ", (Throwable)e);
            throw new SHRPerfWebBizException(SHRPerfWebBizException.GETSERVICECONFIGERR, new Object[]{serviceName});
        }
        String baseUrl = map.get(QuesServerInstance.CLOUD_SERVERURL);
        if (StringUtils.isEmpty((String)baseUrl)) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.SERVICENOTCONFIGERR, new Object[]{serviceName});
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(EID, map.get(QuesServerInstance.SERVICE_ID));
        if (this.customParams != null) {
            params.putAll(this.customParams);
        }
        if (StringUtils.isEmpty((String)(serviceUrl = this.getServiceRequestURL(this.page, this.rows, params)))) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.APIADDRREQUIRED, new Object[]{serviceName});
        }
        String[] urls = baseUrl.split(":");
        String url1 = urls[0];
        int port = 80;
        if (baseUrl.startsWith("http")) {
            url1 = urls[1].substring(2, urls[1].length());
            if (url1.endsWith("/")) {
                url1 = url1.substring(0, url1.length() - 1);
            }
            if (urls.length > 2) {
                port = Integer.parseInt(urls[2].substring(0, urls[2].length() - 1));
            }
        } else if (urls.length > 1) {
            port = Integer.parseInt(urls[1].substring(0, urls[1].length() - 1));
        }
        int port2 = 443;
        if (!AbstractQuesCloudRequest.judgeUrlIsReachable(url1, port) && !AbstractQuesCloudRequest.judgeUrlIsReachable(url1, port2)) {
            logger.error(new SHRPerfWebBizException(SHRPerfWebBizException.REQUESTCLOUDSERVICETIMEOUT, new Object[]{url1, port}).getMessage() + new SHRPerfWebBizException(SHRPerfWebBizException.REQUESTCLOUDSERVICETIMEOUT, new Object[]{url1, port2}));
            throw new SHRPerfWebBizException(SHRPerfWebBizException.REQUESTCLOUDSERVICETIMEOUT, new Object[]{url1, port});
        }
        String url = baseUrl.concat(serviceUrl);
        url = url.contains("?") ? url.concat("&") : url.concat("?");
        this.url = url = url.concat(QuesServerInstance.ACCESS_TOKEN).concat("=") + map.get(QuesServerInstance.ACCESS_TOKEN);
        this.params = params;
        return this;
    }

    public QuesCloudResult doPost() throws EASBizException {
        ResultVo resultVo;
        try {
            resultVo = AbstractQuesCloudRequest.doPostJson(this.url, JSON.toJSONString(this.params));
        }
        catch (BOSException e) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.REQUESTCLOUDSERVICETIERR);
        }
        return AbstractQuesCloudRequest.parseResult(resultVo);
    }

    public QuesCloudResult doPost(String json) throws EASBizException {
        ResultVo resultVo;
        try {
            resultVo = AbstractQuesCloudRequest.doPostJson(this.url, json);
        }
        catch (BOSException e) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.REQQUESCLOUDSERVICEERR);
        }
        return AbstractQuesCloudRequest.parseResult(resultVo);
    }

    public QuesCloudResult doGet() throws EASBizException {
        ResultVo resultVo;
        try {
            resultVo = HttpClientUtil.doGet((String)this.url, this.params);
        }
        catch (BOSException e) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.REQQUESCLOUDSERVICEERR);
        }
        return AbstractQuesCloudRequest.parseResult(resultVo);
    }

    protected abstract String getServiceRequestURL(Integer var1, Integer var2, Map<String, Object> var3);

    public static ResultVo doPostJson(String url, String json) throws BOSException {
        ResultVo resultVo;
        PostMethod method = null;
        try {
            MyHttpClient httpClient = new MyHttpClient();
            httpClient.getParams().setParameter("http.protocol.allow-circular-redirects", (Object)true);
            httpClient.getParams().setIntParameter("http.socket.timeout", 300000);
            httpClient.getParams().setIntParameter("http.connection.timeout", 180000);
            method = URLUtil.getPostMethod((String)url, (Map)null);
            StringRequestEntity requestEntity = new StringRequestEntity(json, "application/json", "UTF-8");
            method.setRequestEntity((RequestEntity)requestEntity);
            method.setRequestHeader("Content-Type", "application/json;charset=UTF-8");
            int status = httpClient.executeMethod((HttpMethod)method);
            String data = method.getResponseBodyAsString();
            resultVo = status == 200 ? new ResultVo(String.valueOf(status), (Object)data, "request success") : new ResultVo(String.valueOf(status), (Object)data, "request failed");
        }
        catch (Exception var11) {
            logger.error(var11.getMessage());
            throw new BOSException((Throwable)var11);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return resultVo;
    }

    private static boolean isJSONString(String str) {
        try {
            JSON.parse((String)str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static QuesCloudResult parseResult(ResultVo resultVo) {
        if (resultVo == null || !"200".equals(resultVo.getErrorCode())) {
            QuesCloudResult result = new QuesCloudResult();
            result.setCode(resultVo.getErrorCode());
            result.setSuccess(false);
            result.setErrorMessage(resultVo.getInfo());
            return result;
        }
        String resultData = resultVo.getData().toString();
        if (AbstractQuesCloudRequest.isJSONString(resultData)) {
            return (QuesCloudResult)JSONObject.parseObject((String)resultVo.getData().toString(), QuesCloudResult.class);
        }
        QuesCloudResult result = new QuesCloudResult();
        result.setCode(resultVo.getErrorCode());
        result.setSuccess(false);
        result.setErrorMessage(resultVo.getData().toString());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean judgeUrlIsReachable(String url, int port) {
        boolean isReachable;
        Socket socket = null;
        try {
            socket = new Socket();
            socket.setSoTimeout(10000);
            InetSocketAddress address = new InetSocketAddress(url, port);
            socket.connect(address, 10000);
            isReachable = true;
        }
        catch (IOException e) {
            isReachable = false;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    logger.error("IOException: ", (Throwable)e);
                }
            }
        }
        return isReachable;
    }
}

