/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.DeepClone;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaFormFieldConfFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.IEvaFormFieldConf;
import com.kingdee.shr.perfweb.app.base.evalrule.IRecordFieldConf;
import com.kingdee.shr.perfweb.app.base.evalrule.PWorkFlowDefFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.PWorkFlowDefInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.RecordFieldConfFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefInfo;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScorLevelDefineCollection;
import com.kingdee.shr.perfweb.app.common.YesOrNoEnum;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.app.workflow.GradeTargetInstCollection;
import com.kingdee.shr.perfweb.app.workflow.GradeTargetInstFactory;
import com.kingdee.shr.perfweb.app.workflow.GradeTargetInstInfo;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstCollection;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstFactory;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstInfo;
import com.kingdee.shr.perfweb.app.workflow.IGradeTaskNodeInst;
import com.kingdee.shr.perfweb.app.workflow.IWholeComment;
import com.kingdee.shr.perfweb.app.workflow.WholeCommentCollection;
import com.kingdee.shr.perfweb.app.workflow.WholeCommentFactory;
import com.kingdee.shr.perfweb.app.workflow.WholeCommentInfo;
import com.kingdee.shr.perfweb.portal.bean.EvaAreaListBean;
import com.kingdee.shr.perfweb.portal.bean.PersonalEvaBaseBean;
import com.kingdee.shr.perfweb.portal.serviceImpl.AbstractPerfScoreService;
import com.kingdee.shr.perfweb.portal.serviceImpl.PerfGoasFillService;
import com.kingdee.shr.perfweb.portal.serviceImpl.PerfScoreServiceFactory;
import com.kingdee.shr.perfweb.util.AttachmentUtil;
import com.kingdee.shr.perfweb.util.EvaFormUtil;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.PerfConfigUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class GetGradingDetailService
implements IHRMsfService {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.osf.GetGradingDetailService");

    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        String evaObjId = (String)param.get("evaObjId");
        String nodeTaskId = (String)param.get("nodeTaskId");
        String ruleId = (String)param.get("perfRule");
        if (StringUtils.isEmpty((CharSequence)evaObjId)) {
            ArrayList result = new ArrayList();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("resultFlag", "failure");
            map.put("errorDes", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PARAMREQUIRED, ctx));
            return result.add(map);
        }
        logger.error("\u3010PERFWEB\u3011-Get grading detail,evaObjId is :" + evaObjId + "    nodeTaskId :" + nodeTaskId + "   ruleId :" + ruleId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.getWholeDetail(ctx, nodeTaskId, result, evaObjId);
        this.getScoreOrRankDetail(ctx, ruleId, result);
        this.getEvaluTargetList(ctx, nodeTaskId, evaObjId, result);
        HashMap<String, String> targrtMap = GetEntityInfoUtils.getCalcNodeSumScore(ctx, nodeTaskId, evaObjId);
        DecimalFormat df = new DecimalFormat("#.##");
        if (targrtMap.get("showTarget") != null && targrtMap.get("showTarget").equals("0")) {
            Object wholeScoreTemp = result.get("wholeScore");
            Object sumScore = targrtMap.get("sumScore");
            BigDecimal temp1 = wholeScoreTemp != null && StringUtils.isEmpty((CharSequence)wholeScoreTemp.toString()) ? new BigDecimal(wholeScoreTemp.toString()) : new BigDecimal("0");
            BigDecimal temp2 = sumScore != null && StringUtils.isEmpty((CharSequence)sumScore.toString()) ? new BigDecimal(sumScore.toString()) : new BigDecimal("0");
            BigDecimal wholeScore = temp1.subtract(temp2);
            if ((wholeScore = wholeScore.abs()).compareTo(new BigDecimal("0.01")) == 0) {
                result.put("wholeScore", "0.00");
            } else {
                result.put("wholeScore", df.format(wholeScore));
            }
        }
        result.put("upgradeType", 1);
        logger.info("wholeScore1:" + (String)result.get("wholeScore"));
        logger.info("wholeScore3:" + (String)result.get("wholeScore"));
        return result;
    }

    public void getWholeDetail(Context ctx, String nodeTaskId, Map<String, Object> result, String evaObjId) throws BOSException, EASBizException {
        PerfEvaObjectInfo evaObjInfo = GetEntityInfoUtils.getPerfEvaObjectInfo(ctx, evaObjId);
        ArrayList<Map<String, Object>> wholeList = new ArrayList<Map<String, Object>>();
        if (1 == evaObjInfo.getCanAdjustEvaluer().getValue()) {
            GradeTaskNodeInstCollection gradeTaskNodeColl = GetEntityInfoUtils.getOnlyCurrentAndPrevGradeTaskNodeInstWithJumpCollection(ctx, evaObjId, nodeTaskId, null);
            for (int i = 0; i < gradeTaskNodeColl.size(); ++i) {
                if (!"1".equals(gradeTaskNodeColl.get(i).getCanEdit().getValue())) continue;
                wholeList.add(this.getWholeCommentDetail(ctx, gradeTaskNodeColl.get(i), GetEntityInfoUtils.getWFNodeDefInfo(ctx, gradeTaskNodeColl.get(i).getWfNode().getId().toString()), true));
            }
            nodeTaskId = GetEntityInfoUtils.getLastCommittedGradeTaskNodeIdByEvaObj(ctx, evaObjId);
        } else {
            GradeTaskNodeInstInfo gradeTaskNodeInstInfo = GetEntityInfoUtils.getGradeTaskNodeInstInfoById(ctx, nodeTaskId);
            if (gradeTaskNodeInstInfo != null && gradeTaskNodeInstInfo.getWfNode() != null && gradeTaskNodeInstInfo.getWfNode().getWorkflow() != null) {
                PWorkFlowDefInfo workFlowDefInfo = PWorkFlowDefFactory.getLocalInstance((Context)ctx).getPWorkFlowDefInfo("where id = '" + gradeTaskNodeInstInfo.getWfNode().getWorkflow().getId().toString() + "'");
                if ("1".equals(workFlowDefInfo.getConcurrent())) {
                    GradeTaskNodeInstCollection gradeTaskNodeColl = GetEntityInfoUtils.getConCurrentAndPrevGradeTaskNodeInstWithJumpCollection(ctx, evaObjId, gradeTaskNodeInstInfo);
                    for (int i = 0; i < gradeTaskNodeColl.size(); ++i) {
                        if (!"1".equals(gradeTaskNodeColl.get(i).getCanEdit().getValue())) continue;
                        wholeList.add(this.getWholeCommentDetail(ctx, gradeTaskNodeColl.get(i), GetEntityInfoUtils.getWFNodeDefInfo(ctx, gradeTaskNodeColl.get(i).getWfNode().getId().toString()), true));
                    }
                    nodeTaskId = GetEntityInfoUtils.getLastCommittedGradeTaskNodeIdByEvaObj(ctx, evaObjId);
                } else {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("*"));
                    sic.add(new SelectorItemInfo("evaObj.id"));
                    sic.add(new SelectorItemInfo("wfNode.id"));
                    sic.add(new SelectorItemInfo("wfNode.WholeComment"));
                    sic.add(new SelectorItemInfo("wfNode.IndicatorComment"));
                    sic.add(new SelectorItemInfo("wfNode.NeedScore"));
                    sic.add(new SelectorItemInfo("wfNode.PerfGradeEvaluate"));
                    sic.add(new SelectorItemInfo("wfNode.CanVeto"));
                    sic.add(new SelectorItemInfo("wfNode.WholeComment"));
                    sic.add(new SelectorItemInfo("wfNode.nodeName"));
                    sic.add(new SelectorItemInfo("wfNode.targetComment"));
                    sic.add(new SelectorItemInfo("wfNode.workFlow"));
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)nodeTaskId, CompareType.EQUALS));
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    viewInfo.setFilter(filter);
                    viewInfo.setSelector(sic);
                    GradeTaskNodeInstCollection coll = GradeTaskNodeInstFactory.getLocalInstance((Context)ctx).getGradeTaskNodeInstCollection(viewInfo);
                    GradeTaskNodeInstInfo info = coll.get(0);
                    if ("1".equals(info.getCanEdit().getValue())) {
                        wholeList.add(this.getWholeCommentDetail(ctx, info, info.getWfNode(), false));
                    }
                }
            }
        }
        result.put("wholeCommentList", wholeList);
        List<Object> attachmentList = new ArrayList();
        try {
            HashMap<String, String> parames = new HashMap<String, String>();
            parames.put("evaObj", evaObjInfo.getId().toString());
            parames.put("gradeTaskNode", nodeTaskId);
            List<Map<String, String>> attachInfoList = EvaFormUtil.initialAttachmentAction(ctx, parames, false);
            ArrayList<String> attachIds = new ArrayList<String>();
            for (Map<String, String> attachInfoMap : attachInfoList) {
                String attachId = attachInfoMap.get("id");
                if (!StringUtils.isNotBlank((CharSequence)attachId)) continue;
                attachIds.add(attachId);
            }
            attachmentList = AttachmentUtil.getAttachmentsByIds(ctx, attachIds);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        result.put("attachmentList", attachmentList);
        logger.error("attachmentList:{}" + JSON.toJSONString(attachmentList));
    }

    public Map<String, Object> getWholeCommentDetail(Context ctx, GradeTaskNodeInstInfo info, WFNodeDefInfo wfNodeInfo, boolean flag) throws BOSException, EASBizException {
        String nodeWeight;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String nodeTaskId = info.getId().toString();
        GradeTargetInstCollection gradeTaskColl = GradeTargetInstFactory.getLocalInstance((Context)ctx).getGradeTargetInstCollection("where gradeTaskNode = '" + nodeTaskId + "'");
        HashMap<String, GradeTargetInstInfo> targetMap = new HashMap<String, GradeTargetInstInfo>();
        for (int i = 0; i < gradeTaskColl.size(); ++i) {
            String targetID = gradeTaskColl.get(i).getTarget();
            GradeTargetInstInfo gradeInfo = gradeTaskColl.get(i);
            targetMap.put(targetID, gradeInfo);
        }
        result.put("wholeComment", wfNodeInfo.getWholeComment() == null ? "2" : wfNodeInfo.getWholeComment().getValue());
        result.put("targetComment", wfNodeInfo.getTargetComment().getValue());
        result.put("indicatorComment", wfNodeInfo.getIndicatorComment() == null ? "0" : wfNodeInfo.getIndicatorComment().getValue());
        result.put("needScore", wfNodeInfo.getNeedScore().getValue());
        result.put("perfGradeEvaluate", wfNodeInfo.getPerfGradeEvaluate() == null ? "0" : wfNodeInfo.getPerfGradeEvaluate().getValue());
        result.put("targetTask", targetMap);
        result.put("gradeTaskNode", nodeTaskId);
        result.put("canEdit", info.getCanEdit().getValue());
        result.put("nodeHandlerName", info.getNodeHandlerName());
        result.put("nodeHandlerId", info.getNodeHandler().getId().toString());
        String inWeight = info.getInweight();
        String outWeight = info.getOutWeight();
        String string = nodeWeight = StringUtils.isEmpty((CharSequence)wfNodeInfo.getNodeWeight()) ? "0" : wfNodeInfo.getNodeWeight();
        if (!StringUtils.isEmpty((CharSequence)inWeight)) {
            nodeWeight = String.valueOf(new BigDecimal(nodeWeight).add(new BigDecimal(inWeight)).setScale(2, RoundingMode.DOWN));
        }
        if (!StringUtils.isEmpty((CharSequence)outWeight)) {
            nodeWeight = String.valueOf(new BigDecimal(nodeWeight).subtract(new BigDecimal(outWeight)).setScale(2, RoundingMode.DOWN));
        }
        result.put("nodeWeight", nodeWeight);
        String evaObj = info.getEvaObj().getId().toString();
        if (flag) {
            Map<String, String> areaNameMap = GetEntityInfoUtils.getAreaBaseNameByNodeTaskInst(ctx, info.getId().toString(), evaObj);
            result.put("nodeName", StringUtils.isEmpty((CharSequence)wfNodeInfo.getNodeName()) ? " " : wfNodeInfo.getNodeName() + "(" + areaNameMap.get(info.getId().toString()) + ")");
        } else {
            result.put("nodeName", StringUtils.isEmpty((CharSequence)wfNodeInfo.getNodeName()) ? "" : wfNodeInfo.getNodeName());
        }
        if (wfNodeInfo.getCanVeto() == null) {
            result.put("canVeto", "0");
        } else {
            result.put("canVeto", wfNodeInfo.getCanVeto().getValue());
        }
        PerformanceRuleInfo ruleInfo = GetEntityInfoUtils.getPerformanceRuleInfoByEvaObj(ctx, evaObj);
        result.put("scoreWay", ruleInfo.getScoringWay().getValue());
        IWholeComment iWholeComment = WholeCommentFactory.getLocalInstance((Context)ctx);
        WholeCommentInfo wholeInfo = iWholeComment.getWholeCommentInfo("select score,Grade,comment,evaObj.id WHERE gradeTaskNodeInst ='" + nodeTaskId + "'");
        DecimalFormat df = new DecimalFormat("#.##");
        df.setRoundingMode(RoundingMode.DOWN);
        if (wholeInfo.get("score") != null) {
            BigDecimal wholeScore = new BigDecimal(String.valueOf(wholeInfo.getScore()));
            HashMap<String, String> noFormulaScoreMap = GetEntityInfoUtils.getCalcNodeSumScore(ctx, info.getId().toString(), info.getEvaObj().getId().toString());
            if ("0".equals(noFormulaScoreMap.get("showTarget"))) {
                if (!StringUtils.isEmpty((CharSequence)((CharSequence)noFormulaScoreMap.get("sumScore")))) {
                    BigDecimal showWholeScore = wholeScore.subtract(new BigDecimal((String)noFormulaScoreMap.get("sumScore")));
                    if (showWholeScore.compareTo(BigDecimal.ZERO) < 0) {
                        result.put("wholeScore", "");
                    } else {
                        result.put("wholeScore", showWholeScore);
                    }
                } else {
                    result.put("wholeScore", "");
                }
            } else {
                result.put("wholeScore", wholeInfo.get("score"));
            }
        } else {
            result.put("wholeScore", wholeInfo.get("score"));
        }
        boolean perfGradeEvaluate = "0".equals(wfNodeInfo.getPerfGradeEvaluate().getValue());
        result.put("wholeGrade", wholeInfo.getGrade() == null || perfGradeEvaluate ? "" : wholeInfo.getGrade());
        result.put("comment", wholeInfo.getComment());
        result.put("isShowWholeGrade", info.getIsShowWholeGrade());
        if (info.getScoreStatus() != null) {
            result.put("scoreStatus", info.getScoreStatus().getValue());
        } else {
            result.put("scoreStatus", "0");
        }
        SelectorItemCollection sic1 = new SelectorItemCollection();
        sic1.add(new SelectorItemInfo("score"));
        sic1.add(new SelectorItemInfo("grade"));
        sic1.add(new SelectorItemInfo("weight"));
        sic1.add(new SelectorItemInfo("comment"));
        sic1.add(new SelectorItemInfo("gradeTaskNodeInst.wfLevel"));
        sic1.add(new SelectorItemInfo("gradeTaskNodeInst.nodeSeq"));
        sic1.add(new SelectorItemInfo("gradeTaskNodeInst.nodeHandler"));
        sic1.add(new SelectorItemInfo("gradeTaskNodeInst.nodeHandlerName"));
        sic1.add(new SelectorItemInfo("gradeTaskNodeInst.wfNode.nodeName"));
        sic1.add(new SelectorItemInfo("gradeTaskNodeInst.wfNode.needScore"));
        sic1.add(new SelectorItemInfo("gradeTaskNodeInst.isShowWholeGrade"));
        IGradeTaskNodeInst igradeTaskNodeInst = GradeTaskNodeInstFactory.getLocalInstance((Context)ctx);
        GradeTaskNodeInstCollection gradeTaskNodeColl = igradeTaskNodeInst.getGradeTaskNodeInstCollection("select id where wfNode.workflow = '" + wfNodeInfo.getWorkflow().getId().toString() + "' and scoreStatus='" + "2" + "' and isEffective='" + "1" + "' and evaObj = '" + wholeInfo.getEvaObj().getId().toString() + "' and wfLevel < " + info.getWfLevel());
        WholeCommentCollection wholeColl = new WholeCommentCollection();
        if (gradeTaskNodeColl != null && gradeTaskNodeColl.size() > 0) {
            HashSet<String> nodeIds = new HashSet<String>();
            for (int ii = 0; ii < gradeTaskNodeColl.size(); ++ii) {
                nodeIds.add(gradeTaskNodeColl.get(ii).getId().toString());
            }
            EntityViewInfo viewInfoTmp = new EntityViewInfo();
            viewInfoTmp.setSelector(sic1);
            FilterInfo filterTmp = new FilterInfo();
            filterTmp.getFilterItems().add(new FilterItemInfo("evaObj", (Object)wholeInfo.getEvaObj().getId().toString(), CompareType.EQUALS));
            filterTmp.getFilterItems().add(new FilterItemInfo("gradeTaskNodeInst.id", nodeIds, CompareType.INCLUDE));
            filterTmp.getFilterItems().add(new FilterItemInfo("id", (Object)wholeInfo.getId().toString(), CompareType.NOTEQUALS));
            viewInfoTmp.setFilter(filterTmp);
            SorterItemCollection sorterItemCollection = new SorterItemCollection();
            viewInfoTmp.setSorter(sorterItemCollection);
            try {
                sorterItemCollection.getSorter().decode("order by gradeTaskNodeInst.wfLevel asc,gradeTaskNodeInst.nodeSeq asc");
            }
            catch (ParserException e) {
                logger.error("ParserException: ", (Throwable)e);
            }
            wholeColl = iWholeComment.getWholeCommentCollection(viewInfoTmp);
        }
        ArrayList<WholeCommentInfo> list = new ArrayList<WholeCommentInfo>();
        for (int i = 0; i < wholeColl.size(); ++i) {
            String needScore = wholeColl.get(i).getGradeTaskNodeInst().getWfNode().getNeedScore().getValue();
            wholeColl.get(i).put("needScore", (Object)needScore);
            GradeTaskNodeInstInfo gradeTaskNodeInst = wholeColl.get(i).getGradeTaskNodeInst();
            gradeTaskNodeInst.put("nodeHandlerId", (Object)gradeTaskNodeInst.getNodeHandler().getId().toString());
            list.add(wholeColl.get(i));
        }
        result.put("wholeScoreHis", list);
        return result;
    }

    public void getScoreOrRankDetail(Context ctx, String ruleId, Map<String, Object> result) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("pariMutual.name"));
        sic.add(new SelectorItemInfo("pariMutual.max"));
        sic.add(new SelectorItemInfo("pariMutual.min"));
        sic.add(new SelectorItemInfo("scoreRate.name"));
        sic.add(new SelectorItemInfo("scoreRate.id"));
        sic.add(new SelectorItemInfo("scoreRate.PerfLevelDefInfo.PerfLevelName"));
        sic.add(new SelectorItemInfo("perfRate.perfLevelDefInfo.PerfLevelName"));
        sic.add(new SelectorItemInfo("perfRate.perfLevelDefInfo.SysPerfLevel"));
        sic.add(new SelectorItemInfo("perfRate.PerfScoreInfo.max"));
        sic.add(new SelectorItemInfo("perfRate.PerfScoreInfo.min"));
        sic.add(new SelectorItemInfo("perfRate.PerfScoreInfo.name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ruleId, CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.setSelector(sic);
        PerformanceRuleCollection coll = PerformanceRuleFactory.getLocalInstance((Context)ctx).getPerformanceRuleCollection(viewInfo);
        PerformanceRuleInfo rule = coll.get(0);
        PerfGoasFillService perfGoasFillService = new PerfGoasFillService();
        logger.info("perfweb : rule:" + rule.toString());
        if (null != rule.getScoreRule() && "100".equals(rule.getScoreRule().getValue())) {
            result.put("scoreName", rule.getPariMutual().getName());
            result.put("max", rule.getPariMutual().getMax().setScale(2, 4));
            result.put("min", rule.getPariMutual().getMin().setScale(2, 4));
            result.put("scoreOrRank", "0");
        } else {
            result.put("scoreName", rule.getScoreRate().getName());
            PerfScorLevelDefineCollection scoreLevelColl = rule.getScoreRate().getPerfLevelDefInfo();
            ArrayList<String> rateList = new ArrayList<String>();
            for (int j = 0; j < scoreLevelColl.size(); ++j) {
                rateList.add(scoreLevelColl.get(j).getPerfLevelName());
            }
            Map<String, String> perfScoreLevelMap = perfGoasFillService.getPerfScoreLevelKV(ctx, rule.getScoreRate().getId().toString());
            result.put("rateRange", perfScoreLevelMap);
            result.put("scoreOrRank", "1");
        }
        ArrayList<String> perfRateList = new ArrayList<String>();
        for (int i = 0; i < rule.getPerfRate().getPerfLevelDefInfo().size(); ++i) {
            if (rule.getPerfRate().getPerfLevelDefInfo().get(i).getPerfLevelName() == null) {
                perfRateList.add(rule.getPerfRate().getPerfLevelDefInfo().get(i).getSysPerfLevel());
                continue;
            }
            perfRateList.add(rule.getPerfRate().getPerfLevelDefInfo().get(i).getPerfLevelName());
        }
        Map<String, String> perfScoreLevelMap = perfGoasFillService.getPerfScoreLevelKV(ctx, rule.getPerfRate().getId().toString());
        result.put("perfRateRange", perfScoreLevelMap);
        result.put("perfScoreMax", rule.getPerfRate().getPerfScoreInfo().getMax());
        result.put("perfScoreMin", rule.getPerfRate().getPerfScoreInfo().getMin());
        result.put("perfScoreName", rule.getPerfRate().getPerfScoreInfo().getName());
    }

    public void getEvaluTargetList(Context ctx, String nodeTask, String evaObjId, Map<String, Object> result2) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("evaObj.id"));
        sic.add(new SelectorItemInfo("areaBase.seq"));
        sic.add(new SelectorItemInfo("areaBase.CanOverSumRange"));
        sic.add(new SelectorItemInfo("areaBase.overRange"));
        sic.add(new SelectorItemInfo("areaBase.CanNegativeScore"));
        sic.add(new SelectorItemInfo("areaBase.CanRate"));
        sic.add(new SelectorItemInfo("areaBase.name"));
        sic.add(new SelectorItemInfo("areaBase.rema"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaObj.id", (Object)evaObjId, CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.setSelector(sic);
        SorterItemCollection sorter1 = new SorterItemCollection();
        sorter1.add(new SorterItemInfo("areaBase.seq"));
        sorter1.add(new SorterItemInfo("seq"));
        sorter1.add(new SorterItemInfo("createTime"));
        sorter1.add(new SorterItemInfo("number"));
        sorter1.add(new SorterItemInfo("name"));
        viewInfo.setSorter(sorter1);
        IndicatorTargetCollection indeColl = IndicatorTargetFactory.getLocalInstance((Context)ctx).getIndicatorTargetCollection(viewInfo);
        viewInfo.setSorter(new SorterItemCollection());
        SorterItemCollection sorter2 = new SorterItemCollection();
        sorter2.add(new SorterItemInfo("areaBase.seq"));
        sorter2.add(new SorterItemInfo("seq"));
        sorter2.add(new SorterItemInfo("createTime"));
        sorter2.add(new SorterItemInfo("keyCode"));
        sorter2.add(new SorterItemInfo("keyItem"));
        viewInfo.setSorter(sorter2);
        RecordTargetCollection recordColl = RecordTargetFactory.getLocalInstance((Context)ctx).getRecordTargetCollection(viewInfo);
        viewInfo.setSorter(new SorterItemCollection());
        List<Object> result = new ArrayList();
        try {
            result = this.sort(ctx, indeColl, recordColl, nodeTask, evaObjId);
        }
        catch (EASBizException e) {
            logger.error("getEvaluTargetList EASBizException: ", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("getEvaluTargetList IOException: ", (Throwable)e);
        }
        result2.put("data", result);
    }

    public List<Map<String, Object>> sort(Context ctx, IndicatorTargetCollection indeColl, RecordTargetCollection recordColl, String nodeTask, String evaObj) throws EASBizException, BOSException, IOException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Map<Object, Object> indecatorsMap = new HashMap();
        PerfEvaObjectInfo evaObjInfo = GetEntityInfoUtils.getPerfEvaObjectInfo(ctx, evaObj);
        try {
            HashMap<String, Object> parames = new HashMap<String, Object>();
            parames.put("evaObj", evaObj);
            parames.put("gradeTaskNode", nodeTask);
            parames.put("getTargetType", "1");
            AbstractPerfScoreService perfScoreService = PerfScoreServiceFactory.getPerfScoreService("1");
            assert (perfScoreService != null);
            indecatorsMap = perfScoreService.compositeEvaObjectData(ctx, parames);
        }
        catch (Exception e1) {
            logger.error("PerfGoasFillService.compositeEvaObjectDataAction is error: " + e1);
        }
        if (!CollectionUtils.isEmpty(indecatorsMap)) {
            Object gtargetInfo;
            String key;
            HashMap<String, Object> otherEvalu;
            GradeTaskNodeInstInfo gtnInfo;
            int j;
            GradeTargetInstInfo gradeTargetInfo;
            IndicatorTargetInfo info;
            ArrayList otherList;
            int i;
            GradeTargetInstCollection gradeTargetInstColl = new GradeTargetInstCollection();
            GradeTaskNodeInstCollection gtnInstColl = new GradeTaskNodeInstCollection();
            GradeTaskNodeInstInfo gradeTaskNodeInstInfo = GetEntityInfoUtils.getGradeTaskNodeInstInfoById(ctx, nodeTask);
            int currentLevel = 0;
            if (gradeTaskNodeInstInfo != null && gradeTaskNodeInstInfo.getWfNode() != null && gradeTaskNodeInstInfo.getWfNode().getWorkflow() != null) {
                PWorkFlowDefInfo workFlowDefInfo = PWorkFlowDefFactory.getLocalInstance((Context)ctx).getPWorkFlowDefInfo("where id = '" + gradeTaskNodeInstInfo.getWfNode().getWorkflow().getId().toString() + "'");
                if (1 == evaObjInfo.getCanAdjustEvaluer().getValue() || "1".equals(workFlowDefInfo.getConcurrent())) {
                    gradeTargetInstColl = this.gerGradeTargetInstColl(ctx, evaObjInfo);
                    gtnInstColl = GetEntityInfoUtils.getMatrixTaskNodeInstCollection(ctx, evaObj);
                } else {
                    gradeTargetInstColl = GradeTargetInstFactory.getLocalInstance((Context)ctx).getGradeTargetInstCollection("where gradeTaskNode = '" + nodeTask + "' and evaObj = '" + evaObj + "'");
                    gtnInstColl = GetEntityInfoUtils.getOnlyCurrentAndPrevGradeTaskNodeInstCollectionForScoreDeal(ctx, evaObj, nodeTask);
                }
                currentLevel = gradeTaskNodeInstInfo.getWfLevel();
            }
            String scoreListPreScores = "0";
            scoreListPreScores = PerfConfigUtils.getConfigByName(ctx, "scoreOtherScoreStyle");
            HashSet<String> gradeTaskNodeIds = new HashSet<String>();
            int gtnSize = gtnInstColl == null ? 0 : gtnInstColl.size();
            for (int i2 = 0; i2 < gtnSize; ++i2) {
                int wfLevel = gtnInstColl.get(i2).getWfLevel();
                if ((wfLevel != currentLevel - 1 || !StringUtils.equals((CharSequence)"1", (CharSequence)scoreListPreScores)) && (wfLevel >= currentLevel || !StringUtils.equals((CharSequence)"0", (CharSequence)scoreListPreScores))) continue;
                gradeTaskNodeIds.add(gtnInstColl.get(i2).getId().toString());
            }
            HashMap<String, GradeTargetInstInfo> gradeTargetMap = new HashMap<String, GradeTargetInstInfo>();
            if (gradeTargetInstColl != null) {
                for (int i3 = 0; i3 < gradeTargetInstColl.size(); ++i3) {
                    gradeTargetMap.put(gradeTargetInstColl.get(i3).getTarget(), gradeTargetInstColl.get(i3));
                }
            }
            Map<String, GradeTargetInstInfo> hisGradeTargetInstMap = this.getHisGradeTargetInstMap(ctx, gradeTaskNodeIds);
            for (i = 0; i < indeColl.size(); ++i) {
                otherList = new ArrayList(16);
                info = indeColl.get(i);
                gradeTargetInfo = (GradeTargetInstInfo)gradeTargetMap.get(info.getId().toString());
                if (gradeTargetInfo == null) continue;
                for (j = 0; j < gtnSize; ++j) {
                    gtnInfo = gtnInstColl.get(j);
                    if (gtnInfo.getId().toString().equals(gradeTargetInfo.getGradeTaskNode().getId().toString())) continue;
                    otherEvalu = new HashMap<String, Object>();
                    key = info.getId().toString() + "$" + gtnInfo.getId().toString();
                    gtargetInfo = hisGradeTargetInstMap.get(key);
                    if (gtargetInfo == null) continue;
                    otherEvalu.put("rejection", gtargetInfo.getIsRejection().getValue() == 1);
                    otherEvalu.put("taskid", gtnInfo.getId().toString());
                    otherEvalu.put("taskrank", gtargetInfo.getGradeRank());
                    otherEvalu.put("taskscore", gtargetInfo.get("targetScore"));
                    otherEvalu.put("weight", Float.valueOf(gtnInfo.getNodeWeight()));
                    otherEvalu.put("nodeHandler", gtnInfo.getNodeHandlerName());
                    otherEvalu.put("nodeName", gtnInfo.getWfNode().getNodeName());
                    otherEvalu.put("indiComment", gtargetInfo.getComment());
                    otherEvalu.put("needScore", gtnInfo.getWfNode().getNeedScore().getValue());
                    otherEvalu.put("nodeHandlerId", gtnInfo.getNodeHandler().getId().toString());
                    Map<String, Object> map = EvaFormUtil.putExtendInfo(ctx, (GradeTargetInstInfo)gtargetInfo);
                    otherEvalu.putAll(map);
                    otherList.add(otherEvalu);
                }
                info.put("otherList", otherList);
            }
            for (i = 0; i < recordColl.size(); ++i) {
                otherList = new ArrayList(16);
                info = recordColl.get(i);
                gradeTargetInfo = (GradeTargetInstInfo)gradeTargetMap.get(info.getId().toString());
                if (gradeTargetInfo == null) continue;
                for (j = 0; j < gtnSize; ++j) {
                    gtnInfo = gtnInstColl.get(j);
                    if (gtnInfo.getId().toString().equals(gradeTargetInfo.getGradeTaskNode().getId().toString())) continue;
                    otherEvalu = new HashMap();
                    key = info.getId().toString() + "$" + gtnInfo.getId().toString();
                    gtargetInfo = hisGradeTargetInstMap.get(key);
                    if (gtargetInfo == null) continue;
                    otherEvalu.put("rejection", gtargetInfo.getIsRejection().getValue() == 1);
                    otherEvalu.put("taskid", gtnInfo.getId().toString());
                    otherEvalu.put("taskrank", gtargetInfo.getGradeRank());
                    otherEvalu.put("taskscore", gtargetInfo.get("targetScore"));
                    otherEvalu.put("weight", Float.valueOf(gtnInfo.getNodeWeight()));
                    otherEvalu.put("nodeHandler", gtnInfo.getNodeHandlerName());
                    otherEvalu.put("nodeName", gtnInfo.getWfNode().getNodeName());
                    otherEvalu.put("indiComment", gtargetInfo.getComment());
                    otherEvalu.put("needScore", gtnInfo.getWfNode().getNeedScore().getValue());
                    otherEvalu.put("nodeHandlerId", gtnInfo.getNodeHandler().getId().toString());
                    Map<String, Object> map = EvaFormUtil.putExtendInfo(ctx, (GradeTargetInstInfo)gtargetInfo);
                    otherEvalu.putAll(map);
                    otherList.add(otherEvalu);
                }
                info.put("otherList", otherList);
            }
            PersonalEvaBaseBean bean = (PersonalEvaBaseBean)indecatorsMap.get("rows");
            ArrayList<EvaAreaListBean> evaAreaList = bean.getEvaAreaList();
            if (!CollectionUtils.isEmpty(evaAreaList)) {
                for (EvaAreaListBean evaAreaListBean : evaAreaList) {
                    GradeTargetInstCollection gradeTargetInstColl1;
                    FilterInfo filter;
                    String gradeTaskNodeId;
                    IndicatorTargetInfo copyTargetInfo;
                    HashMap<String, Object> resultMap = new HashMap<String, Object>();
                    resultMap.put("Area", evaAreaListBean.getAreaName());
                    resultMap.put("canRate", evaAreaListBean.getCanRate());
                    resultMap.put("areaId", evaAreaListBean.getAreaId());
                    resultMap.put("scoreWay", evaAreaListBean.getScoringWay());
                    resultMap.put("weight", evaAreaListBean.getAreaWeight());
                    resultMap.put("showArea", 0);
                    resultMap.put("nodeName", evaAreaListBean.getNodeName());
                    resultMap.put("nodeWeight", evaAreaListBean.getNodeWeight());
                    resultMap.put("nodeHandlerName", evaAreaListBean.getNodeHandlerName());
                    if (evaAreaListBean.getSubAreaType() != null) {
                        resultMap.put("subAreaType", evaAreaListBean.getSubAreaType());
                    } else {
                        resultMap.put("subAreaType", "0");
                    }
                    if (evaAreaListBean.getSubAreaType() != null) {
                        resultMap.put("areaAddSub", evaAreaListBean.getAreaAddSub());
                    } else {
                        resultMap.put("areaAddSub", "0");
                    }
                    if (evaAreaListBean.getSubAreaType() != null) {
                        resultMap.put("targetAddSub", evaAreaListBean.getTargetAddSub());
                    } else {
                        resultMap.put("targetAddSub", "0");
                    }
                    if (evaAreaListBean.getSubAreaType() != null) {
                        resultMap.put("areaAddSubUp", evaAreaListBean.getAreaAddSubUp());
                    } else {
                        resultMap.put("areaAddSubUp", "");
                    }
                    if (evaAreaListBean.getSubAreaType() != null) {
                        resultMap.put("areaAddSubDown", evaAreaListBean.getAreaAddSubDown());
                    } else {
                        resultMap.put("areaAddSubDown", "");
                    }
                    if (evaAreaListBean.getSubAreaType() != null) {
                        resultMap.put("targetAddSubUp", evaAreaListBean.getTargetAddSubUp());
                    } else {
                        resultMap.put("targetAddSubUp", "");
                    }
                    if (evaAreaListBean.getSubAreaType() != null) {
                        resultMap.put("targetAddSubDown", evaAreaListBean.getTargetAddSubDown());
                    } else {
                        resultMap.put("targetAddSubDown", "");
                    }
                    ArrayList<IndicatorTargetInfo> evaAreaTargetList = new ArrayList<IndicatorTargetInfo>();
                    String areaType = evaAreaListBean.getAreaType();
                    if ("200".equals(areaType)) {
                        IEvaFormFieldConf iEvaFormFieldConf = EvaFormFieldConfFactory.getLocalInstance((Context)ctx);
                        for (HashMap hashMap : evaAreaListBean.getEvaIndicatorList()) {
                            for (int i4 = 0; i4 < indeColl.size(); ++i4) {
                                IndicatorTargetInfo indicatorTargetInfo = indeColl.get(i4);
                                if (!hashMap.get("FID").equals(indicatorTargetInfo.getId().toString())) continue;
                                copyTargetInfo = (IndicatorTargetInfo)DeepClone.deepClone((Object)indicatorTargetInfo);
                                gradeTaskNodeId = (String)hashMap.get("nodeTask");
                                GradeTaskNodeInstInfo info2 = GradeTaskNodeInstFactory.getLocalInstance((Context)ctx).getGradeTaskNodeInstInfo("select wfNode.CanVeto where id = '" + gradeTaskNodeId + "'");
                                resultMap.put("canVeto", info2.getWfNode().getCanVeto() == null ? "0" : info2.getWfNode().getCanVeto().getValue());
                                resultMap.put("fieldList", evaAreaListBean.getFieldList());
                                resultMap.put("gradeTaskNode", gradeTaskNodeId);
                                resultMap.put("rema", copyTargetInfo.getAreaBase().getRema());
                                resultMap.put("showArea", 1);
                                resultMap.put("canOverSumRange", copyTargetInfo.getAreaBase().getCanOverSumRange().getValue());
                                resultMap.put("canNegativeScore", copyTargetInfo.getAreaBase().getCanNegativeScore().getValue());
                                resultMap.put("overRange", copyTargetInfo.getAreaBase().getOverRange());
                                filter = new FilterInfo();
                                filter.getFilterItems().add(new FilterItemInfo("areaBase", (Object)copyTargetInfo.getAreaBase().getId().toString(), CompareType.EQUALS));
                                filter.getFilterItems().add(new FilterItemInfo("fieldTemplate", (Object)"PpP9NaiVDD/gU6hCqMD3G5DpHWw=", CompareType.EQUALS));
                                if (iEvaFormFieldConf.exists(filter)) {
                                    resultMap.put("showcomment", 1);
                                } else {
                                    resultMap.put("showcomment", 0);
                                }
                                copyTargetInfo.put("dataValue", (Object)hashMap);
                                copyTargetInfo.put("taskId", hashMap.get("gradeNodeInstId"));
                                copyTargetInfo.put("gradeTaskNode", (Object)gradeTaskNodeId);
                                copyTargetInfo.put("showbox", (Object)false);
                                gradeTargetInstColl1 = GetEntityInfoUtils.getGradeTargetInstCollection(ctx, gradeTaskNodeId, evaObj, indicatorTargetInfo.getId().toString());
                                if (gradeTargetInstColl1 != null && gradeTargetInstColl1.size() > 0) {
                                    GradeTargetInstInfo gradeTargetInfo2 = gradeTargetInstColl1.get(0);
                                    copyTargetInfo.put("taskScore", gradeTargetInfo2.get("targetScore"));
                                    copyTargetInfo.put("taskRank", (Object)(gradeTargetInfo2.getGradeRank() == null ? "" : gradeTargetInfo2.getGradeRank()));
                                    copyTargetInfo.put("comment", (Object)(gradeTargetInfo2.getComment() == null ? "" : gradeTargetInfo2.getComment()));
                                }
                                copyTargetInfo.put("isRejection", (Object)(hashMap.get("isRejection") == null ? 0 : ((YesOrNoEnum)hashMap.get("isRejection")).getValue()));
                                Map<String, Object> extendInfoMap2 = EvaFormUtil.putExtendInfo(ctx, (GradeTargetInstInfo)gradeTargetMap.get(indicatorTargetInfo.getId().toString()));
                                for (String extendKey : extendInfoMap2.keySet()) {
                                    copyTargetInfo.put(extendKey, extendInfoMap2.get(extendKey) == null ? "" : extendInfoMap2.get(extendKey));
                                }
                                evaAreaTargetList.add(copyTargetInfo);
                            }
                        }
                    } else if ("300".equals(areaType)) {
                        IRecordFieldConf iRecordFieldConf = RecordFieldConfFactory.getLocalInstance((Context)ctx);
                        for (HashMap hashMap : evaAreaListBean.getEvaRecordList()) {
                            for (int i5 = 0; i5 < recordColl.size(); ++i5) {
                                RecordTargetInfo recordTargetInfo = recordColl.get(i5);
                                if (!hashMap.get("FID").equals(recordTargetInfo.getId().toString())) continue;
                                copyTargetInfo = (RecordTargetInfo)DeepClone.deepClone((Object)recordTargetInfo);
                                gradeTaskNodeId = (String)hashMap.get("nodeTask");
                                resultMap.put("fieldList", evaAreaListBean.getFieldList());
                                resultMap.put("gradeTaskNode", gradeTaskNodeId);
                                GradeTaskNodeInstInfo info2 = GradeTaskNodeInstFactory.getLocalInstance((Context)ctx).getGradeTaskNodeInstInfo("select wfNode.CanVeto where id = '" + gradeTaskNodeId + "'");
                                resultMap.put("canVeto", info2.getWfNode().getCanVeto() == null ? "0" : info2.getWfNode().getCanVeto().getValue());
                                resultMap.put("rema", copyTargetInfo.getAreaBase().getRema());
                                resultMap.put("showArea", 1);
                                resultMap.put("canOverSumRange", copyTargetInfo.getAreaBase().getCanOverSumRange().getValue());
                                resultMap.put("canNegativeScore", copyTargetInfo.getAreaBase().getCanNegativeScore().getValue());
                                resultMap.put("overRange", copyTargetInfo.getAreaBase().getOverRange());
                                filter = new FilterInfo();
                                filter.getFilterItems().add(new FilterItemInfo("areaBase", (Object)copyTargetInfo.getAreaBase().getId().toString(), CompareType.EQUALS));
                                filter.getFilterItems().add(new FilterItemInfo("fieldTemplate", (Object)"PpP9NaijDD/gU6hCqMD3G5DpHWw=", CompareType.EQUALS));
                                if (iRecordFieldConf.exists(filter)) {
                                    resultMap.put("showcomment", 1);
                                } else {
                                    resultMap.put("showcomment", 0);
                                }
                                copyTargetInfo.put("dataValue", (Object)hashMap);
                                copyTargetInfo.put("taskId", hashMap.get("gradeNodeInstId"));
                                copyTargetInfo.put("gradeTaskNode", (Object)gradeTaskNodeId);
                                copyTargetInfo.put("showbox", (Object)false);
                                gradeTargetInstColl1 = GetEntityInfoUtils.getGradeTargetInstCollection(ctx, gradeTaskNodeId, evaObj, recordTargetInfo.getId().toString());
                                if (gradeTargetInstColl1 != null && gradeTargetInstColl1.size() > 0) {
                                    GradeTargetInstInfo gradeTargetInfo2 = gradeTargetInstColl1.get(0);
                                    copyTargetInfo.put("taskScore", gradeTargetInfo2.get("targetScore"));
                                    copyTargetInfo.put("taskRank", (Object)(gradeTargetInfo2.getGradeRank() == null ? "" : gradeTargetInfo2.getGradeRank()));
                                    copyTargetInfo.put("comment", (Object)(gradeTargetInfo2.getComment() == null ? "" : gradeTargetInfo2.getComment()));
                                }
                                copyTargetInfo.put("isRejection", (Object)(hashMap.get("isRejection") == null ? 0 : ((YesOrNoEnum)hashMap.get("isRejection")).getValue()));
                                Map<String, Object> extendInfoMap = EvaFormUtil.putExtendInfo(ctx, (GradeTargetInstInfo)gradeTargetMap.get(recordTargetInfo.getId().toString()));
                                for (String extendKey : extendInfoMap.keySet()) {
                                    copyTargetInfo.put(extendKey, extendInfoMap.get(extendKey) == null ? "" : extendInfoMap.get(extendKey));
                                }
                                evaAreaTargetList.add(copyTargetInfo);
                            }
                        }
                    }
                    resultMap.put("data", evaAreaTargetList);
                    resultMap.put("needScore", "1");
                    String gradeTaskNodeId2 = (String)resultMap.get("gradeTaskNode");
                    if (!StringUtils.isEmpty((CharSequence)gradeTaskNodeId2)) {
                        EntityViewInfo viewInfo = new EntityViewInfo();
                        SelectorItemCollection selectorItemCollection = viewInfo.getSelector();
                        selectorItemCollection.add("wfNode.needScore");
                        selectorItemCollection.add("wfNode.targetComment");
                        FilterInfo filter2 = new FilterInfo();
                        filter2.getFilterItems().add(new FilterItemInfo("id", (Object)gradeTaskNodeId2));
                        viewInfo.setFilter(filter2);
                        IGradeTaskNodeInst iGradeTaskNodeInst = GradeTaskNodeInstFactory.getLocalInstance((Context)ctx);
                        GradeTaskNodeInstCollection gradeTaskNodeColl = iGradeTaskNodeInst.getGradeTaskNodeInstCollection(viewInfo);
                        if (!gradeTaskNodeColl.isEmpty() && gradeTaskNodeColl.size() > 0) {
                            resultMap.put("needScore", gradeTaskNodeColl.get(0).getWfNode().get("needScore"));
                            resultMap.put("targetComment", gradeTaskNodeColl.get(0).getWfNode().getTargetComment().getValue());
                        }
                    }
                    result.add(resultMap);
                }
            }
        }
        return result;
    }

    public GradeTargetInstCollection gerGradeTargetInstColl(Context ctx, PerfEvaObjectInfo evaObjInfo) throws BOSException, EASBizException {
        HashSet<String> gtNodeSet = new HashSet<String>(4);
        UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserByID(ctx.getCaller());
        GradeTaskNodeInstCollection gradeNodeInstColl = GetEntityInfoUtils.getGradeTaskNodeInstCollectionByNodeHandler(ctx, evaObjInfo.getId().toString(), userInfo.getPerson().getId().toString(), "1");
        for (int m = 0; m < gradeNodeInstColl.size(); ++m) {
            gtNodeSet.add(gradeNodeInstColl.get(m).getId().toString());
        }
        FilterInfo gtInstFilter = new FilterInfo();
        gtInstFilter.getFilterItems().add(new FilterItemInfo("gradeTaskNode", gtNodeSet, CompareType.INCLUDE));
        gtInstFilter.getFilterItems().add(new FilterItemInfo("evaObj", (Object)evaObjInfo.getId().toString(), CompareType.EQUALS));
        EntityViewInfo gtInstViewInfo = new EntityViewInfo();
        gtInstViewInfo.setFilter(gtInstFilter);
        return GradeTargetInstFactory.getLocalInstance((Context)ctx).getGradeTargetInstCollection(gtInstViewInfo);
    }

    public Map<String, GradeTargetInstInfo> getHisGradeTargetInstMap(Context ctx, Set<String> gtnIdset) throws BOSException {
        HashMap<String, GradeTargetInstInfo> result = new HashMap<String, GradeTargetInstInfo>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("gradeTaskNode.id", gtnIdset, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("gradeTaskNode.taskStatus", (Object)"2", CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SorterItemCollection sorter = viewInfo.getSorter();
        sorter.add(new SorterItemInfo("areaBase.seq"));
        sorter.add(new SorterItemInfo("createTime"));
        GradeTargetInstCollection coll = GradeTargetInstFactory.getLocalInstance((Context)ctx).getGradeTargetInstCollection(viewInfo);
        for (int i = 0; i < coll.size(); ++i) {
            result.put(coll.get(i).getTarget() + "$" + coll.get(i).getGradeTaskNode().getId().toString(), coll.get(i));
        }
        return result;
    }
}

