/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.OsfUtils;
import com.kingdee.shr.perfweb.util.PerfDbUtil;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetMyEvaluatedScoreDataService
implements IHRMsfService {
    private static Logger logger = LoggerFactory.getLogger((String)GetMyEvaluatedScoreDataService.class.getName());

    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        HashMap<String, Object> result = new HashMap<String, Object>();
        OsfUtils.requirePagingParams(ctx, param, result);
        if (result != null && result.size() > 0) {
            return result;
        }
        String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
        StringBuilder lastSqlSb = new StringBuilder("select t.FID AS gradeTaskNode ,t.FNODESUMSCORE AS nodeSumScore,t.FNODEGRADE AS nodeGrade,b.FNAME" + mlFlag + " AS positionName,o.FADMINORGUNITID AS admionOrg,");
        lastSqlSb.append("a.FNAME").append(mlFlag).append(" AS adminOrgName, person.fname").append(mlFlag).append(" AS evaobjName,n.fname").append(mlFlag).append(" AS planName,p.FPSTARTDATE ,").append("p.FPENDDATE,m.fname as modelName,o.FID AS evaObj,person.FNUMBER AS pnumber,f.FPERSONID AS personId ,wfnode.FNeedScore as needScore ").append(" ,wfnode.FPerfGradeEvaluate  as perfGradeEvaluate ").append("from T_EVA_GradeTaskNodeInst t left join T_EVA_PerfPeriod p on t.FPERIODID=p.fid ").append("left join T_EVA_PERFPLAN n on p.FPERFPLAN =n.fid ").append("left join T_EVA_PerformanceRule r on p.FPERFRULEID =r.FID ").append("left join T_PEF_PerfModel m on r.FEVALUMODEID =m.FID ").append("left join T_EVA_PerfEvaobject o on t.FEVAOBJID =o.FID ").append("left join T_EVA_PerfFile f on o.FPERFFILEID =f.FID ").append("left join T_BD_Person person on f.fpersonid =person.FID ").append("left join T_ORG_Position b on f.FPOSITIONID =b.fid ").append("left join T_ORG_ADMIN a on f.FADMINORGUNITID =a.fid ").append("left join T_EVA_WFNodeDef wfnode on t.FWfNodeID =wfnode.fid ").append("where t.FNODEHANDLERID = ?").append(" and t.FScoreStatus='").append("2").append("' and t.FIsEndProcess=").append(0).append(" and n.FIsorg='").append(0).append("' and t.FConcurrentNodeStatus=").append(1);
        String number = (String)param.get("number");
        String adminOrg = (String)param.get("adminOrg");
        String evaObjName = (String)param.get("evaObjName");
        String belongOrgId = (String)param.get("belongOrgId");
        String perfPlanId = (String)param.get("perfPlanId");
        String periodId = (String)param.get("periodId");
        ArrayList<String> params = new ArrayList<String>();
        params.add(personId);
        if (!StringUtils.isEmpty((CharSequence)evaObjName)) {
            params.add("%" + evaObjName + "%");
            lastSqlSb.append(" and( (o.fname").append(mlFlag).append(" like ?)");
        }
        if (!StringUtils.isEmpty((CharSequence)number)) {
            params.add("%" + number + "%");
            lastSqlSb.append(" or (o.fnumber like ?)");
        }
        if (!StringUtils.isEmpty((CharSequence)adminOrg)) {
            params.add("%" + adminOrg + "%");
            lastSqlSb.append(" or (a.fname").append(mlFlag).append(" like ?))");
        }
        if (!StringUtils.isEmpty((CharSequence)belongOrgId)) {
            params.add(belongOrgId);
            lastSqlSb.append(" and a.FID = ?");
        }
        if (!StringUtils.isEmpty((CharSequence)perfPlanId)) {
            params.add(perfPlanId);
            lastSqlSb.append(" and n.FID  = ?");
        }
        if (!StringUtils.isEmpty((CharSequence)periodId)) {
            params.add(periodId);
            lastSqlSb.append(" and p. FID  = ?");
        }
        lastSqlSb.append(" order by t.FHANDLETIME desc");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)lastSqlSb.toString(), (Object[])params.toArray());
        int totalCount = rowSet.size();
        int rows = (Integer)param.get("rows");
        int page = (Integer)param.get("page");
        int length = rows;
        if (page * rows > totalCount) {
            length = totalCount - (page - 1) * rows;
        }
        IRowSet dataSet = PerfDbUtil.executeQuery(ctx, lastSqlSb.toString(), (page - 1) * rows, length, params.toArray());
        LinkedList data = new LinkedList();
        try {
            while (dataSet.next()) {
                HashMap<String, String> rowMap = new HashMap<String, String>();
                rowMap.put("gradeTaskNode", dataSet.getString("gradeTaskNode"));
                rowMap.put("positionName", dataSet.getString("positionName"));
                rowMap.put("admionOrg", dataSet.getString("admionOrg"));
                rowMap.put("adminOrgName", dataSet.getString("adminOrgName"));
                rowMap.put("evaobjName", dataSet.getString("evaobjName"));
                rowMap.put("planName", dataSet.getString("planName"));
                rowMap.put("FPSTARTDATE", dataSet.getString("FPSTARTDATE"));
                rowMap.put("FPENDDATE", dataSet.getString("FPENDDATE"));
                rowMap.put("modelName", dataSet.getString("modelName"));
                rowMap.put("evaObj", dataSet.getString("evaObj"));
                rowMap.put("pnumber", dataSet.getString("pnumber"));
                rowMap.put("personId", dataSet.getString("personId"));
                rowMap.put("perfPlanName", dataSet.getString("planName"));
                rowMap.put("needScore", dataSet.getString("needScore"));
                String nodeSumScore = dataSet.getString("nodeSumScore");
                if (null != nodeSumScore) {
                    HashMap<String, String> targrtMap = GetEntityInfoUtils.getCalcNodeSumScore(ctx, dataSet.getString("gradeTaskNode"), dataSet.getString("evaObj"));
                    DecimalFormat df = new DecimalFormat("0.00");
                    if (targrtMap.get("showTarget") != null && targrtMap.get("showTarget").equals("0")) {
                        if (StringUtils.isEmpty((CharSequence)((String)targrtMap.get("sumScore")))) {
                            rowMap.put("nodeSumScore", df.format(new BigDecimal(nodeSumScore)));
                        } else {
                            BigDecimal wholeScore = new BigDecimal(nodeSumScore).subtract(new BigDecimal((String)targrtMap.get("sumScore")));
                            rowMap.put("nodeSumScore", df.format(wholeScore));
                        }
                    } else {
                        rowMap.put("nodeSumScore", df.format(new BigDecimal(nodeSumScore)));
                    }
                } else {
                    rowMap.put("nodeSumScore", "");
                }
                rowMap.put("nodeGrade", dataSet.getString("nodeGrade"));
                String perfGradeEvaluate = dataSet.getString("perfGradeEvaluate");
                if ("0".equals(perfGradeEvaluate)) {
                    rowMap.put("nodeGrade", "");
                }
                rowMap.put("photo", null);
                data.add(rowMap);
            }
            int pages = totalCount % rows == 0 ? totalCount / rows : totalCount / rows + 1;
            result.put("pages", pages);
            result.put("records", totalCount);
            result.put("rows", data);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        return result;
    }
}

