/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsMessageReceiverCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsMessageReceiverFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfEvaObject;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanInfo;
import com.kingdee.shr.perfweb.utils.OrgAssessmentUtils;
import com.kingdee.shr.perfweb.utils.PermitUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetOrgGoalsTransmitListService
implements IHRMsfService {
    private static Logger logger = LoggerFactory.getLogger(GetOrgGoalsTransmitListService.class);

    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        int page = 0;
        int rows = 0;
        if (param.get("page") != null) {
            page = Integer.valueOf((String)param.get("page"));
        }
        if (param.get("rows") != null) {
            rows = Integer.valueOf((String)param.get("rows"));
        }
        IObjectPK userId = ctx.getCaller();
        UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserByID(userId);
        String oql = "where receiver = '" + user.getPerson().getId().toString() + "' and HandleStatus='" + "1" + "' and MsgType='" + "0" + "' and IsSelf=" + 0 + " and person = 'ORG'";
        GoalsMessageReceiverCollection coll = GoalsMessageReceiverFactory.getLocalInstance((Context)ctx).getGoalsMessageReceiverCollection(oql);
        HashSet<String> receiverSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            if (coll.get(i).getEvaObj() == null) continue;
            receiverSet.add(coll.get(i).getEvaObj().getId().toString());
        }
        Map perfColl = this.getEvaObjectList(ctx, receiverSet, page, rows, param);
        return perfColl;
    }

    private Map getEvaObjectList(Context ctx, Set receiverSet, int page, int rows, Map param) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        EntityViewInfo viewInfo = this.getEntityView(ctx, receiverSet, param);
        IPerfEvaObject bizInterface = PerfEvaObjectFactory.getLocalInstance((Context)ctx);
        int totalCount = bizInterface.getCount(viewInfo);
        int length = rows;
        if (page * rows > totalCount) {
            length = totalCount - (page - 1) * rows;
        }
        List perfColl = bizInterface.getPagingList(viewInfo, (page - 1) * rows, length);
        Map<String, String> responsorsMap = OrgAssessmentUtils.getResponsorsMap(ctx, receiverSet);
        for (int i = 0; i < perfColl.size(); ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            PerfEvaObjectInfo info = (PerfEvaObjectInfo)perfColl.get(i);
            map.put("name", info.getName());
            map.put("number", info.getNumber());
            map.put("responsors", MapUtils.getString(responsorsMap, (Object)info.getId().toString()));
            map.put("id", info.getId().toString());
            map.put("date", info.getPeriod().getName());
            map.put("period", info.getPeriod().getId().toString());
            map.put("personalGoalStatus", info.getPersonalGoalStatus().getValue());
            map.put("personalGoalStatusAlias", info.getPersonalGoalStatus().getAlias());
            PerfPlanInfo perfInfo = PerfPlanFactory.getLocalInstance((Context)ctx).getPerfPlanInfo("where id = '" + info.getPeriod().getPerfPlan().getId().toString() + "'");
            map.put("perfPlan", perfInfo.getName());
            result.add(map);
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("data", result);
        map.put("total", Integer.valueOf(totalCount));
        return map;
    }

    private EntityViewInfo getEntityView(Context ctx, Set receiverSet, Map param) {
        SelectorItemCollection sic = new SelectorItemCollection();
        String planName = (String)param.get("planName");
        String name = (String)param.get("name");
        String belongOrgId = (String)param.get("belongOrgId");
        String perfPlanId = (String)param.get("perfPlanId");
        String periodId = (String)param.get("periodId");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)receiverSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("personalGoalStatus", (Object)3, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("unitGoalsStatus", (Object)1, CompareType.EQUALS));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("period.id"));
        sic.add(new SelectorItemInfo("period.name"));
        sic.add(new SelectorItemInfo("period.pStartDate"));
        sic.add(new SelectorItemInfo("period.pEndDate"));
        sic.add(new SelectorItemInfo("period.perfplan.id"));
        sic.add(new SelectorItemInfo("personalGoalStatus"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(sic);
        if (!StringUtils.isEmpty((CharSequence)periodId)) {
            String[] periodIds = periodId.split(",");
            HashSet<String> periodSet = new HashSet<String>();
            periodSet.addAll(Arrays.asList(periodIds));
            filter.getFilterItems().add(new FilterItemInfo("period.id", periodSet, CompareType.INCLUDE));
        }
        if (!StringUtils.isEmpty((CharSequence)belongOrgId)) {
            ArrayList<String> orgList = PermitUtil.getInterSectionOrg(PermitUtil.getCurrentUserOwnOrg(ctx), PermitUtil.getCurAndSubOrg(ctx, belongOrgId));
            HashSet<String> orgSet = new HashSet<String>();
            orgSet.addAll(orgList);
            filter.getFilterItems().add(new FilterItemInfo("evaluOrgAdmin", orgSet, CompareType.INCLUDE));
        }
        if (!StringUtils.isEmpty((CharSequence)perfPlanId)) {
            filter.getFilterItems().add(new FilterItemInfo("period.perfplan.id", (Object)perfPlanId, CompareType.EQUALS));
        }
        if (!StringUtils.isEmpty((CharSequence)name) || !StringUtils.isEmpty((CharSequence)planName)) {
            FilterInfo filter1 = new FilterInfo();
            FilterInfo filter2 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("period.perfplan.name", (Object)("%" + planName + "%"), CompareType.LIKE));
            filter2.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + name + "%"), CompareType.LIKE));
            try {
                filter1.mergeFilter(filter2, "OR");
                filter.mergeFilter(filter1, "and");
            }
            catch (BOSException e) {
                logger.error("merge filter bos err: ", (Throwable)e);
            }
        }
        viewInfo.setFilter(filter);
        SorterItemCollection sorter = viewInfo.getSorter();
        sorter.add(new SorterItemInfo("period.id"));
        sorter.add(new SorterItemInfo("id"));
        return viewInfo;
    }
}

