/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.shr.perfweb.osf.GetPerfPlansService;
import com.kingdee.shr.perfweb.util.PerfDbUtil;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetPerfPeriodsService
implements IHRMsfService {
    private static Logger logger = LoggerFactory.getLogger((String)GetPerfPeriodsService.class.getName());
    private final IHRMsfService ihrMsfService = new GetPerfPlansService();

    public Object process(Context ctx, Map map) throws EASBizException, BOSException {
        String perfPlanId = (String)map.get("perfPlanId");
        String periodName = (String)map.get("periodName");
        HashSet<String> planIds = new HashSet<String>();
        if (StringUtils.isEmpty((CharSequence)perfPlanId)) {
            Map plansMap = (Map)this.ihrMsfService.process(ctx, map);
            if (plansMap != null) {
                List list = (List)plansMap.get("rows");
                for (int i = 0; i < list.size(); ++i) {
                    Map item = (Map)list.get(i);
                    planIds.add(item.get("id").toString());
                }
            }
        } else {
            planIds.add(perfPlanId);
        }
        if (planIds == null) {
            return null;
        }
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        try {
            IRowSet rowSet;
            String baseSQL = GetPerfPeriodsService.getBaseSQL(ctx, planIds, periodName);
            Object[] params = new Object[2];
            if (StringUtils.isEmpty((CharSequence)periodName)) {
                rowSet = DbUtil.executeQuery((Context)ctx, (String)baseSQL);
            } else {
                params[0] = "%" + periodName + "%";
                params[1] = "%" + periodName + "%";
                rowSet = DbUtil.executeQuery((Context)ctx, (String)baseSQL, (Object[])params);
            }
            int totalCount = rowSet.size();
            int rows = (Integer)map.get("rows");
            int page = (Integer)map.get("page");
            int length = rows;
            if (page * rows > totalCount) {
                length = totalCount - (page - 1) * rows;
            }
            IRowSet dataSet = StringUtils.isEmpty((CharSequence)periodName) ? DbUtil.executeQuery((Context)ctx, (String)baseSQL, (int)((page - 1) * rows), (int)length) : PerfDbUtil.executeQuery(ctx, baseSQL, (page - 1) * rows, length, params);
            IRowSetMetaData md = dataSet.getRowSetMetaData();
            LinkedList data = new LinkedList();
            while (dataSet.next()) {
                HashMap<String, Object> rowMap = new HashMap<String, Object>();
                int count = md.getColumnCount();
                for (int i = 1; i <= count; ++i) {
                    String columnName = md.getColumnName(i);
                    Object value = dataSet.getObject(i);
                    rowMap.put(columnName.toLowerCase(), value);
                }
                data.add(rowMap);
            }
            int pages = totalCount % rows == 0 ? totalCount / rows : totalCount / rows + 1;
            result.put("pages", Integer.valueOf(pages));
            result.put("records", Integer.valueOf(totalCount));
            result.put("rows", data);
        }
        catch (SQLException e) {
            logger.error("period query failed", (Throwable)e);
        }
        return result;
    }

    private static String getBaseSQL(Context ctx, Set<String> planIds, String periodName) {
        StringBuffer sb = new StringBuffer();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("FPerfPlan", planIds, CompareType.INCLUDE));
        FilterInfo multiFilter = new FilterInfo();
        multiFilter.getFilterItems().add(new FilterItemInfo("FmultiPerfplanID", planIds, CompareType.INCLUDE));
        String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
        sb.append("SELECT a.id, a.name, a.type FROM (");
        sb.append("SELECT FID AS id, FName" + mlFlag + " AS name, '0' AS type from T_EVA_PerfPeriod period").append(" where ").append(filter.toSql());
        if (!StringUtils.isEmpty((CharSequence)periodName)) {
            sb.append(" and FName" + mlFlag + "  like ? ");
        }
        sb.append(" union ");
        sb.append("SELECT FID AS id, FName" + mlFlag + " AS name, '1' AS type  from T_EVA_MultiPerfPeriod multiPeriod").append(" where ").append(multiFilter.toSql());
        if (!StringUtils.isEmpty((CharSequence)periodName)) {
            sb.append(" and FName" + mlFlag + " like ? ");
        }
        sb.append(") as a ");
        sb.append(" order by type, name");
        return sb.toString();
    }
}

