/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.tool.function.Strings;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.portal.common.util.DateUtil;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiEvaAdminLeaderCollection;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiEvaAdminLeaderFactory;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiEvaAdminLeaderInfo;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.multiEvalution.commontask.utils.QuesServerInstance;
import com.kingdee.shr.perfweb.util.AdminOrgFilterUtil;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.QuesCloudRequestUtil;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiEvaluationScheduleListService
implements IHRMsfService {
    private static Logger logger = LoggerFactory.getLogger((String)MultiEvaluationScheduleListService.class.getName());

    /*
     * WARNING - void declaration
     */
    public Object process(Context ctx, Map map) throws EASBizException, BOSException {
        Map<String, String> quesCloudConfig;
        int rows = (Integer)map.get("rows");
        int page = (Integer)map.get("page");
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.shr.perfweb.app.multiEvalution.commonTask.MultiEvaluInstQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo evi = MultiEvaluationScheduleListService.getEntityView(ctx, map);
        exec.setObjectView(evi);
        exec.option().isIgnoreOrder = true;
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().isIgnorePermissionCheck = false;
        LinkedList data = new LinkedList();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashSet<String> orgObjIds = new HashSet<String>();
        HashMap<String, String> orgObjIdMaps = new HashMap<String, String>();
        try {
            quesCloudConfig = QuesServerInstance.getServerInfo(ctx);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new SHRPerfWebBizException(SHRPerfWebBizException.GETQUESCLOUDSERVERCONFIGERR);
        }
        String baseUrl = quesCloudConfig.get(QuesServerInstance.CLOUD_SERVERURL);
        if (StringUtils.isEmpty((String)baseUrl)) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.REQQUESCLOUDSERVICEERR);
        }
        String avoidLoginUrl = baseUrl + "avoidlogin?shorturl=$1&from=PERFGO";
        try {
            int totalCount = exec.getRowCount();
            int start = (page - 1) * rows;
            IRowSet rowSet = exec.executeQueryForRealPage(start, rows);
            IRowSetMetaData md = rowSet.getRowSetMetaData();
            HashSet<String> taskIds = new HashSet<String>();
            while (rowSet.next()) {
                void var21_27;
                HashMap<String, Object> rowMap = new HashMap<String, Object>();
                boolean bl = true;
                int count = md.getColumnCount();
                while (var21_27 <= count) {
                    String columnName = md.getColumnName((int)var21_27);
                    Object value = rowSet.getObject((int)var21_27);
                    rowMap.put(columnName, value);
                    ++var21_27;
                }
                Date date = (Date)rowMap.get("multiPeriod.pStartDate");
                Date pEndDate = (Date)rowMap.get("multiPeriod.pEndDate");
                String startDate = DateUtil.dateToStr((Date)date, (String)"yyyy-MM-dd");
                String endDate = DateUtil.dateToStr((Date)pEndDate, (String)"yyyy-MM-dd");
                rowMap.remove("multiPeriod.pStartDate");
                rowMap.remove("multiPeriod.pEndDate");
                rowMap.put("multiPeriod.startDate", startDate);
                rowMap.put("multiPeriod.endDate", endDate);
                String shortUrl = (String)rowMap.get("shortUrl");
                if (!StringUtils.isEmpty((String)shortUrl)) {
                    rowMap.put("avoidLoginUrl", avoidLoginUrl.replace("$1", URLEncoder.encode((String)rowMap.get("shortUrl"), "UTF-8")));
                }
                String id = (String)rowMap.get("id");
                String perfEvaObjId = (String)rowMap.get("perfEvaObj.id");
                if (MultiEvaluationScheduleListService.isOrg(map)) {
                    orgObjIds.add(perfEvaObjId);
                }
                taskIds.add(id);
                data.add(rowMap);
            }
            if (taskIds.size() > 0) {
                Set<String> submitteds = null;
                try {
                    submitteds = QuesCloudRequestUtil.getQuestionnaireCommitteds(ctx, taskIds);
                }
                catch (Exception exception) {
                    logger.error("the questionnaire has been submitted for information cloud interface is unusual, failed to get 360 - degree assessment used real-time information, please contact the system administrator analysis!", (Throwable)exception);
                    resultMap.put("errorMsg", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.GETMULTITODODATAASQUESCLOUDSUBMITTEDCOUNTERR, ctx));
                }
                if (submitteds != null) {
                    totalCount -= submitteds.size();
                    Iterator iterator = data.iterator();
                    while (iterator.hasNext()) {
                        Map item = (Map)iterator.next();
                        if (!submitteds.contains(item.get("id"))) continue;
                        iterator.remove();
                    }
                }
            }
            if (orgObjIds.size() > 0) {
                String join = Strings.join((String[])orgObjIds.toArray(new String[orgObjIds.size()]), (String)"','");
                join = " ('" + join + "') ";
                MultiEvaAdminLeaderCollection multiEvaAdminLeaderCollection = MultiEvaAdminLeaderFactory.getLocalInstance((Context)ctx).getMultiEvaAdminLeaderCollection(" select person.name ,evaObj.id where evaObj.id in " + join);
                if (multiEvaAdminLeaderCollection != null && multiEvaAdminLeaderCollection.size() > 0) {
                    for (MultiEvaAdminLeaderInfo next : multiEvaAdminLeaderCollection) {
                        if (next.getEvaObj() == null || next.getPerson() == null) continue;
                        orgObjIdMaps.put(next.getEvaObj().getId().toString(), next.getPerson().getName());
                    }
                }
            }
            for (Map map2 : data) {
                if (!StringUtils.isEmpty((String)((String)orgObjIdMaps.get(map2.get("perfEvaObj.id"))))) {
                    map2.put("responsors", orgObjIdMaps.get(map2.get("perfEvaObj.id")));
                    continue;
                }
                map2.put("responsors", "");
                map2.put("photo", null);
                map2.put("pnumber", map2.get("perfEvaObj.number"));
                map2.put("personId", map2.get("evaPerson.id"));
            }
            int n = totalCount % rows == 0 ? totalCount / rows : totalCount / rows + 1;
            resultMap.put("pages", n);
            resultMap.put("records", totalCount);
            resultMap.put("data", data);
            resultMap.put("getMultiPerfPlanList", null != Class.forName("com.kingdee.shr.perfweb.osf.GetMultiPerfPlanListService"));
        }
        catch (SQLException e) {
            logger.error("360 schedule list get record error", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("360 schedule list shortUrl encode error", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("360 schedule list shortUrl other error", (Throwable)e);
        }
        return resultMap;
    }

    private static EntityViewInfo getEntityView(Context ctx, Map map) throws BOSException {
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        String name = (String)map.get("name");
        String positionName = (String)map.get("positionName");
        String belongOrgId = (String)map.get("belongOrgId");
        String perfPlanId = (String)map.get("perfPlanId");
        String multiPlanName = (String)map.get("multiPlanName");
        String periodId = (String)map.get("periodId");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("receiver", (Object)personId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)"1", CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isEffect", (Object)1, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("perfEvaObj.paperStatus", (Object)"200", CompareType.EQUALS));
        if (!MultiEvaluationScheduleListService.isOrg(map)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("perfEvaObj.isOrg", (Object)0, CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("perfEvaObj.isOrg", (Object)1, CompareType.EQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("multiPeriod.evaPeriodStatus", (Object)200, CompareType.EQUALS));
        if (!(StringUtils.isEmpty((String)name) && StringUtils.isEmpty((String)positionName) && StringUtils.isEmpty((String)multiPlanName))) {
            FilterInfo fastFilter = new FilterInfo();
            fastFilter.getFilterItems().add(new FilterItemInfo("perfEvaObj.name", (Object)("%" + name + "%"), CompareType.LIKE));
            fastFilter.getFilterItems().add(new FilterItemInfo("evaPosition.name", (Object)("%" + positionName + "%"), CompareType.LIKE));
            fastFilter.getFilterItems().add(new FilterItemInfo("multiPlan.name", (Object)("%" + positionName + "%"), CompareType.LIKE));
            fastFilter.setMaskString("#0 OR #1 OR #2");
            filterInfo.mergeFilter(fastFilter, "AND");
        }
        if (!StringUtils.isEmpty((String)perfPlanId)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("multiPlan.id", (Object)perfPlanId, CompareType.EQUALS));
        }
        if (!StringUtils.isEmpty((String)periodId)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("multiPeriod.id", (Object)periodId, CompareType.EQUALS));
        }
        if (!StringUtils.isEmpty((String)belongOrgId)) {
            FilterInfo adminOrgFilter = new FilterInfo();
            adminOrgFilter.getFilterItems().add(new FilterItemInfo("perfEvaObj.adminOrgUnit.id", (Object)AdminOrgFilterUtil.getUserIncludeSubAdminOrgRangeSql(ctx, belongOrgId), CompareType.INNER));
            filterInfo.mergeFilter(adminOrgFilter, "and");
        }
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        try {
            sorterItemCollection.getSorter().decode("order by multiPeriod.PEndDate desc, multiPeriod.PStartDate desc, id");
        }
        catch (ParserException e) {
            logger.error("360 schedule list sortItems error", (Throwable)e);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("perfEvaObj.id"));
        sic.add(new SelectorItemInfo("perfEvaObj.name"));
        sic.add(new SelectorItemInfo("perfEvaObj.number"));
        sic.add(new SelectorItemInfo("multiPeriod.pStartDate"));
        sic.add(new SelectorItemInfo("multiPeriod.pEndDate"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("evaPosition.id"));
        sic.add(new SelectorItemInfo("evaPosition.name"));
        sic.add(new SelectorItemInfo("multiPlan.name"));
        sic.add(new SelectorItemInfo("multiPeriod.name"));
        sic.add(new SelectorItemInfo("shortUrl"));
        sic.add(new SelectorItemInfo("loginKey"));
        sic.add(new SelectorItemInfo("receiverPhone"));
        sic.add(new SelectorItemInfo("receiverEmail"));
        sic.add(new SelectorItemInfo("questionnaierVersion"));
        sic.add(new SelectorItemInfo("relationDetail.questionnaireName"));
        sic.add(new SelectorItemInfo("evaPerson.id"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSelector(sic);
        evi.setSorter(sorterItemCollection);
        return evi;
    }

    private static boolean isOrg(Map map) {
        return map.get("isOrg") != null && map.get("isOrg").toString().equals("1");
    }
}

