/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf.teamPersonalTarget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.metas.ProcInstBizObjCollection;
import com.kingdee.bos.workflow.metas.ProcInstBizObjFactory;
import com.kingdee.bos.workflow.metas.ProcInstBizObjInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectPersonalGoalStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaTargetBackReasonCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaTargetBackReasonFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaTargetBackReasonInfo;
import com.kingdee.shr.perfweb.app.base.targetprocess.TargetTransmitBillCollection;
import com.kingdee.shr.perfweb.app.base.targetprocess.TargetTransmitBillFactory;
import com.kingdee.shr.perfweb.app.base.targetprocess.TargetTransmitBillInfo;
import com.kingdee.shr.perfweb.base.serviceImpl.TargetFillService;
import com.kingdee.shr.perfweb.osf.CommonListHandlerService;
import com.kingdee.shr.perfweb.utils.MapUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class GetPerfMarkingListService
extends CommonListHandlerService {
    TargetFillService targetFillService = new TargetFillService();
    private static Logger logger = LoggerFactory.getLogger(GetPerfMarkingListService.class);

    @Override
    public FilterInfo getDefoFilter(Context ctx, Map param) {
        FilterInfo filter = new FilterInfo();
        try {
            filter = this.targetFillService.getCustomFilter(ctx, param);
            filter.getFilterItems().add(new FilterItemInfo("isOrg", (Object)0, CompareType.EQUALS));
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        return filter;
    }

    @Override
    public FilterInfo getAdvanceFilter(Context ctx, Map param) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        String searchText = MapUtils.getParam(param, "searchText");
        String belongOrgId = MapUtils.getParam(param, "belongOrgId");
        String perfPlanId = MapUtils.getParam(param, "perfPlanId");
        String periodId = MapUtils.getParam(param, "periodId");
        if (!StringUtils.isEmpty((CharSequence)searchText)) {
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("position.name", (Object)("%" + searchText + "%"), CompareType.LIKE));
            filter1.getFilterItems().add(new FilterItemInfo("person.name", (Object)("%" + searchText + "%"), CompareType.LIKE));
            filter1.setMaskString("(#0 or #1)");
            filter.mergeFilter(filter1, "and");
        }
        if (!StringUtils.isEmpty((CharSequence)belongOrgId)) {
            filter.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", (Object)belongOrgId, CompareType.EQUALS));
        }
        if (!StringUtils.isEmpty((CharSequence)perfPlanId)) {
            filter.getFilterItems().add(new FilterItemInfo("perfPlan.id", (Object)perfPlanId, CompareType.EQUALS));
        }
        if (!StringUtils.isEmpty((CharSequence)periodId)) {
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)periodId, CompareType.EQUALS));
        }
        return filter;
    }

    @Override
    public void afterGetListData(Context ctx, List list) {
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        this.targetFillService.afterGetListData(list, ctx);
        HashSet<String> evaObjIds = new HashSet<String>(list.size());
        for (Object curObj : list) {
            Map curMap = (Map)curObj;
            evaObjIds.add((String)curMap.get("id"));
        }
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("evaObj.id", evaObjIds, CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = viewInfo.getSelector();
            sic.add(new SelectorItemInfo("evaObj.id"));
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("creator.name"));
            SorterItemCollection sorter = viewInfo.getSorter();
            sorter.add(new SorterItemInfo("evaObj.id"));
            SorterItemInfo createTimeSort = new SorterItemInfo("createTime");
            createTimeSort.setSortType(SortType.DESCEND);
            sorter.add(createTimeSort);
            PerfEvaTargetBackReasonCollection backReasonCollection = PerfEvaTargetBackReasonFactory.getLocalInstance((Context)ctx).getPerfEvaTargetBackReasonCollection(viewInfo);
            if (backReasonCollection != null && backReasonCollection.size() > 0) {
                for (Object curObj : list) {
                    Map curMap = (Map)curObj;
                    for (int i = 0; i < backReasonCollection.size(); ++i) {
                        PerfEvaTargetBackReasonInfo backReasonInfo = backReasonCollection.get(i);
                        if (!backReasonInfo.getEvaObj().getId().toString().equals(curMap.get("id"))) continue;
                        ArrayList backReasonList = (ArrayList)curMap.get("backReasonList");
                        if (backReasonList == null) {
                            backReasonList = new ArrayList();
                        }
                        HashMap<String, Object> backReasonMap = new HashMap<String, Object>();
                        backReasonMap.put("backReason", backReasonInfo.getReason());
                        backReasonMap.put("backPerson", backReasonInfo.getCreator().getName());
                        backReasonMap.put("backTime", backReasonInfo.getCreateTime());
                        backReasonList.add(backReasonMap);
                        curMap.put("backReasonList", backReasonList);
                    }
                }
            }
            this.assembleTransmitBillInfo(ctx, list, evaObjIds);
        }
        catch (BOSException e) {
            logger.error("get backReasonInfo error: ", (Throwable)e);
        }
    }

    private void assembleTransmitBillInfo(Context ctx, List list, Set<String> evaObjIds) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaObj.id", evaObjIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)"3,4", CompareType.NOTINCLUDE));
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("evaObj.id"));
        viewInfo.setFilter(filter);
        TargetTransmitBillCollection targetTransmitBillCollection = TargetTransmitBillFactory.getLocalInstance((Context)ctx).getTargetTransmitBillCollection(viewInfo);
        if (targetTransmitBillCollection != null && targetTransmitBillCollection.size() > 0) {
            ProcInstBizObjInfo procInstBizObjInfo;
            HashMap<String, String> targetTransmitBillMap = new HashMap<String, String>();
            int len = targetTransmitBillCollection.size();
            for (int i = 0; i < len; ++i) {
                TargetTransmitBillInfo targetTransmitBillInfo = targetTransmitBillCollection.get(i);
                targetTransmitBillMap.put(targetTransmitBillInfo.getEvaObj().getId().toString(), targetTransmitBillInfo.getId().toString());
            }
            viewInfo = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bizObjID", (Object)StringUtils.join(targetTransmitBillMap.values(), (String)","), CompareType.INCLUDE));
            sic = viewInfo.getSelector();
            sic.add(new SelectorItemInfo("procInstID"));
            sic.add(new SelectorItemInfo("bizObjID"));
            viewInfo.setFilter(filter);
            ProcInstBizObjCollection procInstBizObjCollection = ProcInstBizObjFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
            if (procInstBizObjCollection != null && procInstBizObjCollection.size() > 0 && (procInstBizObjInfo = procInstBizObjCollection.get(0)).getProcInstID() != null) {
                targetTransmitBillMap.put(procInstBizObjInfo.getBizObjID().toString(), procInstBizObjInfo.getProcInstID().toString());
            }
            for (Object curObj : list) {
                Map curMap = (Map)curObj;
                String evaObj = (String)curMap.get("id");
                String targetTransmitBillId = (String)targetTransmitBillMap.get(evaObj);
                if (!StringUtils.isNotEmpty((CharSequence)targetTransmitBillId)) continue;
                curMap.put("transmitBillId", targetTransmitBillId);
                curMap.put("fprocinstid", targetTransmitBillMap.get(targetTransmitBillId));
            }
        }
    }

    @Override
    public void afterResultData(Context ctx, Map<String, Object> reMap) {
        ArrayList data = (ArrayList)reMap.get("data");
        int size = data.size();
        for (int i = 0; i < size; ++i) {
            HashMap map = (HashMap)data.get(i);
            map.put("personalGoalStatusAlias", PerfEvaObjectPersonalGoalStatusEnum.getEnum((int)((Integer)map.get("personalGoalStatus"))).getAlias());
            map.put("photo", null);
        }
    }
}

