/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.portal.serviceImpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.DeepClone;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.TargetEvaluModeEnum;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.IEvaluFormAreaBase;
import com.kingdee.shr.perfweb.app.base.evalrule.PWorkFlowDefFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.PWorkFlowDefInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.SubAreaTypeEnum;
import com.kingdee.shr.perfweb.app.base.perfmancescore.IPerfScore;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScoreFactory;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScoreInfo;
import com.kingdee.shr.perfweb.app.common.YesOrNoEnum;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.shr.perfweb.app.workflow.AreaInstCollection;
import com.kingdee.shr.perfweb.app.workflow.AreaInstFactory;
import com.kingdee.shr.perfweb.app.workflow.AreaInstInfo;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstCollection;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstFactory;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstInfo;
import com.kingdee.shr.perfweb.app.workflow.IAreaInst;
import com.kingdee.shr.perfweb.app.workflow.IGradeTaskNodeInst;
import com.kingdee.shr.perfweb.exception.SHRPerfWebException;
import com.kingdee.shr.perfweb.portal.bean.AreaFieldBean;
import com.kingdee.shr.perfweb.portal.bean.EvaAreaListBean;
import com.kingdee.shr.perfweb.portal.bean.PersonalEvaBaseBean;
import com.kingdee.shr.perfweb.portal.serviceImpl.AbstractAreaTypeBaseService;
import com.kingdee.shr.perfweb.portal.serviceImpl.AreaTypeServiceFactory;
import com.kingdee.shr.perfweb.portal.serviceImpl.PerfGoasFillService;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.PerfPortalUtils;
import java.io.IOException;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class AbstractPerfScoreService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPerfScoreService.class);
    public static final String FILL_TARGET = "0";
    public static final String FILL_SCORE = "1";
    public static final String VIEW_SCORE = "2";
    public static final String MY_HISTORY = "3";
    public static final String VIEW_FORM = "4";

    public Map<String, Object> compositeEvaObjectData(Context ctx, Map<String, Object> parames) throws SHRPerfWebException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String evaObj = (String)parames.get("evaObj");
            String refAreaType = (String)parames.get("areaType");
            String gradeTaskNode = (String)parames.get("gradeTaskNode");
            if (StringUtils.isEmpty((CharSequence)evaObj) || !PerfEvaObjectFactory.getLocalInstance((Context)ctx).exists("where id='" + evaObj + "'")) {
                return new HashMap<String, Object>();
            }
            PerfEvaObjectInfo evaObjectInfo = GetEntityInfoUtils.getPerfEvaObjectInfo(ctx, evaObj);
            PerfPeriodInfo periodInfo = PerfPeriodFactory.getLocalInstance((Context)ctx).getPerfPeriodInfo(" select *,perfPlan.perfModel.*,perfPlan.*,perfRule.*,perfRule.pariMutual.*,perfRule.scoreRate.* where id='" + evaObjectInfo.getPeriod().getId().toString() + "' ");
            PerfPlanInfo planInfo = periodInfo.getPerfPlan();
            PerformanceRuleInfo ruleInfo = periodInfo.getPerfRule();
            gradeTaskNode = this.getGradeTaskNode(ctx, evaObj, gradeTaskNode);
            UserInfo userInfo = this.getUserInfo(ctx, gradeTaskNode);
            PersonalEvaBaseBean personEvaBaseBean = this.initResult(ctx, result, periodInfo, evaObjectInfo);
            String areaQuerySql = this.buildAreaQuerySql(ctx, gradeTaskNode, evaObj, userInfo.getPerson().getId().toString(), ruleInfo.getId().toString(), refAreaType, evaObjectInfo);
            Map<String, ArrayList<EvaAreaListBean>> areaTypeToAreaBaseInfoMap = this.getEvaAreaListAndSetAreaBaseList(ctx, areaQuerySql, result, personEvaBaseBean);
            for (String areaType : areaTypeToAreaBaseInfoMap.keySet()) {
                ArrayList<EvaAreaListBean> evaAreaList;
                ArrayList<EvaAreaListBean> evaAreaBeanList = areaTypeToAreaBaseInfoMap.get(areaType);
                AbstractAreaTypeBaseService areaTypeService = AreaTypeServiceFactory.getAreaTypeService(areaType);
                if (areaTypeService == null) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("current areaType get bean is null: " + areaType);
                    continue;
                }
                areaTypeService.packageFiledListWithEvaAreaBeans(ctx, evaAreaBeanList);
                for (EvaAreaListBean evaAreaBean : evaAreaBeanList) {
                    ArrayList<AreaFieldBean> fieldList = evaAreaBean.getFieldList();
                    String personId = userInfo.getPerson().getId().toString();
                    IRowSet rowSet = this.executeTargetQuerySql(ctx, planInfo.getIsShowQuantity(), areaType, fieldList, evaObj, evaAreaBean.getAreaId(), personId);
                    evaAreaBean.setGradeTaskNodeId(gradeTaskNode);
                    this.packageTargetDetailInfo(ctx, rowSet, evaAreaBean, gradeTaskNode, personId, evaObjectInfo);
                }
                this.getAreaSumScore(ctx, gradeTaskNode, evaObj, evaAreaBeanList);
                List<EvaAreaListBean> returnList = this.setNodeInfoToEvaArea(ctx, evaAreaBeanList, gradeTaskNode, areaTypeService.getTargetTableName());
                if (!CollectionUtils.isEmpty(returnList)) {
                    evaAreaList = personEvaBaseBean.getEvaAreaList();
                    if (CollectionUtils.isEmpty(evaAreaList)) {
                        evaAreaList = new ArrayList();
                    }
                    evaAreaList.addAll(returnList);
                    evaAreaList.sort(Comparator.comparing(EvaAreaListBean::getNodeName));
                    personEvaBaseBean.setEvaAreaList(evaAreaList);
                    continue;
                }
                evaAreaList = personEvaBaseBean.getEvaAreaList();
                if (CollectionUtils.isEmpty(evaAreaList)) {
                    evaAreaList = new ArrayList();
                }
                evaAreaList.addAll(evaAreaBeanList);
                personEvaBaseBean.setEvaAreaList(evaAreaList);
            }
            this.setNeedScore(ctx, result, gradeTaskNode);
            this.dealFillTargetInfo(ctx, result, evaObjectInfo, periodInfo);
            return result;
        }
        catch (SHRPerfWebException e) {
            logger.error("\u3010PERFWEB\u3011- perfScoreFill compositeEvaObjectData fail!", (Throwable)e);
            throw new SHRPerfWebException(e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB\u3011- perfScoreFill compositeEvaObjectData fail!", (Throwable)e);
            throw new SHRPerfWebException(new SHRPerfWebBizException(SHRPerfWebBizException.GETBILLFAIL, new Object[]{e.getMessage()}).getMessage());
        }
    }

    protected String buildAreaQuerySql(Context ctx, String gradeTaskNode, String evaObj, String personId, String ruleId, String refAreaType, PerfEvaObjectInfo evaObjectInfo) throws SQLException, BOSException {
        String areaQuerySql = evaObjectInfo.getCanAdjustEvaluer() == TargetEvaluModeEnum.MATRIX ? this.buildAreaQuerySql(ctx, gradeTaskNode, evaObj, personId, ruleId) : (StringUtils.isNotEmpty((CharSequence)refAreaType) ? "where performanceRule='" + ruleId + "' and areaType = '" + refAreaType + "' order by Seq ASC" : "where performanceRule='" + ruleId + "' order by Seq ASC");
        return areaQuerySql;
    }

    protected UserInfo getUserInfo(Context ctx, String gradeTaskNode) throws EASBizException, BOSException {
        return new PerfGoasFillService().getUserInfo(ctx);
    }

    private String getGradeTaskNode(Context ctx, String evaObj, String gradeTaskNode) {
        if (!StringUtils.isEmpty((CharSequence)gradeTaskNode)) {
            return gradeTaskNode;
        }
        return GetEntityInfoUtils.getLastCommittedGradeTaskNodeIdByEvaObj(ctx, evaObj);
    }

    protected void setNeedScore(Context ctx, Map<String, Object> result, String gradeTaskNode) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add("wfNode.needScore");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)gradeTaskNode));
        viewInfo.setFilter(filter);
        IGradeTaskNodeInst iGradeTaskNodeInst = GradeTaskNodeInstFactory.getLocalInstance((Context)ctx);
        GradeTaskNodeInstCollection gradeTaskNodeColl = iGradeTaskNodeInst.getGradeTaskNodeInstCollection(viewInfo);
        if (!gradeTaskNodeColl.isEmpty() && gradeTaskNodeColl.size() > 0) {
            result.put("needScore", gradeTaskNodeColl.get(0).getWfNode().get("needScore"));
        } else {
            result.put("needScore", FILL_SCORE);
        }
    }

    private PersonalEvaBaseBean initResult(Context ctx, Map<String, Object> result, PerfPeriodInfo periodInfo, PerfEvaObjectInfo evaObjectInfo) {
        PerformanceRuleInfo perfRule = periodInfo.getPerfRule();
        String scoreOrRate = FILL_TARGET;
        if (perfRule.getPariMutual() == null || null == perfRule.getPariMutual().getId()) {
            scoreOrRate = FILL_SCORE;
        }
        result.put("scoreOrRate", scoreOrRate);
        if (perfRule.getScoringWay() != null) {
            result.put("scoringWay", perfRule.getScoringWay().getValue());
            if (null != perfRule.getPariMutual()) {
                result.put("maxScore", perfRule.getPariMutual().getMax().setScale(2, RoundingMode.HALF_UP));
            }
        } else {
            result.put("scoringWay", 0);
        }
        PersonalEvaBaseBean personEvaBaseBean = this.packagePersonalEvaBaseBean(ctx, periodInfo, evaObjectInfo);
        result.put("rows", personEvaBaseBean);
        return personEvaBaseBean;
    }

    protected void getAreaSumScore(Context ctx, String gradeTaskNode, String evaObj, ArrayList<EvaAreaListBean> evaAreaBeanList) {
        try {
            String areaBaseIdStr = evaAreaBeanList.stream().map(evaAreaBean -> "'" + evaAreaBean.getAreaId() + "'").collect(Collectors.joining(","));
            IAreaInst iareaInst = AreaInstFactory.getLocalInstance((Context)ctx);
            AreaInstCollection areaInstColl = iareaInst.getAreaInstCollection(" where gradeNodeInst='" + gradeTaskNode + "' and evaObj='" + evaObj + "' and areaBase in (" + areaBaseIdStr + ")");
            if (areaInstColl != null && areaInstColl.size() > 0) {
                for (int i = 0; i < areaInstColl.size(); ++i) {
                    AreaInstInfo areaInstInfo = areaInstColl.get(i);
                    evaAreaBeanList.forEach(evaAreaBean -> {
                        if (evaAreaBean.getAreaId().equals(areaInstInfo.getAreaBase().getId().toString())) {
                            evaAreaBean.setAreaSumScore(String.valueOf(areaInstInfo.getAreaSumScore()));
                        }
                    });
                }
            }
        }
        catch (BOSException e) {
            logger.error("get AreaInstCollection error: ", (Throwable)e);
        }
    }

    private Map<String, ArrayList<EvaAreaListBean>> getEvaAreaListAndSetAreaBaseList(Context ctx, String areaQuerySql, Map<String, Object> result, PersonalEvaBaseBean personEvaBaseBean) throws SHRPerfWebException {
        HashMap<String, ArrayList<EvaAreaListBean>> returnMap = new HashMap<String, ArrayList<EvaAreaListBean>>();
        try {
            IEvaluFormAreaBase iEvaFABase = EvaluFormAreaBaseFactory.getLocalInstance((Context)ctx);
            EvaluFormAreaBaseCollection evaFormABColl = iEvaFABase.getEvaluFormAreaBaseCollection(areaQuerySql);
            ArrayList<EvaAreaListBean> recordAreaList = new ArrayList<EvaAreaListBean>();
            ArrayList<EvaAreaListBean> evaFormAreaList = new ArrayList<EvaAreaListBean>();
            ArrayList<EvaluFormAreaBaseInfo> areaBaseList = new ArrayList<EvaluFormAreaBaseInfo>();
            if (evaFormABColl != null && evaFormABColl.size() > 0) {
                for (int i = 0; i < evaFormABColl.size(); ++i) {
                    areaBaseList.add(evaFormABColl.get(i));
                    EvaAreaListBean evaAreaBean = new EvaAreaListBean();
                    evaAreaBean.setScoreOrRate((String)result.get("scoreOrRate"));
                    EvaluFormAreaBaseInfo evaFABaseInfo = evaFormABColl.get(i);
                    evaAreaBean.setAreaId(evaFABaseInfo.getId().toString());
                    String areaType = evaFABaseInfo.getAreaType().getValue();
                    evaAreaBean.setRema(evaFABaseInfo.getRema());
                    evaAreaBean.setAreaType(areaType);
                    if ("200".equalsIgnoreCase(areaType) && evaFABaseInfo.getSubAreaType().equals((Object)SubAreaTypeEnum.ADDSUB)) {
                        evaAreaBean.setSubAreaType(evaFABaseInfo.getSubAreaType().getValue());
                        evaAreaBean.setAreaAddSub(evaFABaseInfo.getAreaAddSub().getValue() + "");
                        evaAreaBean.setTargetAddSub(evaFABaseInfo.getTargetAddSub().getValue() + "");
                        evaAreaBean.setAreaAddSubUp(evaFABaseInfo.getAreaAddSubUp());
                        evaAreaBean.setAreaAddSubDown(evaFABaseInfo.getAreaAddSubDown());
                        evaAreaBean.setTargetAddSubUp(evaFABaseInfo.getTargetAddSubUp());
                        evaAreaBean.setTargetAddSubDown(evaFABaseInfo.getTargetAddSubDown());
                    }
                    evaAreaBean.setAreaName(evaFABaseInfo.getName());
                    evaAreaBean.setSumScoreRule(evaFABaseInfo.getSumScoreRule().getValue());
                    evaAreaBean.setWeightControl(String.valueOf(evaFABaseInfo.getWeightControl().getValue()));
                    evaAreaBean.setCanRate(evaFABaseInfo.getCanRate().getValue());
                    if (evaFABaseInfo.getSubAreaType() != null) {
                        evaAreaBean.setSubAreaType(evaFABaseInfo.getSubAreaType().getValue());
                    }
                    evaAreaBean.setAreaControlWeight(evaFABaseInfo.getAreaWeight());
                    if (result.get("scoringWay") != null && StringUtils.isNotBlank((CharSequence)result.get("scoringWay").toString())) {
                        evaAreaBean.setScoringWay(Integer.parseInt(result.get("scoringWay").toString()));
                    } else {
                        evaAreaBean.setScoringWay(0);
                    }
                    evaAreaBean.setRelatedAreaId(evaFABaseInfo.getRelatedAreaId());
                    if ("300".equals(areaType)) {
                        recordAreaList.add(evaAreaBean);
                        continue;
                    }
                    if (!"200".equals(areaType)) continue;
                    evaFormAreaList.add(evaAreaBean);
                }
            }
            returnMap.put("200", evaFormAreaList);
            returnMap.put("300", recordAreaList);
            result.put("areaBaseList", areaBaseList);
        }
        catch (BOSException e) {
            logger.error("AbstractPerfScoreFillService.getEvaAreaListAndSetAreaBaseList is error: ", (Throwable)e);
            throw new SHRPerfWebException("AbstractPerfScoreFillService.getEvaAreaListAndSetAreaBaseList is error: ");
        }
        return returnMap;
    }

    protected List<EvaAreaListBean> setNodeInfoToEvaArea(Context ctx, List<EvaAreaListBean> evaAreaBeanList, String gradeTaskNode, String targetTableName) throws SHRPerfWebException {
        IRowSet rowSet = null;
        try {
            List<EvaAreaListBean> returnList = new ArrayList<EvaAreaListBean>();
            GradeTaskNodeInstInfo gradeTaskNodeInfo = this.getGradeTaskNodeWithWFNodeDefByNodeId(ctx, gradeTaskNode);
            PWorkFlowDefInfo workFlowDefInfo = PWorkFlowDefFactory.getLocalInstance((Context)ctx).getPWorkFlowDefInfo("where id = '" + gradeTaskNodeInfo.getWfNode().getWorkflow().getId().toString() + "'");
            PerfEvaObjectInfo perfEvaObjectInfo = GetEntityInfoUtils.getPerfEvaObjectInfo(ctx, gradeTaskNodeInfo.getEvaObj().getId().toString());
            PersonInfo nodeHandler = gradeTaskNodeInfo.getNodeHandler();
            if (!CollectionUtils.isEmpty(evaAreaBeanList) && perfEvaObjectInfo != null && nodeHandler != null) {
                String areaBaseIdStr = evaAreaBeanList.stream().map(evaAreaBean -> "'" + evaAreaBean.getAreaId() + "'").collect(Collectors.joining(","));
                boolean copyFlag = this.isNeedCopy(workFlowDefInfo.getConcurrent());
                HashMap<String, List<Map<String, Object>>> rowSetMap = new HashMap<String, List<Map<String, Object>>>();
                if (1 == perfEvaObjectInfo.getCanAdjustEvaluer().getValue() || copyFlag) {
                    String sqlStr = this.buildGradeTargetSql(workFlowDefInfo.getConcurrent(), targetTableName, areaBaseIdStr, perfEvaObjectInfo.getId().toString(), nodeHandler.getId().toString(), gradeTaskNodeInfo.getWfLevel());
                    rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
                }
                if (copyFlag) {
                    while (rowSet.next()) {
                        List<HashMap<String, Object>> nodeTargetList;
                        HashMap<String, Object> targetMap = new HashMap<String, Object>();
                        String id = rowSet.getString("id");
                        if (rowSetMap.containsKey(id)) {
                            nodeTargetList = (List)rowSetMap.get(id);
                        } else {
                            nodeTargetList = new ArrayList();
                            rowSetMap.put(id, nodeTargetList);
                        }
                        targetMap.put("targetId", rowSet.getString("targetId"));
                        targetMap.put("targetScore", rowSet.getObject("targetScore"));
                        targetMap.put("gradeRank", rowSet.getObject("gradeRank"));
                        targetMap.put("isRejection", rowSet.getObject("isRejection"));
                        targetMap.put("comment", rowSet.getString("comments"));
                        targetMap.put("gradeNodeInstId", rowSet.getString("gradeNodeInstId"));
                        targetMap.put("areaBaseId", rowSet.getString("areaBaseId"));
                        nodeTargetList.add(targetMap);
                    }
                    if (!CollectionUtils.isEmpty(rowSetMap)) {
                        returnList = this.addCopyEavAreaBeanList(ctx, evaAreaBeanList, rowSetMap, targetTableName);
                    } else {
                        this.setNodeHandlerInfo(evaAreaBeanList, gradeTaskNodeInfo);
                    }
                } else if (null != rowSet && rowSet.next()) {
                    this.setNodeHandlerInfo(ctx, evaAreaBeanList, rowSet.getString("id"));
                } else {
                    this.setNodeHandlerInfo(evaAreaBeanList, gradeTaskNodeInfo);
                }
            }
            ArrayList<EvaAreaListBean> arrayList = returnList;
            return arrayList;
        }
        catch (Exception e) {
            logger.error("setNodeInfoToEvaArea is Exception: ", (Throwable)e);
            throw new SHRPerfWebException("setNodeInfoToEvaArea is Exception:" + e.getMessage());
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    logger.error("setNodeInfoToEvaArea close rowSet is error: ", (Throwable)e);
                }
            }
        }
    }

    private List<EvaAreaListBean> addCopyEavAreaBeanList(Context ctx, List<EvaAreaListBean> evaAreaList, Map<String, List<Map<String, Object>>> rowSetMap, String targetTableName) throws IOException, BOSException {
        ArrayList<EvaAreaListBean> returnList = new ArrayList<EvaAreaListBean>();
        for (String gradeTaskNodeId : rowSetMap.keySet()) {
            ArrayList<EvaAreaListBean> loopList = new ArrayList<EvaAreaListBean>(evaAreaList);
            List<Map<String, Object>> mapList = rowSetMap.get(gradeTaskNodeId);
            for (EvaAreaListBean evaAreaBean : loopList) {
                EvaAreaListBean copyEvaArea = (EvaAreaListBean)DeepClone.deepClone((Object)evaAreaBean);
                ArrayList<HashMap<String, Object>> indicatorList = "T_EVA_IndicatorTarget".equals(targetTableName) ? copyEvaArea.getEvaIndicatorList() : copyEvaArea.getEvaRecordList();
                for (Map<String, Object> targetMap : mapList) {
                    for (HashMap<String, Object> indicatorMap : indicatorList) {
                        if (!targetMap.get("targetId").equals(indicatorMap.get("FID"))) continue;
                        indicatorMap.put("nodeTask", gradeTaskNodeId);
                        indicatorMap.put("gradeRank", targetMap.get("gradeRank") == null ? "" : targetMap.get("gradeRank"));
                        indicatorMap.put("targetScore", targetMap.get("targetScore") == null ? "" : targetMap.get("targetScore"));
                        indicatorMap.put("isRejection", FILL_SCORE.equals(String.valueOf(targetMap.get("isRejection"))) ? YesOrNoEnum.YES : YesOrNoEnum.NO);
                        indicatorMap.put("FCOMMENT", targetMap.get("comment"));
                        indicatorMap.put("gradeNodeInstId", targetMap.get("gradeNodeInstId"));
                        this.setNodeHandlerInfo(ctx, copyEvaArea, gradeTaskNodeId);
                    }
                }
                boolean existFlag = returnList.stream().anyMatch(evaAreaListBean -> evaAreaListBean.getAreaId().equals(copyEvaArea.getAreaId()) && evaAreaListBean.getGradeTaskNodeId().equals(copyEvaArea.getGradeTaskNodeId()));
                if (existFlag) continue;
                returnList.add(copyEvaArea);
            }
        }
        return returnList;
    }

    private void setNodeHandlerInfo(Context ctx, List<EvaAreaListBean> evaAreaBeanList, String gradeTaskNode) throws BOSException {
        GradeTaskNodeInstInfo gradeTaskNodeInfo = this.getGradeTaskNodeWithWFNodeDefByNodeId(ctx, gradeTaskNode);
        this.setNodeHandlerInfo(evaAreaBeanList, gradeTaskNodeInfo);
    }

    private void setNodeHandlerInfo(Context ctx, EvaAreaListBean evaAreaBean, String gradeTaskNode) throws BOSException {
        GradeTaskNodeInstInfo gradeTaskNodeInfo = this.getGradeTaskNodeWithWFNodeDefByNodeId(ctx, gradeTaskNode);
        if (null != gradeTaskNodeInfo) {
            evaAreaBean.setGradeTaskNodeId(gradeTaskNodeInfo.getId().toString());
            if (gradeTaskNodeInfo.getWfNode() != null) {
                evaAreaBean.setNodeName(gradeTaskNodeInfo.getWfNode().getNodeName());
                evaAreaBean.setNodeWeight(gradeTaskNodeInfo.getWfNode().getNodeWeight());
                evaAreaBean.setNeedScore(gradeTaskNodeInfo.getWfNode().getNeedScore().getValue());
            }
            if (gradeTaskNodeInfo.getNodeHandler() != null && !StringUtils.isEmpty((CharSequence)gradeTaskNodeInfo.getNodeHandler().getName())) {
                evaAreaBean.setNodeHandlerName(gradeTaskNodeInfo.getNodeHandler().getName());
            } else {
                evaAreaBean.setNodeHandlerName(gradeTaskNodeInfo.getNodeHandlerName());
            }
        }
    }

    private void setNodeHandlerInfo(List<EvaAreaListBean> evaAreaBeanList, GradeTaskNodeInstInfo gradeTaskNodeInfo) {
        evaAreaBeanList.forEach(evaAreaBean -> {
            if (null != gradeTaskNodeInfo) {
                evaAreaBean.setGradeTaskNodeId(gradeTaskNodeInfo.getId().toString());
                if (gradeTaskNodeInfo.getWfNode() != null) {
                    evaAreaBean.setNodeName(gradeTaskNodeInfo.getWfNode().getNodeName());
                    evaAreaBean.setNodeWeight(gradeTaskNodeInfo.getWfNode().getNodeWeight());
                    evaAreaBean.setNeedScore(gradeTaskNodeInfo.getWfNode().getNeedScore().getValue());
                }
                if (gradeTaskNodeInfo.getNodeHandler() != null && !StringUtils.isEmpty((CharSequence)gradeTaskNodeInfo.getNodeHandler().getName())) {
                    evaAreaBean.setNodeHandlerName(gradeTaskNodeInfo.getNodeHandler().getName());
                } else {
                    evaAreaBean.setNodeHandlerName(gradeTaskNodeInfo.getNodeHandlerName());
                }
            }
        });
    }

    private GradeTaskNodeInstInfo getGradeTaskNodeWithWFNodeDefByNodeId(Context ctx, String gradeTaskNode) throws BOSException {
        GradeTaskNodeInstInfo gradeTaskNodeInstInfo = null;
        IGradeTaskNodeInst igradeTaskNodeInst = GradeTaskNodeInstFactory.getLocalInstance((Context)ctx);
        GradeTaskNodeInstCollection gradeTaskNodeInstColl = igradeTaskNodeInst.getGradeTaskNodeInstCollection("select *,nodeHandler.name,wfNode.workflow, wfNode.nodeName, wfNode.nodeWeight, wfNode.needScore where id='" + gradeTaskNode + "'");
        if (gradeTaskNodeInstColl != null && gradeTaskNodeInstColl.size() > 0) {
            gradeTaskNodeInstInfo = gradeTaskNodeInstColl.get(0);
        }
        return gradeTaskNodeInstInfo;
    }

    private PersonalEvaBaseBean packagePersonalEvaBaseBean(Context ctx, PerfPeriodInfo periodInfo, PerfEvaObjectInfo evaObjectInfo) {
        PerformanceRuleInfo ruleInfo = periodInfo.getPerfRule();
        PersonalEvaBaseBean personalEvaBaseBean = new PersonalEvaBaseBean();
        personalEvaBaseBean.setPeriodId(periodInfo.getId().toString());
        personalEvaBaseBean.setPlanName(periodInfo.getPerfPlan().getName());
        personalEvaBaseBean.setRuleName(ruleInfo.getName());
        personalEvaBaseBean.setPerfModelName(periodInfo.getPerfPlan().getPerfModel().getName());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd");
        personalEvaBaseBean.setpStartDate(sdf.format(periodInfo.getPStartDate()));
        personalEvaBaseBean.setpEndDate(sdf.format(periodInfo.getPEndDate()));
        personalEvaBaseBean.setPeriodName(periodInfo.getName());
        personalEvaBaseBean.setPersonalGoalStatus(String.valueOf(evaObjectInfo.getPersonalGoalStatus().getValue()));
        personalEvaBaseBean.setPersonalGoalStatusAlias(evaObjectInfo.getPersonalGoalStatus().getAlias());
        personalEvaBaseBean.setHrOrgUnit(periodInfo.getPerfPlan().getHrUnitOrg().getId().toString());
        String scoreRuleName = "200".equals(ruleInfo.getScoreRule().getValue()) ? ruleInfo.getScoreRate().getName() : ruleInfo.getPariMutual().getName();
        StringBuilder scoreRuleContent = new StringBuilder(StringUtils.isEmpty((CharSequence)scoreRuleName) ? "" : scoreRuleName);
        try {
            IPerfScore iPerfScore;
            PerfScoreInfo scoreInfo;
            if (null != ruleInfo.getPariMutual() && null != ruleInfo.getPariMutual().getId() && null != (scoreInfo = (iPerfScore = PerfScoreFactory.getLocalInstance((Context)ctx)).getPerfScoreInfo("select min,max where id='" + ruleInfo.getPariMutual().getId().toString() + "'"))) {
                scoreRuleContent.append("(").append(PerfPortalUtils.roudUpRemainGiveDecimal(2, scoreInfo.getMin().floatValue())).append("-").append(PerfPortalUtils.roudUpRemainGiveDecimal(2, scoreInfo.getMax().floatValue())).append(")");
            }
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB\u3011-GETPERFSCOREERR\uff01", (Throwable)e);
        }
        personalEvaBaseBean.setScoreRuleContent(scoreRuleContent.toString());
        return personalEvaBaseBean;
    }

    protected abstract String buildAreaQuerySql(Context var1, String var2, String var3, String var4, String var5) throws SQLException, BOSException;

    protected abstract void packageTargetDetailInfo(Context var1, IRowSet var2, EvaAreaListBean var3, String var4, String var5, PerfEvaObjectInfo var6) throws SQLException, BOSException, EASBizException;

    protected abstract IRowSet executeTargetQuerySql(Context var1, YesOrNoEnum var2, String var3, ArrayList<AreaFieldBean> var4, String var5, String var6, String var7) throws BOSException;

    protected abstract boolean isNeedCopy(String var1);

    protected abstract String buildGradeTargetSql(String var1, String var2, String var3, String var4, String var5, int var6);

    protected abstract void dealFillTargetInfo(Context var1, Map<String, Object> var2, PerfEvaObjectInfo var3, PerfPeriodInfo var4) throws BOSException, EASBizException;
}

