/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.attachment.AttachmentState;
import com.kingdee.shr.attachment.AttachmentTypeEnum;
import com.kingdee.shr.attachment.ISHRAttachmentExt;
import com.kingdee.shr.attachment.SHRAttachmentExtCollection;
import com.kingdee.shr.attachment.SHRAttachmentExtFactory;
import com.kingdee.shr.attachment.SHRAttachmentExtInfo;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.bean.AttachmentsBean;
import com.kingdee.shr.perfweb.util.AttachmentUtil;
import com.kingdee.shr.perfweb.util.ExceptionUtil;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.PerfwebStrUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class OsfFormAttachmentUploadUtil {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.util.OsfFormAttachmentUploadUtil");
    private static final String ATTACHMENT_ID = "attachment.id";
    private static final String ATTACHMENT_SIZE = "attachment.size";
    private static final String ATTACHMENT_NAME = "attachment.name";
    private static final String ATTACHMENT_SIMPLENAME = "attachment.simplename";
    private static final String ATTACHMENT_DESC = "attachment.description";
    private static final String ATTACHMENT_CREATOR = "attachment.creator.name";
    private static final String ATTACHMENT_CREATOR_TIME = "attachment.createTime";

    public static List<AttachmentsBean> initialAttachment(Context ctx, String formId, String propertyName, String bundUipk, String sorter) throws BOSException, EASBizException {
        String userId = ctx.getCaller().toString();
        String bunding = userId + "#" + bundUipk;
        ISHRAttachmentExt SHRAttchExt = SHRAttachmentExtFactory.getLocalInstance((Context)ctx);
        OsfFormAttachmentUploadUtil.deleteUnsaveAttachment(bunding, formId);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("boID", (Object)formId));
        if (!StringUtils.isEmpty((String)propertyName)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("propertyName", (Object)propertyName));
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo(ATTACHMENT_SIZE));
        sic.add(new SelectorItemInfo(ATTACHMENT_ID));
        sic.add(new SelectorItemInfo(ATTACHMENT_NAME));
        sic.add(new SelectorItemInfo(ATTACHMENT_SIMPLENAME));
        sic.add(new SelectorItemInfo(ATTACHMENT_CREATOR));
        sic.add(new SelectorItemInfo(ATTACHMENT_CREATOR_TIME));
        entityViewInfo.setSelector(sic);
        if (!StringUtils.isEmpty((String)sorter)) {
            SorterItemCollection sorters = OsfFormAttachmentUploadUtil.getSorters(sorter);
            entityViewInfo.setSorter(sorters);
        }
        SHRAttachmentExtCollection coll = SHRAttchExt.getSHRAttachmentExtCollection(entityViewInfo);
        List<Map<String, String>> attachInfoList = OsfFormAttachmentUploadUtil.getAttachmentByBoIdAndPropertyName(ctx, SHRAttchExt, coll, formId, propertyName, bunding);
        List<AttachmentsBean> attachmentsBeanList = OsfFormAttachmentUploadUtil.fromMap2AttachmentsBean(attachInfoList);
        AttachmentUtil.setTmpUrl(attachmentsBeanList, "");
        return attachmentsBeanList;
    }

    private static List<AttachmentsBean> fromMap2AttachmentsBean(List<Map<String, String>> attachInfoList) {
        ArrayList<AttachmentsBean> attachmentsBeanList = new ArrayList<AttachmentsBean>();
        if (!CollectionUtils.isEmpty(attachInfoList)) {
            for (Map<String, String> map : attachInfoList) {
                String id = map.get("id");
                String name = map.get("name");
                String simpleName = map.get("simpleName");
                String size = map.get("size");
                String uploader = map.get("uploader");
                String uploadDateTime = map.get("uploadDateTime");
                String remark = map.get("remark");
                AttachmentsBean attachmentsBean = new AttachmentsBean();
                attachmentsBean.setId(id);
                attachmentsBean.setName(name);
                attachmentsBean.setSimplename(simpleName);
                attachmentsBean.setSize(size);
                attachmentsBean.setCreator(uploader);
                attachmentsBean.setCreateTime(uploadDateTime);
                attachmentsBean.setRemark(remark);
                attachmentsBeanList.add(attachmentsBean);
            }
        }
        return attachmentsBeanList;
    }

    public static void uploadAttachment(Context ctx, String boID, String bundUipk, List<String> attachmentList, List<String> attachmentIdList) throws BOSException, EASBizException, SQLException {
        String assoid;
        String attachmentid;
        List<AttachmentInfo> imageInfoByUrlList = AttachmentUtil.getImageInfoByUrlList(ctx, attachmentList);
        ArrayList<String> attachmentIDs = new ArrayList<String>();
        ArrayList<String> assoIDs = new ArrayList<String>();
        String queryAttachSql = "select a.FID AS ATTACHMENTID,b.FID AS ASSOID from T_BAS_Attachment a inner join T_BAS_BoattchAsso b on a.FID = b.FAttachmentID where b.FBoID = ? ";
        String queryAttachExtSql = "select a.FID AS ATTACHMENTID,b.FID AS ASSOID from T_BAS_Attachment a inner join T_HR_SHRATTACHMENTEXT b on a.FID = b.FATTACHMENT where b.FBOID = ? ";
        if (!CollectionUtils.isEmpty(attachmentIdList)) {
            String ids = "(" + PerfwebStrUtils.convertListToString(attachmentIdList) + ")";
            queryAttachSql = queryAttachSql + " and a.FID not in " + ids;
            queryAttachExtSql = queryAttachExtSql + " and a.FID not in " + ids;
        }
        String deleteAttachSql = "delete T_BAS_Attachment where FID in  ";
        String deleteAssoSql = "delete T_BAS_BoattchAsso where FID in  ";
        String deleteAttachExtSql = "delete T_HR_SHRATTACHMENTEXT where FATTACHMENT in  ";
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)queryAttachSql, (Object[])new Object[]{boID});
        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)queryAttachExtSql, (Object[])new Object[]{boID});
        if (rs1 != null) {
            while (rs1.next()) {
                attachmentid = rs1.getString("ATTACHMENTID");
                assoid = rs1.getString("ASSOID");
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)attachmentid)) {
                    attachmentIDs.add(attachmentid);
                }
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)assoid)) continue;
                assoIDs.add(assoid);
            }
        }
        if (rs2 != null) {
            while (rs2.next()) {
                attachmentid = rs2.getString("ATTACHMENTID");
                assoid = rs2.getString("ASSOID");
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)attachmentid)) {
                    attachmentIDs.add(attachmentid);
                }
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)assoid)) continue;
                assoIDs.add(assoid);
            }
        }
        if (!CollectionUtils.isEmpty(attachmentIDs)) {
            String attachmentIDsList = "(" + PerfwebStrUtils.convertListToString(attachmentIDs.toArray()) + ")";
            DbUtil.execute((Context)ctx, (String)(deleteAttachSql + attachmentIDsList));
            DbUtil.execute((Context)ctx, (String)(deleteAttachExtSql + attachmentIDsList));
        }
        if (!CollectionUtils.isEmpty(assoIDs)) {
            String assoIDsList = "(" + PerfwebStrUtils.convertListToString(assoIDs.toArray()) + ")";
            DbUtil.execute((Context)ctx, (String)(deleteAssoSql + assoIDsList));
        }
        OsfFormAttachmentUploadUtil.saveAttachment(ctx, boID, bundUipk, imageInfoByUrlList);
    }

    private static void saveAttachment(Context context, String boID, String bundUipk, List<AttachmentInfo> imageInfoByUrlList) throws BOSException, EASBizException {
        IAttachment attachment = AttachmentFactory.getRemoteInstance();
        ISHRAttachmentExt shrAttchExt = SHRAttachmentExtFactory.getRemoteInstance();
        CoreBaseCollection attachmentCoreBaseCollection = new CoreBaseCollection();
        CoreBaseCollection shrAttchExtCoreBaseCollection = new CoreBaseCollection();
        String userId = context.getCaller().toString();
        for (AttachmentInfo attachmentInfo : imageInfoByUrlList) {
            SHRAttachmentExtInfo attchExt = new SHRAttachmentExtInfo();
            attachmentInfo.setBeizhu(bundUipk);
            attchExt.setAttachment(attachmentInfo);
            attchExt.setName(attachmentInfo.getName());
            attchExt.setPropertyName("null0");
            attchExt.setType(AttachmentTypeEnum.FORM);
            attchExt.setState(AttachmentState.SAVE);
            attchExt.setBunding(userId + '#' + bundUipk);
            attchExt.setBoID(boID);
            attachmentCoreBaseCollection.add((CoreBaseInfo)attachmentInfo);
            shrAttchExtCoreBaseCollection.add((CoreBaseInfo)attchExt);
        }
        try {
            attachment.addnew(attachmentCoreBaseCollection);
            shrAttchExt.addnew(shrAttchExtCoreBaseCollection);
        }
        catch (Exception var19) {
            logger.error(var19.getMessage(), (Throwable)var19);
            throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ATTCHMENTUPLOADERR, context), var19);
        }
    }

    private static void deleteUnsaveAttachment(String bunding, String formId) throws BOSException, EASBizException {
        ISHRAttachmentExt shrAttchExt = SHRAttachmentExtFactory.getRemoteInstance();
        IAttachment attachment = AttachmentFactory.getRemoteInstance();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bunding", (Object)bunding));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)20));
        if (!StringUtils.isEmpty((String)formId)) {
            filter.getFilterItems().add(new FilterItemInfo("boID", (Object)formId));
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SHRAttachmentExtCollection col = shrAttchExt.getSHRAttachmentExtCollection(view);
        shrAttchExt.delete(filter);
        for (int i = 0; i < col.size(); ++i) {
            attachment.delete((IObjectPK)new ObjectUuidPK(col.get(i).getId().toString()));
        }
    }

    private static SorterItemCollection getSorters(String sorter) {
        String[] strs;
        SorterItemCollection sorters = new SorterItemCollection();
        for (String sort : strs = sorter.split(",")) {
            String[] sorts = sort.split("\\s+");
            if (sorts.length != 2) continue;
            SorterItemInfo itemInfo = new SorterItemInfo(sorts[0]);
            itemInfo.setSortType(SortType.ASCEND.toString().equals(sorts[1]) ? SortType.ASCEND : SortType.DESCEND);
            sorters.add(itemInfo);
        }
        return sorters;
    }

    private static List<Map<String, String>> getAttachmentByBoIdAndPropertyName(Context ctx, ISHRAttachmentExt SHRAttchExt, SHRAttachmentExtCollection coll, String formId, String propertyName, String bunding) throws BOSException, EASBizException {
        ArrayList<Map<String, String>> attachInfoList;
        block9: {
            block8: {
                attachInfoList = new ArrayList<Map<String, String>>();
                if (coll.size() != 0) break block8;
                SHRAttachmentExtCollection extColl = OsfFormAttachmentUploadUtil.getSHRAttchExtColByBoID(formId);
                BoAttchAssoCollection boColl = OsfFormAttachmentUploadUtil.getBoAttchAssoCol(formId);
                if (extColl.size() == boColl.size()) {
                    return attachInfoList;
                }
                List<AttachmentInfo> list = OsfFormAttachmentUploadUtil.getNoPropertyNameAttch(extColl, boColl);
                if (list.size() <= 0) break block9;
                propertyName = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)propertyName) ? "null0" : propertyName;
                for (AttachmentInfo ai : list) {
                    SHRAttachmentExtInfo shrAttch = new SHRAttachmentExtInfo();
                    shrAttch.setPropertyName(propertyName);
                    shrAttch.setAttachment(ai);
                    shrAttch.setBoID(formId);
                    shrAttch.setBunding(bunding);
                    if (propertyName.startsWith("null")) {
                        shrAttch.setType(AttachmentTypeEnum.FORM);
                    } else {
                        shrAttch.setType(AttachmentTypeEnum.PROPERTY);
                    }
                    shrAttch.setState(AttachmentState.SAVE);
                    SHRAttchExt.addnew((CoreBaseInfo)shrAttch);
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", ai.getId().toString());
                    map.put("name", ai.getName());
                    map.put("simpleName", ai.getSimpleName());
                    map.put("size", ai.getSize());
                    map.put("uploader", shrAttch.getCreator().getName());
                    map.put("uploadDateTime", DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                    map.put("remark", shrAttch.getDescription());
                    attachInfoList.add(map);
                }
                break block9;
            }
            for (int i = 0; i < coll.size(); ++i) {
                SHRAttachmentExtInfo shrAttach = coll.get(i);
                AttachmentInfo ai = shrAttach.getAttachment();
                String id = ai.getId().toString();
                AttachmentInfo attachmentInfo = null;
                try {
                    attachmentInfo = AttachmentFactory.getLocalInstance((Context)ctx).getAttachmentInfo(MessageFormat.format(" where id = ''{0}''", id));
                }
                catch (ObjectNotFoundException e) {
                    logger.error("attachment not found, id :" + id, (Throwable)e);
                    continue;
                }
                if (attachmentInfo != null) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", ai.getId().toString());
                    map.put("name", ai.getName());
                    map.put("simpleName", ai.getSimpleName());
                    map.put("size", ai.getSize());
                    map.put("uploader", shrAttach.getCreator().getName());
                    map.put("uploadDateTime", DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                    map.put("remark", shrAttach.getDescription());
                    attachInfoList.add(map);
                    continue;
                }
                SHRAttachmentExtFactory.getRemoteInstance().delete(MessageFormat.format(" where id = ''{0}''", shrAttach.getId().toString()));
            }
        }
        return attachInfoList;
    }

    private static SHRAttachmentExtCollection getSHRAttchExtColByBoID(String formId) throws BOSException {
        ISHRAttachmentExt shrAttchExt = SHRAttachmentExtFactory.getRemoteInstance();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("boID", (Object)formId));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo(ATTACHMENT_SIZE));
        sic.add(new SelectorItemInfo(ATTACHMENT_ID));
        sic.add(new SelectorItemInfo(ATTACHMENT_NAME));
        sic.add(new SelectorItemInfo(ATTACHMENT_SIMPLENAME));
        sic.add(new SelectorItemInfo(ATTACHMENT_DESC));
        sic.add(new SelectorItemInfo(ATTACHMENT_CREATOR));
        sic.add(new SelectorItemInfo(ATTACHMENT_CREATOR_TIME));
        entityViewInfo.setSelector(sic);
        return shrAttchExt.getSHRAttachmentExtCollection(entityViewInfo);
    }

    public static BoAttchAssoCollection getBoAttchAssoCol(String boid) throws BOSException {
        IBoAttchAsso boAttchAsso = BoAttchAssoFactory.getRemoteInstance();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("boid", (Object)boid));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo(ATTACHMENT_SIZE));
        sic.add(new SelectorItemInfo(ATTACHMENT_ID));
        sic.add(new SelectorItemInfo(ATTACHMENT_NAME));
        sic.add(new SelectorItemInfo(ATTACHMENT_SIMPLENAME));
        sic.add(new SelectorItemInfo(ATTACHMENT_DESC));
        sic.add(new SelectorItemInfo(ATTACHMENT_CREATOR));
        sic.add(new SelectorItemInfo(ATTACHMENT_CREATOR_TIME));
        entityViewInfo.setSelector(sic);
        return boAttchAsso.getBoAttchAssoCollection(entityViewInfo);
    }

    private static List<AttachmentInfo> getNoPropertyNameAttch(SHRAttachmentExtCollection extColl, BoAttchAssoCollection boColl) {
        ArrayList<AttachmentInfo> list = new ArrayList<AttachmentInfo>();
        if (extColl.size() > 0) {
            for (int i = 0; i < boColl.size(); ++i) {
                AttachmentInfo atti = boColl.get(i).getAttachment();
                list.add(atti);
            }
            for (int j = 0; j < extColl.size(); ++j) {
                AttachmentInfo attj = extColl.get(j).getAttachment();
                if (!list.contains(attj)) continue;
                list.remove(attj);
            }
        } else {
            for (int k = 0; k < boColl.size(); ++k) {
                AttachmentInfo attk = boColl.get(k).getAttachment();
                list.add(attk);
            }
        }
        return list;
    }
}

