/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfDbUtil
extends DbUtil {
    private static final Logger logger = LoggerFactory.getLogger(PerfDbUtil.class);

    public static IRowSet executeQuery(Context ctx, String sql, int start, int rows, Object[] params) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)exc);
        }
        try {
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs, start, rows, true);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                logger.error("error sql is:" + sql, (Throwable)exc);
                throw new BOSException("Sql3 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return jdbcRowSet;
    }
}

