/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfGoalsGroup;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfGoalsGroupCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfGoalsGroupFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.UniteIndicatorCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.UniteIndicatorInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.UniteRecordCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.UniteRecordInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleInfo;
import com.kingdee.shr.perfweb.app.common.YesOrNoEnum;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public final class PerfEvaObjGroupUtils {
    public static boolean checkGroupIsValid(Context ctx, String groupId) throws BOSException {
        UniteRecordCollection uniteRecordColl;
        UniteIndicatorCollection uniteIndicatorColl;
        int scoringWay = 0;
        IPerfGoalsGroup iPerfGoalsGroup = PerfGoalsGroupFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)groupId, CompareType.EQUALS));
        evi.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("period.id"));
        sic.add(new SelectorItemInfo("period.perfRule.scoringWay"));
        evi.setSelector(sic);
        PerfGoalsGroupCollection perfGoalsGroupColl = iPerfGoalsGroup.getPerfGoalsGroupCollection(evi);
        if (null != perfGoalsGroupColl && perfGoalsGroupColl.size() > 0) {
            PerformanceRuleInfo ruleInfo = perfGoalsGroupColl.get(0).getPeriod().getPerfRule();
            scoringWay = ruleInfo.getScoringWay().getValue();
        }
        if (null != (uniteIndicatorColl = GetEntityInfoUtils.getUniteIndicatorCollByGroupId(ctx, groupId)) && uniteIndicatorColl.size() > 0) {
            int indicatorSize = uniteIndicatorColl.size();
            HashSet<String> areaBases = new HashSet<String>();
            for (int i = 0; i < indicatorSize; ++i) {
                UniteIndicatorInfo uniteIndicatorInfo = uniteIndicatorColl.get(i);
                if (StringUtils.isEmpty((CharSequence)uniteIndicatorInfo.getName())) {
                    return false;
                }
                areaBases.add(uniteIndicatorInfo.getAreaBase());
            }
            Map<String, Boolean> canRateMap = PerfEvaObjGroupUtils.getCanRateMapByAreaBaseIds(ctx, areaBases);
            for (int i = 0; i < indicatorSize; ++i) {
                UniteIndicatorInfo indicatorInfo = uniteIndicatorColl.get(i);
                if (!(scoringWay == 0 ? !indicatorInfo.isRejection() && StringUtils.isEmpty((CharSequence)indicatorInfo.getWeight()) && canRateMap.get(indicatorInfo.getAreaBase()) != false : !indicatorInfo.isRejection() && StringUtils.isEmpty((CharSequence)indicatorInfo.getTarScore()) && canRateMap.get(indicatorInfo.getAreaBase()) != false)) continue;
                return false;
            }
        }
        if (null != (uniteRecordColl = GetEntityInfoUtils.getUniteRecordCollByGroupId(ctx, groupId)) && uniteRecordColl.size() > 0) {
            int recordSize = uniteRecordColl.size();
            HashSet<String> areaBases = new HashSet<String>();
            for (int j = 0; j < recordSize; ++j) {
                UniteRecordInfo uniteRecordInfo = uniteRecordColl.get(j);
                if (StringUtils.isEmpty((CharSequence)uniteRecordInfo.getKeyItem())) {
                    return false;
                }
                areaBases.add(uniteRecordInfo.getAreaBase());
            }
            Map<String, Boolean> canRateMap = PerfEvaObjGroupUtils.getCanRateMapByAreaBaseIds(ctx, areaBases);
            for (int i = 0; i < recordSize; ++i) {
                UniteRecordInfo recordInfo = uniteRecordColl.get(i);
                if (!(scoringWay == 0 ? StringUtils.isEmpty((CharSequence)recordInfo.getWeight()) && canRateMap.get(recordInfo.getAreaBase()) != false : StringUtils.isEmpty((CharSequence)recordInfo.getTarScore()) && canRateMap.get(recordInfo.getAreaBase()) != false)) continue;
                return false;
            }
        }
        return true;
    }

    private static Map<String, Boolean> getCanRateMapByAreaBaseIds(Context ctx, Set<String> areaBases) {
        EvaluFormAreaBaseCollection areaBaseColl = GetEntityInfoUtils.getEvaluFormAreaBaseCollByIds(ctx, areaBases);
        HashMap<String, Boolean> canRateMap = new HashMap<String, Boolean>();
        if (areaBaseColl != null && areaBaseColl.size() > 0) {
            for (int j = 0; j < areaBaseColl.size(); ++j) {
                EvaluFormAreaBaseInfo areaBaseInfo = areaBaseColl.get(j);
                if (areaBaseInfo == null) continue;
                String key = areaBaseInfo.getId().toString();
                canRateMap.put(key, YesOrNoEnum.YES == areaBaseInfo.getCanRate());
            }
        }
        return canRateMap;
    }
}

