/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.shr.base.syssetting.json.adapter.BOSUuidTypeAdapter;
import com.kingdee.shr.base.syssetting.json.adapter.BosObjectCollectionTypeAdapter;
import com.kingdee.shr.base.syssetting.json.adapter.BosObjectTypeAdapter;
import com.kingdee.shr.base.syssetting.json.adapter.DateTypeAdapter;
import com.kingdee.shr.base.syssetting.json.adapter.EnumTypeAdapter;
import com.kingdee.util.enums.Enum;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;

public class JsonUtils {
    public static <T> T getJsonObj(String jsonStr, T type) {
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping();
        Gson gson = builder.create();
        Object result = gson.fromJson(jsonStr, type.getClass());
        return (T)result;
    }

    public static String getJsonStr(Object obj) {
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping();
        Gson gson = builder.create();
        String json = gson.toJson(obj);
        return json;
    }

    public static HashMap convertJsonToObject(Context ctx, String json) {
        Gson gson = JsonUtils.getGson(ctx);
        return (HashMap)gson.fromJson(json.toString(), HashMap.class);
    }

    public static Gson getGson(Context ctx) {
        GsonBuilder builder = new GsonBuilder();
        builder.disableHtmlEscaping();
        builder.serializeNulls();
        builder.serializeSpecialFloatingPointValues();
        builder.registerTypeHierarchyAdapter(Date.class, (Object)new DateTypeAdapter());
        builder.registerTypeHierarchyAdapter(Timestamp.class, (Object)new DateTypeAdapter());
        builder.registerTypeHierarchyAdapter(BOSUuid.class, (Object)new BOSUuidTypeAdapter());
        builder.registerTypeHierarchyAdapter(IObjectValue.class, (Object)new BosObjectTypeAdapter(ctx));
        builder.registerTypeHierarchyAdapter(IObjectCollection.class, (Object)new BosObjectCollectionTypeAdapter(ctx));
        builder.registerTypeHierarchyAdapter(OrgUnitInfo.class, (Object)new BosObjectTypeAdapter(ctx));
        builder.registerTypeHierarchyAdapter(BizEnumValueDTO.class, (Object)new EnumTypeAdapter());
        builder.registerTypeHierarchyAdapter(Enum.class, (Object)new EnumTypeAdapter());
        return builder.create();
    }
}

