/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.AdminOrgUnitHISInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.org.SHRAdminOrgUnitExtendInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfPeriod;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.IEvaluFormAreaBase;
import com.kingdee.shr.perfweb.app.base.evalrule.IOrgFormFieldConf;
import com.kingdee.shr.perfweb.app.base.evalrule.IPerformanceRule;
import com.kingdee.shr.perfweb.app.base.evalrule.OrgFormFieldConfCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.OrgFormFieldConfFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.OrgFormFieldConfInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleInfo;
import com.kingdee.shr.perfweb.app.common.YesOrNoEnum;
import com.kingdee.shr.perfweb.utils.OrgAssessmentUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class OrgBaseUtils {
    static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.utils.OrgBaseUtils");

    public static String getOrgBaseData(Context ctx, String evaObj, String periodId) throws BOSException, EASBizException {
        String json = "";
        Assert.hasText((String)evaObj, (String)"evaObj mast not be empty!");
        Assert.hasText((String)periodId, (String)"periodId mast not be empty!");
        PerfEvaObjectInfo orgEvaObj = OrgAssessmentUtils.getOrgAssessmentInfoByEvaObj(ctx, evaObj);
        ArrayList<HashMap<String, Object>> fieldConfList = OrgBaseUtils.getOrgBaseFileds(ctx, periodId);
        String orgAdminIdHIS = orgEvaObj.getAdminHis().getId().toString();
        AdminOrgUnitHISInfo adminInfo = OrgAssessmentUtils.getEvaluAdminHISInfo(ctx, orgAdminIdHIS);
        SHRAdminOrgUnitExtendInfo adminInfoExt = OrgAssessmentUtils.getEvaluAdminExtInfo(ctx, orgAdminIdHIS);
        String colNameVal = null;
        for (HashMap<String, Object> map : fieldConfList) {
            colNameVal = "";
            String colName = (String)map.get("colName");
            if (OrgAssessmentUtils.orgfieldKV.containsKey(colName)) {
                colNameVal = adminInfo.getString(OrgAssessmentUtils.orgfieldKV.get(colName));
            } else if (colName.equals("FPRINCIPLENAME")) {
                List<String> responsorNames = OrgAssessmentUtils.getOrgResponserNameByEvaObject(ctx, evaObj);
                if (!CollectionUtils.isEmpty(responsorNames)) {
                    colNameVal = StringUtils.join(responsorNames, (String)",");
                }
            } else if (colName.equals("FCITY")) {
                if (null != adminInfoExt && null != adminInfoExt.getCity()) {
                    colNameVal = adminInfoExt.getCity().getName();
                }
            } else if (colName.equals("FENTERPRISENATURE")) {
                if (null != adminInfoExt && null != adminInfoExt.getEnterpriseNature()) {
                    colNameVal = adminInfoExt.getEnterpriseNature().getName();
                }
            } else if (colName.equals("FHRINDUSTRY")) {
                if (null != adminInfoExt && null != adminInfoExt.getHrIndustry()) {
                    colNameVal = adminInfoExt.getHrIndustry().getName();
                }
            } else if (colName.equals("FISJURIDICALCOMPANY")) {
                colNameVal = "true".equals(adminInfo.getString("isJuridicalCompany")) ? YesOrNoEnum.YES.getAlias() : YesOrNoEnum.NO.getAlias();
            } else if (null != adminInfo.get(colName = colName.replaceFirst("F", ""))) {
                colNameVal = adminInfo.getString(colName);
            }
            map.put("colNameVal", colNameVal);
        }
        Gson gson = new Gson();
        json = gson.toJson(fieldConfList);
        return json;
    }

    public static ArrayList<HashMap<String, Object>> getOrgBaseFileds(Context ctx, String periodId) throws BOSException, EASBizException {
        ArrayList<HashMap<String, Object>> fieldList = new ArrayList<HashMap<String, Object>>();
        IPerfPeriod iperfPeriod = PerfPeriodFactory.getLocalInstance((Context)ctx);
        PerfPeriodInfo perfPeriodInfo = iperfPeriod.getPerfPeriodInfo(" where id='" + periodId + "'");
        IPerformanceRule iperfRule = PerformanceRuleFactory.getLocalInstance((Context)ctx);
        PerformanceRuleInfo perfRuleInfo = iperfRule.getPerformanceRuleInfo(" where id='" + perfPeriodInfo.getPerfRule().getId().toString() + "'");
        IEvaluFormAreaBase iEvaFABase = EvaluFormAreaBaseFactory.getLocalInstance((Context)ctx);
        EvaluFormAreaBaseInfo evaFABInfo = iEvaFABase.getEvaluFormAreaBaseInfo(" where performanceRule='" + perfRuleInfo.getId().toString() + "' and areaType='" + "400" + "'");
        IOrgFormFieldConf iOrgFormFieldConf = OrgFormFieldConfFactory.getLocalInstance((Context)ctx);
        OrgFormFieldConfCollection coll = iOrgFormFieldConf.getOrgFormFieldConfCollection(" where areaBase='" + evaFABInfo.getId().toString() + "' order by seqNo ASC");
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                OrgFormFieldConfInfo info = coll.get(i);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("colName", info.getColName());
                map.put("showName", info.getShowName());
                map.put("seqNo", info.getSeqNo());
                fieldList.add(map);
            }
        }
        return fieldList;
    }
}

