/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.baseconfig;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.impl.HistoryGeneratorParam;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterConstant;
import com.kingdee.eas.hr.base.app.filter.SqlGenerateUtils;
import com.kingdee.eas.hr.base.app.filter.StructureConfigConvertHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.baseconfig.StructureConfigCollection;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.baseconfig.service.api.impl.CommonSHRSqlBuilder;
import com.kingdee.shr.compensation.util.filter.CmpPermFilter;
import com.kingdee.shr.perfweb.formulaplatform.common.FunUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PERFWEB001SHRSqlBuilder
extends CommonSHRSqlBuilder {
    private static final Logger logger = Logger.getLogger(PERFWEB001SHRSqlBuilder.class);
    public static final String HRORG_FIELD = "cmpHROrgUnit";
    public static final String ADMINORG_FIELD = "adminOrgUnit";
    public static final String PersonCmp_FIELD = "personCmp";
    public static final String CmpORelation_FIELD = "cmpEmpORelation";
    public static final String EmpOrgRelation_FIELD = "empOrgRelation";

    public static PERFWEB001SHRSqlBuilder getInstance() {
        return PERFWEB001SHRSqlBuilderInst.instance;
    }

    protected String generateOneColumn(String column, String alias) throws EASBizException, BOSException {
        String[] keys = column.split("\\.");
        boolean isBigDataType = false;
        Map<String, StructureConfigInfo> structMap = FunUtils.getPERFWEB001StructureMap(this.ctx);
        StructureConfigInfo structureInfo = structMap.get(column.substring(0, column.indexOf(".")));
        String scheme = structureInfo.getScheme().getNumber();
        StringBuffer selectColumnString = new StringBuffer();
        if ("002".equalsIgnoreCase(scheme) && (keys.length == 1 || keys[1].matches("(?i)s\\d+"))) {
            if ("_row_index".equalsIgnoreCase(alias)) {
                return "";
            }
            alias = SqlGenerateUtils.getLabCostColumnAlias((Context)this.ctx, (String)column, (String)alias);
            selectColumnString.append(" ").append(column).append(" AS ").append(this.appendQuo(alias)).append(" ");
        } else {
            StructureConfigInfo configInfo = StructureConfigConvertHelper.getStructureConfigByNumber((Context)this.ctx, (String)keys[0], (String)scheme);
            if (configInfo == null) {
                return "";
            }
            if (this.param.isNeedDistinct()) {
                isBigDataType = this.isBigDataType(configInfo, column);
            }
            if (this.param.isHistoryMode() && column.toUpperCase().contains("LONGNUMBER") && "com.kingdee.eas.basedata.org.app.AdminOrgUnit".equalsIgnoreCase(configInfo.getEntityName())) {
                this.appendQueAdminHis(selectColumnString, configInfo, "T", "FLongNumber", alias);
            } else if (this.param.isHistoryMode() && column.toUpperCase().contains("DISPLAYNAME") && "com.kingdee.eas.basedata.org.app.AdminOrgUnit".equalsIgnoreCase(configInfo.getEntityName())) {
                this.appendQueAdminHis(selectColumnString, configInfo, "T", "FDisplayName_l2", alias);
            } else {
                selectColumnString.append(" ");
                if (isBigDataType) {
                    selectColumnString.append("convert(nvarchar(4000),");
                }
                selectColumnString.append(this.getColumnHisotryName(this.historyReplayColumn, this.getColumnName(configInfo, keys[1])));
                if (isBigDataType) {
                    selectColumnString.append(")");
                }
                selectColumnString.append(" AS ").append(this.appendQuo(alias)).append(" ");
            }
        }
        return selectColumnString.toString();
    }

    protected String generateCustomColumnStr(String column, String alias) throws EASBizException, BOSException {
        return super.generateCustomColumnStr(column, alias);
    }

    public List<Map<String, Object>> pupolate(Context ctx, SqlParam param, IRowSet rowSet) throws BOSException, EASBizException {
        return super.pupolate(ctx, param, rowSet);
    }

    protected String getAlias(String scheme, Map.Entry<String, String> entry) throws EASBizException, BOSException {
        return super.getAlias(scheme, entry);
    }

    protected void appendGroupField(StringBuffer sql, String[] keys, StructureConfigInfo configInfo, Map.Entry<String, String> entry) throws EASBizException, BOSException {
        super.appendGroupField(sql, keys, configInfo, entry);
    }

    protected void recordOrgInfo(EntityObjectInfo clientEntity, StructureConfigInfo clientInfo, String clientField, String leftJoinField) {
        if (this.permissFields.get("hr") == null) {
            this.permissFields.put("hr", "\"cmpHROrgUnit\".FID");
        }
        if (this.permissFields.get("admin") == null) {
            this.permissFields.put("admin", "\"adminOrgUnit\".FhistoryRelateID");
        }
        if (this.permissFields.get("defaultManage") == null) {
            this.permissFields.put("defaultManage", "\"cmpEmpORelation\".FUseDefault");
        }
    }

    protected void afterGetAllTableInfoForReport(StructureConfigCollection tableCollection) {
        try {
            StructureConfigInfo personCmpInfo = StructureConfigConvertHelper.getStructureConfigByKey((Context)this.ctx, (String)PersonCmp_FIELD, (String)this.param.getScheme());
            StructureConfigInfo cmpInfo = StructureConfigConvertHelper.getStructureConfigByKey((Context)this.ctx, (String)CmpORelation_FIELD, (String)this.param.getScheme());
            StructureConfigInfo empInfo = StructureConfigConvertHelper.getStructureConfigByKey((Context)this.ctx, (String)EmpOrgRelation_FIELD, (String)this.param.getScheme());
            StructureConfigInfo adminInfo = StructureConfigConvertHelper.getStructureConfigByKey((Context)this.ctx, (String)ADMINORG_FIELD, (String)this.param.getScheme());
            StructureConfigInfo hrInfo = StructureConfigConvertHelper.getStructureConfigByKey((Context)this.ctx, (String)HRORG_FIELD, (String)this.param.getScheme());
            if (tableCollection == null) {
                tableCollection = new StructureConfigCollection();
            }
            if (!tableCollection.contains(personCmpInfo)) {
                tableCollection.add(personCmpInfo);
            }
            if (!tableCollection.contains(cmpInfo)) {
                tableCollection.add(cmpInfo);
            }
            if (!tableCollection.contains(empInfo)) {
                tableCollection.add(empInfo);
            }
            if (!tableCollection.contains(adminInfo)) {
                tableCollection.add(adminInfo);
            }
            if (!tableCollection.contains(hrInfo)) {
                tableCollection.add(hrInfo);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    protected FilterInfo privateDataSourceCustomFilter(String scheme, Map configParam, String effdtStr, Date effdt) throws EASBizException, BOSException {
        FilterInfo customFilter = new FilterInfo();
        String permItemId = (String)configParam.get("permItemId");
        String hrOrgId = (String)configParam.get("pHr");
        try {
            FilterInfo permFilter = null;
            permFilter = !StringUtils.isEmpty((String)hrOrgId) ? CmpPermFilter.getPermFilterByHRO((Context)this.ctx, (String)scheme, (String)hrOrgId, (boolean)true) : CmpPermFilter.getPermFilter((Context)this.ctx, (String)scheme, (String)permItemId);
            customFilter.mergeFilter(permFilter, "AND");
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return customFilter;
    }

    public EntityObjectInfo _getEntityObject(String entityName) {
        return this.getEntityObject(entityName);
    }

    private boolean isBigDataType(StructureConfigInfo configInfo, String column) {
        EntityObjectInfo entityObjectInfo = this.getEntityObject(configInfo.getEntityName());
        String propertyName = "";
        propertyName = column.indexOf(".") > 0 ? column.split("\\.")[1] : column;
        PropertyInfo propertyInfo = entityObjectInfo.getPropertyByNameRuntime(propertyName);
        ColumnInfo ColumnInfo2 = propertyInfo.getMappingField();
        int sqlType = ColumnInfo2.getSQLType();
        return sqlType == SQLType.CLOB.getSQLType() || sqlType == SQLType.BLOB.getSQLType() || sqlType == SQLType.NCLOB.getSQLType();
    }

    protected StringBuffer getFromOnSql(StructureConfigInfo configInfo, StructureConfigInfo relateInfo, Map<String, HistoryGeneratorParam> hisParamMap) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        StructureConfigInfo clientInfo = this.getClientInfo(configInfo, relateInfo);
        EntityObjectInfo clientEntity = this.getEntityObject(clientInfo.getEntityName());
        EntityObjectInfo parentEntity = this.getEntityObject(clientInfo.getParent().getEntityName());
        this.recordArchivesInfo(clientEntity, clientInfo);
        int total = clientInfo.getFilterColumn().size();
        for (int i = 0; i < total; ++i) {
            if (i > 0) {
                sql.append(" AND ");
            }
            String clientField = this.getRelationFieldTableColumn(clientEntity, configInfo.getFilterColumn().get(i).getClientColumn(), configInfo.getFilterColumn().get(i).getClientColumnAlias());
            StringBuffer client = new StringBuffer();
            this.appendAliasQueAndFiled(client, this.getTableAlias(clientInfo), clientField);
            String leftJoinField = this.getColumnHisotryName(this.historyReplayColumn, client.toString());
            sql.append(leftJoinField);
            this.recordOrgInfo(clientEntity, clientInfo, clientField, leftJoinField);
            if (clientInfo.getFilterColumn().get(i).getCompareType() == null || clientInfo.getFilterColumn().get(i).getCompareType().getValue() == null) {
                sql.append(" = ");
            } else {
                sql.append(clientInfo.getFilterColumn().get(i).getCompareType().getValue());
            }
            if (clientInfo.getFilterColumn().get(i).getParentColumn() != null) {
                String parentField = this.getQuoTableAlias(clientInfo.getParent()) + "." + this.getRelationFieldTableColumn(parentEntity, clientInfo.getFilterColumn().get(i).getParentColumn(), configInfo.getFilterColumn().get(i).getParentColumnAlias());
                sql.append(this.getColumnHisotryName(this.historyReplayColumn, parentField.toUpperCase()));
                continue;
            }
            String fixValue = clientInfo.getFilterColumn().get(i).getFixValue();
            if ("@baseDate".equalsIgnoreCase(fixValue)) {
                fixValue = this.getValueStringOnly(this.param.getFilterDate());
            }
            sql.append(fixValue);
        }
        if (this.isNeedHistory(hisParamMap.get(clientInfo.getId().toString()), clientEntity, clientInfo) && this.param.isHistoryMode()) {
            if (!this.param.isIgnoreNowDateFilter()) {
                if (clientInfo.isNowDateFilter() || StringUtils.isEmpty((String)clientInfo.getSingleCondition())) {
                    this.hisModleHandlerDateFilter(clientInfo, sql);
                }
            } else if (clientInfo.isNowDateFilter() && !StringUtils.isEmpty((String)clientInfo.getSingleCondition())) {
                this.addSingleCondition(clientInfo, sql);
            }
        }
        String tableAlias = this.getTableAlias(clientInfo);
        if (this.param.getInfoCtr().containsKey(tableAlias)) {
            String string = (String)this.param.getInfoCtr().get(tableAlias);
        }
        if ("com.kingdee.eas.hr.base.app.EmpPosOrgRelation".equals(configInfo.getEntityName()) && "true".equals(this.param.getInfoCtr().get("isLatestInAday".toUpperCase()))) {
            sql.append(" AND ").append(this.getQuoTableAlias(clientInfo)).append(".").append("FIsLatestInAday = 1");
        }
        return sql;
    }

    private StructureConfigInfo getClientInfo(StructureConfigInfo configInfo, StructureConfigInfo relateInfo) {
        if (configInfo.getParent() != null && configInfo.getParent().getId().equals((Object)relateInfo.getId())) {
            configInfo.setParent(relateInfo);
            return configInfo;
        }
        relateInfo.setParent(configInfo);
        return relateInfo;
    }

    protected void addSingleCondition(StructureConfigInfo clientInfo, StringBuffer sql) throws EASBizException, BOSException {
        StringBuffer fromCond;
        String filterCond = clientInfo.getSingleCondition();
        FilterInfo filterInfo = null;
        if (StringUtils.isEmpty((String)filterCond)) {
            return;
        }
        try {
            filterInfo = new FilterInfo(filterCond);
        }
        catch (ParserException e) {
            logger.error((Object)e);
        }
        if (filterInfo != null && filterInfo.getFilterItems().size() > 0 && (fromCond = this.getFromClause(filterInfo, clientInfo)).length() > 0) {
            sql.append(" AND ").append(fromCond);
        }
    }

    private StringBuffer getFromClause(FilterInfo filterInfo, StructureConfigInfo clientInfo) throws EASBizException, BOSException {
        int i;
        StringBuffer whereSql = new StringBuffer("");
        int filtersCount = filterInfo.getFilterItems().size();
        if (filtersCount <= 0) {
            return whereSql;
        }
        String format = filterInfo.getMaskString();
        if (!StringUtils.isEmpty((String)format)) {
            format = "(" + format + ")";
            for (i = filtersCount - 1; i >= 0; --i) {
                format = StringUtils.replace((String)format, (String)("#" + i), (String)("~9^Nz" + i + "~9^Nz"));
            }
        }
        for (i = 0; i < filtersCount; ++i) {
            StringBuffer filter = new StringBuffer("");
            FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
            Object value = filterItemInfo.getCompareValue();
            if (value != null && FilterConstant.DATEFILTER.equalsIgnoreCase(value.toString())) {
                value = this.param.getFilterDate();
            }
            CompareType type = filterItemInfo.getCompareType();
            String[] propertyNames = null;
            String propertyName = null;
            if (filterItemInfo.getPropertyName().contains(".")) {
                propertyNames = filterItemInfo.getPropertyName().split("\\.");
                propertyName = propertyNames[1];
            } else {
                propertyName = filterItemInfo.getPropertyName();
            }
            PropertyInfo propInfo = this.getPropertyInfo(clientInfo, propertyName);
            if (!CompareType.EXISTS.equals((Object)type) && !CompareType.NOTEXISTS.equals((Object)type)) {
                filter.append(this.getColumnName(clientInfo, propertyName));
            }
            if (filterItemInfo.isCompareValueIsProperty()) {
                filter.append(filterItemInfo.getCompareExpression());
                String propertyValue = filterItemInfo.getCompareValue().toString();
                StructureConfigInfo propertyConfigInfo = StructureConfigConvertHelper.getStructureConfigByKey((Context)this.ctx, (String)propertyValue, (String)this.param.getScheme());
                if (propertyValue.contains(".")) {
                    propertyValue = propertyValue.split("\\.")[1];
                }
                filter.append(this.getColumnName(propertyConfigInfo, propertyValue));
            } else {
                this.appendClouse(filter, value, type, filterItemInfo, propInfo);
            }
            if (StringUtils.isEmpty((String)format)) {
                whereSql.append(filter);
                if (i >= filtersCount - 1) continue;
                whereSql.append(" AND ");
                continue;
            }
            format = StringUtils.replace((String)format, (String)("~9^Nz" + i + "~9^Nz"), (String)filter.toString());
        }
        if (format != null) {
            whereSql.append(format);
        }
        return whereSql;
    }

    protected StringBuffer generateAdminHis(StructureConfigInfo configInfo, String adminAlias, String adminTAlias) {
        StringBuffer sql = new StringBuffer();
        if (this.param.getRealFilterDate() != null) {
            this.appendCommonJoinOnCondition(null, sql, adminAlias, "FhistoryRelateID", " = ", adminTAlias, "FAdminOrgID");
            this.appendCommonJoinOnCondition(" AND ", sql, adminTAlias, "FEFFDT", " <= ", null, "{ts '" + DateTimeUtils.format((Date)this.param.getFilterDate()) + "'}");
            this.appendCommonJoinOnCondition(" AND ", sql, adminTAlias, "FLEFFDT", " >= ", null, "{ts '" + DateTimeUtils.format((Date)this.param.getFilterDate()) + "'}");
        } else if ("002".equals(this.param.getScheme())) {
            if ("\"CAL_CMPCALORGT\"".equalsIgnoreCase(adminTAlias)) {
                this.appendCommonJoinOnCondition(null, sql, adminTAlias, "FAdminOrgID", " = ", "CMP_CTB", "FCMPCALORGID");
                this.appendCommonJoinOnCondition(" AND ", sql, "CMP_CTB", "FRealEndDate", " <= ", adminTAlias, "FLEFFDT");
                this.appendCommonJoinOnCondition(" AND ", sql, "CMP_CTB", "FRealEndDate", " >= ", adminTAlias, "FEFFDT");
            } else if ("\"CAL_ADMINORGT\"".equalsIgnoreCase(adminTAlias)) {
                this.appendCommonJoinOnCondition(null, sql, adminTAlias, "FAdminOrgID", " = ", "CMP_CTB", "FADMINORGUNITID");
                this.appendCommonJoinOnCondition(" AND ", sql, "CMP_CTB", "FRealEndDate", " <= ", adminTAlias, "FLEFFDT");
                this.appendCommonJoinOnCondition(" AND ", sql, "CMP_CTB", "FRealEndDate", " >= ", adminTAlias, "FEFFDT");
            } else if ("\"CAL_COMPANYT\"".equalsIgnoreCase(adminTAlias)) {
                this.appendCommonJoinOnCondition(null, sql, adminTAlias, "FAdminOrgID", " = ", "CMP_CTB", "FADMINORGUNITID");
                this.appendCommonJoinOnCondition(" AND ", sql, "CMP_CTB", "FRealEndDate", " <= ", adminTAlias, "FLEFFDT");
                this.appendCommonJoinOnCondition(" AND ", sql, "CMP_CTB", "FRealEndDate", " >= ", adminTAlias, "FEFFDT");
            } else if ("\"CAL_COSTORGT\"".equalsIgnoreCase(adminTAlias)) {
                this.appendCommonJoinOnCondition(null, sql, adminTAlias, "FAdminOrgID", " = ", "\"CAL_COSTORG\"", "FhistoryRelateID");
                this.appendCommonJoinOnCondition(" AND ", sql, "\"CAL_COSTORG\"", "FLEFFDT", " <= ", adminTAlias, "FLEFFDT");
                this.appendCommonJoinOnCondition(" AND ", sql, "\"CAL_COSTORG\"", "FLEFFDT", " >= ", adminTAlias, "FEFFDT");
            } else {
                this.appendCommonJoinOnCondition(null, sql, adminAlias, "FhistoryRelateID", " = ", adminTAlias, "FAdminOrgID");
                this.appendCommonJoinOnCondition(" AND ", sql, "CMP_CTB", "FRealEndDate", " <= ", adminTAlias, "FLEFFDT");
                this.appendCommonJoinOnCondition(" AND ", sql, "CMP_CTB", "FRealEndDate", " >= ", adminTAlias, "FEFFDT");
            }
        } else {
            this.appendCommonJoinOnCondition(null, sql, adminAlias, "FhistoryRelateID", " = ", adminTAlias, "FAdminOrgID");
            this.appendCommonJoinOnCondition(" AND ", sql, adminTAlias, "FEFFDT", " <= ", adminTAlias, "FLEFFDT");
            this.appendCommonJoinOnCondition(" AND ", sql, adminTAlias, "FEFFDT", " >= ", adminTAlias, "FEFFDT");
        }
        return sql;
    }

    protected String assembleSQLWhereWithOrderAndGroup() throws EASBizException, BOSException {
        String groupbySql;
        StringBuffer sql = new StringBuffer();
        String whereSql = this.assembleSQLWhere();
        sql.append(whereSql);
        String orderSql = this.assembleSQLOrderby();
        if (!StringUtils.isEmpty((String)orderSql)) {
            sql.append(" ORDER BY ").append(orderSql);
        }
        if (this.param.isNeedGropBy() && !StringUtils.isEmpty((String)(groupbySql = this.assembleSQLGroupby()))) {
            sql.append(" GROUP BY ").append(groupbySql);
        }
        sql.append(" ");
        return sql.toString();
    }

    public static class PERFWEB001SHRSqlBuilderInst {
        private static final PERFWEB001SHRSqlBuilder instance = new PERFWEB001SHRSqlBuilder();
    }
}

