/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.comprehensive.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.shr.compensation.app.calculate.CmpCalConfigQueuEnum;
import com.kingdee.shr.perfweb.comprehensive.utils.SumCalThreadPoolExecutor;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;

public class SumCalThreadPoolManger {
    private static volatile SumCalThreadPoolExecutor pool;

    private SumCalThreadPoolManger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SumCalThreadPoolExecutor getInstance(Context ctx) throws BOSException {
        if (null != pool) return pool;
        Class<SumCalThreadPoolManger> clazz = SumCalThreadPoolManger.class;
        synchronized (SumCalThreadPoolManger.class) {
            if (null != pool) return pool;
            int processors = Runtime.getRuntime().availableProcessors();
            int queueSize = 500;
            pool = new SumCalThreadPoolExecutor(processors, processors, 0L, TimeUnit.SECONDS, SumCalThreadPoolManger.getBlockingQueue(CmpCalConfigQueuEnum.LinkedBlockingQueue, queueSize));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return pool;
        }
    }

    private static BlockingQueue<Runnable> getBlockingQueue(CmpCalConfigQueuEnum queueEnum, int size) {
        switch (queueEnum.getValue()) {
            case 10: {
                return new ArrayBlockingQueue<Runnable>(size);
            }
            case 20: {
                return new LinkedBlockingQueue<Runnable>(size);
            }
            case 30: {
                return new PriorityBlockingQueue<Runnable>(size);
            }
        }
        return new ArrayBlockingQueue<Runnable>(size);
    }

    public static Future<Runnable> addTask(Context ctx, Runnable runnable) throws BOSException {
        return SumCalThreadPoolManger.getInstance(ctx).submit(runnable);
    }
}

