/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.formulaplatform.data;

import com.kingdee.shr.perfweb.formulaplatform.data.DataTable;
import java.util.ArrayList;
import java.util.Hashtable;

public class DataSet {
    ArrayList tables = new ArrayList();
    Hashtable hstables = new Hashtable();

    public void addTable(DataTable dt) {
        if (this.hstables.containsKey(dt.tablename)) {
            this.tables.add(dt);
            return;
        }
        int i = this.tables.size();
        this.hstables.put(dt.tablename, new Integer(i));
        this.tables.add(dt);
    }

    public DataTable getTables(int index) {
        if (!this.testArray(this.tables, index)) {
            throw new RuntimeException("index out of range");
        }
        return (DataTable)this.tables.get(index);
    }

    public DataTable getTables(String name) {
        Integer findedindex = (Integer)this.hstables.get(name);
        if (findedindex == null) {
            throw new RuntimeException("No matching table:" + name + ".");
        }
        return (DataTable)this.tables.get(findedindex);
    }

    public boolean isExistedTable(String name) {
        Integer findedindex;
        return this.hstables != null && this.hstables.get(name) != null && (findedindex = (Integer)this.hstables.get(name)) != null && this.tables.get(findedindex) != null;
    }

    private void refreshIndex() {
        if (this.tables == null || this.tables.size() == 0) {
            return;
        }
        for (int i = 0; i < this.tables.size(); ++i) {
            DataTable dt = (DataTable)this.tables.get(i);
            this.hstables.put(dt.tablename, new Integer(i));
        }
    }

    public void removeTable(int index) {
        String tablename = this.getTables(index).TableName();
        this.hstables.remove(tablename);
        this.tables.remove(index);
        this.refreshIndex();
    }

    public void removeTable(String name) {
        Integer findedindex = (Integer)this.hstables.get(name);
        if (findedindex == null) {
            throw new RuntimeException("No matching table:" + name + ".");
        }
        this.hstables.remove(name);
        this.tables.remove(findedindex);
        this.refreshIndex();
    }

    public int tableCount() {
        if (this.tables == null) {
            return 0;
        }
        return this.tables.size();
    }

    protected boolean testArray(ArrayList list, int index) {
        if (list == null) {
            return false;
        }
        return index >= 0 && index < list.size();
    }
}

