/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.jdbc;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.jdbc.ForEachDynamicTagHandler;
import com.kingdee.shr.perfweb.jdbc.IDynamicTagHandler;
import com.kingdee.shr.perfweb.jdbc.ResultMapBean;
import com.kingdee.shr.perfweb.jdbc.SelectNode;
import com.kingdee.shr.perfweb.jdbc.exception.SqlMapNoTargetSqlMapFoundException;
import com.kingdee.shr.perfweb.jdbc.utils.ClassUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlMapClient {
    private static Logger logger = LoggerFactory.getLogger(SqlMapClient.class);
    private static SqlMapClient sqlMapClient;
    private static String DIALECT;
    public static String OS_NAME;
    private Map<String, SelectNode> maps = new HashMap<String, SelectNode>();
    private List<String> files = new ArrayList<String>();
    private List<IDynamicTagHandler> handlers = new ArrayList<IDynamicTagHandler>();
    private Map<String, List<ResultMapBean>> resultMaps = new HashMap<String, List<ResultMapBean>>();

    private SqlMapClient() {
    }

    public static synchronized SqlMapClient newInstance() {
        if (sqlMapClient != null) {
            SqlMapClient.init();
            return sqlMapClient;
        }
        SqlMapClient.init();
        return sqlMapClient;
    }

    private static void init() {
        sqlMapClient = new SqlMapClient();
        String windowsFile = "src/com/kingdee/eas/custom/jdbc/client/template_importSqlMap.xml";
        try {
            if (OS_NAME.indexOf("WINDOWS") >= 0) {
                sqlMapClient.addSingleSqlMap(windowsFile);
            } else if (OS_NAME.indexOf("LINUX") >= 0) {
                sqlMapClient.addSingleSqlMap("template_importSqlMap.xml");
            }
        }
        catch (MalformedURLException e) {
            logger.error("MalformedURLException: ", (Throwable)e);
        }
        catch (DocumentException e) {
            logger.error("DocumentException: ", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("UnsupportedEncodingException: ", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error("FileNotFoundException: ", (Throwable)e);
        }
        sqlMapClient.setDynamicTagHandler(new ForEachDynamicTagHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlMapClient addSingleSqlMap(String filePath) throws MalformedURLException, DocumentException, UnsupportedEncodingException, FileNotFoundException {
        if (filePath == null) {
            return this;
        }
        String fullPath = "";
        if (OS_NAME.contains("WINDOWS")) {
            fullPath = filePath;
        } else if (OS_NAME.contains("LINUX")) {
            String currentPath = SqlMapClient.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            String configPath = currentPath.substring(0, currentPath.lastIndexOf("/")) + "/config";
            fullPath = configPath + "/" + filePath;
        }
        File f = new File(fullPath);
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        SAXReader reader = new SAXReader();
        try {
            fileInputStream = new FileInputStream(f);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            Document doc = reader.read((Reader)inputStreamReader);
            Element el = doc.getRootElement();
            String namespace = el.attributeValue("namespace");
            Iterator it = el.elementIterator();
            while (it.hasNext()) {
                Element el_0 = (Element)it.next();
                if (el_0.getName() == "import") {
                    if (OS_NAME.indexOf("LINUX") >= 0) {
                        this.addSingleSqlMap(el_0.attributeValue("linuxSrc"));
                        continue;
                    }
                    if (OS_NAME.indexOf("WINDOWS") < 0) continue;
                    this.addSingleSqlMap(el_0.attributeValue("src"));
                    continue;
                }
                if (el_0.getName() == "resultMap") {
                    Iterator it2 = el_0.elementIterator();
                    ArrayList<ResultMapBean> re = new ArrayList<ResultMapBean>();
                    this.resultMaps.put(el_0.attributeValue("id"), re);
                    while (it2.hasNext()) {
                        Element el_0_0 = (Element)it2.next();
                        if (el_0_0.getName() != "result") continue;
                        ResultMapBean bean = new ResultMapBean();
                        re.add(bean);
                        bean.setColumn(el_0_0.attributeValue("column"));
                        bean.setProperty(el_0_0.attributeValue("property"));
                        bean.setType(el_0_0.attributeValue("type"));
                    }
                    continue;
                }
                String paramterClass = el_0.attributeValue("parameterClass");
                String resultClass = el_0.attributeValue("resultClass");
                String resultMap = el_0.attributeValue("resultMap");
                String id = el_0.attributeValue("id");
                SelectNode select = new SelectNode(el_0, null, namespace, paramterClass, id);
                select.setResultClass(resultClass);
                select.setResultMap(resultMap);
                this.maps.put(select.getUri(), select);
            }
        }
        finally {
            if (null != inputStreamReader) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException e) {
                    logger.error("addSingleSqlMap IOException: ", (Throwable)e);
                }
            }
            if (null != fileInputStream) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    logger.error("addSingleSqlMap IOException: ", (Throwable)e);
                }
            }
        }
        return this;
    }

    public String parseSqlString(String sqlId, Object obj) throws Exception {
        SelectNode node = this.getDeepCloneNode(sqlId);
        if (node == null) {
            throw new SqlMapNoTargetSqlMapFoundException(sqlId);
        }
        return DIALECT + node.getParsedString(obj);
    }

    public void addDynamicTagHandler(IDynamicTagHandler handler) {
        if (handler != null) {
            this.handlers.add(handler);
        }
    }

    public List selectList(String sqlId, Object obj) throws Exception {
        ArrayList<Map> result = new ArrayList<Map>();
        SelectNode node = this.getDeepCloneNode(sqlId);
        if (node == null) {
            throw new SqlMapNoTargetSqlMapFoundException(sqlId);
        }
        String sql = this.parseSqlString(sqlId, obj);
        IRowSet rowSet = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
        String resultClass = node.getResultClass();
        String resultMap = node.getResultMap();
        while (rowSet.next()) {
            Object value = null;
            if (resultMap != null) {
                List<ResultMapBean> configs = this.resultMaps.get(resultMap);
                value = this.singleRow2Map(rowSet, configs);
            } else {
                value = resultClass == null || resultClass == "java.util.HashMap" ? ClassUtil.singleRowSet2Map(rowSet) : ClassUtil.singleRowSet2Entity(rowSet, resultClass);
            }
            result.add((Map)value);
        }
        return result;
    }

    public List selectList(Context ctx, String sqlId, Object obj) throws Exception {
        if (ctx == null) {
            return this.selectList(sqlId, obj);
        }
        ArrayList<Map> result = new ArrayList<Map>();
        SelectNode node = this.getDeepCloneNode(sqlId);
        if (node == null) {
            throw new SqlMapNoTargetSqlMapFoundException(sqlId);
        }
        String sql = this.parseSqlString(sqlId, obj);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        String resultClass = node.getResultClass();
        String resultMap = node.getResultMap();
        while (rowSet.next()) {
            Object value = null;
            if (resultMap != null) {
                List<ResultMapBean> configs = this.resultMaps.get(resultMap);
                value = this.singleRow2Map(rowSet, configs);
            } else {
                value = resultClass == null || resultClass == "java.util.HashMap" ? ClassUtil.singleRowSet2Map(rowSet) : ClassUtil.singleRowSet2Entity(rowSet, resultClass);
            }
            result.add((Map)value);
        }
        return result;
    }

    public List executeQuerySql(Context ctx, String sql) throws Exception {
        ArrayList<Map> result = new ArrayList<Map>();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        String resultClass = "java.util.HashMap";
        String resultMap = "java.util.HashMap";
        while (rowSet.next()) {
            Object value = null;
            if (resultMap != null) {
                List<ResultMapBean> configs = this.resultMaps.get(resultMap);
                value = this.singleRow2Map(rowSet, configs);
            } else {
                value = resultClass == null || resultClass == "java.util.HashMap" ? ClassUtil.singleRowSet2Map(rowSet) : ClassUtil.singleRowSet2Entity(rowSet, resultClass);
            }
            result.add((Map)value);
        }
        return result;
    }

    @Deprecated
    public List<Map> selectListAsLowKeyMap(Context ctx, String sqlId, Object obj) throws Exception {
        if (ctx == null) {
            return this.selectList(sqlId, obj);
        }
        ArrayList<Map> result = new ArrayList<Map>();
        SelectNode node = this.getDeepCloneNode(sqlId);
        if (node == null) {
            throw new SqlMapNoTargetSqlMapFoundException(sqlId);
        }
        String sql = this.parseSqlString(sqlId, obj);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        String resultClass = node.getResultClass();
        while (rowSet.next()) {
            Map value = null;
            if (resultClass == null || resultClass == "java.util.HashMap") {
                value = ClassUtil.singleRowSet2LowKeyMap(rowSet);
            }
            result.add(value);
        }
        return result;
    }

    public void insert(String sqlId, Object obj) throws Exception {
        ArrayList result = new ArrayList();
        SelectNode node = this.getDeepCloneNode(sqlId);
        if (node == null) {
            throw new SqlMapNoTargetSqlMapFoundException(sqlId);
        }
        String sql = this.parseSqlString(sqlId, obj);
        FMIsqlFacadeFactory.getRemoteInstance().executeSql(sql);
    }

    public void insert(Context ctx, String sqlId, Object obj) throws Exception {
        ArrayList result = new ArrayList();
        SelectNode node = this.getDeepCloneNode(sqlId);
        if (node == null) {
            throw new SqlMapNoTargetSqlMapFoundException(sqlId);
        }
        String sql = this.parseSqlString(sqlId, obj);
        DbUtil.execute((Context)ctx, (String)sql);
    }

    public void execute(Context ctx, String sqlId, Object obj) throws Exception {
        SelectNode node = this.getDeepCloneNode(sqlId);
        if (node == null) {
            throw new SqlMapNoTargetSqlMapFoundException(sqlId);
        }
        String sql = this.parseSqlString(sqlId, obj);
        DbUtil.execute((Context)ctx, (String)sql);
    }

    public void execute(Context ctx, String sql) throws Exception {
        DbUtil.execute((Context)ctx, (String)sql);
    }

    public List<IDynamicTagHandler> getHandlers() {
        return this.handlers;
    }

    public void setDynamicTagHandler(IDynamicTagHandler handler) {
        if (!this.handlers.isEmpty()) {
            for (IDynamicTagHandler h : this.handlers) {
                if (!h.getClass().equals(handler.getClass())) continue;
                return;
            }
        }
        this.handlers.add(handler);
        if (!this.maps.isEmpty()) {
            Set<String> selectNodes = this.maps.keySet();
            for (String sn : selectNodes) {
                this.maps.get(sn).setHandler(handler);
            }
        }
    }

    public SelectNode getDeepCloneNode(String id) {
        return this.maps.get(id).deepClone();
    }

    private Map singleRow2Map(IRowSet rowSet, List<ResultMapBean> configs) throws SQLException {
        HashMap<String, String> localMap = new HashMap<String, String>();
        if (rowSet == null || configs == null) {
            return null;
        }
        ResultSetMetaData meta = rowSet.getMetaData();
        int col = meta.getColumnCount();
        for (int i = 1; i <= col; ++i) {
            String key = meta.getColumnName(i);
            String value = rowSet.getString(i);
            for (ResultMapBean bean : configs) {
                if (!bean.getColumn().equalsIgnoreCase(key)) continue;
                localMap.put(bean.getProperty(), value);
            }
        }
        return localMap;
    }

    public Map<String, SelectNode> getMaps() {
        return this.maps;
    }

    public void setMaps(Map<String, SelectNode> maps) {
        this.maps = maps;
    }

    static {
        DIALECT = "/*dialect*/";
        OS_NAME = System.getProperty("os.name").toUpperCase();
    }
}

