/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.DeepClone;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsProgressCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsProgressFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsProgressInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetHISFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetHISInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetHISFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetHISInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetInfo;
import com.kingdee.shr.perfweb.app.base.targetprocess.ITargetReviseBill;
import com.kingdee.shr.perfweb.app.base.targetprocess.TargetReviseBillCollection;
import com.kingdee.shr.perfweb.app.base.targetprocess.TargetReviseBillFactory;
import com.kingdee.shr.perfweb.app.base.targetprocess.TargetReviseBillInfo;
import com.kingdee.shr.perfweb.bean.AttachmentsBean;
import com.kingdee.shr.perfweb.exception.SHRPerfWebException;
import com.kingdee.shr.perfweb.osf.GetMyGoalsScheduleService;
import com.kingdee.shr.perfweb.osf.converter.CoreConverter;
import com.kingdee.shr.perfweb.osf.model.SimpleFieldInfo;
import com.kingdee.shr.perfweb.osf.teamPersonalTarget.CompositeEvaObjectDataService;
import com.kingdee.shr.perfweb.portal.bean.AreaFieldBean;
import com.kingdee.shr.perfweb.portal.bean.EvaAreaListBean;
import com.kingdee.shr.perfweb.portal.bean.PersonalEvaBaseBean;
import com.kingdee.shr.perfweb.portal.serviceImpl.PerfGoalsHisService;
import com.kingdee.shr.perfweb.portal.serviceImpl.PerfGoasFillService;
import com.kingdee.shr.perfweb.portal.serviceImpl.TargetRelationService;
import com.kingdee.shr.perfweb.util.AttachmentUtil;
import com.kingdee.shr.perfweb.util.MetaDataUtil;
import com.kingdee.shr.perfweb.utils.IndicatorUtils;
import com.kingdee.shr.perfweb.utils.MapUtils;
import com.kingdee.shr.perfweb.utils.PermissionUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class GetMyGoalsDetailService
implements IHRMsfService {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.osf.GetMyGoalsDetailService");
    private static final String GOALSPROCESSTYPE = "1";
    private static final String TARGETREVISETYPE = "2";

    public Object process(Context ctx, Map map) throws EASBizException, BOSException {
        String periodId = (String)map.get("periodId");
        String evaObj = (String)map.get("evaObj");
        String gradeTaskNode = (String)map.get("gradeTaskNode");
        String type = (String)map.get("type");
        HashMap<String, Object> result = new HashMap<String, Object>();
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        Map<String, Object> indecatorsMap = null;
        try {
            if (TARGETREVISETYPE.equals(type)) {
                TargetReviseBillInfo targetReviseBillInfo = this.getTargetReviseBillInfo(ctx, map);
                String targetReviseBillId = targetReviseBillInfo.getId().toString();
                indecatorsMap = PerfGoalsHisService.getInstance().compositeEvaObjectDataAction(ctx, evaObj, targetReviseBillId);
                result.put("targetReviseBill.state", targetReviseBillInfo.getBillState());
                result.put("targetReviseBill.id", targetReviseBillInfo.getId().toString());
            } else {
                indecatorsMap = PerfGoasFillService.getInstance().compositeEvaObjectDataAction(ctx, evaObj, gradeTaskNode, "0", null, null, null);
            }
            this.setTargetFieldsInfo(ctx, map, indecatorsMap, GOALSPROCESSTYPE.equals(type));
            boolean perfSumInterview = PermissionUtils.hasFunctionPermission(ctx, "targetDecompose");
            result.put("targetDecompose", perfSumInterview);
            boolean progressUpdate = PermissionUtils.hasFunctionPermission(ctx, "progressUpdate");
            result.put("progressUpdate", progressUpdate);
            result.put("personBase", GetMyGoalsDetailService.getPersonBaseData(ctx, personId, periodId));
            result.put("indecators", indecatorsMap);
        }
        catch (SHRPerfWebException e) {
            logger.error("get myGoalsDetail err", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("get myGoalsDetail err", (Throwable)e);
        }
        return result;
    }

    private TargetReviseBillInfo getTargetReviseBillInfo(Context ctx, Map map) throws BOSException, EASBizException {
        ObjectBaseInfo hisInfo;
        ObjectBaseInfo targetInfo;
        int i;
        String evaObj = (String)map.get("evaObj");
        ITargetReviseBill instance = TargetReviseBillFactory.getLocalInstance(ctx);
        TargetReviseBillCollection coll = instance.getTargetReviseBillCollection("where evaObj='" + evaObj + "' and billState in (0,1,2)");
        if (coll != null && coll.size() > 0) {
            return coll.get(0);
        }
        TargetReviseBillInfo info = new TargetReviseBillInfo();
        BOSUuid id = BOSUuid.create((String)"789163AE");
        info.put("id", id);
        info.put("evaObj", evaObj);
        info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        info.setBillState(HRBillStateEnum.SAVED);
        info.setNumber("NO" + System.currentTimeMillis());
        IndicatorTargetCollection indicators = IndicatorTargetFactory.getRemoteInstance().getIndicatorTargetCollection("WHERE EVAOBJ = '" + evaObj + "'");
        RecordTargetCollection records = RecordTargetFactory.getRemoteInstance().getRecordTargetCollection("where evaObj = '" + evaObj + "'");
        CoreBaseCollection targetCoreBaseCollection = new CoreBaseCollection();
        CoreBaseCollection recordCollection = new CoreBaseCollection();
        for (i = 0; i < indicators.size(); ++i) {
            targetInfo = indicators.get(i);
            hisInfo = new IndicatorTargetHISInfo();
            IndicatorUtils.convertIndicatorTargetAndHistory((IndicatorTargetHISInfo)hisInfo, targetInfo);
            hisInfo.setHistoryRelateId(targetInfo.getId());
            hisInfo.put("targetReviseBill", info.get("id"));
            hisInfo.setId(null);
            targetCoreBaseCollection.add((CoreBaseInfo)hisInfo);
        }
        for (i = 0; i < records.size(); ++i) {
            targetInfo = records.get(i);
            hisInfo = new RecordTargetHISInfo();
            IndicatorUtils.convertRecordTargetAndHistory((RecordTargetHISInfo)hisInfo, (RecordTargetInfo)targetInfo);
            hisInfo.setHistoryRelateId(targetInfo.getId());
            hisInfo.put("targetReviseBillId", info.get("id"));
            hisInfo.setId(null);
            recordCollection.add((CoreBaseInfo)hisInfo);
        }
        IndicatorTargetHISFactory.getLocalInstance(ctx).save(targetCoreBaseCollection);
        RecordTargetHISFactory.getLocalInstance(ctx).save(recordCollection);
        instance.save((CoreBaseInfo)info);
        return info;
    }

    private List<AreaFieldBean> getGoalsProcessFields(Context ctx, Map map, boolean isRecord) throws SQLException, EASBizException, BOSException {
        String entityName = "com.kingdee.shr.perfweb.app.base.evalplan.GoalsProgress";
        List<SimpleFieldInfo> goalsProcessFieldInfos = new CoreConverter().buildSimpleFieldsByModel(ctx, entityName, map);
        Map<String, PropertyInfo> properties = MetaDataUtil.getProperties(ctx, entityName);
        ArrayList<AreaFieldBean> goalsProcessFields = new ArrayList<AreaFieldBean>();
        for (SimpleFieldInfo simpleFieldInfo : goalsProcessFieldInfos) {
            String fieldName = simpleFieldInfo.getFieldName();
            if (properties.get(fieldName) == null || isRecord && (fieldName.equalsIgnoreCase("targetValue") || fieldName.equalsIgnoreCase("actualCompleValue"))) continue;
            AreaFieldBean goalsProcessFieldBean = new AreaFieldBean();
            String showName = simpleFieldInfo.getShowName();
            if (!LocaleUtils.locale_L2.equals(ctx.getLocale())) {
                showName = properties.get(fieldName).getAlias(ctx.getLocale());
            }
            goalsProcessFieldBean.setShowName(showName);
            goalsProcessFieldBean.setColName(simpleFieldInfo.getFieldName());
            goalsProcessFieldBean.setRequired(simpleFieldInfo.isRequired());
            goalsProcessFieldBean.setFieldType(simpleFieldInfo.getFieldType());
            goalsProcessFieldBean.setOptions(simpleFieldInfo.getOptions());
            goalsProcessFieldBean.setHidden(simpleFieldInfo.isHidden());
            goalsProcessFields.add(goalsProcessFieldBean);
        }
        return goalsProcessFields;
    }

    private void setTargetFieldsInfo(Context ctx, Map map, Map<String, Object> indecatorsMap, boolean setGoaslProgress) throws BOSException, EASBizException, SQLException, SHRPerfWebException {
        String evaObj = (String)map.get("evaObj");
        HashMap<String, String> indParamMap = new HashMap<String, String>();
        indParamMap.put("fieldList", MapUtils.getParam(map, "indFieldList"));
        HashMap<String, String> recParamMap = new HashMap<String, String>();
        recParamMap.put("fieldList", MapUtils.getParam(map, "recFieldList"));
        HashSet<String> targetIds = new HashSet<String>();
        List<AreaFieldBean> goalsProcessFields = null;
        List<AreaFieldBean> recordGoalsProcessFields = null;
        if (setGoaslProgress) {
            HashMap<String, String> progParamMap = new HashMap<String, String>();
            progParamMap.put("fieldList", MapUtils.getParam(map, "progFieldList"));
            goalsProcessFields = this.getGoalsProcessFields(ctx, progParamMap, false);
            recordGoalsProcessFields = this.getGoalsProcessFields(ctx, progParamMap, true);
        }
        CompositeEvaObjectDataService compositeDataService = new CompositeEvaObjectDataService();
        Map<String, SimpleFieldInfo> indFieMap = compositeDataService.listToMap(new CoreConverter().buildSimpleFieldsByModel(ctx, "com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTarget", indParamMap));
        Map<String, SimpleFieldInfo> recFieMap = compositeDataService.listToMap(new CoreConverter().buildSimpleFieldsByModel(ctx, "com.kingdee.shr.perfweb.app.base.evalplan.RecordTarget", recParamMap));
        HashMap<String, Map<String, Boolean>> fieldMap = TargetRelationService.getInstance().getIsShowFields(ctx, evaObj);
        PersonalEvaBaseBean row = (PersonalEvaBaseBean)indecatorsMap.get("rows");
        if (row != null) {
            for (EvaAreaListBean areaBean : row.getEvaAreaList()) {
                ArrayList<HashMap<String, Object>> arrayList;
                Object item2;
                String baseColName;
                if (areaBean.getAreaType().equals("200")) {
                    for (AreaFieldBean areaFieldBean : areaBean.getFieldList()) {
                        baseColName = areaFieldBean.getColName().substring(1);
                        SimpleFieldInfo simpleFieldInfo = indFieMap.get(baseColName);
                        this.hideEvaluateFields(areaFieldBean, simpleFieldInfo);
                    }
                }
                if (areaBean.getAreaType().equals("300")) {
                    for (AreaFieldBean areaFieldBean : areaBean.getFieldList()) {
                        baseColName = areaFieldBean.getColName().substring(1);
                        SimpleFieldInfo simpleFieldInfo = recFieMap.get(baseColName);
                        this.hideEvaluateFields(areaFieldBean, simpleFieldInfo);
                    }
                }
                if (!setGoaslProgress) continue;
                ArrayList<HashMap<String, Object>> indicatorList = areaBean.getEvaIndicatorList();
                if (!CollectionUtils.isEmpty(indicatorList)) {
                    for (Object item2 : indicatorList) {
                        targetIds.add((String)((HashMap)item2).get("FID"));
                    }
                }
                if (CollectionUtils.isEmpty(arrayList = areaBean.getEvaRecordList())) continue;
                item2 = arrayList.iterator();
                while (item2.hasNext()) {
                    HashMap hashMap = (HashMap)item2.next();
                    targetIds.add((String)hashMap.get("FID"));
                }
            }
        }
        if (setGoaslProgress) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("target", targetIds, CompareType.INCLUDE));
            SorterItemCollection sorter = new SorterItemCollection();
            SorterItemInfo sorterItemInfo = new SorterItemInfo();
            sorterItemInfo.setPropertyName("lastUpdateTime");
            sorterItemInfo.setSortType(SortType.DESCEND);
            sorter.add(sorterItemInfo);
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(filterInfo);
            entityViewInfo.setSorter(sorter);
            GoalsProgressCollection goalsProgressColls = GoalsProgressFactory.getLocalInstance(ctx).getGoalsProgressCollection(entityViewInfo);
            ArrayList<String> arrayList = new ArrayList<String>();
            HashMap<String, List<Map<String, Object>>> goalsProgressMap = new HashMap<String, List<Map<String, Object>>>();
            if (goalsProgressColls != null && !goalsProgressColls.isEmpty()) {
                Object target;
                Iterator it = goalsProgressColls.iterator();
                while (it.hasNext()) {
                    GoalsProgressInfo goalsProgressInfo = (GoalsProgressInfo)it.next();
                    target = goalsProgressInfo.getTarget();
                    ArrayList progressInfos = (ArrayList)goalsProgressMap.get(target);
                    if (progressInfos == null) {
                        progressInfos = new ArrayList();
                    }
                    HashMap<String, GoalsProgressInfo> progressInfo = new HashMap<String, GoalsProgressInfo>();
                    progressInfo.put("process", goalsProgressInfo);
                    progressInfos.add(progressInfo);
                    goalsProgressMap.put((String)target, progressInfos);
                    arrayList.add(goalsProgressInfo.getId().toString());
                }
                List<AttachmentsBean> attachmentList = AttachmentUtil.getAttachments(ctx, evaObj, arrayList);
                HashMap<Object, ArrayList<AttachmentsBean>> attachmentMap = new HashMap<Object, ArrayList<AttachmentsBean>>();
                target = attachmentList.iterator();
                while (target.hasNext()) {
                    AttachmentsBean attachmentsBean = (AttachmentsBean)target.next();
                    String processId = attachmentsBean.getPermission();
                    ArrayList<AttachmentsBean> attachments = (ArrayList<AttachmentsBean>)attachmentMap.get(processId);
                    if (attachments == null) {
                        attachments = new ArrayList<AttachmentsBean>();
                    }
                    attachments.add(attachmentsBean);
                    attachmentMap.put(processId, attachments);
                }
                for (Map.Entry goalsItems : goalsProgressMap.entrySet()) {
                    for (Map goalsItem : (List)goalsItems.getValue()) {
                        GoalsProgressInfo goalsProgressInfo = (GoalsProgressInfo)goalsItem.get("process");
                        goalsItem.put("attachments", attachmentMap.get(goalsProgressInfo.getId().toString()));
                    }
                }
            }
            try {
                for (EvaAreaListBean evaAreaListBean : row.getEvaAreaList()) {
                    ArrayList<HashMap<String, Object>> recordList;
                    String areaId = evaAreaListBean.getAreaId();
                    Map<String, Boolean> fieldItem = fieldMap.get(areaId);
                    List gpFieldsForArea = (List)DeepClone.deepClone(goalsProcessFields);
                    Iterator it = gpFieldsForArea.iterator();
                    while (it.hasNext()) {
                        AreaFieldBean goalsFieldItem = (AreaFieldBean)it.next();
                        if (goalsFieldItem.getColName().equals("targetValue") && (fieldItem == null || fieldItem.get("isTargetValue") == null || !fieldItem.get("isTargetValue").booleanValue())) {
                            it.remove();
                        }
                        if (!goalsFieldItem.getColName().equals("actualCompleValue") || fieldItem != null && fieldItem.get("isActualCompleValue") != null && fieldItem.get("isActualCompleValue").booleanValue()) continue;
                        it.remove();
                    }
                    ArrayList<HashMap<String, Object>> indicatorList = evaAreaListBean.getEvaIndicatorList();
                    if (!CollectionUtils.isEmpty(indicatorList)) {
                        this.combineProgressInfo(indicatorList, goalsProgressMap, gpFieldsForArea);
                    }
                    if (CollectionUtils.isEmpty(recordList = evaAreaListBean.getEvaRecordList())) continue;
                    this.combineProgressInfo(recordList, goalsProgressMap, recordGoalsProcessFields);
                }
            }
            catch (IOException e) {
                logger.error("deep clone err", (Throwable)e);
            }
        }
    }

    private void hideEvaluateFields(AreaFieldBean fieldBean, SimpleFieldInfo fieldInfo) {
        String baseColName = fieldBean.getColName().substring(1);
        if (fieldInfo != null) {
            fieldBean.setFieldType(fieldInfo.getFieldType());
            fieldBean.setOptions(fieldInfo.getOptions());
            fieldBean.setHidden(fieldInfo.isHidden());
            fieldBean.setDataSource(fieldInfo.getDataSource());
        }
        if (baseColName.equalsIgnoreCase("COMMENT") || baseColName.equalsIgnoreCase("SCORE") || baseColName.equalsIgnoreCase("ACTUALCOMPLEVALUE") || baseColName.equalsIgnoreCase("ACTUALCOMPLETETIME") || baseColName.equalsIgnoreCase("ACTUALCOMPLETEDESC")) {
            fieldBean.setHidden(true);
        }
    }

    private void combineProgressInfo(List<HashMap<String, Object>> recordList, Map<String, List<Map<String, Object>>> goalsProgressMap, List<AreaFieldBean> recordGoalsProcessFields) {
        for (HashMap<String, Object> item : recordList) {
            String targetId = (String)item.get("FID");
            HashMap<String, Object> copyItem = new HashMap<String, Object>();
            copyItem.putAll(item);
            item.clear();
            item.put("indicator", copyItem);
            List<Map<String, Object>> goalsInfos = goalsProgressMap.get(targetId);
            item.put("goalsProcessList", goalsInfos);
            if (!CollectionUtils.isEmpty(goalsInfos)) {
                item.put("lastGoalsProcess", goalsInfos.get(0));
            } else {
                HashMap targetValue = new HashMap();
                targetValue.put("targetValue", copyItem.get("FTARGETVALUE"));
                HashMap progress = new HashMap();
                progress.put("process", targetValue);
                item.put("lastGoalsProcess", progress);
            }
            item.put("goalsProcessFields", recordGoalsProcessFields);
        }
    }

    private static Map<String, Object> getPersonBaseData(Context ctx, String person, String periodId) {
        String baseSQL = GetMyGoalsScheduleService.getBaseSQL(ctx, person, new HashMap());
        baseSQL = baseSQL + " AND TT.FID = ?";
        HashMap<String, Object> item = new HashMap<String, Object>();
        try {
            Object[] params = new Object[]{periodId};
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)baseSQL, (Object[])params);
            if (rs != null && rs.size() > 0) {
                rs.next();
                item.put("planName", rs.getString("FNAME"));
                item.put("evaluModeName", rs.getString("MODELNAME"));
                item.put("belongOrgName", rs.getString("FBELONGORGNAME"));
                item.put("positionName", rs.getString("FPOSITIONNAME"));
                item.put("periodStatus", GetMyGoalsScheduleService.getEvaPeriodStatuDesc(rs.getInt("FEVAPERIODSTATUS")));
                item.put("periodDate", rs.getString("PERIODNAME"));
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        return item;
    }
}

