/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ResponsibleCollection;
import com.kingdee.bos.workflow.define.ResponsibleDef;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JumpPermissionUtil {
    private static Logger logger = LoggerFactory.getLogger(JumpPermissionUtil.class);

    public static boolean checkProcessOperate(ProcessDef processDef, ProcessInstInfo processInstInfo, String permissionName, boolean isOnlyView, Context ctx) throws EASBizException, BOSException {
        String userName = ctx.getUserName();
        UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUser(userName);
        if (user == null) {
            return false;
        }
        String employeeId = (user.getPerson() == null ? user.getId() : user.getPerson().getId()).toString();
        if (JumpPermissionUtil.checkResponsibles(processDef, employeeId)) {
            return true;
        }
        if (isOnlyView && processInstInfo != null) {
            String initiatorId = processInstInfo.getInitiatorId();
            if (user.getId().toString().equals(initiatorId)) {
                return true;
            }
        }
        IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
        try {
            permission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (OrgType)null, (IObjectPK)null, permissionName);
            return true;
        }
        catch (Exception var10) {
            logger.error("permission check error!", (Throwable)var10);
            return false;
        }
    }

    private static boolean checkResponsibles(ProcessDef processDef, String employeeId) throws EASBizException, BOSException {
        ResponsibleDef resDef;
        String id;
        if (processDef == null) {
            return false;
        }
        ResponsibleCollection respons = processDef.getProcessHeader().getResponsibles();
        if (respons == null) {
            return false;
        }
        Iterator it = respons.iterator();
        do {
            if (it.hasNext()) continue;
            return false;
        } while (!(id = (resDef = (ResponsibleDef)it.next()).getID()).equals(employeeId));
        return true;
    }

    public static boolean canjump(String procInstId, Context ctx) throws Exception {
        IEnactmentService service;
        ProcessInstInfo processInstInfo;
        boolean disableJump = false;
        String parentProcInstId = null;
        if (procInstId.endsWith("WFPCINST") && (processInstInfo = (service = EnactmentServiceFactory.createEnactService((Context)ctx)).getProcessInstInfo(procInstId)) != null) {
            if ("closed.completed".equals(processInstInfo.getState())) {
                disableJump = true;
            }
            parentProcInstId = processInstInfo.getParentProcInstId();
            ProcessDef pdf = service.getProcessDefByDefineHashValue(processInstInfo.getProcDefHashValue());
            if (!JumpPermissionUtil.checkProcessOperate(pdf, null, "", false, ctx)) {
                disableJump = true;
            }
        }
        return disableJump;
    }
}

