/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.shr.perfweb.app.base.perfmancescore.IPerfScorLevelDefine;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScorLevelDefineCollection;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScorLevelDefineFactory;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScorLevelDefineInfo;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class PerfScoreLevelUtils {
    private static final Logger logger = LoggerFactory.getLogger(PerfScoreLevelUtils.class);

    private PerfScoreLevelUtils() {
    }

    public static Map<String, String> getPerfScoreLevelKVAndUpLowInfo(Context ctx, String perfRateId) {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        if (StringUtils.isEmpty((CharSequence)perfRateId)) {
            return ret;
        }
        BigDecimal scoreLowLimit = BigDecimal.ZERO;
        BigDecimal scoreUpLimit = BigDecimal.ZERO;
        PerfScorLevelDefineCollection perfScoreLvlDefineColl = GetEntityInfoUtils.getPerfScorLevelDefineCollection(ctx, perfRateId);
        if (!perfScoreLvlDefineColl.isEmpty()) {
            int size = perfScoreLvlDefineColl.size();
            for (int j = 0; j < size; ++j) {
                PerfScorLevelDefineInfo scoreLvDefineInfo = perfScoreLvlDefineColl.get(j);
                BigDecimal currScoreLowLimit = scoreLvDefineInfo.getScoreLowLimit();
                BigDecimal currScoreUpLimit = scoreLvDefineInfo.getScoreUpLimit();
                ret.put(currScoreLowLimit.setScale(2, RoundingMode.DOWN) + "~" + currScoreUpLimit.setScale(2, RoundingMode.DOWN), scoreLvDefineInfo.getPerfLevelName());
                scoreLowLimit = currScoreLowLimit.compareTo(scoreLowLimit) < 0 ? currScoreLowLimit : scoreLowLimit;
                scoreUpLimit = currScoreUpLimit.compareTo(scoreUpLimit) > 0 ? currScoreUpLimit : scoreUpLimit;
            }
        }
        ret.put("scoreLowLimit", scoreLowLimit.toString());
        ret.put("scoreUpLimit", scoreUpLimit.toString());
        return ret;
    }

    public static String getGradeSelect(String periodId, HashMap<String, ArrayList<String>> gradeNameByPeriods) {
        ArrayList result = new ArrayList();
        if (CollectionUtils.isEmpty(gradeNameByPeriods)) {
            return JSON.toJSONString(result);
        }
        ArrayList<String> arrayList = gradeNameByPeriods.get(periodId);
        if (CollectionUtils.isEmpty(arrayList)) {
            return JSON.toJSONString(result);
        }
        for (String s : arrayList) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("value", s);
            map.put("alias", s);
            result.add(map);
        }
        return JSON.toJSONString(result);
    }

    public static List<String> getGradeNamesByScoreLevelDefine(Context ctx, String perfScoreLevelId) throws BOSException {
        ArrayList<String> result = new ArrayList<String>();
        IPerfScorLevelDefine iPerfScorLevelDefine = PerfScorLevelDefineFactory.getLocalInstance(ctx);
        PerfScorLevelDefineCollection perfScorLevelDefineCollection = iPerfScorLevelDefine.getPerfScorLevelDefineCollection(" where perfScoreLevel = '" + perfScoreLevelId + "' order by showNumber ASC");
        if (perfScorLevelDefineCollection == null || perfScorLevelDefineCollection.size() == 0) {
            return result;
        }
        for (int i = 0; i < perfScorLevelDefineCollection.size(); ++i) {
            PerfScorLevelDefineInfo perfScorLevelDefineInfo = perfScorLevelDefineCollection.get(i);
            result.add(perfScorLevelDefineInfo.getPerfLevelName());
        }
        return result;
    }

    public static String getGradeSelectStr(List<String> gradeNames) {
        ArrayList result = new ArrayList(gradeNames.size());
        if (CollectionUtils.isEmpty(gradeNames)) {
            return JSON.toJSONString(result);
        }
        for (String s : gradeNames) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(2);
            map.put("value", s);
            map.put("alias", s);
            result.add(map);
        }
        return JSON.toJSONString(result);
    }
}

