/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.google.common.base.Strings;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfEmailConfig;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEmailConfigCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEmailConfigFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEmailConfigInfo;
import com.kingdee.shr.perfweb.utils.EmailConfigConst;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.Security;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailUtils {
    private static final Logger logger = LoggerFactory.getLogger(EmailUtils.class);
    private static final int SSL_PORT = 465;
    private static final int NORMAL_PORT = 25;

    public static PerfEmailConfigCollection getEmailServerConfig(Context ctx) {
        PerfEmailConfigCollection perfEmailConfigColl = null;
        try {
            IPerfEmailConfig iPerfEmailConfig = PerfEmailConfigFactory.getLocalInstance(ctx);
            perfEmailConfigColl = iPerfEmailConfig.getPerfEmailConfigCollection(" where type='" + EmailConfigConst.FORSCORETASK + "' order by useCount asc");
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return perfEmailConfigColl;
    }

    public static PerfEmailConfigInfo getUnDefaultEmailServerConfig(Context ctx) {
        PerfEmailConfigCollection perfEmailConfigColl = null;
        PerfEmailConfigInfo perfEmailConfigInfo = null;
        try {
            IPerfEmailConfig iPerfEmailConfig = PerfEmailConfigFactory.getLocalInstance(ctx);
            perfEmailConfigColl = iPerfEmailConfig.getPerfEmailConfigCollection(" where type='" + EmailConfigConst.FORSCORETASK + "' and isDefault=0");
            if (null != perfEmailConfigColl && perfEmailConfigColl.size() > 1) {
                perfEmailConfigInfo = perfEmailConfigColl.get(0);
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return perfEmailConfigInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean connectDetect(final String password, final String from, String server, Boolean isSupportSSL, int emailPort) {
        if (Strings.isNullOrEmpty((String)from) || Strings.isNullOrEmpty((String)server)) {
            logger.error("email sevice validate err, from or server is null");
            return false;
        }
        boolean flag = false;
        Properties props = new Properties();
        props.put("mail.smtp.host", server);
        props.put("mail.smtp.auth", "true");
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.stmp.timeout", "10000");
        props.put("mail.smtp.localhost", "localhost");
        props.setProperty("mail.user", from);
        props.setProperty("mail.password", password);
        if (isSupportSSL.booleanValue()) {
            Security.setProperty("ssl.SocketFactory.provider", "");
            Security.setProperty("ssl.ServerSocketFactory.provider", "");
            props.put("mail.smtp.ssl.enable", "true");
            props.put("mail.smtp.ssl.socketFactory.class", "DummySSLSocketFactory");
            props.put("mail.smtp.ssl.socketFactory.fallback", "false");
            props.put("mail.smtp.starttls.enable", "true");
            props.put("mail.smtp.port", (Object)465);
        } else {
            props.put("mail.smtp.port", (Object)25);
        }
        Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(from, password);
            }
        });
        session.setDebug(false);
        Transport transport = null;
        try {
            transport = session.getTransport("smtp");
            transport.connect(server, emailPort, from, password);
            flag = true;
        }
        catch (Exception e) {
            flag = false;
            logger.error("email sevice err", (Throwable)e);
        }
        finally {
            if (transport != null) {
                try {
                    transport.close();
                }
                catch (MessagingException e) {
                    logger.error("MessagingException: ", (Throwable)e);
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean judgeUrlIsReachable(String url, int port) {
        boolean isReachable = false;
        Socket socket = null;
        try {
            socket = new Socket();
            socket.setSoTimeout(3000);
            InetSocketAddress address = new InetSocketAddress(url, port);
            socket.connect(address, 3000);
            isReachable = true;
        }
        catch (IOException e) {
            isReachable = false;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    logger.error("IOException: ", (Throwable)e);
                }
            }
        }
        return isReachable;
    }
}

