/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.preentry.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.HRInitInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.api.service.SHRCodingRuleApi;
import com.kingdee.shr.preentry.IPreEntry;
import com.kingdee.shr.preentry.PreEntryCollection;
import com.kingdee.shr.preentry.PreEntryFactory;
import com.kingdee.shr.preentry.PreEntryInfo;
import com.kingdee.shr.preentry.PreentryException;
import com.kingdee.shr.preentry.app.AbstractPreEntryFacadeControllerBean;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;

public class PreEntryFacadeControllerBean
extends AbstractPreEntryFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.preentry.app.PreEntryFacadeControllerBean");
    private static final String IS_PREENTRY_NUM_UPDATE_FINISH = "isPreEntryNumUpFinished";
    private static final String UPDATE_FINISH_VALUE = "1";
    private static final String NUMBER_PROPNAME = "number";
    private static final String NEED_UPDATE = "needUpdate";
    private static final String ERRORMSG = "errorMsg";

    @Override
    protected Map _updatePreEntryNumberFromUpGrade(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (this._isUpdateNumFinished(ctx)) {
            resultMap.put(NEED_UPDATE, false);
            return resultMap;
        }
        PreEntryInfo preEntry = new PreEntryInfo();
        if (!SHRCodingRuleApi.hasCodingRule((Context)ctx, (IObjectValue)preEntry, (String)"00000000-0000-0000-0000-000000000000CCE7AED4")) {
            resultMap.put(ERRORMSG, new PreentryException(PreentryException.UPDATE_NO_CODINGRULE).getMessage());
            return resultMap;
        }
        StringBuilder oql = new StringBuilder(" where number is null and id in (select Fid from T_HR_PreEntry where FPrePersonSubID is not null)");
        PreEntryCollection peColl = PreEntryFactory.getLocalInstance(ctx).getPreEntryCollection(oql.toString());
        LinkedList<String[]> list = new LinkedList<String[]>();
        for (int i = 0; i < peColl.size(); ++i) {
            preEntry = peColl.get(i);
            String number = this.getCodingNumber(ctx, preEntry, "00000000-0000-0000-0000-000000000000CCE7AED4");
            if (StringUtils.isEmpty((String)number)) continue;
            list.add(new String[]{number, preEntry.getId().toString()});
        }
        String sql = " update T_HR_PreEntry set Fnumber = ? where Fid = ? ";
        DbUtil.executeBatch((Context)ctx, (String)sql, list);
        this.addUpdateFinishedFlag(ctx);
        resultMap.put(NEED_UPDATE, true);
        return resultMap;
    }

    private String getCodingNumber(Context ctx, PreEntryInfo preEntry, String mainOrgId) throws BOSException, EASBizException {
        String number = null;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        RuleStatus ruleStatus = iCodingRuleManager.getRuleStatus((IObjectValue)preEntry, mainOrgId);
        if (ruleStatus.isExist()) {
            number = ruleStatus.isAddNoBreak() ? iCodingRuleManager.getNonbreakNumber((IObjectValue)preEntry, mainOrgId) : iCodingRuleManager.getNumber((IObjectValue)preEntry, mainOrgId);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(NUMBER_PROPNAME, (Object)number, CompareType.EQUALS));
            IPreEntry ipreEntry = PreEntryFactory.getLocalInstance(ctx);
            int count = 0;
            while (ipreEntry.exists(filter)) {
                number = ruleStatus.isAddNoBreak() ? iCodingRuleManager.getNonbreakNumber((IObjectValue)preEntry, mainOrgId) : iCodingRuleManager.getNumber((IObjectValue)preEntry, mainOrgId);
                if (count >= 1000) break;
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo(NUMBER_PROPNAME, (Object)number, CompareType.EQUALS));
                ++count;
            }
        }
        return number;
    }

    private IObjectPK addUpdateFinishedFlag(Context ctx) throws EASBizException, BOSException {
        HRInitInfo hrInit = new HRInitInfo();
        hrInit.setKey(IS_PREENTRY_NUM_UPDATE_FINISH);
        hrInit.setValue(UPDATE_FINISH_VALUE);
        hrInit.setIsFinish(true);
        hrInit.put("IS_CU_FILTER", (Object)false);
        return HRInitFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)hrInit);
    }

    @Override
    protected boolean _isUpdateNumFinished(Context ctx) throws BOSException, EASBizException {
        StringBuilder oql = new StringBuilder(" where key='").append(IS_PREENTRY_NUM_UPDATE_FINISH).append("' and value = '").append(UPDATE_FINISH_VALUE).append("'");
        return HRInitFactory.getLocalInstance((Context)ctx).exists(oql.toString());
    }
}

