/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.preentry.util;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.cloudservice.CloudServiceConfigCollection;
import com.kingdee.shr.cloudservice.CloudServiceConfigFactory;
import com.kingdee.shr.cloudservice.CloudServiceConfigInfo;
import com.kingdee.shr.cloudservice.CloudServiceURLConfigFactory;
import com.kingdee.shr.cloudservice.CloudServiceURLConfigInfo;
import com.kingdee.shr.cloudservice.ICloudServiceConfig;
import com.kingdee.shr.cloudservice.ICloudServiceURLConfig;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.preentry.PreEntrySmsException;
import com.kingdee.shr.preentry.util.SmsEmpSha256Util;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsEmpHttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(SmsEmpHttpUtils.class);
    public static final String BASE_SEND = "/message/smssend/other/send";

    public static String getServiceUrl(Context ctx) throws EASBizException, BOSException {
        String serviceURL = "";
        try {
            ICloudServiceURLConfig icUrlConfig = CloudServiceURLConfigFactory.getLocalInstance((Context)ctx);
            CloudServiceURLConfigInfo csConfigInfo = icUrlConfig.getCloudServiceURLConfigInfo(" where state = '1' and serviceType= 'BASE'");
            serviceURL = csConfigInfo.getServiceURL();
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        if (!StringUtils.isEmpty((String)serviceURL)) {
            serviceURL = serviceURL + BASE_SEND;
        }
        return serviceURL;
    }

    public static HashMap<String, String> getHeader(Context ctx) throws EASBizException {
        try {
            ICloudServiceConfig irecConfig = CloudServiceConfigFactory.getLocalInstance((Context)ctx);
            HashMap<String, String> header = new HashMap<String, String>();
            CloudServiceConfigCollection coll = irecConfig.getCloudServiceConfigCollection();
            CloudServiceConfigInfo configInfo = null;
            if (coll.size() <= 0) {
                String label0 = SHRServerResource.getString((String)"com.kingdee.shr.preentry.PreEntrySmsResource", (String)"label0", (Context)ctx);
                logger.error("com.kingdee.shr.preentry.util.SmsEmpHttpUtils.getHeader label0:" + label0);
                throw new PreEntrySmsException(PreEntrySmsException.CLOUD_ERR_OTHER);
            }
            configInfo = coll.get(0);
            header.put("tenantId", configInfo.getServiceID());
            header.put("token", configInfo.getAccessToken());
            return header;
        }
        catch (BOSException e) {
            String label0 = SHRServerResource.getString((String)"com.kingdee.shr.preentry.PreEntrySmsResource", (String)"label0", (Context)ctx);
            logger.error("com.kingdee.shr.preentry.util.SmsEmpHttpUtils.getHeader label0 e:" + label0 + e.getMessage());
            throw new PreEntrySmsException(PreEntrySmsException.CLOUD_ERR_OTHER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendMessage(Context ctx, Map<String, String> params, String phone, String content) throws EASBizException, BOSException {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        String serviceUrl = SmsEmpHttpUtils.getServiceUrl(ctx);
        HashMap<String, String> header = SmsEmpSha256Util.getHeader(ctx, phone, content);
        HttpPost httpPost = new HttpPost(serviceUrl);
        httpPost.addHeader("accept", "*/*");
        httpPost.addHeader("content-Type", "application/json");
        if (!header.isEmpty()) {
            Set<Map.Entry<String, String>> headEntrys = header.entrySet();
            for (Map.Entry<String, String> entry : headEntrys) {
                httpPost.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (!params.isEmpty()) {
            JSONObject jsonObject = new JSONObject();
            Set<Map.Entry<String, String>> paramEntrys = params.entrySet();
            for (Map.Entry<String, String> entry : paramEntrys) {
                jsonObject.put(entry.getKey(), (Object)entry.getValue());
            }
            StringEntity stringEntity = new StringEntity(jsonObject.toString(), ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)stringEntity);
        }
        String result = "";
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            HttpEntity httpEntity = response.getEntity();
            String string = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            JSONObject successObject = new JSONObject();
            successObject.put("code", (Object)response.getStatusLine().getStatusCode());
            successObject.put("data", (Object)string);
            result = successObject.toJSONString();
            logger.error("com.kingdee.shr.preentry.util.SmsEmpHttpUtils.sendMessage result:" + result);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("code", (Object)"400");
            result = jSONObject.toJSONString();
        }
        finally {
            try {
                client.close();
            }
            catch (IOException e) {
                logger.error("com.kingdee.shr.preentry.util.SmsEmpHttpUtils.sendMessage e:" + e.toString());
            }
        }
        return result;
    }
}

