/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.shareservice.ActivityFieldEntryFactory;
import com.kingdee.shr.shareservice.ActivityFieldFactory;
import com.kingdee.shr.shareservice.ActivityFieldInfo;
import com.kingdee.shr.shareservice.IActivityField;
import com.kingdee.shr.shareservice.SSCActivityException;
import com.kingdee.shr.shareservice.StateEnum;
import com.kingdee.shr.shareservice.app.AbstractActivityFieldControllerBean;
import org.apache.log4j.Logger;

public class ActivityFieldControllerBean
extends AbstractActivityFieldControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.shareservice.app.ActivityFieldControllerBean");

    @Override
    protected void _enable(Context ctx, String id) throws BOSException, EASBizException {
        IActivityField iActivityField = ActivityFieldFactory.getLocalInstance(ctx);
        ActivityFieldInfo info = iActivityField.getActivityFieldInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        info.setState(StateEnum.enable);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("state"));
        iActivityField.updatePartial(info, selector);
    }

    @Override
    protected void _disable(Context ctx, String id) throws BOSException, EASBizException {
        String label6 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label6", (Context)ctx);
        this.checkFieldIsUse(ctx, id, label6);
        IActivityField iActivityField = ActivityFieldFactory.getLocalInstance(ctx);
        ActivityFieldInfo info = iActivityField.getActivityFieldInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        info.setState(StateEnum.disable);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("state"));
        iActivityField.updatePartial(info, selector);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String label7 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label7", (Context)ctx);
        this.checkFieldIsUse(ctx, pk.toString(), label7);
        this.checkIsEnable(ctx, pk);
        super._delete(ctx, pk);
    }

    private void checkIsEnable(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        ActivityFieldInfo info = ActivityFieldFactory.getLocalInstance(ctx).getActivityFieldInfo(pk);
        if (info.getState().equals((Object)StateEnum.enable)) {
            throw new SSCActivityException(SSCActivityException.DELETEISNOTALLOWED_EXCEPTION);
        }
    }

    private void checkFieldIsUse(Context ctx, String pk, String operateStr) throws EASBizException, BOSException {
        if (ActivityFieldEntryFactory.getLocalInstance(ctx).exists("where field ='" + pk + "'")) {
            throw new SSCActivityException(SSCActivityException.ACTIVITY_REFERENCE_EXCEPTION, new Object[]{operateStr});
        }
    }
}

