/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.dataquery;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.dataset.model.DataResult;
import com.kingdee.shr.dataset.model.JavaAPIParam;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.shareservice.dataquery.AbstractSSCBaseDataQueryService;
import com.kingdee.shr.shareservice.util.SSCTaskAppUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetSatisfactionDataQueryService
extends AbstractSSCBaseDataQueryService {
    private static final Logger logger = LoggerFactory.getLogger(GetSatisfactionDataQueryService.class);
    private static final String EXELLENT = "exellent";
    private static final String CONTENTMENT = "contentment";
    private static final String ORDINARY = "ordinary";
    private static final String DISSATISFIED = "dissatisfied";
    private static final String WORST = "worst";
    public static List<String> daySumList = new LinkedList<String>();

    public DataResult getAllData(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        this.checkUserPermission(ctx);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        paramMap.put("userId", userInfo.getId().toString());
        Map timeParam = (Map)this.getParamValue(ctx, "time", param);
        paramMap.put("startDate", timeParam.get("_###BEGIN###"));
        paramMap.put("endDate", timeParam.get("_###END###"));
        paramMap.put("dimensionId", "");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("sysAttr.id", (Object)"qSRO0PdERume6Ov+F0oes8uCaH0=", CompareType.EQUALS));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("filterItems", filterInfo.toString());
        paramMap.put("billTypeId", SSCTaskAppUtil.getQuerySourceDataStr(ctx, "com.kingdee.eas.base.shrssc.app.SHRBillTypeF7Query", params));
        JsonObject satisfactionData = SSCTaskAppUtil.operateTaskAll(ctx, "GETSATISFACTIONDATA", paramMap);
        if (logger.isDebugEnabled()) {
            logger.debug("\u83b7\u53d6\u6ee1\u610f\u5ea6\u8bc4\u4ef7=====" + satisfactionData);
        }
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        if (satisfactionData.get("dataType") != null && "JsonArray".equals(satisfactionData.get("dataType").getAsString())) {
            JsonArray dataArray = satisfactionData.get("data").getAsJsonArray();
            Gson gson = new Gson();
            for (int i = 0; i < dataArray.size(); ++i) {
                JsonObject dataObj = dataArray.get(i).getAsJsonObject();
                Map satisfactionDataMap = new HashMap();
                satisfactionDataMap = (Map)gson.fromJson((JsonElement)dataObj, satisfactionDataMap.getClass());
                int tempIndex = 0;
                for (Map.Entry eny : satisfactionDataMap.entrySet()) {
                    int val = Integer.parseInt((String)eny.getValue());
                    if (val == 0) {
                        ++tempIndex;
                    }
                    HashMap<String, Object> resultMap = new HashMap<String, Object>();
                    resultMap.put("type", eny.getKey());
                    resultMap.put("count", val);
                    resultList.add(resultMap);
                }
                if (tempIndex != satisfactionDataMap.size()) continue;
                resultList.clear();
            }
        }
        DataResult dataResult = new DataResult();
        if (!resultList.isEmpty()) {
            List<Map<String, Object>> rankDataList = this.rankDataList(ctx, resultList);
            dataResult.setRows(rankDataList);
        }
        return dataResult;
    }

    protected List<Map<String, Object>> rankDataList(Context ctx, List<Map<String, Object>> resultList) {
        LinkedList<Map<String, Object>> rankList = new LinkedList<Map<String, Object>>();
        for (int i = 0; i < daySumList.size(); ++i) {
            String key = daySumList.get(i);
            for (int a = 0; a < resultList.size(); ++a) {
                Map<String, Object> map = resultList.get(a);
                String type = (String)map.get("type");
                if (!key.equalsIgnoreCase(type)) continue;
                String typeMutilLang = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.SSCDimension", (String)type, (Context)ctx);
                map.put("type", typeMutilLang);
                rankList.add(map);
            }
        }
        return rankList;
    }

    public DataResult getPageData(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        return this.getAllData(ctx, param);
    }

    static {
        daySumList.add(EXELLENT);
        daySumList.add(CONTENTMENT);
        daySumList.add(ORDINARY);
        daySumList.add(DISSATISFIED);
        daySumList.add(WORST);
    }
}

