/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.dataquery;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.dataset.model.DataResult;
import com.kingdee.shr.dataset.model.JavaAPIParam;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.shareservice.dataquery.AbstractSSCBaseDataQueryService;
import com.kingdee.shr.shareservice.util.SSCTaskAppUtil;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTaskStatesDataQueryService
extends AbstractSSCBaseDataQueryService {
    private static final Logger logger = LoggerFactory.getLogger(GetTaskStatesDataQueryService.class);
    private static final String WITHIN_ONEDAY = "withinOneDay";
    private static final String WITHIN_TWODAY = "withinTwoDay";
    private static final String WITHIN_THREEDAY = "withinThreeDay";
    private static final String WITHIN_FOURDAY = "withinFourDay";
    private static final String WITHIN_FIVEDAY = "withinFiveDay";
    private static final String BEYOND_FIVEDAY = "beyondFiveDay";
    public static List<String> daySumList = new LinkedList<String>();
    public List<String> priorityList;

    public DataResult getAllData(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        this.checkUserPermission(ctx);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = userInfo.getId().toString();
        paramMap.put("userId", userId);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        paramMap.put("shareCenter", SSCTaskAppUtil.getSourceDataStr(ctx, "GETSHARECENTER", params));
        params.put("roleType", "hEw8bwRNR8qPRPajcUdX4C0WZ4A=");
        paramMap.put("buAttrs", SSCTaskAppUtil.getSourceDataStr(ctx, "SHRBUSSATTR", params));
        String paramValue = (String)this.getParamValue(ctx, "type", param);
        boolean isDaySum = this.getIsDaySum(paramValue);
        if (isDaySum) {
            paramMap.put("endDate", this.getDays());
        }
        paramMap.put("isDaySum", isDaySum);
        JsonObject taskStatesObj = SSCTaskAppUtil.operateTaskAll(ctx, "GETTASKSTATES", paramMap);
        if (logger.isDebugEnabled()) {
            logger.debug("\u4efb\u52a1\u72b6\u6001\u7edf\u8ba1\u83b7\u53d6=====" + taskStatesObj);
        }
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        if (taskStatesObj.get("dataType") != null && "JsonArray".equals(taskStatesObj.get("dataType").getAsString())) {
            JsonArray dataArray = taskStatesObj.get("data").getAsJsonArray();
            Gson gson = new Gson();
            for (int i = 0; i < dataArray.size(); ++i) {
                JsonObject dataObj = dataArray.get(i).getAsJsonObject();
                JsonObject expire = dataObj.getAsJsonObject("expire");
                Map expireMap = new HashMap();
                expireMap = (Map)gson.fromJson((JsonElement)expire, expireMap.getClass());
                for (Map.Entry eny : expireMap.entrySet()) {
                    HashMap<String, String> resultMap = new HashMap<String, String>();
                    String string = (String)eny.getKey();
                    resultMap.put("data", string);
                    resultMap.put("total", (String)eny.getValue());
                    String expireMutilLang = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.SSCDimension", (String)"expire", (Context)ctx);
                    resultMap.put("type", expireMutilLang);
                    resultList.add((Map<String, Object>)resultMap);
                }
                JsonObject unexpire = dataObj.getAsJsonObject("unexpire");
                Map unexpireMap = new HashMap();
                unexpireMap = (Map)gson.fromJson((JsonElement)unexpire, unexpireMap.getClass());
                for (Map.Entry entry : unexpireMap.entrySet()) {
                    HashMap<String, String> resultMap = new HashMap<String, String>();
                    String key = (String)entry.getKey();
                    resultMap.put("data", key);
                    resultMap.put("total", (String)entry.getValue());
                    String unexpireMutilLang = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.SSCDimension", (String)"unexpire", (Context)ctx);
                    resultMap.put("type", unexpireMutilLang);
                    resultList.add(resultMap);
                }
                if (isDaySum) continue;
                JsonObject priority = dataObj.getAsJsonObject("priority");
                HashMap hashMap = new HashMap();
                Map map = (Map)gson.fromJson((JsonElement)priority, hashMap.getClass());
                this.sortMap(map);
            }
        }
        List<Object> dataList = new LinkedList();
        dataList = isDaySum ? this.rankDataList(ctx, resultList) : this.rankPriorityList(ctx, resultList);
        DataResult dataResult = new DataResult();
        dataResult.setRows(dataList);
        return dataResult;
    }

    protected List<Map<String, Object>> rankDataList(Context ctx, List<Map<String, Object>> resultList) {
        LinkedList<Map<String, Object>> rankList = new LinkedList<Map<String, Object>>();
        for (int i = 0; i < daySumList.size(); ++i) {
            String key = daySumList.get(i);
            for (int a = 0; a < resultList.size(); ++a) {
                Map<String, Object> map = resultList.get(a);
                String data = (String)map.get("data");
                if (!key.equalsIgnoreCase(data)) continue;
                String dataKey = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.SSCDimension", (String)data, (Context)ctx);
                map.put("data", dataKey);
                rankList.add(map);
            }
        }
        return rankList;
    }

    protected List<Map<String, Object>> rankPriorityList(Context ctx, List<Map<String, Object>> resultList) {
        LinkedList<Map<String, Object>> rankList = new LinkedList<Map<String, Object>>();
        for (int i = 0; i < this.priorityList.size(); ++i) {
            String key = this.priorityList.get(i);
            for (int a = 0; a < resultList.size(); ++a) {
                Map<String, Object> map = resultList.get(a);
                String data = (String)map.get("data");
                if (!key.equalsIgnoreCase(data)) continue;
                rankList.add(map);
            }
        }
        return rankList;
    }

    protected void sortMap(Map<String, Object> map) {
        this.priorityList = new LinkedList<String>();
        ArrayList<Map.Entry<String, Object>> entryList = new ArrayList<Map.Entry<String, Object>>(map.entrySet());
        Collections.sort(entryList, new Comparator<Map.Entry<String, Object>>(){

            @Override
            public int compare(Map.Entry<String, Object> o1, Map.Entry<String, Object> o2) {
                return Integer.parseInt((String)o1.getValue()) - Integer.parseInt((String)o2.getValue());
            }
        });
        for (Map.Entry entry : entryList) {
            this.priorityList.add((String)entry.getKey());
        }
    }

    protected boolean getIsDaySum(String paramValue) {
        boolean isDaySum = true;
        if (!StringUtils.isEmpty((String)paramValue)) {
            isDaySum = paramValue.contains(",") ? true : paramValue.contains("1");
        }
        return isDaySum;
    }

    public DataResult getPageData(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        return this.getAllData(ctx, param);
    }

    protected String getDays() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, -7);
        Date d = calendar.getTime();
        String day = format.format(d);
        return day;
    }

    static {
        daySumList.add(WITHIN_ONEDAY);
        daySumList.add(WITHIN_TWODAY);
        daySumList.add(WITHIN_THREEDAY);
        daySumList.add(WITHIN_FOURDAY);
        daySumList.add(WITHIN_FIVEDAY);
        daySumList.add(BEYOND_FIVEDAY);
    }
}

