/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.strategy.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.certificationservice.HRCertificationBillFactory;
import com.kingdee.shr.certificationservice.HRCertificationBillInfo;
import com.kingdee.shr.certificationservice.HRCertificationBillTypeFactory;
import com.kingdee.shr.certificationservice.HRCertificationBillTypeInfo;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.shareservice.strategy.SendEmailInterface;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificationBillSendMailImpl
implements SendEmailInterface {
    private static final Logger logger = LoggerFactory.getLogger(CertificationBillSendMailImpl.class);

    @Override
    public HashMap<String, Object> getEmailMsg(Context ctx, String billId) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            String billType;
            HRCertificationBillInfo hRCertificationBillInfo = HRCertificationBillFactory.getLocalInstance((Context)ctx).getHRCertificationBillInfo((IObjectPK)new ObjectUuidPK(billId));
            PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(hRCertificationBillInfo.getPerson().getId()));
            HRCertificationBillTypeInfo hRCertificationBillTypeInfo = HRCertificationBillTypeFactory.getLocalInstance((Context)ctx).getHRCertificationBillTypeInfo((IObjectPK)new ObjectUuidPK(hRCertificationBillInfo.getCertificationBillType().getId()));
            String toEmailAddr = "";
            if (hRCertificationBillInfo.getEmail() != null && !hRCertificationBillInfo.getEmail().isEmpty()) {
                toEmailAddr = hRCertificationBillInfo.getEmail();
            }
            logger.error("CertificationBillSendMailImpl send to email ");
            String signNO = hRCertificationBillInfo.getSignNO();
            String number = hRCertificationBillInfo.getNumber();
            String label70 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label70", (Context)ctx);
            String fileName = label70 + "(" + number + ").pdf";
            if (signNO == null || signNO.isEmpty()) {
                logger.error("EmailSystem sendEmail error, signNO is null, billId = " + billId);
                return null;
            }
            String personName = personInfo.getName();
            String label43 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label43", (Context)ctx);
            String label65 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label65", (Context)ctx);
            String content = label43;
            String subject = label65;
            String string = billType = hRCertificationBillTypeInfo != null ? hRCertificationBillTypeInfo.getBillType().getName() : "OTHER_CER";
            String bizType = billType.equals("Income") ? "INCOME_CER" : (billType.equals("Employee") ? "EMP_CER" : (billType.equals("Resign") ? "RESIGN_CER" : "OTHER_CER"));
            map.put("subject", subject);
            map.put("content", content);
            map.put("toEmailAddr", toEmailAddr);
            map.put("signNO", signNO);
            map.put("bizType", bizType);
            map.put("bizIdentifyId", number);
            map.put("toEmailPersonName", personName);
            map.put("fileName", fileName);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return map;
    }
}

