/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.threadpool;

import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.shareservice.callabletask.AbstractSSCTaskCallable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSCTaskThreadPool {
    public static SSCTaskThreadPool INSTANCE;
    private Context ctx;
    private static Logger logger;
    private ExecutorService threadPool;
    private LinkedBlockingQueue<Runnable> jobQuene = new LinkedBlockingQueue();
    private int max = 10;
    private static final Map<String, Integer> asynTask;

    private SSCTaskThreadPool(Context ctx) {
        this.threadPool = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors() + 1, 0L, TimeUnit.MILLISECONDS, this.jobQuene);
        this.ctx = ctx;
    }

    private ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public static SSCTaskThreadPool getInstance(Context ctx) {
        if (INSTANCE == null) {
            INSTANCE = new SSCTaskThreadPool(ctx);
        }
        return INSTANCE;
    }

    public void submitAsyncTask(AbstractSSCTaskCallable callable) {
        final FutureTask<String> future = new FutureTask<String>(callable);
        this.getThreadPool().submit(future);
        this.getThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                while (!future.isDone()) {
                }
                String taskKey = ContextUtil.getCurrentUserInfo((Context)SSCTaskThreadPool.this.ctx).getId().toString();
                Integer asynDone = (Integer)asynTask.get(taskKey);
                if (null != asynDone && 0 != asynDone) {
                    asynTask.put(taskKey, asynDone - 1);
                }
                String result = null;
                try {
                    result = (String)future.get();
                }
                catch (InterruptedException e) {
                    logger.error("InterruptedException:" + e.getMessage(), (Throwable)e);
                }
                catch (ExecutionException e) {
                    logger.error("ExecutionException:" + e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    logger.error("Exception:" + e.getMessage(), (Throwable)e);
                }
                logger.error("thread name:" + Thread.currentThread().getName() + "======result:" + result);
            }
        });
    }

    public String submitWaitTask(AbstractSSCTaskCallable callable) {
        FutureTask<String> future = new FutureTask<String>(callable);
        this.getThreadPool().submit(future);
        String result = null;
        try {
            result = future.get();
        }
        catch (InterruptedException e) {
            logger.error("InterruptedException:" + e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            logger.error("ExecutionException:" + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Exception:" + e.getMessage(), (Throwable)e);
        }
        logger.error("thread name:" + Thread.currentThread().getName() + "======result:" + result);
        return result;
    }

    public String submitWaitTaskList(List<AbstractSSCTaskCallable> callableList) {
        String result = "";
        try {
            List invokeResult = this.getThreadPool().invokeAll(callableList);
            if (invokeResult != null) {
                for (Future future : invokeResult) {
                    result = result + result + (String)future.get();
                }
            }
        }
        catch (InterruptedException e) {
            logger.error("InterruptedException:" + e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            logger.error("ExecutionException:" + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Exception:" + e.getMessage(), (Throwable)e);
        }
        logger.error("thread name:" + Thread.currentThread().getName() + "======result:" + result);
        return result;
    }

    public boolean isAsynTaskDone() {
        boolean isDone = false;
        String userId = ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString();
        Integer asyn = asynTask.get(userId);
        if (null == asyn || 0 == asyn) {
            isDone = true;
        }
        return isDone;
    }

    public void setAsynTaskNum(int taskNum) {
        String userId = ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString();
        asynTask.put(userId, taskNum);
    }

    static {
        logger = LoggerFactory.getLogger(SSCTaskThreadPool.class);
        asynTask = new ConcurrentHashMap<String, Integer>();
    }
}

