/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.shr.base.syssetting.app.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.shareservice.inter.AssembleInter;
import com.kingdee.shr.shareservice.util.AssembleConfigUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.IntEnum;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssembleUtils {
    private static Logger logger = LoggerFactory.getLogger(AssembleUtils.class);

    public static Map<String, Map<String, Object>> assembleModule(Context ctx, Map<String, Object> assembledMap, String billIDS) throws BOSException {
        if (assembledMap == null || assembledMap.isEmpty() || StringUtils.isEmpty((String)billIDS)) {
            return null;
        }
        boolean isValid = AssembleUtils.isSameBill(ctx, billIDS);
        if (!isValid) {
            throw new BOSException("billIDS is not from the same Bill!");
        }
        HashMap<String, Map<String, Object>> resultObject = new HashMap<String, Map<String, Object>>();
        String[] billCol = billIDS.split(",");
        BOSObjectType billType = BOSUuid.getBOSObjectType((String)billCol[0].trim(), (boolean)true);
        ICoreBase coreIter = MetaDataUtil.getBizInterface((Context)ctx, (BOSObjectType)billType);
        EntityObjectInfo rootEntityObject = MetaDataUtil.getEntityObjectInfo((Context)ctx, (BOSObjectType)billType);
        SelectorItemCollection selCol = new SelectorItemCollection();
        for (String key : assembledMap.keySet()) {
            String[] itemInfo = new SelectorItemInfo(key);
            selCol.add((SelectorItemInfo)itemInfo);
        }
        String primaryKey = AssembleUtils.getEntityPrimaryKey(ctx, rootEntityObject);
        if (primaryKey == null) {
            throw new BOSException("assembleModule primaryKey is invalid!");
        }
        HashSet<String> billSet = new HashSet<String>();
        for (String bill : billCol) {
            billSet.add(bill);
        }
        FilterInfo filterinfo = new FilterInfo();
        filterinfo.getFilterItems().add(new FilterItemInfo(primaryKey, billSet, CompareType.INCLUDE));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterinfo);
        entityViewInfo.setSelector(selCol);
        CoreBaseCollection assembleData = coreIter.getCollection(entityViewInfo);
        if (assembleData != null && !assembleData.isEmpty()) {
            for (String key : assembledMap.keySet()) {
                PropertyInfo property = BaseMetaDataUtil.getPropertyInfo((Context)ctx, (String)rootEntityObject.getFullName(), (String)key.split("\\.")[0]);
                DataType dateType = null;
                if (property instanceof OwnPropertyInfo) {
                    OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)property;
                    dateType = ownPropertyInfo.getDataType();
                    AssembleUtils.assemOwnPropVals(ctx, resultObject, assembleData, key, dateType);
                    continue;
                }
                if (!(property instanceof LinkPropertyInfo)) continue;
                AssembleUtils.getTreeSelectorRes(ctx, key, assembleData, property, dateType, resultObject);
            }
        }
        return resultObject;
    }

    public static Map<String, Map<String, Object>> assembleOwnDef(Context ctx, Map<String, Object> assembledMap, String billIDS) throws BOSException {
        if (assembledMap == null || assembledMap.isEmpty() || StringUtils.isEmpty((String)billIDS)) {
            return null;
        }
        boolean isValid = AssembleUtils.isSameBill(ctx, billIDS);
        if (!isValid) {
            throw new BOSException("billIDS is not from the same Bill!");
        }
        Map<String, Map<String, Object>> resultObject = null;
        BOSObjectType billType = BOSUuid.getBOSObjectType((String)billIDS.split(",")[0], (boolean)true);
        if (billType == null) {
            throw new BOSException("billID is invalid!");
        }
        try {
            AssembleInter assInter = AssembleConfigUtils.getRuleAssemInter(ctx, billType.toString());
            resultObject = assInter.assmbleDefCol(ctx, assembledMap, billIDS);
        }
        catch (Exception e) {
            logger.error("AssembleInter Exception:" + e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return resultObject;
    }

    public static void assembleStructure(Context ctx, Map<String, Object> assembledMap, Map structureParam) throws BOSException {
    }

    public static void assembleQuery(Context ctx, Map<String, Object> assembledMap) throws BOSException {
    }

    private static String getEntityPrimaryKey(Context ctx, EntityObjectInfo eninfo) {
        String priKey = null;
        LogicalKeyInfo logicalInfo = eninfo.getLogicalKey();
        PropertyCollection props = logicalInfo.getKeyPropertys();
        if (props != null && !props.isEmpty()) {
            PropertyInfo prop = props.get(0);
            priKey = prop.getName();
        }
        return priKey;
    }

    private static void getTreeSelectorRes(Context ctx, String key, CoreBaseCollection assembleData, PropertyInfo propertyInfo, DataType dataType, Map<String, Map<String, Object>> resultObject) {
        LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)propertyInfo;
        RelationshipInfo relationshipInfo = linkPropertyInfo.getRelationship();
        EntityObjectInfo supplierObject = relationshipInfo.getSupplierObject();
        String fullName = supplierObject.getRealFullName();
        String primaryKey = AssembleUtils.getEntityPrimaryKey(ctx, supplierObject);
        RelationshipType relationshipType = relationshipInfo.getType();
        String[] keysplit = key.split("\\.");
        HashSet<String> firstChildSet = new HashSet<String>();
        HashMap<String, LinkedList<String>> idMap = new HashMap<String, LinkedList<String>>();
        for (int i = 0; i < assembleData.size(); ++i) {
            CoreBaseInfo fieldCore;
            CoreBaseInfo coreBaseInfo = assembleData.get(i);
            Map<String, Object> assembledSet = resultObject.get(coreBaseInfo.getId().toString());
            if (null == assembledSet) {
                assembledSet = new HashMap<String, Object>();
            }
            if (relationshipType == RelationshipType.COMPOSITION) {
                Object idObj;
                IObjectValue objectValue;
                AbstractObjectCollection entrysCol = (AbstractObjectCollection)coreBaseInfo.get(keysplit[0]);
                if (entrysCol != null && !entrysCol.isEmpty() && null != (objectValue = entrysCol.getObject(0)) && null != (idObj = objectValue.get(primaryKey))) {
                    String childkey = objectValue.get(primaryKey).toString();
                    firstChildSet.add(childkey);
                    LinkedList<String> idList = (LinkedList<String>)idMap.get(childkey);
                    if (null == idList) {
                        idList = new LinkedList<String>();
                    }
                    idList.add(coreBaseInfo.getId().toString());
                    idMap.put(childkey, idList);
                    continue;
                }
            } else if (relationshipType == RelationshipType.ASSOCIATION && null != (fieldCore = (CoreBaseInfo)coreBaseInfo.get(keysplit[0]))) {
                String childkey = fieldCore.getId().toString();
                firstChildSet.add(childkey);
                LinkedList<String> idList = (LinkedList<String>)idMap.get(childkey);
                if (null == idList) {
                    idList = new LinkedList<String>();
                }
                idList.add(coreBaseInfo.getId().toString());
                idMap.put(childkey, idList);
                continue;
            }
            assembledSet.put(key, "");
            resultObject.put(coreBaseInfo.getId().toString(), assembledSet);
        }
        String childkey = key.replace(keysplit[0] + ".", "");
        if (logger.isDebugEnabled()) {
            logger.debug("getAssoLinkProVal params:" + key + "--" + fullName + "---" + firstChildSet);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rawKey", key);
        params.put("key", childkey);
        params.put("entityFullName", fullName);
        params.put("primaryKey", primaryKey);
        params.put("firstChildSet", firstChildSet);
        params.put("resultObject", resultObject);
        params.put("idMaps", idMap);
        AssembleUtils.getAssoLinkProVal(ctx, params);
    }

    private static boolean isSameBill(Context ctx, String billIDS) {
        String[] ids = billIDS.split(",");
        BOSObjectType billType = BOSUuid.getBOSObjectType((String)ids[0], (boolean)true);
        for (int i = 1; i < ids.length; ++i) {
            BOSObjectType idBos = BOSUuid.getBOSObjectType((String)ids[i], (boolean)true);
            if (billType.equals((Object)idBos)) continue;
            return false;
        }
        return true;
    }

    private static String decideFieldValueIfEnum(Context ctx, OwnPropertyInfo ownPropertyInfo, String fieldValue) {
        String enumRefName = ownPropertyInfo.getMetaDataRef();
        if (!StringUtils.isEmpty((String)enumRefName)) {
            try {
                MetaDataPK metaPk = MetaDataPK.create((String)enumRefName);
                BizEnumInfo bizEnum = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEnum((IMetaDataPK)metaPk);
                IntEnum enumValie = null;
                if (bizEnum.getDataType() == BizEnumValueType.INTEGER) {
                    enumValie = EnumUtils.getEnum(Class.forName(enumRefName), (int)Integer.parseInt(fieldValue));
                } else if (bizEnum.getDataType() == BizEnumValueType.STRING) {
                    enumValie = EnumUtils.getEnumByValue(Class.forName(enumRefName), (String)fieldValue.toString());
                } else if (bizEnum.getDataType() == BizEnumValueType.LONG) {
                    enumValie = EnumUtils.getEnum(Class.forName(enumRefName), (long)Long.parseLong(fieldValue));
                } else if (bizEnum.getDataType() == BizEnumValueType.FLOAT) {
                    enumValie = EnumUtils.getEnum(Class.forName(enumRefName), (float)Float.parseFloat(fieldValue));
                } else if (bizEnum.getDataType() == BizEnumValueType.DOUBLE) {
                    enumValie = EnumUtils.getEnum(Class.forName(enumRefName), (double)Double.parseDouble(fieldValue));
                }
                fieldValue = enumValie == null ? "" : enumValie.getAlias(ctx.getLocale());
            }
            catch (ClassNotFoundException e) {
                logger.error("decideFieldValueIfEnum:" + e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                logger.error("decideFieldValueIfEnum:" + e.getMessage(), (Throwable)e);
            }
        }
        return fieldValue;
    }

    public static String getEnumPath(Context ctx, String rootObject, String propKey) {
        OwnPropertyInfo ownPropertyInfo;
        String enumpath = "";
        PropertyInfo property = BaseMetaDataUtil.getPropertyInfo((Context)ctx, (String)rootObject, (String)propKey);
        DataType dateType = null;
        if (property instanceof OwnPropertyInfo && DataType.ENUM.equals((Object)(dateType = (ownPropertyInfo = (OwnPropertyInfo)property).getDataType()))) {
            enumpath = ownPropertyInfo.getMetaDataRef();
        }
        return enumpath;
    }

    public static void getAssoLinkProVal(Context ctx, Map params) {
        String rawKey = (String)params.get("rawKey");
        String key = (String)params.get("key");
        String entityFullName = (String)params.get("entityFullName");
        String primaryKey = (String)params.get("primaryKey");
        Set firstChildSet = (Set)params.get("firstChildSet");
        Map resultObject = (Map)params.get("resultObject");
        Map idMaps = (Map)params.get("idMaps");
        try {
            String[] keys = key.split("\\.");
            String fieldName = keys[0];
            ICoreBase entityBizInterface = (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)entityFullName));
            EntityViewInfo entityView = new EntityViewInfo();
            SelectorItemCollection selCol = new SelectorItemCollection();
            selCol.add(new SelectorItemInfo(fieldName));
            entityView.setSelector(selCol);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo(primaryKey, (Object)firstChildSet, CompareType.INCLUDE));
            entityView.setFilter(filterInfo);
            CoreBaseCollection coreCol = entityBizInterface.getCollection(entityView);
            PropertyInfo propertyInfo = BaseMetaDataUtil.getPropertyInfo((Context)ctx, (String)entityFullName, (String)fieldName);
            if (propertyInfo instanceof OwnPropertyInfo) {
                OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)propertyInfo;
                DataType dataType = ownPropertyInfo.getDataType();
                for (int i = 0; i < coreCol.size(); ++i) {
                    CoreBaseInfo entityInfo = coreCol.get(i);
                    Object fieldValue = entityInfo.get(fieldName);
                    if (DataType.BOOLEAN.equals((Object)dataType)) {
                        fieldValue = null != fieldValue && "" != fieldValue && "true".equalsIgnoreCase(fieldValue.toString()) ? Integer.valueOf(1) : Integer.valueOf(0);
                    } else if ((DataType.TIME.equals((Object)dataType) || DataType.TIMESTAMP.equals((Object)dataType) || DataType.DATE.equals((Object)dataType)) && null != fieldValue && "" != fieldValue) {
                        SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        Date timeObj = (Date)fieldValue;
                        fieldValue = simpleFormat.format(timeObj);
                    }
                    List topParentIds = (List)idMaps.get(entityInfo.getId().toString());
                    for (String topParentId : topParentIds) {
                        HashMap<String, Object> assembledSet = (HashMap<String, Object>)resultObject.get(topParentId);
                        if (null == assembledSet) {
                            assembledSet = new HashMap<String, Object>();
                        }
                        assembledSet.put(rawKey, null == fieldValue ? "" : fieldValue);
                        resultObject.put(topParentId, assembledSet);
                    }
                }
            } else if (propertyInfo instanceof LinkPropertyInfo) {
                HashSet<String> childIds = new HashSet<String>();
                String fullName = entityFullName;
                String maryKey = primaryKey;
                LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)propertyInfo;
                if (keys.length == 1) {
                    for (int i = 0; i < coreCol.size(); ++i) {
                        CoreBaseInfo entityInfo = coreCol.get(i);
                        Object fieldValue = entityInfo.get(fieldName);
                        List topParentIds = (List)idMaps.get(entityInfo.getId().toString());
                        for (String topParentId : topParentIds) {
                            HashMap<String, Object> assembledSet = (HashMap<String, Object>)resultObject.get(topParentId);
                            if (null == assembledSet) {
                                assembledSet = new HashMap<String, Object>();
                            }
                            assembledSet.put(rawKey, null == fieldValue ? "" : fieldValue);
                            resultObject.put(topParentId, assembledSet);
                        }
                    }
                    return;
                }
                RelationshipInfo relationshipInfo = linkPropertyInfo.getRelationship();
                EntityObjectInfo supplierObject = relationshipInfo.getSupplierObject();
                fullName = supplierObject.getRealFullName();
                maryKey = AssembleUtils.getEntityPrimaryKey(ctx, supplierObject);
                key = key.replace(fieldName + ".", "");
                for (int i = 0; i < coreCol.size(); ++i) {
                    CoreBaseInfo entityInfo = coreCol.get(i);
                    CoreBaseInfo fieldCore = (CoreBaseInfo)entityInfo.get(fieldName);
                    if (null != fieldCore) {
                        childIds.add(fieldCore.getId().toString());
                        LinkedList parentList = (LinkedList)idMaps.get(fieldCore.getId().toString());
                        if (null == parentList) {
                            parentList = new LinkedList();
                        }
                        parentList.addAll((Collection)idMaps.get(entityInfo.getId().toString()));
                        idMaps.put(fieldCore.getId().toString(), parentList);
                        idMaps.remove(entityInfo.getId().toString());
                        continue;
                    }
                    List topParentIds = (List)idMaps.get(entityInfo.getId().toString());
                    for (String topParentId : topParentIds) {
                        HashMap<String, String> assembledSet = (HashMap<String, String>)resultObject.get(topParentId);
                        if (null == assembledSet) {
                            assembledSet = new HashMap<String, String>();
                        }
                        assembledSet.put(rawKey, "");
                        resultObject.put(topParentId, assembledSet);
                    }
                }
                if (!childIds.isEmpty()) {
                    params.put("key", key);
                    params.put("entityFullName", fullName);
                    params.put("primaryKey", maryKey);
                    params.put("firstChildSet", childIds);
                    params.put("idMaps", idMaps);
                    AssembleUtils.getAssoLinkProVal(ctx, params);
                }
            }
        }
        catch (Exception e) {
            logger.error("com.kingdee.shr.shareservice.util.AssembleUtils.getAssoLinkProVal " + e.getMessage(), (Throwable)e);
        }
    }

    private static void assemOwnPropVals(Context ctx, Map<String, Map<String, Object>> resultObject, CoreBaseCollection assembleData, String key, DataType dataType) {
        for (int i = 0; i < assembleData.size(); ++i) {
            CoreBaseInfo coreBaseInfo = assembleData.get(i);
            Map<String, Object> assembledSet = resultObject.get(coreBaseInfo.getId().toString());
            if (null == assembledSet) {
                assembledSet = new HashMap<String, Object>();
            }
            if (DataType.BOOLEAN.equals((Object)dataType)) {
                int booleanVal = 0;
                Object rawObj = coreBaseInfo.get(key);
                if (null != rawObj && "true".equalsIgnoreCase(rawObj.toString())) {
                    booleanVal = 1;
                }
                assembledSet.put(key, booleanVal);
            } else if (DataType.TIME.equals((Object)dataType) || DataType.TIMESTAMP.equals((Object)dataType) || DataType.DATE.equals((Object)dataType)) {
                Object rawObj = coreBaseInfo.get(key);
                String keyval = "";
                if (null != rawObj) {
                    SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Date timeObj = (Date)rawObj;
                    keyval = simpleFormat.format(timeObj);
                }
                assembledSet.put(key, keyval);
            } else {
                assembledSet.put(key, coreBaseInfo.get(key) == null ? "" : coreBaseInfo.get(key));
            }
            resultObject.put(coreBaseInfo.getId().toString(), assembledSet);
        }
    }
}

