/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.util;

import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;

public class Base64Utils {
    public static final String DEFAULT_CHARSETNAME = "UTF-8";
    public static Base64 base64 = new Base64();

    public static String encode(String encodeStr) {
        return Base64Utils.encode(encodeStr, DEFAULT_CHARSETNAME);
    }

    public static String encode(String encodeStr, String charsetName) {
        if (StringUtils.isEmpty((String)encodeStr)) {
            return null;
        }
        String encodedText = null;
        try {
            byte[] textByte = encodeStr.getBytes(charsetName);
            encodedText = base64.encodeToString(textByte);
        }
        catch (UnsupportedEncodingException e) {
            encodedText = encodeStr;
        }
        return encodedText;
    }

    public static String encode(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        return base64.encodeToString(bytes);
    }

    public static byte[] encodeAsByte(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        return base64.encode(bytes);
    }

    public static String decode(String decodeStr) {
        return Base64Utils.decode(decodeStr, DEFAULT_CHARSETNAME);
    }

    public static String decode(String decodeStr, String charsetName) {
        if (StringUtils.isEmpty((String)decodeStr)) {
            return null;
        }
        String result = null;
        try {
            result = new String(base64.decode(decodeStr), charsetName);
        }
        catch (UnsupportedEncodingException e) {
            result = decodeStr;
        }
        return result;
    }

    public static byte[] decodeAsByte(String decodeStr) {
        if (StringUtils.isEmpty((String)decodeStr)) {
            return null;
        }
        return base64.decode(decodeStr);
    }
}

