/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.app.util.MetaDataServerUtil;
import com.kingdee.shr.shareservice.strategy.ActivitySolutionOperation;
import com.kingdee.shr.shareservice.strategy.impl.CommonBillActivitySolutionOperation;
import com.kingdee.shr.shareservice.strategy.impl.EmpAuditBizBillActivitySolutionOperation;
import com.kingdee.shr.shareservice.strategy.impl.HRBizAffairActivitySolutionOperation;
import com.kingdee.shr.shareservice.strategy.impl.ResignBillActivitySolutionOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum BillType {
    ResignBizBill("CC58A617", new ResignBillActivitySolutionOperation()),
    EmpAuditBizBill("44ABDE55", new EmpAuditBizBillActivitySolutionOperation()),
    HRAffairBizBill("HRAffairBizBill", new HRBizAffairActivitySolutionOperation()),
    CommonBill("OTHER", new CommonBillActivitySolutionOperation());

    private static final Logger logger;
    private static final String HRAFFAIRBIZBILL = "com.kingdee.eas.hr.affair.app.HRAffairBizBill";
    private String bosType;
    private ActivitySolutionOperation activitySolutionOperation;

    private BillType(String bosType, ActivitySolutionOperation activitySolutionOperation) {
        this.bosType = bosType;
        this.activitySolutionOperation = activitySolutionOperation;
    }

    public static BillType getBillType(Context ctx, String billId) throws BOSException {
        String billBosType = BOSUuid.read((String)billId).getType().toString();
        logger.info("billBosType---->:" + billBosType);
        ICoreBase bizInterface = MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)BOSUuid.read((String)billId).getType());
        logger.info("bizInterface---->:" + bizInterface.getName());
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(BOSUuid.read((String)billId).getType());
        BusinessObjectInfo parent = entityInfo.getParent();
        logger.info("parent---->:" + parent.getName());
        boolean loop = true;
        logger.info("\u5faa\u73af HRAffairBizBill---->:" + (Object)((Object)HRAffairBizBill) + ";entityInfo-BOSType--->:" + entityInfo.getBOSType().toString() + ";getFullName():" + entityInfo.getFullName());
        while (loop) {
            if (HRAFFAIRBIZBILL.equals(entityInfo.getFullName())) {
                loop = false;
                return HRAffairBizBill;
            }
            if (parent == null) {
                loop = false;
                continue;
            }
            logger.info("\u5faa\u73af parent---->:" + parent.getName() + ";BOSType--->:" + parent.getBOSType().toString() + ";getFullName():" + parent.getFullName());
            if (HRAFFAIRBIZBILL.equals(parent.getFullName())) {
                loop = false;
                return HRAffairBizBill;
            }
            parent = parent.getParent();
        }
        BillType result = null;
        for (BillType billType : BillType.values()) {
            if (!billBosType.equals(billType.bosType)) continue;
            result = billType;
        }
        if (result == null) {
            result = CommonBill;
        }
        return result;
    }

    public ActivitySolutionOperation getActivitySolutionOperation() {
        return this.activitySolutionOperation;
    }

    static {
        logger = LoggerFactory.getLogger(BillType.class);
    }
}

