/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.util;

import com.kingdee.bos.Context;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyReader {
    private static final Logger logger = LoggerFactory.getLogger(PropertyReader.class);
    private static String propertiesPath = SHRSyssettingUtil.getShrWebWarPath();
    private static String PROPERTIES_PATH = propertiesPath + File.separator + "addon" + File.separator + "shrecontractservice" + File.separator + "web" + File.separator + "config" + File.separator + "config.properties";
    private static long LASTMODIFIED_TIME;
    private static Properties instance;

    private PropertyReader() {
    }

    private static Properties getInstance(Context ctx) {
        if (instance == null || instance.size() == 0) {
            PropertyReader.load(PropertyReader.getPropertiesFile());
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(File file) {
        if (file.exists()) {
            FileReader fileReader = null;
            BufferedReader bufferedReader = null;
            try {
                fileReader = new FileReader(file);
                bufferedReader = new BufferedReader(fileReader);
                instance = new Properties();
                instance.load(bufferedReader);
                LASTMODIFIED_TIME = file.lastModified();
            }
            catch (FileNotFoundException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        } else {
            logger.error("cann't find the config file ");
        }
    }

    public static String getProperty(Context ctx, String key) {
        PropertyReader.reload(ctx);
        if (PropertyReader.getInstance(ctx) != null) {
            return PropertyReader.getInstance(ctx).getProperty(key);
        }
        return null;
    }

    public static String getProperty(Context ctx, String key, String defaultValue) {
        PropertyReader.reload(ctx);
        if (PropertyReader.getInstance(ctx) != null) {
            return PropertyReader.getInstance(ctx).getProperty(key, defaultValue);
        }
        return null;
    }

    private static void reload(Context ctx) {
        File file = PropertyReader.getPropertiesFile();
        if (file.exists() && file.lastModified() != LASTMODIFIED_TIME) {
            PropertyReader.load(file);
        }
    }

    private static File getPropertiesFile() {
        String fileName = PROPERTIES_PATH;
        return new File(fileName);
    }

    public static String getEContractSignText(Context ctx) {
        return PropertyReader.getProperty(ctx, "econtract.sign.msg.text");
    }

    public static String getEContractSignUrl(Context ctx) {
        return PropertyReader.getProperty(ctx, "econtract.sign.lightapp.base.url");
    }

    static {
        PropertyReader.load(PropertyReader.getPropertiesFile());
    }
}

