/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.shr.shareservice.strategy.SendEmailInterface;
import com.kingdee.shr.shareservice.strategy.impl.CertificationBillSendMailImpl;
import com.kingdee.shr.shareservice.strategy.impl.ContractChangeBillSendMailImpl;
import com.kingdee.shr.shareservice.strategy.impl.ContractPreSignBillSendMailImpl;
import com.kingdee.shr.shareservice.strategy.impl.ContractRenewBillSendMailImpl;
import com.kingdee.shr.shareservice.strategy.impl.ContractSignBillSendMailImpl;
import com.kingdee.shr.shareservice.strategy.impl.OtherContractBillSendMailImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SendEmailType {
    CertificationBill("C84F6BC0", new CertificationBillSendMailImpl()),
    ContractChangeBill("056FBF2E", new ContractChangeBillSendMailImpl()),
    ContractPreSignBill("9F4ECBD6", new ContractPreSignBillSendMailImpl()),
    ContractRenewBill("2A2632A9", new ContractRenewBillSendMailImpl()),
    OtherContractBill("CB88E0A5", new OtherContractBillSendMailImpl()),
    ContractSignBill("502B7D81", new ContractSignBillSendMailImpl());

    private static final Logger logger;
    private String bosType;
    private SendEmailInterface sendEmailInterface;

    private SendEmailType(String bosType, SendEmailInterface sendEmailInterface) {
        this.bosType = bosType;
        this.sendEmailInterface = sendEmailInterface;
    }

    public static SendEmailType getBillType(Context ctx, String billId) throws BOSException {
        String billBosType = BOSUuid.read((String)billId).getType().toString();
        for (SendEmailType sendEmailType : SendEmailType.values()) {
            if (!billBosType.equals(sendEmailType.bosType)) continue;
            return sendEmailType;
        }
        logger.error("SendEmailType can't matching the billBosType: " + billBosType);
        return null;
    }

    public SendEmailInterface getSendEmailInterface() {
        return this.sendEmailInterface;
    }

    static {
        logger = LoggerFactory.getLogger(SendEmailType.class);
    }
}

