/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.socialSecurity.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import com.kingdee.shr.compensation.record.assemble.RecordUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.ml.util.UserNantionalUtil;
import com.kingdee.shr.socialSecurity.ISocPersonRecord;
import com.kingdee.shr.socialSecurity.SocPersonRecordCollection;
import com.kingdee.shr.socialSecurity.SocPersonRecordFactory;
import com.kingdee.shr.socialSecurity.SocPersonRecordInfo;
import com.kingdee.shr.socialSecurity.app.AbstractSocPersonRecordFacadeControllerBean;
import com.kingdee.shr.socialSecurity.sql.SocPersonRecordSQL;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SocPersonRecordFacadeControllerBean
extends AbstractSocPersonRecordFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.socialSecurity.app.SocPersonRecordFacadeControllerBean");

    @Override
    protected Object _loseSocPersonRecord(Context ctx, Map param) throws BOSException, EASBizException {
        String billIds = (String)param.get("billIds");
        StringBuilder sucBillIds = new StringBuilder();
        java.util.Date loseDate = (java.util.Date)param.get("loseDate");
        String billId2 = "";
        String personName = "";
        java.util.Date effectDate = null;
        java.util.Date empEffdt = null;
        java.util.Date joinDate = null;
        java.util.Date entryDate = null;
        java.util.Date socPayDate = null;
        SocPersonRecordInfo socPersonRecordInfo = null;
        BatchMessageTipsHeader header = new BatchMessageTipsHeader();
        int successCount = 0;
        int errorCount = 0;
        String sqlBillIds = CmpStrUtil.buildInSql((String)billIds);
        Map<String, SocPersonRecordInfo> allDataMap = this.getSocPersonRecordMap(ctx, sqlBillIds);
        Map<String, java.util.Date> joinSocDateMap = this.getMaxJoinSocDateMap(ctx, sqlBillIds);
        Map<String, java.util.Date> socEntryDateMap = this.getMaxSocEntryDateMap(ctx, sqlBillIds);
        Map<String, java.util.Date> maxSocPayDateMap = this.getMaxSocPayDateMap(ctx, sqlBillIds);
        String[] billArr = billIds.split(",");
        String person = EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocFileDynResource", (String)"label24", (Locale)ctx.getLocale());
        String msg = EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocFileDynResource", (String)"label25", (Locale)ctx.getLocale());
        String msg1 = EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocFileDynResource", (String)"label26", (Locale)ctx.getLocale());
        String msg2 = EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocFileDynResource", (String)"label27", (Locale)ctx.getLocale());
        String msg3 = EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocFileDynResource", (String)"label28", (Locale)ctx.getLocale());
        String msg4 = EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocFileDynResource", (String)"label29", (Locale)ctx.getLocale());
        String checkpass = EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocConstant", (String)"checkpass", (Locale)ctx.getLocale());
        Map dateUTCFormat = UserNantionalUtil.getDateUTCFormat((Context)ctx);
        String dateFormat = (String)dateUTCFormat.get(DataType.DATE.getName());
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        for (String billId2 : billArr) {
            socPersonRecordInfo = allDataMap.get(billId2);
            personName = socPersonRecordInfo.getPerson().getName();
            effectDate = socPersonRecordInfo.getEffectDate();
            empEffdt = socPersonRecordInfo.getEmpEffdt();
            joinDate = joinSocDateMap.get(billId2);
            entryDate = socEntryDateMap.get(billId2);
            socPayDate = maxSocPayDateMap.get(billId2);
            BatchMessageTipsBody body = new BatchMessageTipsBody();
            body.setId(billId2);
            if (loseDate.before(effectDate)) {
                ++errorCount;
                body.setMuitTipsState(false);
                body.setMuitTipsMessage(person + "\uff1a" + personName + msg);
                header.addResult(body);
                continue;
            }
            if (empEffdt != null && loseDate.before(empEffdt)) {
                ++errorCount;
                body.setMuitTipsState(false);
                body.setMuitTipsMessage(person + "\uff1a" + personName + msg1 + sdf.format(empEffdt));
                header.addResult(body);
                continue;
            }
            if (joinDate != null && loseDate.before(joinDate)) {
                ++errorCount;
                body.setMuitTipsState(false);
                body.setMuitTipsMessage(person + "\uff1a" + personName + msg2 + sdf.format(joinDate));
                header.addResult(body);
                continue;
            }
            if (entryDate != null && loseDate.before(entryDate)) {
                ++errorCount;
                body.setMuitTipsState(false);
                body.setMuitTipsMessage(person + "\uff1a" + personName + msg3 + sdf.format(entryDate));
                header.addResult(body);
                continue;
            }
            if (socPayDate != null && loseDate.before(socPayDate)) {
                ++errorCount;
                body.setMuitTipsState(false);
                body.setMuitTipsMessage(person + "\uff1a" + personName + msg4 + sdf.format(socPayDate));
                header.addResult(body);
                continue;
            }
            ++successCount;
            body.setMuitTipsState(true);
            body.setMuitTipsMessage(person + "\uff1a" + personName + checkpass);
            header.addResult(body);
            sucBillIds.append(billId2).append(",");
        }
        header.setFailureCount(errorCount);
        header.setSuccessCount(successCount);
        header.setBillId(billIds);
        if (successCount <= 0) {
            return header;
        }
        billIds = CmpStrUtil.buildInSql((String)sucBillIds.toString().substring(0, sucBillIds.length() - 1));
        Date sqlDate = new Date(loseDate.getTime());
        Object[] updateParam = new Object[]{sqlDate};
        String sql = SocPersonRecordSQL.getLoseSocPersonRecordSql(billIds);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])updateParam);
        String pbuIdSql = " select fpersonburelationid from t_hr_ssocpersonrecord where fid in " + billIds + "";
        RecordUtil.updatePBUState((Context)ctx, (String)pbuIdSql, (int)2, (boolean)false);
        return header;
    }

    @Override
    protected void _checkDateValid(Context ctx, String billIds, java.util.Date loseDate) throws BOSException, EASBizException {
    }

    private Map<String, SocPersonRecordInfo> getSocPersonRecordMap(Context ctx, String billIds) throws BOSException {
        HashMap<String, SocPersonRecordInfo> map = new HashMap<String, SocPersonRecordInfo>();
        ISocPersonRecord socPersonRecord = SocPersonRecordFactory.getLocalInstance(ctx);
        SocPersonRecordCollection coll = socPersonRecord.getSocPersonRecordCollection("select person.name,effectDate,empEffdt,person.id where id in " + billIds);
        if (coll.size() > 0) {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                SocPersonRecordInfo socPersonRecordInfo = coll.get(i);
                String key = socPersonRecordInfo.getId().toString();
                map.put(key, socPersonRecordInfo);
            }
        }
        return map;
    }

    private Map<String, java.util.Date> getMaxJoinSocDateMap(Context ctx, String billIds) throws BOSException {
        HashMap<String, java.util.Date> map = new HashMap<String, java.util.Date>();
        String sql = "select fbillId, max(FEffectDay) maxDate from T_HR_SSocEmpSocFiles where fbillId in " + billIds + " group by fbillId";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        String billId = "";
        Date maxDate = null;
        try {
            while (rs.next()) {
                maxDate = rs.getDate("maxDate");
                billId = rs.getString("fbillId");
                map.put(billId, maxDate);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }

    private Map<String, java.util.Date> getMaxSocPayDateMap(Context ctx, String billIds) throws BOSException {
        HashMap<String, java.util.Date> map = new HashMap<String, java.util.Date>();
        StringBuilder str = new StringBuilder();
        str.append(" select FSocPersonRecordID,FPeriodYear,FPeriodMonth ");
        str.append(" from T_HR_SSocPay ");
        str.append(" where FPersonId in (select FPersonId from T_HR_SSocPersonRecord where FID in " + billIds + ")");
        str.append(" order by FPeriodYear desc,FPeriodMonth desc");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        String billId = "";
        Calendar calendar = null;
        java.util.Date socPayDate = null;
        try {
            while (rs.next()) {
                billId = rs.getString("FSocPersonRecordID");
                if (map.containsKey(billId)) continue;
                int periodYear = rs.getInt("FPeriodYear");
                int periodMonth = rs.getInt("FPeriodMonth");
                calendar = Calendar.getInstance();
                calendar.set(1, periodYear);
                calendar.set(2, periodMonth - 1);
                calendar.set(5, calendar.getActualMaximum(5));
                calendar.set(periodYear, periodMonth - 1, calendar.getActualMaximum(5), 0, 0, 0);
                calendar.clear(14);
                socPayDate = calendar.getTime();
                map.put(billId, socPayDate);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }

    private Map<String, java.util.Date> getMaxSocEntryDateMap(Context ctx, String billIds) throws BOSException {
        HashMap<String, java.util.Date> map = new HashMap<String, java.util.Date>();
        StringBuilder sb = new StringBuilder("select socFiles.fbillId,max(entry.feffectDay) maxDate");
        sb.append(" from T_HR_SSocEmpSocFiles socFiles ");
        sb.append(" left join T_HR_SSocEmpSocFilesEntry entry on socFiles.fid=entry.FBillID ");
        sb.append(" where socFiles.fbillId in " + billIds);
        sb.append(" group by socFiles.fbillId ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        String billId = "";
        Date maxDate = null;
        try {
            while (rs.next()) {
                maxDate = rs.getDate("maxDate");
                billId = rs.getString("fbillId");
                map.put(billId, maxDate);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }
}

